package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class StructureSuperpositionAlignDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel1 = new JPanel();
	private JPanel setPanel2 = new JPanel();
	
	private JPanel namePanel = new JPanel();
	
	private ButtonGroup nameGroup = new ButtonGroup();
	private JRadioButton alignAll = new JRadioButton("Use the entire sequence alignment for superposition", true);
	private JRadioButton alignSelected = new JRadioButton("Use only selected columns", false);
	
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	
	private ButtonGroup group1 = new ButtonGroup();
	private JRadioButton select1 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick1 = new JRadioButton("Pick structure in display", false);
	
	private ButtonGroup group2 = new ButtonGroup();
	private JRadioButton select2 = new JRadioButton("Select structure from list", true);
	private JRadioButton pick2 = new JRadioButton("Pick structure in display", false);
	
	private JTextField field1 = new JTextField(30);
	private JTextField field2 = new JTextField(30);
	
	private Atom[] atoms = new Atom[2];

	private JLabel label11 = new JLabel();
	private JLabel label12 = new JLabel();
	
	private JLabel label21 = new JLabel();
	private JLabel label22 = new JLabel();
	
	private JTextField activeField = field1;

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	
	private JComboBox combo11 = new JComboBox();
	private Vector structures1 = new Vector();

	private JComboBox combo12 = new JComboBox();
	private Vector chains1 = new Vector();
	
	private JComboBox combo21 = new JComboBox();
	private Vector structures2 = new Vector();

	private JComboBox combo22 = new JComboBox();
	private Vector chains2 = new Vector();

	private Structure structure1;
	private Structure structure2;
	private Chain chain1;
	private Chain chain2;

	private Structure structureOut1;
	private Structure structureOut2;

	
	public StructureSuperpositionAlignDialog(JFrame f, Manager p, StructureViewer s){

		super(f, " Superimpose two structures based on sequence alignment", false);

		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 425, 230);
		base.setLayout(null);
		
		
		setPanel1.setBounds(5,5,205,150);
		setPanel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " First structure (aligned) ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel1.setBorder(border);
		

		label11.setForeground(Color.black);
		label11.setFont(new Font("Dialog", Font.PLAIN, 11));
		label11.setText("Structure:");
		label11.setBounds(30,50,50,20);
		label11.setVisible(true);
		
		//walk through the loaded structures
		structures1.add("Select");
		chains1.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures1.add(sv.getStructureName(st));
		}
		
		combo11 = new JComboBox(structures1);
		combo11.setBounds(85,50,100,20);
		combo11.setVisible(true);
		if (structures1.size() == 1) combo11.setEnabled(false);
		combo11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo11.getSelectedItem();
				try{
					structure1 = (Structure)sv.getLoadedStructures().get(combo11.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains1.clear();
					chains1.add("Select");
					StructureMap map = structure1.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains1.add((map.getChain(i)).getChainId());
					}
					if (chains1.size() == 1){
						chains1.add("Default");
						combo12.setSelectedIndex(1);
					}
					combo12.setEnabled(true);
					combo12.setModel(new DefaultComboBoxModel(chains1));
				}
				catch (Exception ex){
					chains1.clear();
					chains1.add("Select");
					combo12.setEnabled(false);
					combo12.setSelectedIndex(0);
				}
				combo12.revalidate();
			}
		});
		
		
		label12.setForeground(Color.black);
		label12.setFont(new Font("Dialog", Font.PLAIN, 11));
		label12.setText("Chain:");
		label12.setBounds(30,80,40,20);
		label12.setVisible(true);

		combo12 = new JComboBox(chains1);
		combo12.setBounds(85,80,100,20);
		combo12.setVisible(true);
		combo12.setEnabled(false);
		combo12.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo12.getSelectedItem();
				try{
					chain1 = structure1.getStructureMap().getChain(combo12.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		select1.setBounds(20,20,150,20);
		select1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures1.size() > 1) combo11.setEnabled(true);
//				combo12.setEnabled(true);
				field1.setText("");
				field1.setEnabled(false);
				field1.setEditable(false);
			}
		});
		
		pick1.setBounds(20,80,150,20);
		pick1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo11.setEnabled(false);
				combo12.setEnabled(false);
				field1.setEnabled(true);
				field1.setEditable(true);
				field1.requestFocus();
				activeField = field1;
			}
		});
		
		field1.setBounds(85, 110, 100, 20);
		field1.setEnabled(false);
		field1.setEditable(false);
		field1.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field1;
			}
		});

		setPanel1.add(label11);
		setPanel1.add(combo11);
//		setPanel1.add(label12);
//		setPanel1.add(combo12);
		setPanel1.add(select1);
		setPanel1.add(pick1);
		setPanel1.add(field1);
		
		group1.add(select1);
		group1.add(pick1);
		
		
		
		///second set panel
		setPanel2.setBounds(215,5,205,150);
		setPanel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Second structure (reference) ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel2.setBorder(border);
		
		label21.setForeground(Color.black);
		label21.setFont(new Font("Dialog", Font.PLAIN, 11));
		label21.setText("Structure:");
		label21.setBounds(30,50,50,20);
		label21.setVisible(true);
		
		//walk through the loaded structures
		structures2.add("Select");
		chains2.add("Select");

		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures2.add(sv.getStructureName(st));
		}
		
		combo21 = new JComboBox(structures2);
		combo21.setBounds(85,50,100,20);
		combo21.setVisible(true);
		if (structures2.size() == 1) combo21.setEnabled(false);
		combo21.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo21.getSelectedItem();
				try{
					structure2 = (Structure)sv.getLoadedStructures().get(combo21.getSelectedIndex() - 1);
					//walk through the chains in the structure and add them
					chains2.clear();
					chains2.add("Select");
					StructureMap map = structure2.getStructureMap();
					for (int i = 0; i < map.getChainCount(); i++){
						chains2.add((map.getChain(i)).getChainId());
					}
					if (chains2.size() == 1){
						chains2.add("Default");
						combo22.setSelectedIndex(1);
					}
					combo22.setEnabled(true);
					combo22.setModel(new DefaultComboBoxModel(chains2));
				}
				catch (Exception ex){
					chains2.clear();
					chains2.add("Select");
					combo22.setEnabled(false);
					combo22.setSelectedIndex(0);
				}
				combo22.revalidate();
			}
		});
		
		
		label22.setForeground(Color.black);
		label22.setFont(new Font("Dialog", Font.PLAIN, 11));
		label22.setText("Chain:");
		label22.setBounds(30,80,40,20);
		label22.setVisible(true);

		combo22 = new JComboBox(chains1);
		combo22.setBounds(85,80,100,20);
		combo22.setVisible(true);
		combo22.setEnabled(false);
		combo22.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo22.getSelectedItem();
				try{
					chain2 = structure2.getStructureMap().getChain(combo22.getSelectedIndex() - 1);
				}
				catch (Exception ex){}
			}
		});
		
		select2.setBounds(20,20,150,20);
		select2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if (structures2.size() > 1) combo21.setEnabled(true);
//				combo12.setEnabled(true);
				field2.setText("");
				field2.setEnabled(false);
				field2.setEditable(false);
			}
		});
		
		pick2.setBounds(20,80,150,20);
		pick2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				combo21.setEnabled(false);
				combo22.setEnabled(false);
				field2.setEnabled(true);
				field2.setEditable(true);
				field2.requestFocus();
				activeField = field2;
			}
		});
		
		field2.setBounds(85, 110, 100, 20);
		field2.setEnabled(false);
		field2.setEditable(false);
		field2.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				activeField = field2;
			}
		});

		setPanel2.add(label21);
		setPanel2.add(combo21);
//		setPanel2.add(label22);
//		setPanel2.add(combo22);
		setPanel2.add(select2);
		setPanel2.add(pick2);
		setPanel2.add(field2);
		
		group2.add(select2);
		group2.add(pick2);

		
		
		//add panels to the base
		base.add(setPanel1);
		base.add(setPanel2);
		
		
		//bottom panel
		///second set panel
		namePanel.setBounds(5,155,415,70);
		namePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Selection of residues as anchor points ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		namePanel.setBorder(border);
		
		alignAll.setBounds(20,20,380,20);
		alignAll.setVisible(true);
		
		alignSelected.setBounds(20,40,380,20);
		alignSelected.setVisible(true);

		namePanel.add(alignAll);
		namePanel.add(alignSelected);
		
		nameGroup.add(alignAll);
		nameGroup.add(alignSelected);
		
		base.add(namePanel);
		
		
		//buttons
		okButton.setBounds(115, 240, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(225, 240, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(440, 300);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			
			
			//get the chains to be aligned
			if (select1.isSelected()){
				//get the choice from the combo box
				structureOut1 = structure1;
			}
			else if (pick1.isSelected()){
				//get the picked chain
				if (atoms[0] != null){
					structureOut1 = atoms[0].structure;
				}
				
				if (structureOut1 == null){
					//try getting it out of the text in the field
					structureOut1 = (Structure)sv.labelToObject(field1.getText());
				}
				
				if (structureOut1 == null){
					parent.displayErrorMessage("Unable to identify the first structure. Please try again");
					return;
				}
			}
			
			//get the chains to be aligned
			if (select2.isSelected()){
				//get the choice from the combo box
				structureOut2 = structure2;
			}
			else if (pick2.isSelected()){
				//get the picked chain
				if (atoms[1] != null){
					structureOut2 = atoms[1].structure;
				}
				
				if (structureOut2 == null){
					//try getting it out of the text in the field
					structureOut2 = (Structure)sv.labelToObject(field2.getText());
				}
				
				if (structureOut2 == null){
					parent.displayErrorMessage("Unable to identify the second structure. Please try again");
					return;
				}
			}
			
			if (structureOut1 == null || structureOut2 == null){
				parent.displayErrorMessage("Unable to identify one or both structures. Please try again");
				return;
			}
			
			Thread runner = new Thread(){
				public void run(){
					sv.superimposeStructures(structureOut1, structureOut2, alignAll.isSelected());
				}
			};
			runner.start();
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception in structure editing", e);
		}
		
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		activeField.setText(data);
		//move focus along only if something has been picked
		if (data.length() > 0){
			if (activeField == field1){
				atoms[0] = (Atom)structureComponent;
				if (field2.isEnabled()){
					activeField = field2;
					field2.requestFocus();
				}
			}
			else{
				atoms[1] = (Atom)structureComponent;
			}
		}
	}
	
}
