//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs;

// Core

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

/**
 *  This class impements a dialog box used to color the currently displayed structures.
 *  <P>
 *  @see edu.sdsc.sirius.viewers.StructureViewer
 *  @see edu.sdsc.sirius.dialogs.DisplayDialog
 *  <P>
 *  @author Oleksandr V. Buzko
 */

public class SuperimposeDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	
	private StructureComponent[] atoms1 = new StructureComponent[3];
	private StructureComponent[] atoms2 = new StructureComponent[3];
	
	
	private DisplayDialog itself;
	
	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel panel1 = new JPanel();
	private JPanel panel2 = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	private JTextField activeField;
	
	private JTextField atom11 = new JTextField(30);
	private JTextField atom12 = new JTextField(30);
	private JTextField atom13 = new JTextField(30);
	private JTextField atom21 = new JTextField(30);
	private JTextField atom22 = new JTextField(30);
	private JTextField atom23 = new JTextField(30);
	
	private JLabel label11 = new JLabel("Atom 1:");
	private JLabel label12 = new JLabel("Atom 2:");
	private JLabel label13 = new JLabel("Atom 3:");
	private JLabel label21 = new JLabel("Atom 1:");
	private JLabel label22 = new JLabel("Atom 2:");
	private JLabel label23 = new JLabel("Atom 3:");

	
	
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private boolean message = false;
	

	
	/**
	 * Constructor that builds the dialog.
	 * @param f
	 * @param p
	 * @param s
	 */
	public SuperimposeDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, " Superimpose structures using anchor atoms", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setBounds(5, 5, 410, 150);
		base.setLayout(null);
		
		panel1.setBounds(5,5,200,140);
		panel1.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Anchor atoms in aligned structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		panel1.setBorder(border);
		
		
		
		panel2.setBounds(205,5,200,140);
		panel2.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Anchor atoms in reference structure ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 11));
		border = BorderFactory.createCompoundBorder(border1, border2);
		panel2.setBorder(border);
		
		//set up the text fields
		label11.setBounds(20,30,40,20);
		label11.setForeground(Color.red);
		atom11 = new JTextField(30);
		atom11.setBounds(70,30,100,20);
		activeField = atom11;
		atom11.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom11;
			}
		});

		label12.setBounds(20,60,40,20);
		atom12 = new JTextField(30);
		atom12.setBounds(70,60,100,20);
		atom12.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom12;
			}
		});

		label13.setBounds(20,90,40,20);
		atom13 = new JTextField(30);
		atom13.setBounds(70,90,100,20);
		atom13.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom13;
			}
		});
	
		panel1.add(atom11);
		panel1.add(atom12);
		panel1.add(atom13);
		panel1.add(label11);
		panel1.add(label12);
		panel1.add(label13);
		
		label21.setBounds(20,30,40,20);
		atom21 = new JTextField(30);
		atom21.setBounds(70,30,100,20);
		atom21.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom21;
			}
		});

		label22.setBounds(20,60,40,20);
		atom22 = new JTextField(30);
		atom22.setBounds(70,60,100,20);
		atom22.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom22;
			}
		});

		label23.setBounds(20,90,40,20);
		atom23 = new JTextField(30);
		atom23.setBounds(70,90,100,20);
		atom23.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e){
				activeField = atom23;
			}
		});
	
		panel2.add(atom21);
		panel2.add(atom22);
		panel2.add(atom23);
		panel2.add(label21);
		panel2.add(label22);
		panel2.add(label23);
		
		//add panels to the base
		base.add(panel1);
		base.add(panel2);
		
		
		//buttons
		okButton.setBounds(115, 160, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(235, 160, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				if (message) return;
				toFront();
			}
		});
				
		setSize(430, 220);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
			
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		
		setResizable(false);
		setVisible(true);
	}
	
	/**
	 * This method is called by StructureViewer in response to a mouse click and sets the currently
	 * active text field to the String representation of the clicked StructureComponent.
	 * @see edu.sdsc.sirius.viewers.StructureViewer
	 * @see edu.sdsc.mbt.StructureComponent
	 */
	public void processPick(String data, StructureComponent structureComponent){

		if (data.length() == 0 || structureComponent == null) return;
		
		if (activeField == atom11){
			atom11.setText(data);
			atoms1[0] = structureComponent;
			activeField = atom21;
			label11.setForeground(Color.black);
			label21.setForeground(Color.red);
			label21.repaint();
			atom21.requestFocus();
		}
		else if (activeField == atom21){
			atom21.setText(data);
			atoms2[0] = structureComponent;
			activeField = atom12;
			label21.setForeground(Color.black);
			label12.setForeground(Color.red);
			label12.repaint();
			atom12.requestFocus();
		}
		else if (activeField == atom12){
			atom12.setText(data);
			atoms1[1] = structureComponent;
			activeField = atom22;
			label12.setForeground(Color.black);
			label22.setForeground(Color.red);
			label22.repaint();
			atom22.requestFocus();
		}
		else if (activeField == atom22){
			atom22.setText(data);
			atoms2[1] = structureComponent;
			activeField = atom13;
			label22.setForeground(Color.black);
			label13.setForeground(Color.red);
			label13.repaint();
			atom13.requestFocus();
		}
		else if (activeField == atom13){
			atom13.setText(data);
			atoms1[2] = structureComponent;
			activeField = atom23;
			label13.setForeground(Color.black);
			label23.setForeground(Color.red);
			label23.repaint();
			atom23.requestFocus();
		}
		else if (activeField == atom23){
			atom23.setText(data);
			atoms2[2] = structureComponent;
			label23.setForeground(Color.black);
			label23.repaint();

		}

	}
	
	private void process(){
		
		try{
		
			setVisible(false);
			parent.setDisplayDialogStatus(false);
		
			if (atom11.getText().length() == 0 || atom12.getText().length() == 0 || atom13.getText().length() == 0 || 
					atom21.getText().length() == 0 || atom22.getText().length() == 0 || atom23.getText().length() == 0){
					parent.displayErrorMessage("One or more of anchor atoms are missing");
					return;
			}
			
			//call superimpose method in structure viewer
			parent.setSuperimpose(false);
			sv.superimpose(atoms2, atoms1);//to make sure first structure is aligned to the second (not the other way around)
			
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception superimposing structures", e);

		}

		dispose();

	}
}
