package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class SurfaceDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame;
	private Manager parent;
	private StructureViewer sv;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself;

	private Container contentPane;
	private JPanel base = new JPanel();
	private JPanel setPanel = new JPanel();
	private JPanel stylePanel = new JPanel();
	private JPanel qPanel = new JPanel();
	
	private Border border1;
	private TitledBorder border2;
	private Border border;
	
	public int setFlag = DialogConstants.APPLY_STRUCTURE;
	public short qualityFlag = StylesPreferences.SURFACE_QUALITY_MEDIUM;
	public int typeFlag = StylesPreferences.SURFACE_DOT;
	
	private ButtonGroup setGroup = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("Currently selected", true);
	private JRadioButton radio2 = new JRadioButton("Structure", false);
	private JRadioButton radio3 = new JRadioButton("Chain", false);
	private JRadioButton radio4 = new JRadioButton("Residue", false);
	private JRadioButton radio5 = new JRadioButton("Atom", false);
	
	private ButtonGroup styleGroup = new ButtonGroup();
	private JRadioButton radio6 = new JRadioButton("Ignore other atoms", true);
	private JRadioButton radio7 = new JRadioButton("Account for other atoms", false);
	
	private ButtonGroup qGroup = new ButtonGroup();
	private JRadioButton radio9 = new JRadioButton("Low", false);
	private JRadioButton radio10 = new JRadioButton("Medium", true);
	private JRadioButton radio11 = new JRadioButton("High", false);
	private JRadioButton radio12 = new JRadioButton("Ultra fine", false);

	private JTextField field = new JTextField(30);
	private JLabel header = new JLabel();
	private JLabel label = new JLabel();
	
	private JLabel or = new JLabel("or");
	private JComboBox combo = new JComboBox();
	private Vector structures = new Vector();

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	
	public SurfaceDialog(JFrame f, Manager p, StructureViewer s){
	
		super(f, "Create dot surface", false);
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//reset the static variables
		typeFlag = StylesPreferences.SURFACE_DOT;
		setFlag = DialogConstants.APPLY_SELECTION;
		qualityFlag = StylesPreferences.SURFACE_QUALITY_MEDIUM;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(390, 280));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 390, 280);
		base.setLayout(null);
		
		setPanel.setPreferredSize(new Dimension(200, 270));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,200,270);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Apply to ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		//text field
		header.setForeground(Color.black);
		header.setFont(new Font("Dialog", Font.PLAIN, 12));
		header.setText("Pick object for surface");
		header.setPreferredSize(new Dimension(150,20));
		header.setBounds(20,60,150,20);
		header.setLocation(new Point(20,60));
		header.setVisible(true);
		
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 11));
		label.setText("Enter name or click structure");
		label.setPreferredSize(new Dimension(175,20));
		label.setBounds(20,175,170,20);
		label.setLocation(new Point(20,175));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(160,20));
		field.setBounds(20,200,160,20);
		field.setLocation(new Point(20,200));
		field.setEditable(false);
		field.setEnabled(false);
		field.setVisible(true);
		field.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (radio1.isSelected()){
					setFlag = DialogConstants.APPLY_RESIDUE;
					radio1.setSelected(false);
					radio4.setSelected(true);
					field.setText("");
					field.setEditable(true);
					field.setEnabled(true);
					field.requestFocus();
				}
			}
		});
					
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
		
		or.setForeground(Color.black);
		or.setFont(new Font("Dialog", Font.PLAIN, 11));
		or.setPreferredSize(new Dimension(15,20));
		or.setBounds(20,235,15,20);
		or.setLocation(new Point(20,235));
		or.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}
		
		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures.add(setNames.get(i));
		}


		combo = new JComboBox(structures);
		combo.setPreferredSize(new Dimension(145,20));
		combo.setBounds(35,235,145,20);
		combo.setLocation(new Point(35,235));
		combo.setVisible(true);
		if (structures.size() == 1) combo.setEnabled(false);
		combo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo.getSelectedItem();
				if (choice.startsWith("Select")) return;
				field.setText(choice);
				field.setEnabled(true);
				field.setEditable(true);
				setFlag = DialogConstants.APPLY_STRUCTURE;		
				radio2.setSelected(true);
			}
		});
		
		
		//define the radio buttons
		radio1.setLocation(20,25);
		radio1.setBounds(20,25,150,20);
		radio1.setVisible(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_SELECTION;
				field.setText("");
				field.setEditable(false);
				field.setEnabled(false);
			}
		});
		
		radio2.setLocation(20,85);
		radio2.setBounds(20,85,150,20);
		radio2.setVisible(true);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_STRUCTURE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio3.setLocation(20,105);
		radio3.setBounds(20,105,150,20);
		radio3.setVisible(true);
		radio3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_CHAIN;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio4.setLocation(20,125);
		radio4.setBounds(20,125,150,20);
		radio4.setVisible(true);
		radio4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_RESIDUE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio5.setLocation(20,145);
		radio5.setBounds(20,145,150,20);
		radio5.setVisible(true);
		radio5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_ATOM;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		//draw a line between the radio buttons
		JSeparator line = new JSeparator();
		line.setLocation(10,55);
		line.setBounds(10,55,180,5);
		line.setVisible(true);
		
		setPanel.add(line);
		setPanel.add(header);
		
		setGroup.add(radio1);
		setGroup.add(radio2);
		setGroup.add(radio3);
		setGroup.add(radio4);
		setGroup.add(radio5);
		
		setPanel.add(radio1);
		setPanel.add(radio2);
		setPanel.add(radio3);
		setPanel.add(radio4);
		setPanel.add(radio5);
		
		setPanel.add(label);
		setPanel.add(field);
		setPanel.add(or);
		setPanel.add(combo);
		
		
		//style panel
		stylePanel.setBounds(205,5,180,120);
		stylePanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Surface calculation ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		stylePanel.setBorder(border);
		
		//second button group
		radio6.setBounds(20,25,150,20);
		radio6.setVisible(true);
		
		radio7.setBounds(20,50,150,20);
		
		styleGroup.add(radio6);
		styleGroup.add(radio7);
		
		stylePanel.add(radio6);
		stylePanel.add(radio7);
		
		
		
		//quality settings panel
		qPanel.setBounds(205,125,180,150);
		qPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  Surface quality ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		qPanel.setBorder(border);
		
		
		//radio buttons
		radio9.setBounds(25,25,100,20);
		radio9.setVisible(true);
		radio9.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.SURFACE_QUALITY_LOW;
			}
		});

		radio10.setBounds(25,50,100,20);
		radio10.setVisible(true);
		radio10.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.SURFACE_QUALITY_MEDIUM;
			}
		});
		
		radio11.setBounds(25,75,100,20);
		radio11.setVisible(true);
		radio11.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.SURFACE_QUALITY_HIGH;
			}
		});
		
		radio12.setBounds(25,100,100,20);
		radio12.setVisible(true);
		radio12.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				qualityFlag = StylesPreferences.SURFACE_QUALITY_ULTRA;
			}
		});

		qGroup.add(radio9);
		qGroup.add(radio10);
		qGroup.add(radio11);
		qGroup.add(radio12);
		
		qPanel.add(radio9);
		qPanel.add(radio10);
		qPanel.add(radio11);
		qPanel.add(radio12);
		
		
		base.add(setPanel);
		base.add(stylePanel);
		base.add(qPanel);
		
		
		//buttons
		okButton.setPreferredSize(new Dimension(80,25));
		okButton.setLocation(new Point(85, 295));
		okButton.setBounds(110, 295, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setPreferredSize(new Dimension(80,25));
		cancelButton.setLocation(new Point(185, 295));
		cancelButton.setBounds(210, 295, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
		
		
		
		setSize(405, 355);

		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		setResizable(false);

		setVisible(true);
		


	}
	
	private void process(){
		
		//add error checking for selection bounds
		//eg., selection level is residue, but entered only structure name
		try{
			//first, check the number of tags
			int count = 0;
			StringTokenizer tok = new StringTokenizer(field.getText(), ":", false);
			while (tok.hasMoreTokens()){
				Object o = tok.nextToken();//simply to loop through all of them
				count++;
			}
			
			if (setFlag != 0){
				if (count < setFlag){
					setFlag = count;
				}
			}
			
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			
			sv.createSurface(structureComponent, field.getText(), setFlag, typeFlag, qualityFlag, radio6.isSelected());
	
		}
		catch (Exception e){
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception creating surface", e);
		}

		dispose();

	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		if (field.isEditable()){
			field.setText(data);
		}
	}
	
}
