//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

import java.awt.*;
import javax.swing.table.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * This class extends JTable and enables custom cell coloring.
 * @see javax.swing.JTable
 * 
 * @author Oleksandr V. Buzko
 */
public class ColorTable extends JTable {

	/**
	 * Constructor that initializes the table.
	 *
	 */
	public ColorTable(){

		AbstractTableModel tableModel = new AbstractTableModel(){

			public Class getColumnClass(int column) { return Integer.class; }
			public int getColumnCount() { return 6; }
			public int getRowCount() { return 10;}
			public Object getValueAt(int row,int col) { return new Integer(row * col); }
		};

		setModel(tableModel);
		setDefaultRenderer(Integer.class,new ColorRenderer(Color.cyan));
		addMouseListener(new MouseAdapter(){
			private ColorRenderer renderer;
			private JColorChooser chooser = new JColorChooser();
			public void mousePressed(MouseEvent e){
				if(e.getModifiers() == MouseEvent.BUTTON3_MASK){
					renderer = (ColorRenderer)getCellRenderer(rowAtPoint(e.getPoint()),
					columnAtPoint(e.getPoint()));
					chooser.setColor(renderer.getColor());
					renderer.setColor(JColorChooser.showDialog((Component)e.getSource(),"Choose Cell Color",chooser.getColor()));
				}
			}
		});
	}

	class ColorRenderer extends DefaultTableCellRenderer{

		private Color cellColor;

		public ColorRenderer(Color color){
			cellColor = color;
		}

		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column){
			Component comp = super.getTableCellRendererComponent(table,value,isSelected,hasFocus,row,column);
			comp.setBackground(isSelected ? cellColor : Color.white);
			return comp;
		}

		public void setColor(Color color){
			cellColor = color;
			ColorTable.this.repaint();
		}

		public Color getColor(){
			return cellColor;
		}

	}

}