//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

/**
 * Container class storing column attributes.
 * 
 * @author Oleksandr V. Buzko
 */
public class ColumnData {

	/**
	 * Column title.
	 */
	public String m_title;
	
	/**
	 * Column width in pixels.
	 */
	public int m_width;
	
	/**
	 * Content alignment.
	 */
	public int m_alignment;
	
	private String headerTitle;

	/**
	 * Constructor.
	 * @param title column header
	 * @param width width in pixels
	 * @param alignment content alignment
	 */
	public ColumnData(String title, String headerTitle, int width, int alignment){
		
		m_title = title;
		m_width = width;
		m_alignment = alignment;
		if (headerTitle == null){
			this.headerTitle = title;
		}
		else{
			this.headerTitle = headerTitle;
		}

	}
	
	public String getHeaderTitle(){
		return headerTitle;
	}
}

