//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

import java.util.*;

/**
 * This class stores information about a database entry used to display it in search and loading dialogs.
 * It contains only the most essential information and can be extended for more specific cases.
 * Additional fields are introduced to allow for its use in literature and blast searches
 * 
 * @author Oleksandr V. Buzko
 */
public class DataBlock implements java.io.Serializable {

	private String entryId;
	private String description;//to begin with...
	private String name;
	
	private String source;
	
	private String author;
	private String title;
	private String journal;
	private String year;
	
	private String evalue;
	private String accession;
	
	private boolean selected = false;
	public boolean marked = false;
	
	private boolean bold = false;
	private boolean pending = false;
	
	public String id;
	
	public DataBlock(){
		fields = new HashMap();
	}
	
	public DataBlock(String id){
		this.id = id;
		fields = new HashMap();
	}
	
	
	public HashMap fields;
	
	/**
	 * Sets entry database id.
	 * @param id database id as a String
	 */
	public void setEntryId(String id){
		entryId = id;
	}
		
	/**
	 * Returns database id as a String.
	 */
	public String getEntryId(){
		return entryId;
	}
	
	/**
	 * Sets entry name.
	 */
	public void setName(String n){
		name = n;
	}
	
	public boolean getBold(){
		return bold;
	}
	
	public void setBold(boolean bold){
		this.bold = bold;
	}
	
	/**
	 * Returns entry name.
	 */
	public String getName(){
		return name;
	}
	
	/**
	 * Sets entry description.
	 */
	public void setDescription(String d){
		description = d;
	}
	
	/**
	 * Returns entry description.
	 */
	public String getDescription(){
		return description;
	}

	public final String getAuthor() {
		return author;
	}

	public final void setAuthor(String author) {
		this.author = author;
	}

	public final String getJournal() {
		return journal;
	}

	public final void setJournal(String journal) {
		this.journal = journal;
	}

	public final String getTitle() {
		return title;
	}

	public final void setTitle(String title) {
		this.title = title;
	}

	public final String getYear() {
		return year;
	}

	public final void setYear(String year) {
		this.year = year;
	}


	public final String getId() {
		return id;
	}
	
	public final void setId(String id){
		this.id = id;
	}


	public final String getAccession() {
		return accession;
	}


	public final void setAccession(String accession) {
		this.accession = accession;
	}


	public final String getEvalue() {
		return evalue;
	}


	public final void setEvalue(String evalue) {
		this.evalue = evalue;
	}


	public boolean getSelected(){
		return selected;
	}
	
	public void setSelected(boolean selected){
		this.selected = selected;
	}

	public boolean getPending() {
		return pending;
	}

	public void setPending(boolean pending) {
		this.pending = pending;
	}
	
	public String toString(){
		
		if (fields.size() > 0){
			StringBuffer buffer = new StringBuffer();
			Set keys = fields.keySet();
			Iterator it = keys.iterator();
			while (it.hasNext()){
				String key = (String)it.next();
				String value = (String)fields.get(key);
				buffer.append(key + " -> " + value);
				buffer.append("\n");
			}
			return buffer.toString();
		}
		
		return "DataBlock: id = " + id + ", name = " + name + ", description = " + description + ", evalue = " + evalue;
	}
	
	
	//......

}