//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

import java.util.*;

/**
 * This class is a container for DataBlocks and is used to ship information about multiple entries at once.
 * 
 * @author Oleksandr V. Buzko
 */
public class DataSet implements java.io.Serializable {

	//a container class for DataBlock's that are being sent to the client,
	//be it an applet/application of a JSP router class (parsing the DataSet and inserting
	//appropriate blocks into the JSP page)
	
	private HashMap blocks = null;
	private Vector order = null;
	
	/**
	 * Constructor that intializes storage hashes.
	 *
	 */
	public DataSet(){
		blocks = new HashMap();
		order = new Vector();
	}
	
	/**
	 * Returns the number of DataBlocks included in this DataSet
	 * @return
	 */
	public int size(){
		return blocks.size();
	}
	
	/**
	 * Adds a block to this DataSet
	 * @param block DataBlock to be added
	 */
	public void addData(DataBlock block){
		blocks.put(block.getId(), block);
		order.add(block);
	}
	
	/**
	 * Removes a DataBlock from this set based on the id of the entry it represents.
	 * @param id database id of the entry contained in the block to be removed
	 */
	public void removeData(String id){
		DataBlock d = (DataBlock)blocks.get(id);
		order.remove(d);
		blocks.remove(id);
	}
	
	/**
	 * Removes a DataBlock from this set
	 */
	public void removeData(DataBlock block){
		order.remove(block);
		blocks.remove(block.getId());
	}

	/**
	 * Returns a DataBlock stored at the specified index.
	 * @param index position of the block within the set.
	 */
	public DataBlock getData(int index){
		if (index >= order.size()) return null;
		return (DataBlock)order.elementAt(index);
	}

	/**
	 * Returns a hash containing mappings of entry ids to the corresponding DataBlocks.
	 * @return
	 */
	public HashMap getAllData(){
		return blocks;
	}
	
	public void clearData(){
		order.clear();
		blocks.clear();
	}

}