//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

/**
 * This class stores information about a database entry used to display it in search and loading dialogs.
 * It contains only the most essential information and can be extended for more specific cases.
 * Additional fields are introduced to allow for its use in literature and blast searches
 * 
 * @author Oleksandr V. Buzko
 */
public class InterProDataBlock extends DataBlock implements java.io.Serializable {

	private String ev;//to begin with...
	private String name;
	private String application;
	private String acc;
	private String start;
	private String end;
	
///	public String id;
	
	public final String getAcc() {
		return acc;
	}


	public final void setAcc(String acc) {
		this.acc = acc;
	}



	public final String getEv() {
		return ev;
	}



	public final void setEv(String ev) {
		this.ev = ev;
	}

	public final String getApplication() {
		return application;
	}

	public final void setApplication(String application) {
		this.application = application;
	}

	public final String getEnd() {
		return end;
	}

	public final void setEnd(String end) {
		this.end = end;
	}

	public final String getName() {
		return name;
	}

	public final void setName(String name) {
		this.name = name;
	}

	public final String getStart() {
		return start;
	}

	public final void setStart(String start) {
		this.start = start;
	}
	
	public String toString(){
		return "InterProDataBlock: " + application + ", " + acc + ", " + name + ", " + start + ", " + end + ", " + ev;
	}
	
	

}