//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

/**
 * A container class for data displayed in one row of the table of ResultPanel.
 * 
 * @author Oleksandr V. Buzko
 */
public class LineData {

	public String button;
	public String id;
	public String name;
	public String description;
	public String evalue;
	
	public boolean selected = false;//red color
	public boolean marked = false;//blue color
	public boolean bold = false;
	public boolean pending = false;
	
	public Boolean m_flag;
	
	public String[] values;
	public boolean generic = false;
	
	public DataBlock data;//data block that this line is associated with
	
	public LineData(int size){
		m_flag = new Boolean(false);
		values = new String[size];
		generic = true;
	}
	
	public LineData(){
		m_flag = new Boolean(false);
	}
	
	/**
	 * Constructor that initializes values of the fields.
	 * @param i String representation of the entry id
	 * @param n name
	 * @param info description
	 * @param o organism name
	 * @param check whether the checkbox should be checked
	 */
	public LineData(String i, String n, String info, String o, boolean check){
	
		id = i;
		name = n;
		description = info;
		m_flag = new Boolean(false);//the checkbox is unchecked by default
		
	}
	
	
	public void updateData(){
		this.bold = data.getBold();
		this.pending = data.getPending();
	}
	
	public String toString(){
		return "LineData: id = " + id + ", name = " + name + ", description = " + description + ", evalue = " + evalue;
	}
	
}
