//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import edu.sdsc.sirius.util.Manager;

/**
 * This class implements a frame holder for ResultPanel and is used to display search results.
 * @see edu.sdsc.sirius.search.ResultPanel
 * 
 * @author Oleksandr V. Buzko
 */
public class ResultPanelFrame extends JDialog implements ResultPanelCallable {

	private Container contentPane = null;
	private DataSet set = null;
	
	private JDialog self = null;
	
	private JMenuBar menuBar = new JMenuBar();
	private JMenu fileMenu = new JMenu("File");
	private JMenu optionsMenu = new JMenu("Columns");
	private JMenu viewMenu = new JMenu("Options");
	
	private ResultPanel contentPanel = null;
	private String workingDir = ".";
	
	private Vector searchTypes = null;
	
	private Manager parent = null;
	private JFrame parentFrame = null;
	
	private JPanel base = new JPanel();
	
	private int displayType = ResultPanel.SEARCH_TABLE;
	
	static{
		try{
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch (Exception e){
			System.out.println("Look and feel fell through: " + e);
		}
	}
	

	/**
	 * Constructor that instantiates the frame with the Manager object that will process entry loading.
	 * This constructor is called when no DataSet is available and opens a blank frame that can be used to
	 * initiate a new search.
	 * @see edu.sdsc.sirius.search.ResultPanel
	 * @see edu.sdsc.mbt.util.DataSet
	 * @param p Manager object
	 */
	public ResultPanelFrame(Manager p, int type){
		
		super(p.getApplicationFrame(), "Search results", true);
	
		contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		displayType = type;
		
		parent = p;
		parentFrame = parent.getApplicationFrame();
		
		self = this;
		
		base.setBorder(new BevelBorder(BevelBorder.LOWERED));
		
		//get the menubar
		//go through the available data options and determine the future table headers
		searchTypes = new Vector();
		searchTypes.add("PKR id");
		searchTypes.add("Name");
		searchTypes.add("Description");
		searchTypes.add("Organism");
		searchTypes.add("Classification");
		searchTypes.add("Structure");
		searchTypes.add("Database id");
		searchTypes.add("Sequence");
		searchTypes.add("Sequence length");
		searchTypes.add("Molecular weight");
		searchTypes.add("Isoelectric point");
		
		if (displayType == ResultPanel.PATTERN_TABLE){
			//remove fields that are not going to be used
			searchTypes.remove("Classification");
			searchTypes.remove("Structure");
			searchTypes.remove("Database id");
			searchTypes.remove("Molecular weight");
			searchTypes.remove("Isoelectric point");
		}
		
		
		createMenuBar();
		
		updateOptionsMenu();
		
		menuBar.add(fileMenu);
		menuBar.add(optionsMenu);
		setJMenuBar(menuBar);
		
		//add window listener
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
			}
		});
		
		addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e){
				Dimension size = getSize();
				if (contentPanel == null) return;
				contentPanel.resizePanel(size);
			}	
		});
		setTitle("PKR Search");
		
		contentPane.add(base, BorderLayout.CENTER);
		
		setSize(670,350);
		
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		
		setVisible(true);

	}
	
	/**
	 * Constructor that instantiates the frame with the Manager object that will process entry loading.
	 * This constructor is called when there is a DataSet to display.
	 * @see edu.sdsc.sirius.search.ResultPanel
	 * @see edu.sdsc.mbt.util.DataSet
	 * @param p Manager object
	 */	
	public ResultPanelFrame(DataSet s, Manager p, int type){
		
		super(p.getApplicationFrame(), "Search results", true);
	
		set = s;
		parent = p;
		parentFrame = parent.getApplicationFrame();
		displayType = type;
		
		self = this;
		
		contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		base.setBorder(new BevelBorder(BevelBorder.LOWERED));
		
		try{
//				UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch (Exception e){
			System.out.println("Look and feel fell through: " + e);
		}
		
		//get the menubar
		//go through the available data options and determine the future table headers
		searchTypes = new Vector();
		searchTypes.add("PKR id");
		searchTypes.add("Name");
		searchTypes.add("Description");
		searchTypes.add("Organism");
		searchTypes.add("Classification");
		searchTypes.add("Structure");
		searchTypes.add("Database id");
		searchTypes.add("Sequence");
		searchTypes.add("Sequence length");
		searchTypes.add("Molecular weight");
		searchTypes.add("Isoelectric point");
		
		if (displayType == ResultPanel.PATTERN_TABLE){
			//remove fields that are not going to be used
			searchTypes.remove("Classification");
			searchTypes.remove("Structure");
			searchTypes.remove("Database id");
			searchTypes.remove("Molecular weight");
			searchTypes.remove("Isoelectric point");
		}
		
		createMenuBar();
		
		
		updateOptionsMenu();
		
		//add window listener
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				dispose();
//				System.exit(0);
			}
		});
		
		addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e){
				Dimension size = getSize();
				if (contentPanel == null) return;
				contentPanel.resizePanel(size);
			}	
		});
		setTitle("PKR Search: " + set.size() + " entries");
		
		setData(set);
		
		setSize(670,350);
		
		if (parentFrame == null){
			setLocationRelativeTo(null);
		}
		else{
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}
		
		setVisible(true);

	}
	
	private void createMenuBar(){
		
		//take care of the menu items
		fileMenu.setMnemonic('f');
		optionsMenu.setMnemonic('o');
		
		JMenuItem fileMenuLoad = new JMenuItem("Load selected entries");
		//open a search dialog
		fileMenuLoad.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (contentPanel != null){
					if (contentPanel.getSelectedRowCount() > 0){
						setVisible(false);
//						contentPanel.loadSelection();
						dispose();
					}
				}
				
			}
		});
		
/*		JMenuItem fileMenuNew = new JMenuItem("New search...");
		fileMenuNew.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				openSearch();
			}
		});
*/		
		JMenuItem fileMenuOpen = new JMenuItem("Open search...");
/*		fileMenuOpen.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				//this method loads the data from file
				JFileChooser chooser = new JFileChooser(workingDir);
				chooser.setFileFilter(new PKSFilter("pks", "PKR search file (*.pks)"));
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showOpenDialog(self);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String fname = filename.toString();

				try{
					ObjectInputStream is = new ObjectInputStream(new FileInputStream(fname));
					Object obj = is.readObject();
					set = (DataSet)obj;
					is.close();
					is = null;
					obj = null;
				}
				catch (IOException ex){
					System.out.println("IOException: " + ex);
				}
				catch (ClassNotFoundException e){
					System.out.println("ClassNotFoundException: " + e);
				}
				
				//set the data
				setData(set);
			}
		});
*/
		JMenuItem fileMenuSave = new JMenuItem("Save search...");
/*		fileMenuSave.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				if (set == null) return;
				//this method loads the data from file
				JFileChooser chooser = new JFileChooser(workingDir);
				chooser.setFileFilter(new PKSFilter("pks", "PKR search file (*.pks)"));
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int result = chooser.showSaveDialog(self);
				if (result == JFileChooser.CANCEL_OPTION){
					return;
				}
				File filename = chooser.getSelectedFile();
				String fname = filename.toString();

				try{
					ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fname));
					os.writeObject(set);
					os.flush();
					os.reset();
					os.close();
					os = null;
				}
				catch (Exception ex){
					System.out.println("Save Exception: " + ex);
				}
			}
		});
*/		
		
		JMenuItem fileMenuClose = new JMenuItem("Close search");
		fileMenuClose.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				clearData();
			}
		});
		
		JMenuItem printSetup = new JMenuItem("Print setup...");
		printSetup.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				contentPanel.printSetupHandler();
			}
		});
		
		JMenuItem print = new JMenuItem("Print table...");
		print.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				Thread runner = new Thread(){
					public void run(){
						contentPanel.printData();
					}
				};
				runner.start();
			}
		});

		
		JMenuItem fileMenuExit = new JMenuItem("Dismiss");
		fileMenuExit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setVisible(false);
				dispose();
			}
		});
		
//		fileMenu.add(fileMenuLoad);
//		fileMenu.add(new JSeparator());
//		fileMenu.add(fileMenuNew);
		fileMenu.add(fileMenuOpen);
		fileMenu.add(fileMenuSave);
		fileMenu.add(fileMenuClose);
		fileMenu.add(new JSeparator());
		fileMenu.add(printSetup);
		fileMenu.add(print);
		fileMenu.add(new JSeparator());
		fileMenu.add(fileMenuExit);
		
		menuBar.add(fileMenu);
		menuBar.add(optionsMenu);
		
		
		viewMenu.setMnemonic('v');
		final JCheckBoxMenuItem tooltipEnabled = new JCheckBoxMenuItem("Enable tooltips");
		tooltipEnabled.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				enableTooltips(tooltipEnabled.isSelected());
			}
		});
		viewMenu.add(tooltipEnabled);
		
		final JCheckBoxMenuItem commonSelectionEnabled = new JCheckBoxMenuItem("Show selected in classification");
		commonSelectionEnabled.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				contentPanel.enableCommonSelection(commonSelectionEnabled.isSelected());
			}
		});
//		viewMenu.add(commonSelectionEnabled);

		viewMenu.add(new JSeparator());
		final JMenuItem clearSelection = new JMenuItem("Clear selection");
		clearSelection.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				contentPanel.clearRowSelection();
			}
		});
		viewMenu.add(clearSelection);

		final JMenuItem resetTable = new JMenuItem("Reset table");
		resetTable.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				contentPane.remove(contentPanel);
				contentPanel = null;
				setData(set);
				updateOptionsMenu();
				setSize(670,350);
				repaint();
			}
		});
		viewMenu.add(resetTable);
		
		menuBar.add(viewMenu);
		
		
		setJMenuBar(menuBar);
	
	}
	
	/**
	 * Sets display to the given DataSet.
	 */
	public void setData(DataSet set){
	
		if (contentPanel != null){
			clearData();
		}
	
		//used to show a table in a previously open frame
		//(after a new search initiated from this frame)
		contentPanel = new ResultPanel(this, set, parent, displayType);
		contentPane.remove(base);
		contentPane.add(contentPanel, BorderLayout.CENTER);
		
		updateOptionsMenu();
		
	}
	
	/**
	 * Clear data from the display.
	 */
	public void clearData(){
	
		contentPane.remove(contentPanel);
		contentPanel = null;
//		set = null;
		
		contentPane.add(base, BorderLayout.CENTER);
		updateOptionsMenu();
		repaint();
	}
	
	/**
	 * Updates Options menu in response to addition or removal of columns.
	 *
	 */
	public void updateOptionsMenu(){
	
		//recreate the fields menu to avoid dealing with locally defined final values
		optionsMenu.removeAll();
		for (int i = 0; i < searchTypes.size(); i++){
			final String label = (String)searchTypes.elementAt(i);
			final JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
			if (contentPanel != null){
				item.setSelected(ResultPanel.defaultColumns.contains(label));
				item.setEnabled(true);
			}
			else{
				item.setSelected(false);
				item.setEnabled(false);
			}
			item.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e){
					if (contentPanel == null) return;
					contentPanel.displayColumn(label, item.isSelected());
				}
			});
			optionsMenu.add(item);
		}
		
		optionsMenu.revalidate();
		optionsMenu.repaint();
	}
	
	
	public void setNumberOfHits(int hits){
		setTitle("PKR Search: " + hits + " entries");
	}
	
/*	public void processRequest(RequestSet rSet){
		if (rSet == null || rSet.size() == 0) return;
		final RequestSet rs = rSet;
		
		if (parent != null){
			Thread runner = new Thread(){
				public void run(){
					parent.passRequestSet(rs);
				}
			};
			runner.start();
		}
		
		dispose();
	}
*/	
	public void enableTooltips(boolean enable){
		contentPanel.enableTooltips(enable);
	}
	
	public void setSelectedIndices(Vector v){}
	
}