//Copyright (c) 2000-2003  San Diego Supercomputer Center (SDSC),
//a facility operated by the University of California, San Diego (UCSD)
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software.  License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC.  This source is provided "AS IS" without express
//or implied warranty of any kind.
//
//For further information, please see:  http://mbt.sdsc.edu
//

package edu.sdsc.sirius.dialogs.TableImpl;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class extends JTable and implements a custom table to display database contents or search results.
 * @see edu.sdsc.sirius.search.ResultPanel
 * @see edu.sdsc.sirius.search.ResultData
 * 
 * @author Oleksandr V. Buzko
 */
public class ResultTable extends JTable {

	private ResultTable self = null;
	private int minimumWidth = 0;//minimal width below which no resizing should occur

	/**
	 * Constructs the table.
	 */
	public ResultTable(){
		super();

		self = this;

		//add a mouse listener
		MouseInputAdapter mia = new MouseInputAdapter(){

			int m_XDifference;
			int m_YDifference;

			Container c;

			public void mouseDragged(MouseEvent e){
				int modifier = e.getModifiers();
				if (modifier != 16){
					//left mouse button only
					return;
				}
				c = self.getParent();
				if (c instanceof JViewport){
					JViewport jv = (JViewport)c;
					Point p = jv.getViewPosition();
					int newX = p.x - (e.getX() - m_XDifference);
					int newY = p.y - (e.getY() - m_YDifference);

					int maxX = self.getWidth() - jv.getWidth();
					int maxY = self.getHeight() - jv.getHeight();

					if (newX < 0){
						newX = 0;
					}
					if (newX > maxX){
						newX = maxX;
					}
					if (newY < 0){
						newY = 0;
					}
					if (newY > maxY){
						newY = maxY;
					}

					jv.setViewPosition(new Point(newX, newY));

				}
			}

			public void mousePressed(MouseEvent e){
				int modifier = e.getModifiers();
				if (modifier == 16){
					//left mouse button only
					setCursor(Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR));
					m_XDifference = e.getX();
					m_YDifference = e.getY();
				}
			}

			public void mouseReleased(MouseEvent e){
				setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			}
			public void mouseClicked(MouseEvent e){
			}
		};

//		addMouseMotionListener(mia);
//		addMouseListener(mia);
	}
	
	/**
	 * Sets minimum width of the table.
	 * @param w minimum width in pixels
	 */
	public void setMinimumWidth(int w){
		minimumWidth = w;
	}

	
	public boolean getScrollableTracksViewportWidth() {
		if (autoResizeMode == AUTO_RESIZE_OFF) {
			return (false);
		}
		else {
			Container p = getParent();
			if (p instanceof JViewport) {
				if ((autoResizeMode == AUTO_RESIZE_ALL_COLUMNS) && (p.getSize().getWidth() < getPreferredSize().getWidth())) {
					return(false);
				}
				else {
					return(true);
				}
			}
			return(false);
		}
	}
}
