//$Id: MessageDialog.java,v 1.2 2007/05/22 20:55:41 Sasha Buzko Exp $
//
//Copyright (c) 2000-2003 San Diego Supercomputer Center (SDSC),
//a facility operated jointly by the University of California,
//San Diego (UCSD) and General Atomics, San Diego, California, USA.
//
//Users and possessors of this source code are hereby granted a
//nonexclusive, royalty-free copyright and design patent license to
//use this code in individual software. License is not granted for
//commercial resale, in whole or in part, without prior written
//permission from SDSC. This source is provided "AS IS" without express
//or implied warranty of any kind.
// 
//For further information, please see: <http://mbt.sdsc.edu>
// 
//History:
//$Log: MessageDialog.java,v $
//Revision 1.2  2007/05/22 20:55:41  Sasha Buzko
//*** empty log message ***
//
//Revision 1.1  2006/10/21 17:52:13  Sasha Buzko
//Refactored the project to move all new code to edu.sdsc.sirius package.
//
//Revision 1.1  2006/05/20 17:02:01  Sasha Buzko
//Updated version
//
//Revision 1.1  2006/04/30 20:13:56  Sasha Buzko
//New version of the app
//
//Revision 1.1  2006/04/15 19:42:18  Sasha Buzko
//Initial commit
//
//Revision 1.1  2005/11/13 04:35:23  Administrator
//*** empty log message ***
//
//Revision 1.2 2003/05/15 23:44:54 moreland
//Cleaned up code a bit for a preliminary release to obuzko.
//
//Revision 1.1 2003/05/15 22:42:45 moreland
//An application which incorporates more MBT GUI layer components.
//
//Revision 1.0 2003/05/05 16:06:13 moreland
//First version.
// 

package edu.sdsc.sirius.dialogs;

import javax.swing.*;

import java.awt.event.*;
import javax.swing.border.*;
import java.awt.*;
import javax.swing.event.*;

import edu.sdsc.sirius.util.BrowserControl;
import edu.sdsc.sirius.util.BrowserLauncher;

import java.net.*;

public class TextPanel extends JDialog {
	
	private JFrame parent;
	private JDialog parentDialog;
	private String message;
	
	private Container contentPane;
	private JScrollPane scrollPane;
	private JEditorPane textPane;
	
	public TextPanel(JFrame parent, String message){
		
		super(parent, "Data", true);
		this.parent = parent;
		this.message = message;
		
		initialize();
	}
	
	public TextPanel(JFrame parent, String message, String title){
		
		super(parent, title, true);
		this.parent = parent;
		this.message = message;
		
		initialize();
	}

	
	public TextPanel(JDialog parent, String message){
		
		super(parent, "Data", true);
		this.parentDialog = parent;
		this.message = message;
		
		initialize();
	}
	
	private void initialize(){
		
		contentPane = getContentPane();
		
		JPanel base = new JPanel();
		base.setLayout(new BorderLayout());
		
		JPanel messagePanel = new JPanel();
		messagePanel.setLayout(new BorderLayout());
		messagePanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		
		textPane = new JEditorPane();
		textPane.setSelectionColor(new Color(0,50,190));
//		textPane.setBackground(new Color(210,210,210));
		textPane.setFont(new Font("Dialog", Font.PLAIN, 12));
		textPane.setEditable(false);
		
		textPane.addHyperlinkListener(new HyperlinkListener(){
			public void hyperlinkUpdate(HyperlinkEvent e){
				if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
					final URL url = e.getURL();
					if (url == null) return;
					
					try {
	 					Thread runner = new Thread(){
	 						public void run(){
	 							try{	
	 								String os = System.getProperty("os.name");
	 								if (os.startsWith("Win")){
	 									BrowserControl.displayURL(url.toString());
	 								}
	 								else{
	 									BrowserLauncher.openURL(url.toString());
	 								}
	 							}
	 							catch (Exception e){
	 								JOptionPane.showMessageDialog(null, "Unable to display the requested address.", "Error", JOptionPane.ERROR_MESSAGE);
	 								return;
	 							}
	 						}
	 					};
	 					runner.start();
	 		          } catch (Throwable t) {
	 		        	  
	 		          }
					
				}
			}
		});
		
		
		textPane.setContentType("text/html");
		textPane.setText(message);
		
		scrollPane = new JScrollPane();
		JViewport vp = scrollPane.getViewport();
		vp.setView(textPane);
		
		messagePanel.add(scrollPane, BorderLayout.CENTER);
		
		JPanel buttonPanel = new JPanel();
		
		JButton button = new JButton("OK");
		button.setPreferredSize(new Dimension(70,25));
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				dispose();
			}
		});
		buttonPanel.add(button);
		
		base.add(messagePanel, BorderLayout.CENTER);
		base.add(buttonPanel, BorderLayout.SOUTH);
		
		contentPane.add(base);
		
		setSize(800,350);
		
		if (parent == null && parentDialog == null){
			setLocationRelativeTo(null);
		}
		else if (parent != null){
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parent.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parent.getX(), y + parent.getY(), d1.width, d1.height);
		}
		else if (parentDialog != null){
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentDialog.getSize();
		
			int x = Math.max((d2.width - d1.width)/2, 0);
			int y = Math.max((d2.height - d1.height)/2, 0);
		
			setBounds(x + parentDialog.getX(), y + parentDialog.getY(), d1.width, d1.height);
		}
		else{
			setLocationRelativeTo(null);
		}
		
		base.revalidate();
		
		setVisible(true);
		
		
	}
	
}