package edu.sdsc.sirius.dialogs;

// Core
import java.util.*;

// GUI
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// MBT
import edu.sdsc.mbt.*;
import edu.sdsc.sirius.util.Manager;
import edu.sdsc.sirius.viewers.*;

public class WeightDialog extends JDialog implements DisplayDialog {

	private JFrame parentFrame = null;
	private Manager parent = null;
	private StructureViewer sv = null;
	private StructureComponent structureComponent;
	
	private DisplayDialog itself = null;

	private Container contentPane = null;
	private JPanel base = new JPanel();
	private JPanel setPanel = new JPanel();
	
	private Border border1 = null;
	private TitledBorder border2 = null;
	private Border border = null;
	
	public static int setFlag = DialogConstants.APPLY_SELECTION;
	
	private ButtonGroup setGroup = new ButtonGroup();
	private JRadioButton radio1 = new JRadioButton("Currently selected", false);
	private JRadioButton radio2 = new JRadioButton("Structure", true);
	private JRadioButton radio3 = new JRadioButton("Chain", false);
	private JRadioButton radio4 = new JRadioButton("Residue", false);
	private JRadioButton radio5 = new JRadioButton("Atom", false);
	
	private JTextField field = new JTextField(30);
	private JLabel header = new JLabel();
	private JLabel label = new JLabel();
	
	private JLabel or = new JLabel("or");
	private JComboBox combo = new JComboBox();
	private Vector structures = new Vector();

	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("Cancel");
	
	private WeightEvent event;
	
	public WeightDialog(JFrame f, Manager p, StructureViewer s){

		super(f, "Compute molecular weight", false);
		
		setFlag = DialogConstants.APPLY_STRUCTURE;
	
		parentFrame = f;
		parent = p;
		sv = s;
		
		parent.setDisplayDialogStatus(true);
		
		itself = this;
		
		//create the panels
		contentPane = getContentPane();
		contentPane.setLayout(null);
		
		base.setPreferredSize(new Dimension(230, 270));
		base.setBorder(new BevelBorder(BevelBorder.RAISED));
		base.setLocation(new Point(5,5));
		base.setBounds(5, 5, 230, 270);
		base.setLayout(null);
		
		setPanel.setPreferredSize(new Dimension(220, 260));
		setPanel.setLocation(new Point(5,5));
		setPanel.setBounds(5,5,220,260);
		setPanel.setLayout(null);
		
		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), " Structure objects ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		setPanel.setBorder(border);
		
		//text field
		header.setForeground(Color.black);
		header.setFont(new Font("Dialog", Font.PLAIN, 12));
		header.setText("Pick object in display");
		header.setPreferredSize(new Dimension(150,20));
		header.setBounds(20,60,150,20);
		header.setLocation(new Point(20,60));
		header.setVisible(true);
		
		label.setForeground(Color.black);
		label.setFont(new Font("Dialog", Font.PLAIN, 11));
		label.setText("Enter name or click structure");
		label.setPreferredSize(new Dimension(8,20));
		label.setBounds(20,175,170,20);
		label.setLocation(new Point(20,175));
		label.setVisible(true);
		
		field.setPreferredSize(new Dimension(170,20));
		field.setBounds(20,200,170,20);
		field.setLocation(new Point(20,200));
		field.setEditable(true);
		field.setEnabled(true);
		field.setVisible(true);
		field.requestFocus();
		field.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (radio1.isSelected()){
					setFlag = DialogConstants.APPLY_STRUCTURE;
					radio1.setSelected(false);
					radio2.setSelected(true);
					field.setText("");
					field.setEditable(true);
					field.setEnabled(true);
					field.requestFocus();
				}
			}
		});
		field.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent k){
				if (k.getKeyCode() == KeyEvent.VK_ENTER){
					//do the same thing as with OK button
					process();
				}
				else if(k.getKeyCode() == KeyEvent.VK_ESCAPE){
					//do the same thing as with Cancel button
					setVisible(false);
					parent.setDisplayDialogStatus(false);
					dispose();
				}
			}
		});
					
		or.setForeground(Color.black);
		or.setFont(new Font("Dialog", Font.PLAIN, 11));
		or.setPreferredSize(new Dimension(15,20));
		or.setBounds(20,230,15,20);
		or.setLocation(new Point(20,230));
		or.setVisible(true);
		
		//walk through the loaded structures
		structures.add("Select structure or set");
		for (int i = 0; i < sv.getLoadedStructures().size(); i++){
			Structure st = (Structure)sv.getLoadedStructures().get(i);
			structures.add(sv.getStructureName(st));
		}

		Vector setNames = sv.getAtomSetNames();
		for (int i = 0; i < setNames.size(); i++){
			structures.add(setNames.get(i));
		}

		combo = new JComboBox(structures);
		combo.setPreferredSize(new Dimension(155,20));
		combo.setBounds(35,230,155,20);
		combo.setLocation(new Point(35,230));
		combo.setVisible(true);
		if (structures.size() == 1) combo.setEnabled(false);
		combo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				String choice = (String)combo.getSelectedItem();
				field.setText(choice);
				setFlag = DialogConstants.APPLY_STRUCTURE;		
				radio2.setSelected(true);
			}
		});
	
		
		
		//define the radio buttons
		radio1.setLocation(20,25);
		radio1.setBounds(20,25,150,20);
		radio1.setVisible(true);
		radio1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_SELECTION;
				field.setText("");
				field.setEditable(false);
				field.setEnabled(false);
			}
		});
		
		radio2.setLocation(20,85);
		radio2.setBounds(20,85,150,20);
		radio2.setVisible(true);
		radio2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_STRUCTURE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio3.setLocation(20,105);
		radio3.setBounds(20,105,150,20);
		radio3.setVisible(true);
		radio3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_CHAIN;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio4.setLocation(20,125);
		radio4.setBounds(20,125,150,20);
		radio4.setVisible(true);
		radio4.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_RESIDUE;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		radio5.setLocation(20,145);
		radio5.setBounds(20,145,150,20);
		radio5.setVisible(true);
		radio5.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setFlag = DialogConstants.APPLY_ATOM;
				field.setEditable(true);
				field.setEnabled(true);
				field.requestFocus();
			}
		});
		
		//draw a line between the radio buttons
		JSeparator line = new JSeparator();
		line.setLocation(10,55);
		line.setBounds(10,55,180,5);
		line.setVisible(true);
		
		setPanel.add(line);
		setPanel.add(header);
		
		setGroup.add(radio1);
		setGroup.add(radio2);
		setGroup.add(radio3);
		setGroup.add(radio4);
		setGroup.add(radio5);
		
		setPanel.add(radio1);
		setPanel.add(radio2);
		setPanel.add(radio3);
		setPanel.add(radio4);
		setPanel.add(radio5);
		
		setPanel.add(label);
		setPanel.add(field);
		setPanel.add(or);
		setPanel.add(combo);
		
		
		//style panel
//		phPanel.setPreferredSize(new Dimension(180, 260));
//		phPanel.setLocation(new Point(225,0));
//		phPanel.setBounds(225,5,180,260);
//		phPanel.setLayout(null);
		
/*		border1 = BorderFactory.createEmptyBorder(0,0,0,0);//left offset of the boxes in the box
		border2 = BorderFactory.createTitledBorder(new EtchedBorder(), "  pH options ");
		border2.setTitleColor(Color.black);
		border2.setTitleFont(new Font("Dialog", 0, 12));
		border = BorderFactory.createCompoundBorder(border1, border2);
		phPanel.setBorder(border);
		
		//second button group
		radio6.setLocation(20,35);
		radio6.setBounds(20,35,150,20);
		radio6.setVisible(true);
		radio6.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				phFlag = PH_NEUTRAL;
				phText.setEnabled(false);
				phText.setEditable(false);
			}
		});
		
		radio7.setLocation(20,60);
		radio7.setBounds(20,60,150,20);
		radio7.setVisible(true);
		radio7.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				phFlag = PH_CUSTOM;
				phText.setEnabled(true);
				phText.setEditable(true);
				phText.requestFocus();
			}
		});
		
		phText.setPreferredSize(new Dimension(140,20));
		phText.setBounds(20,200,140,20);
		phText.setLocation(new Point(20,200));
		phText.setEditable(false);
		phText.setEnabled(false);
		phText.setVisible(true);
		phText.addMouseListener(new MouseAdapter(){
			public void mouseClicked(MouseEvent m){
				if (radio6.isSelected()){
					phFlag = PH_CUSTOM;
					radio6.setSelected(false);
					radio7.setSelected(true);
					phText.setText("");
					phText.setEditable(true);
					phText.setEnabled(true);
					phText.requestFocus();
				}
			}
		});
		
		
		phGroup.add(radio6);
		phGroup.add(radio7);
		
		phPanel.add(radio6);
		phPanel.add(radio7);
		phPanel.add(phText);
*/		
		//add panels to the base
		base.add(setPanel);
//		base.add(phPanel);
		
		
		//buttons
		okButton.setBounds(25, 285, 80, 25);
		okButton.setVisible(true);
		okButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				process();
			}
		});
		
		
		cancelButton.setBounds(135, 285, 80, 25);
		cancelButton.setVisible(true);
		cancelButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
		});
		
		
		contentPane.add(base);
		contentPane.add(okButton);
		contentPane.add(cancelButton);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setVisible(false);
				parent.setDisplayDialogStatus(false);
				dispose();
			}
			
			public void windowDeactivated(WindowEvent e){
				toFront();
			}
		});
				
		setSize(245, 350);
		
		//add this to accommodate both applet and application cases
		if (parentFrame == null){
//			setLocationRelativeTo(null);
			setBounds(0, 0, getSize().width, getSize().height);
		}
		else{
		
			//set location
			Dimension d1 = getSize();
			Dimension d2 = parentFrame.getSize();
		
//			int x = Math.max((d2.width - d1.width)/2, 0);
//			int y = Math.max((d2.height - d1.height)/2, 0);

			int x = 5 + DialogConstants.toolbarWidth;
			int y = DialogConstants.level + DialogConstants.toolbarHeight;
		
			setBounds(x + parentFrame.getX(), y + parentFrame.getY(), d1.width, d1.height);
		}

		
		setResizable(false);
		
		setVisible(true);
		


	}
	
	private void process(){
		
		try{
			//add error checking for selection bounds
			//eg., selection level is residue, but entered only structure name
			setVisible(false);
			
			//first, check the number of tags
			int count = 0;
			StringTokenizer tok = new StringTokenizer(field.getText(), ":", false);
			while (tok.hasMoreTokens()){
				Object o = tok.nextToken();
				count++;
			}
			
			if (setFlag != 0){
				if (count < setFlag){
					setFlag = count;
				}
			}
	
			event = new WeightEvent(itself);
			event.setFlag = setFlag;
			event.structureComponent = structureComponent;
			event.componentId = field.getText();
			
	//		parent.displayWaitScreen();
			Thread runner = new Thread(){
				public void run(){
					parent.setDisplayDialogStatus(false);
					sv.processDisplayDialogEvent(event);
				}
			};
			runner.start();
		}
		catch (Exception e){
			setVisible(false);
			parent.setDisplayDialogStatus(false);
			parent.displayExceptionMessage("Exception calculating molecular weight", e);
		}
		dispose();
	}
	
	public void processPick(String data, StructureComponent structureComponent){
		this.structureComponent = structureComponent;
		if (field.isEditable()){
			field.setText(data);
		}
	}
	
}
