package edu.sdsc.sirius.export;

import java.util.*;

/**
 * This is a wrapper class to export the current state of the structure viewer
 * @author Oleksandr V. Buzko
 *
 */
public class StateObject implements java.io.Serializable {
	
	private Vector styleMap;
	private Vector structures;
	private Vector sequences;
	private Vector sequenceOrder;//stores indices of the sequence representations of each structure in the sequence viewer
	private ViewerParameters view;
	private float[][][] cellColors;
	private Vector atomSetNames = new Vector();
	
	private int independentStructureIndex = -1;
	private int[] independentResidues;
	private int[] independentAtoms;
	private boolean trackBumps = false;
	
	private int[] ramaViewers;
	private int[][] distanceMonitors;
	private int[][] bumps;
	private int[][] hBonds;
	
	public StateObject(Vector coordinates, Vector sequences, Vector styles, ViewerParameters view, float[][][] cellColors, Vector atomSetNames){
		this.structures = coordinates;
		this.sequences = sequences;
		this.styleMap = styles;
		this.view = view;
		this.cellColors = cellColors;
		this.atomSetNames.addAll(atomSetNames);
		
	}
	
	/**
	 * @return Returns the structures.
	 */
	public final Vector getStructures() {
		return structures;
	}
	/**
	 * @param structures The structures to set.
	 */
	public final void setStructures(Vector structures) {
		this.structures = structures;
	}
	/**
	 * @return Returns the view.
	 */
	public final ViewerParameters getView() {
		return view;
	}
	/**
	 * @param view The view to set.
	 */
	public final void setView(ViewerParameters view) {
		this.view = view;
	}
	
	
	
	public final float[][][] getCellColors() {
		return cellColors;
	}


	public final void setCellColors(float[][][] cellColors) {
		this.cellColors = cellColors;
	}


	/**
	 * @return Returns the styleMap.
	 */
	public final Vector getStyleMap() {
		return styleMap;
	}
	/**
	 * @param styleMap The styleMap to set.
	 */
	public final void setStyleMap(Vector styleMap) {
		this.styleMap = styleMap;
	}

	public final Vector getSequences() {
		return sequences;
	}

	public final void setSequences(Vector sequences) {
		this.sequences = sequences;
	}

	public final Vector getAtomSetNames() {
		return atomSetNames;
	}

	public final void setAtomSetNames(Vector atomSetNames) {
		this.atomSetNames = atomSetNames;
	}

	public final int[] getIndependentAtoms() {
		return independentAtoms;
	}

	public final void setIndependentAtoms(int[] independentAtoms) {
		this.independentAtoms = independentAtoms;
	}

	public final int[] getIndependentResidues() {
		return independentResidues;
	}

	public final void setIndependentResidues(int[] independentResidues) {
		this.independentResidues = independentResidues;
	}

	public final int getIndependentStructureIndex() {
		return independentStructureIndex;
	}

	public final void setIndependentStructureIndex(int independentStructureIndex) {
		this.independentStructureIndex = independentStructureIndex;
	}

	public final boolean isTrackBumps() {
		return trackBumps;
	}

	public final void setTrackBumps(boolean trackBumps) {
		this.trackBumps = trackBumps;
	}

	public final int[] getRamaViewers() {
		return ramaViewers;
	}

	public final void setRamaViewers(int[] ramaViewers) {
		this.ramaViewers = ramaViewers;
	}

	public final int[][] getBumps() {
		return bumps;
	}

	public final void setBumps(int[][] bumps) {
		this.bumps = bumps;
	}

	public final int[][] getDistanceMonitors() {
		return distanceMonitors;
	}

	public final void setDistanceMonitors(int[][] distanceMonitors) {
		this.distanceMonitors = distanceMonitors;
	}

	public final int[][] getHBonds() {
		return hBonds;
	}

	public final void setHBonds(int[][] bonds) {
		hBonds = bonds;
	}
	
	
}