package edu.sdsc.sirius.export;

/**
 * This is a holder class to store all arrays that contain styling details based
 * on indices of atoms, bonds, etc.
 * @author Oleksandr V. Buzko
 *
 */
public class StyleMap implements java.io.Serializable {
	
	private boolean[] atomSelection;
	private boolean[] atomVisibility;
	private short[] atomRenderingStyle;
	private short[] atomRenderingQuality;
	private float[][] atomColors;
	private float[][] residueColors;
	private float[][] ribbonColors;
	private int[] atomSetAssignment;
	private int[] residueSetAssignment;
	
	private int[] labeledResidueIndices;
	private int[] labels;
	private String[] labelText;
	private int[] labelSize;
	private boolean[] labelSelection;
	private float[][] labelColor;
	
	private int[] residueLabels;
	private String[] residueLabelText;
	private int[] residueLabelSize;
	private boolean[] residueLabelSelection;
	private float[][] residueLabelColor;

	
	private int[] ribbons;//length is the number of chains. if no ribbon for each chain = -1, otherwise, ribbon type integer
	private float[] ribbonQuality;
	private boolean[] ribbonVis;
	

	
	/**
	 * Indicates order in which the given sequence appears in the sequence viewer
	 */
	private int sequenceIndex = 0;
	
	/**
	 * Indicates whether the sequence is selected in the sequence viewer
	 */
	private boolean sequenceSelected = false;
	
	/**
	 * @return Returns the atomRenderingQuality.
	 */
	public final short[] getAtomRenderingQuality() {
		return atomRenderingQuality;
	}
	/**
	 * @param atomRenderingQuality The atomRenderingQuality to set.
	 */
	public final void setAtomRenderingQuality(short[] atomRenderingQuality) {
		this.atomRenderingQuality = atomRenderingQuality;
	}
	/**
	 * @return Returns the atomRenderingStyle.
	 */
	public final short[] getAtomRenderingStyle() {
		return atomRenderingStyle;
	}
	/**
	 * @param atomRenderingStyle The atomRenderingStyle to set.
	 */
	public final void setAtomRenderingStyle(short[] atomRenderingStyle) {
		this.atomRenderingStyle = atomRenderingStyle;
	}
	/**
	 * @return Returns the atomSelection.
	 */
	public final boolean[] getAtomSelection() {
		return atomSelection;
	}
	/**
	 * @param atomSelection The atomSelection to set.
	 */
	public final void setAtomSelection(boolean[] atomSelection) {
		this.atomSelection = atomSelection;
	}
	/**
	 * @return Returns the atomVisibility.
	 */
	public final boolean[] getAtomVisibility() {
		return atomVisibility;
	}
	/**
	 * @param atomVisibility The atomVisibility to set.
	 */
	public final void setAtomVisibility(boolean[] atomVisibility) {
		this.atomVisibility = atomVisibility;
	}
	
	
	/**
	 * @return Returns the atomColors.
	 */
	public final float[][] getAtomColors() {
		return atomColors;
	}
	/**
	 * @param atomColors The atomColors to set.
	 */
	public final void setAtomColors(float[][] atomColors) {
		this.atomColors = atomColors;
	}
	
	
	
	public final float[][] getResidueColors() {
		return residueColors;
	}
	public final void setResidueColors(float[][] residueColors) {
		this.residueColors = residueColors;
	}
	public final int getSequenceIndex() {
		return sequenceIndex;
	}
	
	
	public final void setSequenceIndex(int sequenceIndex) {
		this.sequenceIndex = sequenceIndex;
	}
	
	public final boolean getSequenceSelected() {
		return sequenceSelected;
	}
	
	public final void setSequenceSelected(boolean sequenceSelected) {
		this.sequenceSelected = sequenceSelected;
	}
	public final int[] getAtomSetAssignment() {
		return atomSetAssignment;
	}
	public final void setAtomSetAssignment(int[] atomSetAssignment) {
		this.atomSetAssignment = atomSetAssignment;
	}
	public final int[] getResidueSetAssignment() {
		return residueSetAssignment;
	}
	public final void setResidueSetAssignment(int[] residueSetAssignment) {
		this.residueSetAssignment = residueSetAssignment;
	}
	
	public final float[][] getRibbonColors() {
		return ribbonColors;
	}
	public final void setRibbonColors(float[][] ribbonColors) {
		this.ribbonColors = ribbonColors;
	}
	
	public final int[] getRibbons() {
		return ribbons;
	}
	public final void setRibbons(int[] ribbons) {
		this.ribbons = ribbons;
	}
	public final float[] getRibbonQuality() {
		return ribbonQuality;
	}
	public final void setRibbonQuality(float[] ribbonQuality) {
		this.ribbonQuality = ribbonQuality;
	}
	public final boolean[] getRibbonVis() {
		return ribbonVis;
	}
	public final void setRibbonVis(boolean[] ribbonVis) {
		this.ribbonVis = ribbonVis;
	}
	public final int[] getLabeledResidueIndices() {
		return labeledResidueIndices;
	}
	public final void setLabeledResidueIndices(int[] labeledResidueIndices) {
		this.labeledResidueIndices = labeledResidueIndices;
	}
	public final int[] getLabels() {
		return labels;
	}
	public final void setLabels(int[] labels) {
		this.labels = labels;
	}
	public final String[] getLabelText() {
		return labelText;
	}
	public final void setLabelText(String[] labelText) {
		this.labelText = labelText;
	}
	public final int[] getLabelSize() {
		return labelSize;
	}
	public final void setLabelSize(int[] labelSize) {
		this.labelSize = labelSize;
	}
	public final float[][] getLabelColor() {
		return labelColor;
	}
	public final void setLabelColor(float[][] labelColor) {
		this.labelColor = labelColor;
	}
	public final boolean[] getLabelSelection() {
		return labelSelection;
	}
	public final void setLabelSelection(boolean[] labelSelection) {
		this.labelSelection = labelSelection;
	}
	public final float[][] getResidueLabelColor() {
		return residueLabelColor;
	}
	public final void setResidueLabelColor(float[][] residueLabelColor) {
		this.residueLabelColor = residueLabelColor;
	}
	public final int[] getResidueLabels() {
		return residueLabels;
	}
	public final void setResidueLabels(int[] residueLabels) {
		this.residueLabels = residueLabels;
	}
	public final boolean[] getResidueLabelSelection() {
		return residueLabelSelection;
	}
	public final void setResidueLabelSelection(boolean[] residueLabelSelection) {
		this.residueLabelSelection = residueLabelSelection;
	}
	public final int[] getResidueLabelSize() {
		return residueLabelSize;
	}
	public final void setResidueLabelSize(int[] residueLabelSize) {
		this.residueLabelSize = residueLabelSize;
	}
	public final String[] getResidueLabelText() {
		return residueLabelText;
	}
	public final void setResidueLabelText(String[] residueLabelText) {
		this.residueLabelText = residueLabelText;
	}
	
	
	
}