// DLL de fonctions d'analyse de squences pour Anagne
// Erik Boucher de Crvecoeur - CNDP - 1996
// Erik Boucher de Crvecoeur - CNDP - 2000 : version 32 bits et correction de bugs

#include <stdio.h>
#include <windows.h>
#include <string.h>

#include "general.h"
#include "alig.h"

#define MES_PB_MEMOIRE "Erreur d'allocation de mmoire !"

// prototypes
extern "C" {

	void FAR PASCAL Comparer(char far *, char far *, int, int);
	int FAR PASCAL CompteIdentites(char far *, char far *, int, int, int far *);
	int FAR PASCAL CompteConsensus(char far *, int far *, int far *, int far *);
	void FAR PASCAL ComposBases( char far* don,
								 int far*, int far*, int far*, int far*, int far*, int far *);
	long FAR PASCAL ComposPM( char far*, int,
							  int far*, int far*, int far*, int far*, int far*, int far*, int far*, int far*,
							  int far*, int far*, int far*, int far*, int far*, int far*, int far*, int far*,
							  int far*, int far*, int far*, int far*, int far*);

	void FAR PASCAL Transcrire(char far*);
	void FAR PASCAL InvTranscrire(char far*);
	void FAR PASCAL Complement(char far*);

	int FAR PASCAL Traduire(char far*, int);
	int FAR PASCAL TradFirst(char far*, int);
	int FAR PASCAL RechTrad(char far*, int, int);
	int FAR PASCAL RechOrf(char far*, int);
	int FAR PASCAL CompteOrf(char far*, int, int far*);
	int FAR PASCAL CompteTrad(char far*, int, int far*);

	void FAR PASCAL OneToThree(char far*, char far*, int);
	void FAR PASCAL AlignToThree(char far*, char far*, int, int);
	int FAR PASCAL ThreeToOne(char far*, int);
	void FAR PASCAL InvTrad(char far*, char far*, int);

	int MatchSite(char far*, char far*, int, int);
	void Pos_Or(char far *, int, char far *, int);
	int FAR PASCAL Enzyme(char far*, char far*, char far*, __int16);
	void FAR PASCAL SitesEnzyme(char far *, char far *, HWND, char far *, HWND, int, int);
	void FAR PASCAL CarteEnzyme(char far *, HWND, int, int);
	int FAR PASCAL CompteEnz(char far *, int, int far *, int far *);
	int FAR PASCAL CompteEnzAvecTri(char far *, int, int far *, int far *);

	int FAR PASCAL TypeSeq(char far *);
	
	int FAR PASCAL ProcessActif(DWORD);
}

// types
typedef struct { int longueur, debcut, fincut; } fragment;

// variables

char far** donnees;
char far** resultat;

char   Cod[193] ="GCAGCCGCGGCUUGCUGUGACGAUGAAGAGUUCUUUGGAGGCGGGGGUCACCAUAUAAUCAUUAAAAAGUUAUUGCUACUCCUGCUUAUGAACAAUCCACCCCCGCCUCAACAGAGAAGGCGACGCCGGCGUAGCAGUUCAUCCUCGUCUACAACCACGACUGUAGUCGUGGUUUGGUACUAUUAAUAGUGA";
char Trois[190] ="AlaAlaAlaAlaCysCysAspAspGluGluPhePheGlyGlyGlyGlyHisHisIleIleIleLysLysLeuLeuLeuLeuLeuLeuMetAsnAsnProProProProGlnGlnArgArgArgArgArgArgSerSerSerSerSerSerThrThrThrThrValValValValTrpTyrTyr___   ";
char   Une[190] ="  A  A  A  A  C  C  D  D  E  E  F  F  G  G  G  G  H  H  I  I  I  K  K  L  L  L  L  L  L  M  N  N  P  P  P  P  Q  Q  R  R  R  R  R  R  S  S  S  S  S  S  T  T  T  T  V  V  V  V  W  Y  Y  _   ";
char Blanc[4]   ="   ";
char Met[4]     =">>>";
char Traduit[4] ="===";
char Stop[4]    ="~~~";
char Indeter[10] ="Xxx  X???";

char TroisPM[61] ="AlaCysAspGluPheGlyHisIleLysLeuMetAsnProGlnArgSerThrValTrpTyr";
char   UnePM[61] ="  A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y";
long      PM[20] ={891,1212,1331,1471,1652,751,1552,1312,1462,1312,1492,1321,1151,1461,1742,1051,1191,1171,2042,1812};
// PM : donnes multiplis par 10, en long int pour allger les calculs / float
// -> on divisera par 10 dans le programme appelant

HGLOBAL h_donnees;
HGLOBAL * donnees_hMem;
HGLOBAL h_donnees_hMem;

HGLOBAL h_resultat;
HGLOBAL * resultat_hMem;
HGLOBAL h_resultat_hMem;



// ==========================================================================
// =============== AUTRES FONCTIONS POUR GENESIS ============================
// ==========================================================================


// ============= COMPARER
void FAR PASCAL Comparer( char far *donnees,
						char far *resultat, int TypeSeq, int Three)
{
	switch(TypeSeq)
	{
	case 3:		while(*resultat && *(resultat+1) && *(resultat+2)
					  && *donnees && *(donnees+1) && *(donnees+2) )		// Proteiques
				{
					if (    *donnees      == *resultat
						&&  *(donnees+1)  == *(resultat+1)
						&&  *(donnees+2)  == *(resultat+2)
						&&  *(resultat+2) != ' '
						&&  *(resultat+2) != '_'		 	)

						{ if(Three) { *resultat    = '-';
									  *(resultat+1)= ' ';
									  *(resultat+2)= ' '; }

						  else	    { *resultat    = ' ';
									  *(resultat+1)= ' ';
									  *(resultat+2)= '-'; };	};

	 				resultat = resultat+3;
     				donnees  = donnees +3;
			    }
                break;


    default:	while(*resultat && *donnees)							// Nucleiques
				{
					if ( 	 *donnees  == *resultat
						 &&  *resultat != ' '
						 &&  *resultat != '_'		)	*resultat = '-';
	 				resultat++;
     				donnees++;
			    }

	}
}


// ============= COMPTEIDENTITES
int FAR PASCAL CompteIdentites( char far *donnees, char far *resultat,
								int TypeSeq, int Decal, int far *identites)
{   int donlen;
	int reslen;
	int longueur;
	int ident;

	donlen = strlen(donnees);
	reslen = strlen(resultat);

	ident    = 0;
	longueur = 0;

	if (Decal < 0)  { longueur = -Decal;
					  if (longueur >= reslen)
						 { *identites = ident;
						   return (TypeSeq==3) ? (reslen / 3) : reslen;	}
					  else
					  	 { resultat = resultat + longueur;		};
					};

	if (Decal > 0)  { if (Decal >= donlen)
						 { *identites = ident;
						   return (TypeSeq==3) ? (reslen / 3) : reslen;	}
					  else
					     { donnees = donnees + Decal;	  		};
					};


	switch(TypeSeq)
	{
	case 3:		while(	 *resultat && *(resultat+1) && *(resultat+2)
					  && *donnees  && *(donnees +1) && *(donnees +2)	 ) // Proteiques
				{                                                 
					if ( *(resultat+2) != '_'	)

						{ longueur++;

						  if( 	  *donnees      == *resultat
						  	  &&  *(donnees+1)  == *(resultat+1)
							  &&  *(donnees+2)  == *(resultat+2)	)	ident++;
						}; 

	 				resultat = resultat+3;
     				donnees  = donnees +3;
				}

				while(	 *resultat && *(resultat+1) && *(resultat+2)	)
				{                                                 
					if ( *(resultat+2) != '_' ) longueur++;
					resultat = resultat+3;
				}
                
                break;


    default:	while( *resultat && *donnees )							   // Nucleiques
				{
					if ( *resultat != '_'	)

						{ longueur++;
						  if ( *donnees  == *resultat ) ident++;
						};

					resultat++;
     				donnees++;
				}

				while( *resultat  )
				{
					if ( *resultat != '_'	) longueur++;
					resultat++;
                }

	}

    
	*identites = ident;
	return longueur;
}


// ============= COMPTECONSENSUS
int FAR PASCAL CompteConsensus(char far *donnees, int far *etoiles, int far *deuxpts, int far *points)
{
	int longueur;

    longueur = 0;
	*etoiles = 0;
	*deuxpts = 0;
	*points = 0;

	while ( *donnees )
	{
	  if ( *donnees == '*' ) (*etoiles)++ ;
	  if ( *donnees == ':' ) (*deuxpts)++ ;
	  if ( *donnees == '.' ) (*points)++ ;
	  longueur++;

      donnees++;
    }

	return longueur;
}


// ============== COMPOSBASES
void FAR PASCAL ComposBases( char far* don,
							int far* A, int far* T, int far* U, int far* G, int far* C, int far* N)
{
	while (*don)
	{
	 switch(*don)
		  {	case 'A':   
			case 'a':	(*A)++; break;
			case 'T':   
			case 't':	(*T)++; break;
			case 'U':   
			case 'u':	(*U)++; break;
			case 'G':   
			case 'g':	(*G)++; break;
			case 'C':   
			case 'c':	(*C)++; break;

			default :	(*N)++; break; }

	 don++;
	}
}


// ============== COMPOSPM : Ala ou ''A --> Poids Moleculaire et composition
long FAR PASCAL ComposPM( char far* don, int Three,
						  int far*A, int far*C, int far*D, int far*E, int far*F, int far*G, int far*H, int far*I,
						  int far*K, int far*L, int far*M, int far*N, int far*P, int far*Q, int far*R, int far*S,
						  int far*T, int far*V, int far*W, int far*Y, int far*X)
{
	char* pos;
	char* Deb;
	char C1, C2, C3;

	int numAA;
	long totalPM;
	int compos[21];
	int i;

	totalPM = 0;									 
    for (i=0;i<21;i++) compos[i] = 0;

	if(Three) Deb = TroisPM;
	else 	  Deb = UnePM;

	while( (C1=*don) && (C2=*(don+1)) && (C3=*(don+2)) )
	{
        pos = Deb;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

		numAA = (int)(pos-Deb);
        numAA = numAA / 3;
		compos[numAA]++;	// on compte pour chaque Aa

        don=don+3;                      
	}

	for(i=0;i<20;i++) totalPM = totalPM + compos[i] * ( PM[i] - 180 );	// PM total

	// NB: on laisse compos[21] car PM inconnu, donc on l'exclut du total

	totalPM = totalPM + 180;

	// NB : 18 = pm de l'eau limine pour chaque AA lors de la polymrisation du peptide
	// on en enlve une  chaque AA identifi, donc une de trop pour l'ensemble du peptide
	// car liaisons = AA - 1 -> on en rajoute une  la fin

	*A=compos[0]; *C=compos[1]; *D=compos[2]; *E=compos[3]; *F=compos[4]; *G=compos[5];
	*H=compos[6]; *I=compos[7]; *K=compos[8]; *L=compos[9]; *M=compos[10]; *N=compos[11];
	*P=compos[12]; *Q=compos[13]; *R=compos[14]; *S=compos[15]; *T=compos[16];
	*V=compos[17]; *W=compos[18]; *Y=compos[19]; *X=compos[20];

	return totalPM;
}



// ============= TRANCRIRE
void FAR PASCAL Transcrire(char far* seq)
{
	while(*seq)
	{
	 if(*seq =='T') *seq='U';
     seq++;
	};
}

// ============= INVTRANSCRIRE
void FAR PASCAL InvTranscrire(char far* seq)
{
	while(*seq)
	{
	 if(*seq =='U') *seq='T';
     seq++;
	};
}


// ============= COMPLEMENT
void FAR PASCAL Complement(char far* seq)
{
	while(*seq)
	{
	   switch(*seq)
		  {	case 'A':	*seq='T'; break;
			case 'T':	*seq='A'; break;
			case 'G':	*seq='C'; break;
			case 'C':	*seq='G'; break; 
		  	case 'a':	*seq='t'; break;
			case 't':	*seq='a'; break;
			case 'g':	*seq='c'; break;
			case 'c':	*seq='g'; break; }
	   seq++;
	};
}


// ============= TRADUIRE
int FAR PASCAL Traduire(char far* seq, int Three)
{
    char far* Deb;
	char* pos;
    int ecart;
	char C1, C2, C3;

    Deb = seq;

	while( (C1=*seq) && (C2=*(seq+1)) && (C3=*(seq+2)) )
	{
		pos = Cod;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

        ecart = (int)(pos - Cod);
		if( ecart==183 || ecart==186 || ecart==189 ) return (int)(seq - Deb); // Stop

		if(*pos==EOS) { if(Three) pos = Indeter;
						else 	  pos = Indeter + 3;		}

		else		  {	if(Three) pos = Trois + ecart;
						else      pos = Une   + ecart;		};

        *seq=*pos; *(seq+1)=*(pos+1); *(seq+2)=*(pos+2);

        seq=seq+3;                      
	}
	return (int)(seq - Deb);
}


// ============= RECHTRAD
int FAR PASCAL TradFirst(char far* seq, int Three)
{
    char far* Deb;
	char* pos;
	char C1, C2, C3;
    int Trad;    	// True si codon  traduire
    int DebTrad;		// position du premier Met
	int lon;			// longueur traduite

	Deb = seq;
	pos = Cod + 87;			// Met
	Trad = 0;

	while( (C1=*seq) && (C2=*(seq+1)) && (C3=*(seq+2)) )
	{
		if( ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) )
		{	Trad = -1; break;	}
		
		*(seq++) = *Blanc;
	}

	if(Trad)
	{	
		DebTrad = (int)(seq - Deb);
		lon = Traduire(seq, Three);
		seq += lon; 
		while(*seq) *(seq++) = *Blanc;
		return DebTrad;
	}
	else return -1;
}


// ============= RECHTRAD
int FAR PASCAL RechTrad(char far* seq, int Three, int phase)
{
	char* pos;
    int ecart;
	char C1, C2, C3;
	int ORF;			// nbre d'orfs
    int Trad;    	// True si codon  traduire

	ORF = 0;
	Trad = 0;
	if(phase==1) *seq=' ';
    if(phase==2) { *seq=' '; *(seq+1)=' '; };
	seq = seq + phase;

	while( (C1=*seq) && (C2=*(seq+1)) && (C3=*(seq+2)) )
	{
		pos = Cod;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

		ecart = (int)(pos - Cod);
		if( ecart== 87 ) { Trad=-1; ORF++; };					// Met
		if( ecart==183 || ecart==186 || ecart==189 ) Trad=0;    // Stop

        if(Trad) {	if(*pos==EOS) { if(Three) pos = Indeter;      
									else 	  pos = Indeter + 3;	}

					else		  {	if(Three) pos = Trois + ecart;
									else      pos = Une   + ecart;	}; }

		else 								  pos = Blanc;

        *seq=*pos; *(seq+1)=*(pos+1); *(seq+2)=*(pos+2);

        seq=seq+3;                      
	}
	if(C1) { *seq= ' ';
			 if(C2) *(seq+1)=' '; 	}

	return ORF;
}


// ============= RECHORF
int FAR PASCAL RechOrf(char far* seq, int phase)
{
	char* pos;
    int ecart;
	char C1, C2, C3;
	int Trad;  		  // true si dans orf
	int ORF;           // nbre d'orfs

    ORF = 0;
    Trad = 0;
	if(phase==1) *seq=' ';
    if(phase==2) { *seq=' '; *(seq+1)=' '; };
	seq = seq + phase;

	while( (C1=*seq) && (C2=*(seq+1)) && (C3=*(seq+2)) )
	{
		pos = Cod;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

		ecart = (int)(pos - Cod);

		if(Trad) pos = Traduit;
		else 	 pos = Blanc;

		if( ecart== 87 ) { pos=Met;                 			// Met
						   if(!Trad) { Trad=-1; ORF++; }; 		};

		if( ecart==183 || ecart==186 || ecart==189 ) { pos = Stop; Trad=0; };	// Stop

        if( ecart==192 )   pos = Indeter + 6;					// inconnu

        *seq=*pos; *(seq+1)=*(pos+1); *(seq+2)=*(pos+2);

        seq=seq+3;                      
	}
	if(C1) { *seq= ' ';
			 if(C2) *(seq+1)=' '; 	}

	return ORF;
}


// ============= COMPTEORF
int FAR PASCAL CompteOrf(char far* seq, int Init, int far* lon)
{
    char far* pos;
	char C1;
	int Trad;  		  // true si dans orf
	int deb;           // position de dbut de l'ORF

	static int start;	// Att : a vraiment besoin d'tre static

	if(Init) start = 0;
	pos = seq + start;

    Trad = 0;
	deb = -1;

	while( (C1=*pos) && *(pos+1) && *(pos+2) )
	{
		if( (C1==*Met) && !Trad )
		{	Trad = -1; *lon = 0; deb = (int)(pos-seq);	}

		pos=pos+3;	// c'est voulu ici

		if( (C1==*Stop) && Trad ) 
		{	start = (int)(pos - seq);	// pour le prochain appel
			return deb;		}

		if(Trad) (*lon)++;   			// on ne compte pas le Stop
	}

	return deb;
}


// ============= COMPTETRAD
int FAR PASCAL CompteTrad(char far* seq, int Init, int far* lon)
{
    char far* pos;
	char C1,C3;
	int Trad;  		  // true si dans orf
	int deb;           // position de dbut de l'ORF

	static int start;	// Att : a vraiment besoin d'tre static

	if(Init) start = 0;
	pos = seq + start;

    Trad = 0;
	deb = -1;

	while( (C1=*pos) && *(pos+1) && (C3=*(pos+2)) )
	{
		if( ( (C1=='M')||(C3=='M') ) && !Trad )
		{	Trad = -1; *lon = 0; deb = (int)(pos-seq);	}

		pos=pos+3;	// c'est voulu ici
		
		if( C1==*Blanc && C3==*(Blanc+2) && Trad )
		{	start = (int)(pos - seq);	// pour le prochain appel
			return deb;		}

		if(Trad) (*lon)++;   			// on ne compte pas le Stop
	}

	return deb;
}


// ============== ONETOTHREE : A --> Ala ou ''A
void FAR PASCAL OneToThree(char far* don, char far* res, int Three)
{
	char* pos;

    while(*don)
	{
		pos = Une+2;

		while( *pos && *don!=*pos ) pos=pos+3;

		if(*pos==EOS) { if(Three) pos = Indeter + 2;
						else 	  pos = Indeter + 5;				}
		else 		  {	if(Three) pos = Trois + (int)(pos - Une);	};

        *res=*(pos-2); *(res+1)=*(pos-1); *(res+2)=*pos;

        don=don+1;
		res=res+3;                      
	}
}


// ============== ALIGNTOTHREE : idem OneToThree sauf * --> *** pour le consensus
void FAR PASCAL AlignToThree(char far* don, char far* res, int Three, int seq)
{
	if(seq) OneToThree(don, res, Three);

	else {	while(*don) { if(Three) { *res=*don; *(res+1)=' '; *(res+2)=' ' ; }
						  else		{ *res=' ' ; *(res+1)=' '; *(res+2)=*don; }

						  don=don+1; res=res+3;
						};
		};
}


// ============== THREETOONE : Ala ou ''A --> A
int FAR PASCAL ThreeToOne(char far* don, int Three)
{
	char far* res;
    char far* DebRes;
	char* pos;
	char* Deb;
	char C1, C2, C3;

	DebRes = don;
    res = DebRes;

	if(Three) Deb = Trois;
	else 	  Deb = Une;

	while( (C1=*don) && (C2=*(don+1)) && (C3=*(don+2)) )
	{
        pos = Deb;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

		if(*pos==EOS) pos = Indeter + 3;
		else 		  pos = Une + (int)(pos-Deb);

		*res = *(pos+2);

        don=don+3;
		res=res+1;                      
	}
	return (int)(res-DebRes);
}


// ============== INVTRAD : Ala ou ''A --> GCA GCC GCG GCU (6 possibilits max)
void FAR PASCAL InvTrad(char far* don, char far* res, int Three)
{
	char far* DebRes;
	char* pos;
	char* Deb;
    char* base;
	char C1, C2, C3;
    int i, lon, NumCod;

	strset(res, '.');

	lon = strlen(don) +1; // longueur +1 car on veut ajouter les sparateurs
	for(i=1; i<7; i++) *(res-1 + i*lon) = '!';	// sparateurs
	*(res-1 + 6*lon +1) ='+';	// fin, aprs un dernier sparateur

	DebRes = res;

	if(Three) Deb = Trois;
	else 	  Deb = Une;

	while( (C1=*don) && (C2=*(don+1)) && (C3=*(don+2)) )
	{
        pos = Deb;

		while( *pos && ! ( C1==*pos && C2==*(pos+1) && C3==*(pos+2) ) ) pos=pos+3;

		if(*pos==EOS) {	base = Indeter + 6;
						*(res   ) = *(base  );
						*(res +1) = *(base+1);
						*(res +2) = *(base+2);		}
						   
		else 		  { NumCod = 0;
						while ( *pos && C1==*pos && C2==*(pos+1) && C3==*(pos+2) )
						{
							base = Cod + (int)(pos-Deb);
							*(res + NumCod*lon   ) = *(base  );
							*(res + NumCod*lon +1) = *(base+1);
							*(res + NumCod*lon +2) = *(base+2);
							NumCod = NumCod+1;
							pos = pos+3;
						}
																}

		don=don+3;
		res=res+3;
	}
}


// ========================= MatchSite : non exporte : reconnaissance des sites pour Enzyme
int MatchSite(char far* don, char far* site, int lon, int seuil)
{
	int pos, score;
    char D, S;

	score = 0;

	for( pos=0; pos<lon; pos++)
	{
		if( (D=*(don+pos)) == (S=*(site+pos)) ) { score++; }
		else {
				switch(S)
				{
				 case 'N' : score++; break;
				 case 'Y' : if(D=='C' || D=='T') score++; break;
				 case 'R' : if(D=='A' || D=='G') score++; break;
				 case 'M' : if(D=='A' || D=='C') score++; break;
				 case 'K' : if(D=='G' || D=='T') score++; break;
				 case 'S' : if(D=='G' || D=='C') score++; break;
				 case 'W' : if(D=='A' || D=='T') score++; break;
				 case 'H' : if(D=='A' || D=='C' || D=='T') score++; break;
				 case 'B' : if(D=='G' || D=='T' || D=='C') score++; break;
				 case 'V' : if(D=='G' || D=='C' || D=='A') score++; break;
				 case 'D' : if(D=='G' || D=='A' || D=='T') score++; break;
				}
			}
    }

	if( score >= seuil )	{ return 1; }		// seuil en % de la longueur du site
    else				  	{ return 0; };

}


// ============== POS_OR : non exporte, pour Enzyme ; positionne les bits de sites, en vrifiant l'espace mmoire
void Pos_Or(char far * pos, int valeur, char far * res, int lonseq)
{
    if( (pos < res) || (pos > res+lonseq-1) ) return;	// ATT : si avant ou aprs la seq, abort ! 
	*pos |= valeur;
}


// ============== ENZYME : position des sites enzymatiques
int FAR PASCAL Enzyme(char far* don, char far* res, char far* chainesites, __int16 seuil)
{
	char far* pos;
    char far site[50];
	int lon, lonSeq;
	int coupe;

	int ok;
    int i;

	char far* car;
	char far* deb;

	strset(res, ' ');		// on initialise  32
    ok = 1;
	car = chainesites;
    deb = car;

	while( *car && *car!=',' ) car++;	// lecture de la longueur du site
	*car = EOS; car++;
	lon = atoi(deb); deb = car;

	seuil = (seuil * lon) / 100;

	lonSeq = strlen(don);
	if( lon > lonSeq ) return 0;		// ATT : si le site est plus grand que la squence, abort !

    while( ok )		// boucle sur les diffrents sites d'une enzyme
	{
        while( *car && *car!=',' ) car++;	// squence du site
		*car = EOS; car++;
        strncpy(site, deb, 49); *(site+49) = EOS; deb=car;

		while( *car && *car!=',' ) car++;	// position de coupure
        if( *car == EOS ) ok=0;
		*car = EOS; car++;
		coupe = atoi(deb); deb = car;

        pos = don;				// ATT : on ne commence pas avant la squence (pour les seuils < 100 %)
		while( *(pos+lon-1) )	//		 et on ne dpasse pas le bout (MatchSite est ainsi protg)
		{
			if( MatchSite(pos,site,lon,seuil) )            /// ATT aux positions o coupe fait sortir de seq
			{                                          				
				for(i=0; i<lon; i++)
				Pos_Or( ( res +(pos-don) + i ) , 1 , res, lonSeq);				// premier bit = site

				if(coupe < lon-1-coupe) for(i=coupe+1; i <= lon-2-coupe; i++)
				Pos_Or( ( res +(pos-don) + i) , 2 , res, lonSeq);				// deuxieme bit = zone de coupe '-,

				if(coupe > lon-1-coupe) for(i=coupe; i >= lon-1-coupe; i--)
				Pos_Or( ( res +(pos-don) + i) , 4 , res, lonSeq);				// troisieme bit = zone de coupe ,-'

				Pos_Or( ( res +(pos-don) + coupe) , 8 , res, lonSeq);			// quatrieme bit = extremit brin non trans
				Pos_Or( ( res +(pos-don) + lon -1 - coupe) , 16 , res, lonSeq);	// cinquieme bit = extremit brin trans
            }
			pos++;
		}

		//*( res + (pos-don) +lon-1) = EOS; 

	}

	ok = 0;		// compte du nombre de sites vrais '*'

	while( *don )
	{
		if( (*res / 8) % 2 ) ok++;		// jusqu'au bout de res par le bout de don : fin de res est inutilisable car VB passe la variable "longuechaine"
		don++; res++;                   // attention : on sacrifie les pointeurs !
	}

    return ok;
}


// ============= SITESENZYME : texte de la squence avec les zones de coupure, dans la hWnd
void FAR PASCAL SitesEnzyme(char far * don, char far * cdon, HWND hWnd, char far * carte, HWND hWndCarte, int debCurs, int lonCurs)
{
	int x;
    long i;

	int lonSeq;

	HDC hDC;
	RECT rect;

	HPEN hPenSites, hPenOld;

	TEXTMETRIC tm;
	int cw;

    char c;

	// le DC de la fenetre o tracer
	hDC = GetDC(hWnd);
	if(hDC == NULL) return;

	// le pen de sites
	hPenSites = CreatePen(PS_SOLID, 0, RGB(255,0,0));

	// la fenetre : ses dimensions
	GetClientRect(hWnd, &rect);

	// on efface la fentre
	// (astuce utilise par FillSolidRect des MFC)
	ExtTextOut(hDC, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);

	// la squence : sa longueur
	lonSeq = strlen(don);


	//------------------------------- le texte et les sites
	// affichage du texte
	SetTextAlign(hDC, TA_UPDATECP);
	SetTextColor(hDC, RGB(0,0,255));
	GetTextMetrics(hDC, &tm);

	cw = tm.tmAveCharWidth;

	MoveToEx(hDC,0, 0, NULL);
	TextOut(hDC, 0, 0, don + debCurs, lonCurs);
	MoveToEx(hDC, 0, tm.tmHeight, NULL);
	TextOut(hDC, 0, 0, cdon + debCurs, lonCurs);

    // trac des sites sur le texte
	hPenOld = (HPEN)SelectObject(hDC, hPenSites);

	SetTextColor(hDC, RGB(255,0,0));
    
	for(i=0; i<lonCurs; i++)
	{
		x = i * cw;

		c = *(carte + debCurs + i);

		if( (c / 8) % 2 ) 	{	MoveToEx(hDC, x + cw, 0, NULL);
								LineTo(hDC, x + cw, tm.tmHeight );
							}

		if( (c / 16) % 2 )	{	MoveToEx(hDC, x , tm.tmHeight, NULL);
								LineTo(hDC, x , 2 * tm.tmHeight);
							}

		if( (c / 2) % 2 )	{	MoveToEx(hDC, x , tm.tmHeight, NULL);
								LineTo(hDC, x + cw, tm.tmHeight);
							}

		if( (c / 4) % 2 )	{	MoveToEx(hDC, x , tm.tmHeight, NULL);
								LineTo(hDC, x + cw, tm.tmHeight);
							}

		if( c % 2 )			{	MoveToEx(hDC, x, 0, NULL);
								TextOut(hDC, 0, 0, don + debCurs + i, 1);
								MoveToEx(hDC, x, tm.tmHeight, NULL);
								TextOut(hDC, 0, 0, cdon + debCurs + i, 1);
							}
    }

	//------------------------------------ fin
    // on rend les ressources !
	SelectObject(hDC, hPenOld);
	DeleteObject(hPenSites);
	ReleaseDC(hWnd, hDC);

	//---------------------------- la carte graphique
	if(hWndCarte) CarteEnzyme(carte, hWndCarte, debCurs, lonCurs);
}


// ============= CARTEENZYME : carte de restriction dans la hWnd
void FAR PASCAL CarteEnzyme(char far * carte, HWND hWnd, int debCurs, int lonCurs)
{
	int x, xx;
    long i;

	int lonSeq;

    float lonFen;
	float margeLeft;
	float lonUtile;	   // pour les calculs

    float hautFen;
	float hautUtile;
	float posHaut;

	HDC hDC;
	RECT rect;

    HPEN hPenAxe, hPenSites, hPenCurs, hPenOld;

	TEXTMETRIC tm;
	int cw;
	char texte[50];
    int lontexte;

	//--------------------
	// le DC de la fenetre o tracer   
	hDC = GetDC(hWnd);
	if(hDC == NULL) return;

	// les pen d'axe et de courbe
    hPenAxe = CreatePen(PS_SOLID, 0, RGB(0,0,255));
	hPenSites = CreatePen(PS_SOLID, 0, RGB(255,0,0));
	hPenCurs = CreatePen(PS_SOLID, 0, RGB(0,192,0));

	// la fenetre : ses dimensions
	GetClientRect(hWnd, &rect);

	lonFen = float(rect.right - rect.left);
	margeLeft = float(lonFen * .025);
	lonUtile = float(lonFen * .95);

	hautFen = float(rect.bottom - rect.top);
	hautUtile = float(hautFen * .45);
	posHaut = hautFen - hautUtile;

	// on efface la fentre
	// (astuce utilise par FillSolidRect des MFC)
	ExtTextOut(hDC, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);

	// la squence : sa longueur
	lonSeq = strlen(carte);

	// boucle de trac des sites
	hPenOld = (HPEN)SelectObject(hDC, hPenSites);

    for(i=0; i<lonSeq; i++)
	{
		if( ( *(carte+i) / 8 ) % 2 )
		{
			x = int(margeLeft + lonUtile * (i + 1) / lonSeq);

			MoveToEx(hDC, x , int(posHaut - hautUtile / 2 +1), NULL);
			LineTo(hDC, x , int(posHaut + hautUtile / 2 -1));
		}
    }

	// trac de l'axe
	SelectObject(hDC, hPenAxe);
	MoveToEx(hDC, int(margeLeft), int(posHaut-1), NULL);
	LineTo(hDC, int(margeLeft + lonUtile +1), int(posHaut-1));
	MoveToEx(hDC, (int)margeLeft, (int)posHaut, NULL);
	LineTo(hDC, int(margeLeft + lonUtile +1), (int)posHaut);
	MoveToEx(hDC, (int)margeLeft, int(posHaut+1), NULL);
	LineTo(hDC, int(margeLeft + lonUtile +1), int(posHaut+1));

	// texte de graduation de l'axe
	SetTextAlign(hDC, TA_UPDATECP);
	SetTextColor(hDC, RGB(0,0,255));
	GetTextMetrics(hDC, &tm);

	cw = tm.tmAveCharWidth;

	MoveToEx(hDC, (int)margeLeft, int(posHaut + hautUtile / 2 -2), NULL);
	TextOut(hDC, 0, 0, "1", 1);

	sprintf(texte, "%d", lonSeq);
	lontexte = strlen(texte);
	MoveToEx(hDC, int(margeLeft + lonUtile - lontexte * cw), int(posHaut + hautUtile / 2 -2), NULL);
	TextOut(hDC, 0, 0, texte, lontexte);

	// trac du curseur
	if(lonCurs > -1)
    {
		SelectObject(hDC, hPenCurs);
		x = int(margeLeft + lonUtile * debCurs / lonSeq);
		xx = int(margeLeft + lonUtile * (debCurs + lonCurs) / lonSeq);
		Rectangle(hDC, x, int(posHaut - hautUtile / 2) , xx +1, int(posHaut + hautUtile / 2) );
	}

    //------------------------------------ fin
    // on rend les ressources !
	SelectObject(hDC, hPenOld);
	DeleteObject(hPenAxe);
	DeleteObject(hPenSites);
    DeleteObject(hPenCurs);
	ReleaseDC(hWnd, hDC);
}


// ============= COMPTEENZ
int FAR PASCAL CompteEnz(char far* seq, int Init, int far* dcut, int far* fcut)
{
	char far* pos;
	char far* deb;

	int lon;

	static int start;	// Att : a vraiment besoin d'tre static

	if(Init) start = 0;
	deb = pos = seq + start;

	while( *pos )
	{
		if( (*pos / 8 ) % 2 )
		{
            *dcut = (int)(deb - seq);
			*fcut = (int)(pos - seq);

			pos++;						// c'est voulu ici
			lon = (int)(pos - deb);
            start = (int)(pos - seq);	// pour le prochain appel

			return lon;
		}        	
		else
        {	pos++;	}
	}

    *dcut = (int)(deb - seq); 
	*fcut = (int)(pos -1 - seq);   //* -1 car on est sorti

    lon = (int)(pos - deb);

	return -lon;	// <0 pour indiquer la fin
}


// ============= COMPTEENZAVECTRI
int FAR PASCAL CompteEnzAvecTri(char far* seq, int Init, int far* dcut, int far* fcut)
{
	static HGLOBAL p_hMem;	// Att : a vraiment besoin d'tre static
	static fragment * mem;
    static fragment * frag;	// Att : a vraiment besoin d'tre static

	static int nbre;	// nbre total de fragments	// Att : a vraiment besoin d'tre static
    static int i;		// numro du fragment		// Att : a vraiment besoin d'tre static

	int lon;
    int ddcut, ffcut;

	int inv;		// pour le tri
    fragment temp;

    char Buffer[50];

    // initialisation mmoire
	if(Init)
	{
        nbre = Init;

        // allocation du tableau pour trier
		p_hMem = GlobalAlloc(GMEM_MOVEABLE, nbre * sizeof(fragment) );

		if (p_hMem == NULL)	// si erreur d'allocation
		{
			sprintf(Buffer,"%s", MES_PB_MEMOIRE);
            MessageBox(NULL, Buffer, "ANAGEN32.DLL", MB_TASKMODAL || MB_OK);
			*dcut = 0;
            *fcut = 0;
        	return -1;
		}
	
	    // obtention du pointeur
		mem = (fragment*)GlobalLock(p_hMem);

		// remplissage du tableau
		frag = mem;
		lon = CompteEnz(seq, 1, &ddcut, &ffcut);

		while(lon > 0)
		{
			frag->longueur = lon;
			frag->debcut = ddcut;
			frag->fincut = ffcut;
			frag ++;
			lon = CompteEnz(seq, 0, &ddcut, &ffcut);
        }

		frag->longueur = -lon;
		frag->debcut = ddcut;
		frag->fincut = ffcut;


		// tri du tableau
		inv = TRUE;
		while(inv)
		{
			inv = FALSE;
			for(frag = mem, i = 1; i < nbre; frag++, i++)
			{
				if( frag->longueur < (frag+1)->longueur )
				{
					temp = *frag;
					*frag = *(frag+1);
                    *(frag+1) = temp;
					inv = TRUE;                 	
                }
            }
        }

		// placement au premier fragment
		frag = mem; i = 1;
	}

    // renvoit des fragments 
	*dcut = frag->debcut;
   	*fcut = frag->fincut;
	lon = frag->longueur;

	if(i < nbre)
    {
		frag ++; i++;
		return lon;
	}
	else
	{
		// terminaison mmoire
		GlobalUnlock(p_hMem); GlobalFree(p_hMem); // ne pas rappeler cette fonction aprs !
		return -lon;	// <0 pour indiquer la fin
	}
}


// ========================= TypeSeq : renvoit le type suppos d'une squence
// (-1 = squence vide, 0 = ADN/ARN?, 1 = ADN, 2 = ARN, 3 = PROT)
//
int FAR PASCAL TypeSeq(char far * seq)
/* check if DNA or Protein
   The decision is based on counting all A,C,G,T,U or N.
   If >= 85% of all characters (except -) are as above => DNA  */
{
	int nresidues, nbases, arn, adn;
	float ratio;
	
	nresidues = nbases = 0;
	adn = arn = 0;	
    
	while(*seq)
	{
		if(*seq != '-')
		{
			nresidues++;
			if( (*seq == 'A') || (*seq == 'C')|| (*seq == 'G') || (*seq == 'N') ) nbases++;
			if(*seq == 'T') { nbases++; adn++; }
			if(*seq == 'U') { nbases++; arn++; }
		}

        seq++;
	}

	if( (nbases == 0) || (nresidues == 0) ) return FALSE;

	ratio = (float)nbases/(float)nresidues;

	if(ratio >= 0.85)
	{	if( adn && !arn ) {return 1;} else if( arn && !adn ) {return 2;} else {return 0;}
	}		
	else
	{	return 3;	}
}


// ============== GESTION DES PROCESS ====================================
//
// utilis aprs Shell() de VB afin de savoir si le process est toujours actif
//
// -> remplace le GetModuleUsage() du 16 bits
//
int FAR PASCAL ProcessActif(DWORD dwProcessId)
{
	HANDLE hP; 
	DWORD dw;
	BOOL r;

	hP = OpenProcess(STANDARD_RIGHTS_REQUIRED | PROCESS_QUERY_INFORMATION, FALSE ,dwProcessId);
	
	r = GetExitCodeProcess(hP, &dw);
	
	CloseHandle(hP);

	if(r && dw == STILL_ACTIVE) return TRUE; else return FALSE;
}

