unit BarreCar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TBarreCaract = class(TForm)
    ComboTypes: TComboBox;
    ComboCar: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure AfficheCar(Num:Integer);
    procedure ComboTypesChange(Sender: TObject);
    procedure ComboCarChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    NumType: integer;
  public
    { Dclarations publiques }
  end;

var
  BarreCaract: TBarreCaract;

implementation

uses Donnees, PhylObs, PhylComp;

{$R *.DFM}



procedure TBarreCaract.FormCreate(Sender: TObject);
var i:integer;
begin
  for i:=0 to Caracteres.TypeCaract.Count-1 do
   ComboTypes.Items.Add(Caracteres.TypeCaract[i]);
end;

procedure TBarreCaract.FormShow(Sender: TObject);
var
  i: integer;
begin
  ComboCar.Visible:=False;
  // Combo des types de caractres
  with ComboTypes do
  begin
     Clear;
     if (Self.Parent.Name='FormComp') then
      begin
        for i:=0 to Caracteres.NumTypeComp.Count-1 do
          Items.Add(Caracteres.TypeCaract[Caracteres.GetNumTypeComp(i)]);
        if Items.IndexOf('Morphologiques')=-1 then
          Items.Add('Morphologiques');
      end
     else
      for i:=0 to Caracteres.TypeCaract.Count-1 do
        Items.Add(Caracteres.TypeCaract[i]);

     Text:='Donnes';
     Hint:='Choisir un type de donnes';
     SelStart:=0;
  end;   
end;

procedure TBarreCaract.AfficheCar(Num: Integer);
begin
   if (Parent.Name='FormObs') then
      FormObs.AfficheCaract(FormObs.ImageEsp.Tag,Num)
   else if (Parent.Name='FormComp') then
      FormComp.AfficheCaract(Num);
end;


procedure TBarreCaract.ComboTypesChange(Sender: TObject);
// change la combo des caracteres en fn du type
var
   N,i: integer;
begin
 with TComboBox(Sender) do
 begin
   if (ItemIndex > Items.Count-1) or (ItemIndex < 0) then exit;
   SelStart:=0;
   if Items[ItemIndex]='Morphologiques' then   // donnes morpho pour la comparaison
   begin
      ComboCar.Visible:=false;
      FormComp.AfficheEspeces;
      exit;
   end;
   if Self.Parent.Name='FormComp' then
      NumType:=Caracteres.GetNumTypeComp(ItemIndex)
   else
      NumType:=ItemIndex;
 end;

 N:= Caracteres.GetNbCar(NumType);
 ComboCar.Clear;
 if N=1 then               // si un seul caractre
  begin
      ComboCar.Visible:=False; // on n'affiche pas la combo des caractres
      AfficheCar(Caracteres.GetNumCar(NumType,0)); // on affiche directement l'image du caractre
  end
 else                      // sinon on affiche la combo des caractres
  begin
      ComboCar.visible:=True;
      ComboCar.Text:='Donnes disponibles';
      ComboCar.Hint:='Donnes disponibles';
      ComboCar.SelStart:=0;
      for i:=0 to N - 1 do
        ComboCar.Items.Add(Caracteres.GetNom(Caracteres.GetNumCar(NumType,i)));
  end;
end;

procedure TBarreCaract.ComboCarChange(Sender: TObject);
begin
   with TComboBox(Sender) do
   if (ItemIndex > -1) and (ItemIndex < Items.Count) then
     AfficheCar(Caracteres.GetNumCar(NumType,TComboBox(Sender).ItemIndex));
end;

{procedure TBarreCaract.AjouteMorpho;
var
   ind:integer;
begin
   ind:= ComboTypes.Items.IndexOf('Morphologiques');
   if (Parent.Name='FormComp') and (ind=-1) then
        ComboTypes.Items.Add('Morphologiques');
   if (Parent.Name='FormObs') and (ind <> -1) then
        ComboTypes.Items.Delete(ind);
end;  }

end.
