unit ListEtat;

interface

uses
sysutils ,strbox,classes,listinteger;

type

TListEtat =class(TObject)

public

Freq :integer;
Uncertain : integer;
List :TListInteger;

function Compare(Tab:TListEtat):integer;
procedure CombineMult3( E1,E2,E3: TListEtat);
function  Min :integer;
function  Max :integer;
function  Left(val:integer):boolean;
function  Right(val:integer):boolean;
function  CombineO(Etat1,Etat2: TListEtat):integer;
function  IsSubset(Etat:TListEtat):integer;
procedure CombinePlus3(e1,e2,e3 : TListEtat);
function  CombinePlus (etat1,etat2 :TListEtat):integer;
function  AffecteMinMax(min, max:integer):integer;
procedure Range(etat:TListEtat);
function  MinMaxO(etat1:TListEtat; etat2 :TListEtat ):integer;
procedure Unir(etat1:TListEtat; etat2 :TListEtat);
procedure Trier;
procedure Fusionner(etat1 :TListEtat ; etat2:TListEtat );
procedure Closest(etat1: TListEtat ; etat2 : TListEtat);

procedure Intersect(etat1: TListEtat; etat2:TListEtat );
procedure IntersectO(etat1: TListEtat; etat2:TListEtat );
procedure Lister;
procedure CopyList(Tab :TListInteger);
function  GetEtat(i : integer):integer;
function  Transforme(delim :char):string;
constructor Create;
constructor CreateListEtat(ListE :TListEtat);
constructor CreateList(Alist : TListInteger);
constructor CreateStr(chaine :string; delim: char);
end;

implementation
 //*****************************************************************************/
function TListEtat.GetEtat(i : integer):integer;
begin
 result:= List.Items[i];
end;
//*****************************************************************************/
constructor TListEtat.CreateStr(chaine :string; delim: char);
var
 Liststr:TStringList;
 str :string;
 index:integer;

 begin
  ListStr:=GetListWord(chaine,delim);
  List:=TListInteger.create;

  for index:=0 to ListStr.Count-1 do
   begin
    str:=ListStr[index];
    List.add(StrToInt(str));
   end;
 ListStr.free;
 Uncertain:=0;
 Freq:=0;
end;
//*****************************************************************************/
constructor TListEtat.Create;
 begin
  List:=TListInteger.create;
  Uncertain:=0;
  Freq:=0;
 end;
//*****************************************************************************/
constructor TListEtat.CreateList(Alist : TListInteger);
 var
  index :integer;
 begin
  List:=TListInteger.create;
   for index:=0 to Alist.count-1 do List.add(AList.Items[index]);
     Uncertain:=0;
     Freq:=0;
 end;
//*****************************************************************************/
function TListEtat.Transforme(delim :char):string;
var
 i :integer;
 AString, TotString :string;
 begin
 TotString:='';
  for i:=0 to List.Count-1 do
    begin
      AString:=IntToStr( List.Items[i]);
      AString:=AString+delim;
      TotString:=TotString+AString;
    end;
  SetLength(TotString, length(TotString)-1); // Pour enlever le '/'
  result:=TotString;
 end;

//*****************************************************************************/
constructor TListEtat.CreateListEtat(ListE :TListEtat);
var
i:integer;
begin
 List:=TListInteger.create;
 for i:=0 to ListE.List.Count-1 do
  List.Items[i]:=ListE.List.Items[i];
 Uncertain:=ListE.Uncertain;
 Freq:=ListE.Freq;

end;
//*****************************************************************************/
// jfr modifie le 09/09/04
function TListEtat.Left(val:integer):boolean;
begin
if (max<val) then result:=true else result:=false;
end;

function TListEtat.Right(val:integer):boolean;
begin
if (min>val) then result:=true else result:=false;
end;
//********************************************************************/
procedure TListEtat.CopyList(Tab :TListInteger);
var
i :integer;
begin
  List.clear;
  for  i:=0 to Tab.Count-1 do  List.Items[i]:= Tab.Items[i];
end;

// fonction qui transforme une liste  trous en une liste sans trou {1,3} -> {1,2,3}
// utilise pour les caractres ordonns
//  jfr modifie  09/09/04

//********************************************************************/
procedure TListEtat.Lister ;
     var
     aMin, aMax,i :integer;
      newlist1: TListInteger;
 begin
  aMin:= min;
  aMax:= max;

  if (aMin=aMax) then exit;

  newlist1:=TListInteger.create;
  for i:=amin to amax do
     newlist1.Add(i);

  if (newlist1.count=0) then begin List.Clear ; newlist1.free ;end
   else
    begin
      CopyList(newlist1);
       newlist1.free;
    end;
 end;
//********************************************************************/
procedure TListEtat.IntersectO(etat1: TListEtat; etat2:TListEtat );
var
  i,j,amin,amax : integer;
  newlist1, newlist2, listf : TListInteger  ;
begin

 newlist1:=TListInteger.create;
 newlist2:=TListInteger.create;
 listf:= TListInteger.create;

// les caractres sont ordonns et donc on vrifie qu'il n'y a pas de trous  dans les listes d'tats
 amin:=etat1.min;
 amax:=etat1.max;
 // jfr modifie le 28/09/04
  for i:=amin to amax do
    newlist1.Add(i);

 amin:=etat2.min;
 amax:=etat2.max;
  for i:=amin to amax do
  newlist2.Add(i);

 for i:=0 to newList1.Count-1 do
   begin
     for j:=0 to newList2.Count-1 do
       begin
        if newList1.Items[i]=newList2.Items[j] then
	  begin
            listf.add(newList1.List[i]);
	    break;
	  end;
	end;
   end;
   if (listf.count=0) then begin List.Clear ; listf.free ;end
   else
    begin
      CopyList(listf);
       listf.free;
    end;
    newlist1.Free;
    newlist2.Free;
 end;
//********************************************************************/
// mme  fonction que la prcdente mais sans chercher  combler les trous
//  utiliser pour les caractres non ordonns
procedure TListEtat.Intersect(etat1: TListEtat; etat2:TListEtat );
var
 newlist:TListInteger;
 i,j : integer;
begin
 newlist:=TListInteger.create;
   for i:=0 to etat1.List.Count-1 do
   begin
     for j:=0 to etat2.List.Count-1 do
       begin
        if etat1.List.Items[i]=etat2.List.Items[j] then
	  begin
            newlist.add(etat1.List.Items[i]);
	    break;
	  end;
	end;
   end;
   if (newlist.count=0) then begin List.Clear ; newlist.free ;end
   else
    begin
      CopyList(newlist);
      newlist.free;
    end;
 end;
//***************************************************************************/
procedure TListEtat.Closest(etat1: TListEtat ; etat2 : TListEtat);
var
   min, max, Nb, No :integer;
  i, dif1,dif2,diffmin : integer;
begin
  IntersectO(etat1,etat2);
  if (List.Count=0) then
     begin
     min:=etat2.Min;
     max:=etat2.Max;

     Nb:=etat1.List.Items[0];
     dif1:=Abs(Nb-min);
     dif2:=Abs(Nb-max);

     if (dif1<dif2) then diffmin:=dif1 else diffmin:=dif2;

     No:=0;

     for i:=1 to etat1.List.Count-1 do
       begin
       Nb:=etat1.List.Items[i];
       dif1:=Abs(Nb-min);
       dif2:=Abs(Nb-max);
        if (dif1<diffmin) then  begin diffmin:=dif1;No:=i;end;
        if (dif2<diffmin) then  begin diffmin:=dif2;No:=i;end
      end;

    List.Items[0]:=etat1.List.Items[No];
  end;
 end;
//*****************************************************************************
procedure TListEtat.Fusionner(etat1 :TListEtat ; etat2:TListEtat );
var
 newlist:TListInteger;
 i:integer;
 begin
 newlist:=TListInteger.create;

 for i:=0  to etat1.List.Count-1 do
  newlist.add(etat1.List.Items[i]);

  for i:=0  to etat2.List.Count-1 do
   newlist.add(etat2.List.Items[i]);

 CopyList(newlist);
 newlist.free;
 end;

//********************************************************************/
procedure TListEtat.Trier;
var
 i,j :integer;
begin
 for i:=0 to List.Count-1 do
   begin
    for j:=List.Count-1 downto i+1 do
      if (List.Items[j]<List.Items[i]) then  List.Items[i]:=List.Items[j];
   end;
end;

//********************************************************************/
procedure TListEtat.Unir(etat1:TListEtat; etat2 :TListEtat);
var
 nb,trouve,i,j, n2tab :integer;
 tab1,tab2 :TListInteger;
begin
  nb:=(etat1.List.Count)+(etat2.List.Count);

  if (nb=0) then begin  List.clear;  exit ;  end;

  tab1:=TListInteger.create;
  tab2:=TListInteger.create;

  for i:=0 to etat1.List.Count-1 do  tab1.add(etat1.List.Items[i]);
  for i:=0 to etat2.List.Count-1 do   tab1.add(etat2.List.Items[i]);

  trouve:=0;
  n2tab:=1;

  tab2.Items[0]:=tab1.Items[0];      // tab2[0]=tab1[0]

  for i:=1 to nb-1 do
   begin
      for j:=0 to n2tab-1 do
        begin
         if tab1.Items[i]= tab2.Items[j] then
	  begin
            trouve:=1;
	    break;
	  end;
       end;
     if trouve=0 then
      begin
        tab2.Items[n2tab]:= tab1.Items[i];
	n2tab:=n2tab+1;
      end
     else trouve:=0;
   end;

 CopyList(tab2);
 tab1.free;
 tab2.free;
end;

//********************************************************************/
// a priori c'est une fonction qui n'est utilise que pour les caractres ordonns
// jfr modifie 09/09/04
function TListEtat.MinMaxO(etat1:TListEtat; etat2 :TListEtat ):integer;
var
min, max ,diff, temp ,i:integer;
begin

 if (etat1.Max >etat2.Min) then
  begin
   min:=etat1.Min;
   max:=etat2.Max;
   end
 else
  begin
   min:=etat2.Min; max:=etat1.Max;
  end;

  if (min>max) then
  begin
   temp:=min; min:=max; max:=temp;
   end;

   diff:=max-min+1;

  List.clear;

  for i:=0 to diff-1 do begin List.add(min); inc(min);end;
  result:=diff-1;
  // jfr verifie 09/09/04
end;

//********************************************************************/
procedure TListEtat.Range(etat:TListEtat);
var
 min,max,diff,i:integer;
 begin
   min:=etat.Min;
   max:=etat.Max;

  diff:=max-min+1;
  List.clear;

  for i:=0  to diff-1 do begin List.add(min); inc(min);end;
end;

//********************************************************************/
function TListEtat.AffecteMinMax(min, max:integer):integer;
var
diff,i :integer;
begin
  diff:=max-min+1;
  List.clear;

  for i:=0  to diff-1 do begin List.add(min); inc(min);end;
  result:= diff;
end;


//********************************************************************/
function TListEtat.CombinePlus (etat1,etat2 :TListEtat):integer;
var
 step :integer;
begin
 Step:=0;
 Intersect(etat1, etat2);
 if (List.Count=0) then begin Fusionner(etat1, etat2); Step:=1;end;
 result:= Step;
end;

//********************************************************************/
procedure TListEtat.CombinePlus3(e1,e2,e3 : TListEtat);
  var
   Et1, Et2, Et3, Et4 :TListEtat;
  begin

  Et1:=TListEtat.Create;
  Et2:=TListEtat.Create;
  Et3:=TListEtat.Create;
  Et4:=TListEtat.Create;

  Et1.Intersect(e1,e2);
  if (Et1.List.Count>0)
   then
     begin
     Intersect(Et1, e3);
     if (List.count>0)then exit;
     end;

  Et2.Intersect(e1,e3);
  Et3.Intersect(e2,e3);
  Et4.Unir(Et1, Et2);
  Unir(Et4,Et3);
  if (List.Count=0) then
   begin
    Et1.Fusionner(e1,e2);
    Fusionner(Et1,e3);
    end;
    
 Et1.free;  Et2.free; Et3.free; Et4.free;
 end;

 //*******************************************************************/
function TListEtat.IsSubset(Etat:TListEtat):integer;
 var
  Trouve,i,j :integer;
 begin
  Trouve:=0;
  for i:=0 to List.Count-1 do
    begin
     Trouve:=0;
      for j:=0 to Etat.List.count-1 do
       begin
        if List.Items[i]=Etat.List.Items[j] then
         begin
           Trouve:=1;
           break;
         end;
      end;
     if (Trouve=0)then break;
    end;
   result:=Trouve;
  end;

//******************************************************************/
function TListEtat.CombineO(Etat1,Etat2: TListEtat):integer;
var
 step :integer;
 begin
  Step:=0;
  IntersectO (Etat1, Etat2);
  if (List.count=0) then Step:=MinMaxO(Etat1,Etat2);
  result:= Step;
 end;

//***********************************************************************/
function TListEtat.Max :integer;
var
max,i:integer;
begin
 max:=0;
 for  i:=0 to List.count-1 do
   begin
    if (List.Items[i]>max) then max:=List.Items[i];
   end;
 result:= max;
end;

//**********************************************************************/
function TListEtat.Min :integer;
var
min,i:integer;
begin
  min:=List.Items[0];
  for  i:=1 to List.count-1 do
   begin
    if (List.Items[i]<min) then min:=List.Items[i];
   end;
 result:= min;
 end;

// *********************************************************************/
procedure TListEtat.CombineMult3( E1,E2,E3: TListEtat);
var
 Ep1, Ep21, Ep31, Ep22, Ep32, Ep23, Ep33, Ep4: TListEtat ;
begin

 Ep1:=TListEtat.Create;
 Ep21:=TListEtat.Create; Ep31:=TListEtat.Create;
 Ep22:=TListEtat.Create; Ep32:=TListEtat.Create;
 Ep23:=TListEtat.Create; Ep33:=TListEtat.Create;
 Ep4:=TListEtat.Create;

 Ep1.IntersectO(E1, E2);

 if (Ep1.List.count>0)then
    begin
     IntersectO (Ep1, E3);
     if (List.Count>0) then exit ;
    end;

 Ep21.CombineO( E1, E2);
 Ep31.CombineO( Ep21, E3);

 Ep22.CombineO( E1, E3);
 Ep32.CombineO( Ep22, E2);

 Ep23.CombineO( E2, E3);
 Ep33.CombineO( Ep23, E1);

 Ep4.IntersectO(Ep31,Ep32);
 IntersectO(Ep4,Ep33);

 Ep1.free;Ep21.free;Ep22.free;Ep31.free; Ep32.free;Ep4.free;
 Ep23.free;Ep33.free;
 end;
//****************************************************************************************************************/

function TListEtat.Compare(Tab:TListEtat):integer;
 var
 i :integer;
 begin
  result:=1;
  if (List.count<>Tab.List.count)then  begin result:=0; exit ;end;
  for i:=0 to List.count-1 do
  begin
   if (List.Items[i]<> Tab.List.Items[i]) then
    begin result:=0; break; end;
  end;
end;
//******************************************************************************/

end.
