unit arbre;

interface

uses
sysutils ,strbox,classes,listarray2,DataselMat,carac ,group2,ListInteger, typedef,node,boite;

type

{ Modifications :
 - Le 04/05/99
  dans la procedure TTree.T_Root(nodeToRoot :TNodeBase ) Une boucle a t cre
  pour tenir compte de tous les fils d'une racine . (Cas des racines Polytomes)
  Les distances indiques n'ont de sens que si la racine n'est pas polytome, ce qui
  est le cas dans les arbres UPGMA ou NJ enracin
  - Le 04/05/99
  Dans la procedure TTree.Root
  la fonction L_Clean(1) a t place avant T_Root ; cette modification permet de
  parcourir tous les niveaux de l'arbre pour annuler le niveau de chaque noeud, d'annuler
  les niveaux eux mmes,  puis ensuite de supprimer des noeuds dans la fonction suivante (T_Root)
  sans provoquer de plantage (le plantage tant li  Racine.free pour des raisons obscures)

}

TTree =class(TObject)

 private
  TabLevel : TListArray;
  Racine :TNodeBase;
  FTypeTree : TTypeTree;

  
  function GetNbLevel: integer;
  function GetNbTaxon: integer;

 protected

 FTypeArbre : TTypeArbre;

 function  CreerFamille_DND(const nodesDND: string ):string;
 function  L_AddNode(node:TNodeBase):integer;


 function   CreateNode_DND(nom:string; dist:string ):TNodeBase;
 function   CreerNodeparent_DND(ListNode :TList):string ;
 function  FindNode_L(nom:string):TNodeBase;
 procedure  Transform_DND_L(const AstringDND :string );
 procedure   InsertChild_DND(node :TNodeBase; var STringDND:string; posG:integer);
 
 procedure  DefineNodeRelations;
 procedure  L_Arrange;
 procedure  L_Adjust(level :integer);
 procedure  T_RemoveNode(nodeToRemove: TNodeBase);
 procedure  L_Clean(firstlevel :integer);
 procedure  L_Delete;
 procedure  L_AddChild(ANode :TNodeBase; AddSelf: boolean );
 procedure  T_Graft(nodeSrc :TNodeBase ; nodeDest : TNodeBase);
 procedure  T_Root(nodeToRoot :TNodeBase );
 procedure  AdjustSens;
 procedure  CalculDistanceReel;virtual;
 procedure AdjustNodeName;

 public

function    Transform_L_DND:string;
constructor CreateTree(stringDND :string);virtual;

destructor Destroy; override;

function  AddNode ( Alevel :integer; node :TNodeBase):integer;
procedure  L_RemoveNode(node:TNodeBase);

procedure  Graft(nodeSrc :TNodeBase ; nodeDest : TNodeBase); // greffer
procedure  GraftPolytom(node :TNodeBase ; AParent :TNodeBase); // t_graftpolytom
function   Root(nodeToRoot:TNodeBase):integer;  // Enraciner
procedure  Turn(node :TNodeBase);               // Pivoter
procedure  Remove(nodeRemove :TNodeBase);       // Degreffer


function CreateNode:TNodebase;virtual;

function SumDistances :double;

function GetTaxName(index : integer): string;

function GetNode(level:integer;index:integer):TNodebase;
function GetTaxNode(nametax :string):TNodebase;

property NbTaxon:integer read GetNbTaxon;
property NbLevel:integer read GetNbLevel;
property TypeTree : TTypeTree read FTypeTree write FTypeTree;

 end;

TTreeUPGMA=class(TTree)
 public
   constructor CreateTree(stringDND :string);override;
 end;

TTreeNJ=class(TTree)
 public
   constructor CreateTree(stringDND :string);override;
 end;

TTreeCL= class(TTree)
 private
  FUnitLength :integer;
  FTotalLength : integer;              // int longtotale
  FData : TDataSelectCL;


 public
  FListLength : TListInteger;

  constructor createTreeCL(AData:TDataSelectCL);

  // jfr modifie le 10/04/00
  // procedure rajoute
  constructor createTreeCLFile(_DND :string ; AData:TDataSelectCL);
  constructor CreateTreeCLBoite(treeboite :TTreeBoite ;AData:TDataSelectCL);
  constructor CreateTreeCLGroup(treegroup :TTreeGroup;AData:TDataSelectCL);
  // Appelle les trois fonctions suivantes : seule DefineStateMPR tient
  // compte du noeud provisoire
  procedure DefineState(NomCarac : string; etat :TTypeEtatNode);

  procedure  TreeBoiteFill( TreeBoite : TTreeBoite);     // modifie par jfr le 22/12/05
  procedure  CreateBoiteNode( nodeG :tnodeboiteG );      // modifie par jfr le 22/12/05

  function DefineStateDown(nomcarac : string) : integer ;
  function DefineStateUp(nomcarac :string) : integer ;

  function DefineStateMPR(nomcarac :string): integer ;

  function CreateNode:TNodebase;override;

  procedure Create_string(TreeString: string  );virtual ;

  procedure TreeGroupFill(treegroup :TTreeGroup);
  procedure CreateGroupNode( group :TGroup);
  procedure ToGroup(group :TGroup);

  procedure Change(newTreeStr :string);

  function CalcLength: integer;
  function CalcUnitLength(NomCarac : string): integer ;  // CalculLongUnit(string &);

  property TotalLength : integer read FTotalLength;
  property UnitLength : integer read FUnitLength;

 end;

 implementation

{******************************************************************************/
              Conversion stringDND => TabLevel
    Toutes les fonctions suivantes sont impliques dans la cration d'une structure
    TabLevel  partir d'une chaine de caractre de type DND
 ******************************************************************************}
constructor TTree.createTree(stringDND : String);
begin
  TypeTree:=orthogonal;
  TabLevel := TListArray.createListArray;
  Transform_DND_L(stringDND);
  DefineNodeRelations;
  L_Arrange;
  CalculDistanceReel;
end;

constructor TTreeUPGMA.createTree(stringDND : String);
begin
  FTypeArbre:=UPGMA;
  inherited createTree(stringDND);
end;

constructor TTreeNJ.createTree(stringDND : String);
begin
  FTypeArbre:=NJ;
  inherited createTree(stringDND);
end;

destructor TTree.Destroy;
begin
 inherited;
 TabLevel.IsDelete:=toDelete;
 TabLevel.free;
end;

function TTree.SumDistances:double;
 var
  NbNodeLevel,col:integer;
  node:TNodeBase;
  dist,distpro,max:double;

 begin
  NbNodeLevel:=TabLevel.ColCount[1];
  max:=0;
    for col:=0 to NbNodeLevel-1 do
      begin
       dist:=0;
       distpro:=0;
       node:=TNodeBase(TabLevel.Items[1,col]);
            if (node<>nil) then
               repeat
                 dist:=dist+node.Distance;
                 distpro:=node.Distance;
                 node:=node.Parent;
               until node=nil;
             dist:=dist-distpro;
       if (max<dist) then max:=dist;
     end;
  result:= max;
 end;

function TTree.GetTaxName(index : integer): string;
var
node : TNodebase;
begin
 result:='';
 node:=TNodeBase(TabLevel.Items[1,index]);
 if node<>nil then
 result:=node.Name;
end;

function TTree.GetTaxNode(nametax:string):TNodebase;
var
node :TNodeBase;
maxcol, index :integer;
begin
  result:=nil;
  maxcol:=TabLevel.ColCount[1];
   for index:=0 to maxcol-1 do
        begin
           node:=TabLevel.Items[1,index];
           if node.name=nametax then
           begin
              result:=node;
              break;
           end;
        end;
end;

function TTree.GetNode(level:integer;index:integer):TNodebase;
begin
 result:=TNodeBase(TabLevel.Items[level,index]);
end;

function TTree.GetNbTaxon: integer;
begin
 result:=TabLevel.ColCount[1];
end;

function TTree.GetNbLevel: integer;
begin
 result:=TabLevel.RowCount;
end;

function TTree.CreateNode:TNodebase;
 begin
  result:=TNodeBase.create;
 end;
function TTreeCL.CreateNode:TNodebase;
 begin
  result:=TNodeCL.create;
 end;
 //******************************************************************************/
// Traite une expression du type "tax1:dist1, tax2:dist2,..."
//                    ou du type "tax1/tax2:dist12, tax3:dist3,..."
// Cette fonction cre les noeuds correspondant  tax1, tax2...si ils n'existent
// pas et place ces noeuds dans le TabNiveau. Elle retourne une string
// correspondant au pre qui a t galement cr,  de la forme tax1/tax2/...

function TTree.CreerFamille_DND(const nodesDND: string ):string;
var
 ListNode :TList;
 node     :TNodebase;
 nom,dist,temp,expression :string;

 begin

  ListNode:=Tlist.create;
  expression:=nodesDND;

  DecimalSeparator:='.'; //

  temp:=RemoveFirst(expression,',');  // La chaine "expression" est modifie

  while (temp<>'') do
   begin
      nom:=RemoveFirst(temp,':');  // La chaine "temp" est modifie
      dist:=temp;
      dist:=ReplaceChars(dist, ',', '.'); // Pour viter tout probleme

    // Si le noeud n'existe pas dans le TabNiveau, il est crer et ajouter
    // au TabNiveau par la fonction "CreateNode_DND( string&)" qui fait appel 
    // la fonction virtual "CreateNode" et initialise le "Nom" du noeud ainsi que
    // son "Niveau" et son "IndiceNiveau".

    node:=FindNode_L(nom);
    if (node=nil) then
         node:=CreateNode_DND(nom,dist)
    else
    // Si le noeud existe, c'est un noeud pre qui a t cr par
    // "CreerNodeparent_DND" lors d'un appel prcdant. Comme il ne possde pas
    // de "Distance" celle ci est initialise.
    node.Distance:=strToFloat(dist);

    ListNode.add(node);
    temp:=RemoveFirst(expression,',');
   end;

   // aprs le passage dans la boucle prcdante, il ne doit plus rester que
   // la dernire partie de l'expression : c'est  dire celle qui est aprs
   // la dernire virgule

  nom:=RemoveFirst(expression,':');
  dist:=expression;
  dist:=ReplaceChars(dist, ',', '.');

  node:=FindNode_L(nom);
  if (node=nil) then  node:=CreateNode_DND(nom,dist)
  else node.Distance:=strToFloat(dist);

  ListNode.add(node);

   // Cette fonction finit en crant un noeud pre "CreerNodeparent_DND". Sa
   // distance est inconnue par la fonction puisque elle ne fait pas partie de
   // "expression". Le noeud pre est cr  partir de la liste des noeud fils
   // contenue dans "ListNode".
   // Le niveau du pre est calcul et son IndiceNiveau est indiqu  chaque fils

  result:=CreerNodeparent_DND(ListNode);
  ListNode.free;
end;

function TTree.AddNode ( Alevel :integer; node :TNodeBase):integer;
var
index : integer;
 begin
  node.Level:=Alevel;
  index:=TabLevel.AddItem(Alevel,node);

  node.IndexLevel:=index;
  result:=index;
 end;
// ****************************************************************************/
// Cette fonction place le noeud "node" au niveau voulu, c'est  dire  la valeur
// "node.Level", elle initialise IndexLevel du noeud et retourne cette valeur
function TTree.L_AddNode(node:TNodeBase):integer;
var
 lev :integer;
 index:integer;
 begin
  lev:=node.Level;
  index:=TabLevel.AddItem(lev,node);

  node.IndexLevel:=index;
  result:=index;
 end;
 
procedure TTree.L_RemoveNode(node:TNodeBase);
var
 lev :integer;
 index:integer;
 begin
  lev:=node.Level;
  index:=node.IndexLevel;

  TabLevel.DeleteItem(lev,index,TrimMem);

  node.IndexLevel:=0;
  node.Level:=0;
 end;

//*******************************************************************************/
function  TTree.CreateNode_DND(nom:string; dist:string ):TNodeBase;
 var
  node:TNodebase;
begin
  // un noeud cr avec un nom est automatiquement du niveau 1
  DecimalSeparator:='.';
  dist:=ReplaceChars(dist, ',', '.');

  node:=CreateNode;

  node.Level:=1;
  node.VerticalLevel:=1;
  node.Name:=nom;
  node.Distance:=StrToFloat(dist);

  L_AddNode(node); // Plac automatiquement au niveau 1,
                   // et son "IndiceNiveau" est initialis
  result:=node;                 
end;

//*******************************************************************************/
// Cette fonction cre un noeud "pre"  partir d'une liste de noeuds "fils"
// - Elle initialise le nom du pre en concatnant les noms des fils spars par "/"
// - Elle calcule le niveau du pre
// - Elle place le noeud "parent" au bon niveau
// - Elle fournit aux fils le niveau du pre et l'index dans le niveau

function  TTree.CreerNodeparent_DND(ListNode :TList):string ;
 var
  i,nbChilds,index: integer;
  niveau,niveauVert:integer;
  Child,node :TNodeBase;
  Delim, name: string;
 begin

  niveau:=0;
  niveauVert:=0;
  Delim:='/';

  nbChilds:=ListNode.count;

  for i:=0 to nbChilds-1 do
   begin
    Child := TNodeBase(ListNode.items[i]);
    niveau := niveau+Child.Level;
    niveauvert := niveauVert+Child.VerticalLevel;
    name := name+Child.Name;
    if (i<nbChilds-1)then name := name+Delim;
   end;

  node:=CreateNode;
  node.Name:=name;
  node.Level:=niveau;
  node.VerticalLevel:=niveauvert;

  index:=L_AddNode(node);

  for i:=0 to nbChilds-1 do
    begin
     Child := TNodeBase(ListNode.items[i]);
     Child.parentIndexLevel:=index;
     Child.parentLevel:=niveau;
    end;
  result:=name;

end;
// ******************************************************************************/
function TTree.FindNode_L(nom:string):TNodeBase;
 var
 NbNodeLevel,row,col:integer;
 node:TNodeBase;
 begin
 result:=nil;
 for  row:=1 to TabLevel.RowCount-1 do
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            if (node<>nil)and (node.Name=nom)
            then begin result:=node; exit; end;
	  end;
  end;
end;
//*******************************************************************************/

procedure TTree.Transform_DND_L(const AstringDND :string );
 var
  temp,expression,newexpression :string;
  posD, posG:integer;
  node :TNodeBase;                 
  stringDND :string;
 begin

  stringDND:=AstringDND; // ncessaire pour delete qui ne prend pas de param "const"
  posD:=LSubstr(stringDND,temp,')');

  while(posD<>0)do
   begin
    posG:=RSubstr(temp,expression,'(');
    newexpression:=CreerFamille_DND(expression);

    Delete(stringDND,posG,posD-posG+1);
    Insert(newexpression,stringDND,posG);
    posD:=LSubstr(stringDND,temp,')');
   end;


  posG:=find_first(stringDND,':');
  posD:=find_first(stringDND,';');

  expression:=copy(stringDND,posG+1,posD-posG-1);

  node:=FindNode_L(newexpression);

  DecimalSeparator:='.';
  expression:=ReplaceChars(expression, ',', '.');

  node.Distance:=strtofloat(expression);
  Racine:=node;
 end;

 {******************************************************************************/
              fin de Conversion stringDND => TabLevel
 ******************************************************************************}
function TTree.Transform_L_DND:string;
var
row,col,posG,NbNodeLevel :integer;
node :TNodeBase;
stringDND:string;
begin

 AdjustNodeName;  //Pour donner des noms aux noeuds internes qui n'en n'ont pas

 for  row:=TabLevel.RowCount-1 downto 2  do
   begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            posG:=Pos(node.name,StringDND);
            if posG>0 then Delete(StringDND,posG,length(node.name));

            InsertChild_DND(node,STringDND,posG);
          end;
    end;
  StringDND:=StringDND+';';  
  result:=stringDND;
end;

procedure TTree.AdjustNodeName ;
var
 row,col,k,NbNodeLevel:integer;
 node,child:TNodeBase;
 
begin
 for  row:=2 to TabLevel.RowCount-1  do
   begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            node.name:='';
            for k:=0 to node.NbChilds-1 do
                begin
                  child:=node.Child[k];
                  node.name:=node.name+child.name;
                  if k<node.NbChilds-1 then node.name:=node.name+'/';
                 end;
           end;
   end;
end;


procedure TTree.InsertChild_DND(node :TNodeBase;var STringDND:string; posG:integer);
 var
 child:TNodeBase;
 dist:string;
 name:string;
 k:integer;
 
 begin
   name:='(';
   child:=node.Child[0];
   name:=name+child.name;
   name:=name+':';
   name:=name+floatToSTr(child.distance);
       for k:=1 to node.NbChilds-1 do
         begin
             child:=node.Child[k];
             name:=name+',';
             name:=name+child.Name;
             name:=name+':';
             name:=name+FloatToStr(child.distance);
          end;
    name:=name+')';

   if (posG>0) then insert(name,stringDND,posG)
   else
    begin
     stringDND:=StringDND+name;
     stringDND:=StringDND+':';
     stringDND:=StringDND+floatToStr(node.Distance);
    end;
 end;
 // Les noeuds sont dj dans le TabLevel : chaque noeud connait le niveau "parentLevel"
 // et l'indice dans le niveau "parentIndexLevel" de son pre. A partir de ces renseignements
 // sont initialiss Les champs Childs et Parent de chaque noeud

 procedure TTree.DefineNodeRelations;

 var
  NbNodeLevel,row,col:integer;
  node,Aparent:TNodeBase;
 begin

  for  row:=1 to TabLevel.RowCount-1 do
   begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            if  (node.parentLevel<>0) then
              begin
                Aparent:= TabLevel.Items[node.parentLevel,node.parentIndexLevel];
                node.parent:=Aparent;
	      end
	   else node.parent:=nil;
          end;
   end;

  NbNodeLevel:=TabLevel.ColCount[1];
     for col:=0 to NbNodeLevel-1 do
	  begin
            node := TNodeBase(TabLevel.Items[1,col]);
            Aparent := node.parent;
             while (Aparent<>nil) do
              begin
                if (not node.IsChild(Aparent)) then Aparent.AddChild(Node);
               node := Aparent;
               Aparent := node.parent;
              end;
          end;
end;

//***************************************************************************/
// La structure de l'arbre tant tablie, cette fonction modifie l'emplacement
// des noeuds du niveau 1 de faon  les placer en concordance de leur position relle

procedure TTree.L_Arrange;
var
  Pile :TList;
  node: TNodeBase;
  nbfils :integer ;
  index,i :integer;
 begin
  node:=Racine;
  pile:=TList.Create;

  Pile.Add(node);

  node:=TNodeBase(PeekRight(Pile));
  index:=0;

  while (node<>nil) do
   begin
    nbfils:=node.NbChilds;
    if (nbfils>0) then
        for  i:=nbfils-1 downto 0 do Pile.Add(node.Child[i])
    else begin
          TabLevel.Items[1,index]:=node;
          index:=index+1;
          end;

   node:=TNodeBase(PeekRight(Pile));
   end;

 L_Adjust(1);
 Pile.free;
end;
//**********************************************************************************/

procedure TTree.L_Adjust(level :integer);
 var
  node : TNodeBase ;
  index, maxcol : integer;
 begin
  maxcol:=TabLevel.ColCount[level];
  if (maxcol>0)then
   begin
     for index:=0 to maxcol do
        begin
           node:=TabLevel.Items[level,index];
           if node<>nil then  node.IndexLevel:=index;
        end;
    end;
 end;

// ******************************************************************************/
procedure TTree.T_RemoveNode(nodeToRemove: TNodeBase);
 var
   nodeB,nodeP,nodeGP : TNodeBase;
   nbBr : integer;
   index:integer;

 begin
   nbBr :=nodeToRemove.NbBrothers; // Garder en mmoire le nombre de frre

   nodeB  := nodeToRemove.Brother[0];
   nodeP  := nodeToRemove.Parent;
   nodeGP := nodeP.Parent;

  if (nbBr=1) then
   begin
     if (nodeGP<>nil) then
           begin
              index := nodeGP.RemoveAChild(nodeP);
              nodeGP.AddAChild(nodeB,index);
           end
         else
           begin

	     nodeB.Parent:=nil;
	     Racine:=nodeB;
             Racine.Distance:=1;
	   end;
    end
   else                       // Le noeud retir appartient  une polytomie
    nodeP.RemoveChild(nodeToRemove);
end;

//****************************************************************************/
{Efface les diffrents niveaux, sans dtruire les noeuds, mais ne modifie pas le
 nombre des niveaux}
//******************************************************************************/
procedure TTree.L_Clean(firstlevel :integer);
var
 index,NbLevels,level :integer;
 sublist :TList;
 node : TNodeBase;

 begin
  NbLevels:=TabLevel.RowCount-1;
  for level:=firstlevel to NbLevels do
   begin
    sublist:=TabLevel.Row[level];
    if sublist<>nil then
     begin
      for index:=0 to sublist.count-1 do
        begin
          node:=TNodeBase(sublist.Items[index]);
          if (node<>nil) then begin node.Level:=0; node.IndexLevel:=0; end;
        end;
      sublist.count:=0;
     end;
  end;
end;

// supprime tous les noeuds et les niveaux d'un tablevel
procedure TTree.L_Delete;
var
 index,NbLevels,level :integer;
 node : TNodeBase;

 begin
  NbLevels:=TabLevel.RowCount-1;

   for level:=NbLevels  downto 1 do
     begin
         index:=0;
         node:=TabLevel.Items[level,index];
         if (node<>nil )then
             begin
                while node<>nil do
                    begin
                       node.free;
                       index:=index+1;
                       node:=TabLevel.Items[level,index];
                     end;
                TabLevel.ClearRow(level);
                TabLevel.deleteRow(level,toTrim);
              end;
      end;
end;
  //******************************************************************************/
//                           L_AddChild
// C'est une fonction qui place un noeud et ses descendants au niveau qui est
// le leur. Quand ce niveau n'est pas connu, il doit tre calcul. Pour ce faire
// les noeuds descendants sont empils jusqu' la rencontre des noeuds terminaux
// qui permettent alors de remonter vers l'anctre en calculant les niveaux
// des noeuds dpils

//******************************************
procedure TTree.L_AddChild(ANode :TNodeBase; AddSelf: boolean );
 var
  Pile :TList;
  node, nodechild :TNodeBase;
  nbchilds,i:integer;
 begin

  Pile:=TList.Create;
  Pile.Add(ANode);

  node:=TNodeBase(PeekRight(Pile));

  while (node<>nil) do
   begin
    if (node.IsCalcLevel=true) then // si le niveau de tous ses descendants est connu
      begin
        if (node<>ANode)or((node=ANode)and (AddSelf=true)) then L_AddNode(node);
      end
     else
      begin
       Pile.Add(node);
       nbchilds:=node.NbChilds;
       for i:=nbchilds-1 downto 0 do
         begin
          nodechild:=node.Child[i];
          if (nodechild.Level=0) then Pile.add(nodechild);
         end;
      end;
     node:=TNodeBase(PeekRight(Pile));
    end;
 Pile.free;
end;
//************************************************************************/
// le noeud nodeSrc est greff sur nodedest

procedure TTree.T_Graft(nodeSrc :TNodeBase ; nodeDest : TNodeBase);
var
 index :integer;
 Node,NodePere: TNodeBase;

begin
 index:=0;
 Node:=CreateNode;
 NodePere:=nodedest.Parent;

if (nodedest.Parent=nil) then   // Si nodedest est la racine, le futur pre devient
 begin                           // la racine
   Node.Parent:=nil;
   Racine:=Node;
 end
 else
  begin
   index:=NodePere.RemoveAChild(nodedest); // le pere de nodedest n'a plus de fils nodedest et
   NodePere.AddAChild(Node,index);
  end;

  if (index>1) then index:=1;

  Node.AddAChild(nodedest,index);

  if (index>0) then index:=index-1 else index:=index+1;
  Node.AddAChild(nodeSrc,index);
end;

// **************************************************************************/
procedure TTree.Graft(nodeSrc :TNodeBase ; nodeDest : TNodeBase);
 begin
  T_Graft(nodeSrc , nodeDest);
  L_Clean(1);
  L_AddChild(Racine,TRUE);
  AdjustSens;
end;

//******************************************************************************/
procedure TTree.T_Root(nodeToRoot :TNodeBase );

var
 node1,node2,NodeP,Node,nodeCh:TNodeBase;
 Pile,LChild :TList;
 newdistance: double;
 nbchilds, i : integer;

 begin
  LChild:=TList.create;
  nbchilds:= Racine.NbChilds;

  for i:=0 to nbchilds-1 do
   begin
    Racine.Child[i].Parent:=nil;
    newdistance := newdistance +Racine.Child[i].Distance;
    LChild.add(Racine.Child[i]);
   end;

 // node1 := Racine.Child[0];        // modifi
 // node2 := Racine.Child[1];        // modifi

  // Le pre du noeud sur lequel on enracine va devenir l'un des deux fils
  // de la nouvelle racine ; sa distance doit donc tre  tre gale  celle du noeud
  // sur lequel on enracine divise par deux (comme celle de ce noeud).
  // La suite des noeuds pres  de ce pre va devenir la suite de ces fils.
  // Cette modification est faite  l'aide de la pile.
  // Le premier noeud  sortir de la pile va devenir le fils du suivant et
  // prendra sa distance et ainsi de suite. voir fichier arbrephylo5.pub

  nodeToRoot.Distance := nodeToRoot.Distance/2;
 //  newdistance :=node1.Distance+node2.Distance; // modifi

 // node1.Parent := nil; // modifi
 // node2.Parent := nil; // modifi

  Racine.free;
  Racine:=nil;

  Pile:=TList.Create;

 Racine:=CreateNode;
 Racine.Distance:=nodeToRoot.Distance;

 Pile.Add(Racine);

 NodeP:=nodeToRoot.Parent; // Attention on ne peut pas enraciner la racine !
 NodeP.RemoveTheChild(nodeToRoot);  // nodeToRoot n'est plus fils de NodeP dont la liste est remanie

 repeat
  Pile.Add(NodeP);
  Node:=NodeP.Parent;
  if Node<>nil then Node.RemoveTheChild(NodeP);
  NodeP:=Node;
 until NodeP=nil;

 // Le dernier noeud rentr dans la pile est obligatoirement un des deux fils
 // de l'ancienne racine
 // Ce noeud va devenir le pre de l'autre fils (ou des autres fils)

 node:=TNodeBase(PeekRight(Pile));

 for i:=0 to nbchilds-1 do
   begin
    nodeCh:=TNodeBase(LChild[i]);
    if node<>nodeCh then
     begin
     nodeCh.AddParent(node);
     nodeCh.Distance:=NewDistance;
     end;
   end;
 {if (Node=node1)then
   begin
    node2.AddParent(node1);
    node2.Distance:=newdistance;
    end
 else
   begin
    node1.AddParent(node2);
    node1.Distance:=newdistance;
   end; }
                   // On entre dans la boucle avec Node=node1 ou node2
                   // Le premier noeud  sortir de la pile correspond  celui qui
                   // tait son pre dans l'ancienne structure.
 repeat            // Le dernier noeud  sortir est obligatoirement la nouvelle racine

   nodeP:=TNodeBase(PeekRight(Pile));

   if (NodeP<>nil) then
     begin
      Node.AddParent(NodeP);
      Node.Distance:=NodeP.Distance;
     end;
   Node:=NodeP;
 until Node=nil;

 nodeToRoot.AddParent(Racine);    // Initialise nodeToRoot comme fils de racine
 Racine.Distance:=0;
 //CalculDistanceReel;
end;
//************************************************************************/

function TTree.Root(nodeToRoot:TNodeBase):integer;
var
AParent:TNodebase;
begin
 AParent:=nodeToRoot.Parent;
 if (AParent<>nil) and (nodeToRoot<>Racine) then
  begin
   L_Clean(1);  // On vide les niveaux  d'abord, ce qui permet ensuite d'annuler des noeuds
   T_Root(nodeToRoot); // Cette fonction recre de nouvelle parent
   
   L_AddChild(Racine,TRUE); // Tous les niveaux > 1  doivent tre remplis

   AdjustSens;
   result:=1;
  end
 else result:=0;
end;
//*******************************************************************************/
procedure TTree.Turn(node :TNodeBase);
begin
  if (node.SwapChilds=1)then begin
  L_Clean(1);
  L_AddChild(Racine,TRUE);
  AdjustSens;
  end;
end;

//******************************************************************************/
procedure TTree.Remove(nodeRemove :TNodeBase);
var
node :TNodebase;
 begin
  if nodeRemove=nil then exit;
  T_RemoveNode(nodeRemove);

  L_Clean(1);

  L_AddChild(Racine,TRUE);
  AdjustSens;
end;
//**************************************************************************************/
procedure TTree.GraftPolytom(node :TNodeBase ; AParent :TNodeBase);
var
 NbChilds:integer;
begin
 node.Parent:=AParent;
 NbChilds:=AParent.NbChilds ;
 AParent.InsertChild(node,NbChilds-2); // Le noeud est insr  l'avant dernire position

 L_Clean(1);
 L_AddChild(Racine,TRUE);
 AdjustSens;
end;

//********************************************************************************/
procedure TTree.AdjustSens;
var
 Node, NodeChild : TNodeBase;
 nbchilds: integer;
 level,index,k, NbLevels :integer ;
 sublist:TList;
 begin

 Racine.Sens:=ssLeft;

 NbLevels:=TabLevel.RowCount-1;

  for level:=NbLevels downto 2 do
   begin
    sublist:=TabLevel.Row[level];
    if sublist<>nil then
     begin
      for index:=0 to sublist.count-1 do
        begin
          node:=TNodeBase(sublist.Items[index]);
            if node<>nil then
                 begin
                  nbchilds:=node.NbChilds;
		  for  k:=0 to nbchilds-1 do
                    begin
		        NodeChild:=Node.Child[k];
			if k=0 then NodeChild.Sens:=ssLeft
                        else NodeChild.Sens:=ssRight;
                     end;
                 end;
        end;
       end;
    end;
 end;

//******************************************************************************/
procedure TTree.CalculDistanceReel;
 var
 NbNodeLevel,row,col:integer;
 node,nodechild:TNodeBase;
 begin

 NbNodeLevel:=TabLevel.ColCount[1];
    for col:=0 to NbNodeLevel-1 do
      begin
         node:=TNodeBase(TabLevel.Items[1,col]);
         if node <>nil then node.DistanceReel:=node.Distance;
      end;

 for  row:=2 to TabLevel.RowCount-1 do
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            if (node <>nil) and (node.Name <>'') then
             begin
             nodechild:=node.Child[0];
               if FTypeArbre=UPGMA
                   then node.DistanceReel:=node.Distance-nodechild.Distance
               else node.DistanceReel:=node.Distance;
            end;
          end;
  end;

  Racine.Distance:=0;
  Racine.DistanceReel:=0;

 for  row:=1 to TabLevel.RowCount-1 do
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeBase(TabLevel.Items[row,col]);
            if node <>nil then
               node.Distance:=node.DistanceReel;
          end;
  end;
end;

//********************************************************************************/
constructor TTreeCL.createTreeCL(  AData:TDataSelectCL);
begin
  TypeTree:=Diagonal;
  TabLevel := TListArray.createListArray;
  FTotalLength :=0;
  FListLength := TListInteger.create;
  FData :=AData;
  Transform_DND_L(FData.create_DND_Polytom);
  DefineNodeRelations;
  L_Arrange;
end;
//********************************************************************************/
// jfr modifie le 10/04/00
// procedure rajoute
constructor TTreeCL.createTreeCLFile(_DND :string; AData:TDataSelectCL);
begin
  TypeTree:=Diagonal;
  TabLevel := TListArray.createListArray;
  FTotalLength :=0;
  FListLength := TListInteger.create;
  FData :=AData;
  Transform_DND_L(_DND);
  DefineNodeRelations;
  L_Arrange;
end;
//*********************************************************************************/
procedure TTreeCL.Change(newTreeStr :string);
begin
  L_Delete;
  FTotalLength :=0;
  FListLength.clear;
  Transform_DND_L(newTreeStr);
  DefineNodeRelations;
  L_Arrange;
end;

procedure TTreeCL.DefineState(NomCarac : string; etat:TTypeEtatNode);
begin
 FUnitLength:=DefineStateDown(nomcarac);
  if (FUnitLength>=0)then
    begin
     //  if (etat=NEtatUp) or (etat=NEtatMPR)then   // jfr corrig le 04/06/2003
       // begin                         pour un bug sur le non changement des couleurs des branches quand l'option etatdown est choisie
         if (DefineStateUp(nomcarac)>=0) //and (etat=NEtatMPR)
         then DefineStateMPR(nomcarac);
       // end;
    end
  else FUnitLength:=0;
end;
//********************************************************************************/

function TTreeCL.DefineStateDown(NomCarac : string):integer;
begin
result:=CalcUnitLength(nomcarac);
end;

//********************************************************************************/
function TTreeCL.DefineStateMPR(NomCarac : string):integer;
var
 carac :TCaractere;
 node :TNodeCL;
 ttype :integer;
 NbNodeLevel,row,col:integer;
begin
  ttype :=FData.GetTypeOfCarac(nomcarac);
  if ttype>=0 then
    begin
      case ttype of
            0: Carac:= TCaracU.createcarac(nomcarac,FData);
            1: Carac:= TCaracO.createcarac(nomcarac,FData);
        else  begin result:=-1; exit; end;
      end;
     end
   else begin result:=-1; exit; end;

// for  row:=0 to TabLevel.RowCount-1 do
 for  row:=TabLevel.RowCount-1 downto 1 do         // jfr modifie le 07/07/04
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeCL(TabLevel.Items[row,col]);
            node.typeCarac:=ttype;  // jfr modifie le 07/07/00
            Carac.AffecteEtatMPR(node);
         end;
  end;
 result:= 1;
end;
//********************************************************************************/
function TTreeCL.DefineStateUp(NomCarac : string):integer;
var
 carac :TCaractere;
 node :TNodeCL;
 NbNodeLevel,row,col:integer;
 ttype :integer;
begin
  ttype :=FData.GetTypeOfCarac(nomcarac);
  if ttype>=0 then
    begin
      case ttype of
            0: Carac:= TCaracU.createcarac(nomcarac,FData);
            1: Carac:= TCaracO.createcarac(nomcarac,FData);
        else  begin result:=-1; exit; end;
      end;
     end
   else begin result:=-1; exit; end;
 for  row:=TabLevel.RowCount-1 downto 1 do
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeCL(TabLevel.Items[row,col]);
            node.typeCarac:=ttype;  // jfr modifie le 07/07/00
            Carac.AffecteEtatUP(node);
         end;
  end;
 result:= 1;
end;
//*******************************************************************************/
function TTreeCL.CalcUnitLength(NomCarac : string):integer;
var
 carac :TCaractere;
 node :TNodeCL;
 NbNodeLevel,row,col:integer;
 ttype, LongCarac:integer;
begin
 LongCarac:=0;
  ttype :=FData.GetTypeOfCarac(nomcarac);
  if ttype>=0 then
    begin
      case ttype of
            0: Carac:= TCaracU.createcarac(nomcarac,FData);
            1: Carac:= TCaracO.createcarac(nomcarac,FData);
        else  begin result:=-1; exit; end;
      end;
     end
   else begin result:=-1; exit; end;

 for  row:=1 to TabLevel.RowCount-1 do
  begin
    NbNodeLevel:=TabLevel.ColCount[row];
	 for col:=0 to NbNodeLevel-1 do
	  begin
            node:=TNodeCL(TabLevel.Items[row,col]);
            node.typeCarac:=ttype; // jfr modifie le 07/07/00
            LongCarac:=LongCarac+Carac.AffecteEtatDown(node);
          end;
   end;
result:=LongCarac;
end;
//*******************************************************************************/
function TTreeCL.CalcLength:integer;
var
  calcul :boolean;
  lon,NbCarac, NbCaracTot ,i, indexlistcol :integer;
  nomcarac :string;
begin
  calcul:=true;
  FTotalLength:=0;


  if (FData.CreerListCarac=false) then begin result:=0; exit; end;
  // Comme la ListCarac ne comprend qu'une partie des caractres slectionns,
  // ceux dont les tats prsentent une diffrence d'un taxon  l'autre,
  // et que la ListLongueur tient compte de tous les caractres
  // il faut employer NbCaracTot et le reste

  NbCarac:=FData.ListCarac.Count;
  NbCaracTot:=FData.ListCol.Count;

  FListLength.clear;

   for  i:=0 to NbcaracTot-1 do FListLength.add(0);

  for  i:=0 to Nbcarac-1 do
  begin
    indexlistcol:=FData.ListCarac.Items[i];
    nomcarac:=FData.GetNameOfCol(FData.ListCol,indexlistcol);
    lon:=CalcUnitLength(nomcarac);
    if lon>=0 then
     begin
     FListLength.Items[indexlistcol]:=lon;
     FTotalLength:= FTotalLength  + lon;
     end
    else begin calcul:=false; break;end;
  end;
 if (calcul=true) then result:= FTotalLength
 else  result:=-1;
end;
//******************************************************************************/
procedure TTreeCL.Create_string(TreeString: string  );
begin
  Transform_DND_L(TreeString);
  Racine.Distance:=1;
  DefineNodeRelations;
  AdjustSens;
end;

//******************************************************************************/
constructor TTreeCL.CreateTreeCLBoite(treeboite :TTreeBoite ;AData:TDataSelectCL);
  begin
  TypeTree:=Diagonal;
  TabLevel := TListArray.createListArray;
  FTotalLength :=0;
  FListLength := TListInteger.create;
  FData :=AData;

  L_delete;
  TreeBoiteFill(Treeboite);

 // AdjustNodeName;
 // L_Arrange;
 // AdjustSens;
 end;

constructor TTreeCL.CreateTreeCLGroup( TreeGroup :TTreeGroup;AData:TDataSelectCL);
 begin
  TypeTree:=Diagonal;
  TabLevel := TListArray.createListArray;
  FTotalLength :=0;
  FListLength := TListInteger.create;
  FData :=AData;
  TreeGroupFill(TreeGroup);
 // DefineNodeRelations;
  AdjustNodeName;
  L_Arrange;
  AdjustSens;
 end;

procedure TTreeCL.TreeGroupFill( TreeGroup :TTreeGroup);
var
 row,col:integer;
 group,groupChild : TGroup;

begin
 for row:=TreeGroup.RowCount-1 downto 0 do
  begin
    for col:=0 to TreeGroup.ColCount[row]-1 do
      begin
         group:=TGroup(TreeGroup.Items[row,col]);
         if (group<>nil) and (group.ChildsGroup.count=0) then CreateGroupNode( group );
      end;
  end;

for row:=TreeGroup.RowCount-2 downto 0 do
  begin
    for col:=0 to TreeGroup.ColCount[row]-1 do
      begin
         group:=TGroup(TreeGroup.Items[row,col]);
         if group.ChildsGroup.count=1 then
          begin
           groupChild:=group.Child[0];
           group.NodeAssoc:=groupChild.NodeAssoc;
          end
         else ToGroup(group);
      end;
  end;
end;
procedure TTreeCL.TreeBoiteFill( TreeBoite : TTreeBoite);
var
 nodeg, nodegf : tnodeboiteG ;
 liste :Tlist ;
 nodeBoiteG :TNodeBoiteG ;
 nb ,i,j,dep: integer ;

 begin
 treeboite.annulerNiveauxG();
 treeboite.definirNiveauxG()  ;

  liste:=TList.Create;
  nb := treeBoite.getNbNiveaux();

  for i:=1 to nb do                    // pour chaque niveau en commenant par le niveau 1
   begin
    liste.Clear;
    treeBoite.creerListeNodeLevel (i , liste)  ;    // on cre la liste de tous les noeux qui y sont
    if ((nb=1) and (liste.Count=2))  then dep:=1 else dep:=0;
     for j:=0 to liste.Count-1 do
      begin
        nodeBoiteG := TNodeBoiteG(liste.Items[j]);
        if nodeBoiteG<>nil then
         begin
           CreateBoiteNode( nodeBoiteG);
         end ;
      end;
  end;
  liste.Free;

end;

procedure TTreeCL.CreateBoiteNode( nodeG :tnodeboiteG );
var
 nodeCLF,nodeCL:TNodeCL;
 i,nb , niveauT: integer;
 nodeGF :tnodeboiteG  ;
 taxon : String ;

 begin
  nodeCL:=TNodeCL(createnode);
  nodeG.nodeCLAssoc := nodeCL;
  if (nodeG.nodeParentG=nil) then Racine := nodeCL ;
  
  if (nodeG.getIndex()=0) then nodeCL.sens:=ssleft else nodeCL.sens:=ssright;
  if (nodeG.taxonsG <> nil)    // si sa liste de taxons n'est pas nulle, c'est un ex-noeud terminal
    then begin
      nb := nodeG.taxonsG.Count ;
         nodeCL.level := nb ;
         L_AddNode(nodeCL) ;

      if nb=1 then  nodeCL.Name:=nodeG.taxonsG[0]
      else begin
       for i:=0 to nb -1 do
        begin
         taxon:= nodeG.taxonsG[i];
         if (taxon <> '') then
           begin
             nodeCLF := TNodeCL(createnode);
             nodeCLF.Level:=1;
             L_AddNode(nodeCLF) ;
             nodeCLF.Name:=taxon;
             if i=0 then NodeCLF.Sens:=ssLeft else NodeCLF.Sens:=ssright;
             nodeCLF.Parent:=NodeCL;
             nodeCL.Childs.add(nodeCLF);
           end;
        end;
       end;
   end
  else
      begin
        nb := nodeG.nodeChildsG.count ;
        if nb>0  then
           begin
              niveauT := 0;
              for i:=0 to nb-1 do
                 begin
                   nodeGF := TNodeBoiteG( nodeG.nodeChildsG.Items[i])  ;
                    if ((nodeGF <> nil) and (nodeGF.nodeCLAssoc<>nil)) then
                      begin
                       niveauT := niveauT + nodeGF.nodeCLAssoc.level ;
                       nodeGF.nodeCLAssoc.Parent := nodeCL;
                       nodeCL.Childs.add(nodeGF.nodeCLAssoc);
                      end ;
                  end;
               nodeCL.level := niveauT ;
               L_AddNode(nodeCL) ;
            end
         else  begin nodeCL.level := 1;  L_AddNode(nodeCL) ;end;
      end;
end;

procedure TTreeCL.ToGroup(group :TGroup);
var
 groupChild :TGroup;
 nodeP,nodeR:TNodeCL;
 i :integer;
 begin

  groupChild:=group.Child[0];
  NodeR:=TnodeCL(groupChild.NodeAssoc);
  NodeR.Sens:=ssLeft;

  groupChild:=group.Child[1];
  NodeP:=TNodeCL(groupChild.NodeAssoc);
  NodeP.Sens:=ssRight;

  Graft(NodeP,NodeR);

    for i:=2 to group.ChildsGroup.Count-1 do
          begin
            groupChild:=group.Child[i];
            NodeP:=TNodeCL(groupChild.NodeAssoc);
            NodeP.Sens:=ssRight;
            GraftPolytom(nodeP, nodeR.Parent);
          end;
     group.NodeAssoc:=nodeR.Parent;
 end;

  
procedure TTreeCL.CreateGroupNode( group :TGroup);
var
 nodeP,nodeR:TNodeCL;
 i : integer;

 begin
  nodeR:=TNodeCL(createnode);
  nodeR.Level:=1;
  nodeR.Name:=group.ListItems[0];
  NodeR.Sens:=ssLeft;

  if group.ListItems.count>1 then
    begin
         nodeP:=TNodeCL(createnode);
         nodeP.Level:=1;
         nodeP.Name:=group.ListItems[1];
         NodeP.Sens:=ssRight;
         Graft(nodeP, nodeR);

         for i:=2 to group.ListItems.Count-1 do
          begin
            nodeP:=TNodeCL(createnode);
            nodeP.Level:=1;
            nodeP.Name:=group.ListItems[i];
            NodeP.Sens:=ssRight;
            GraftPolytom(nodeP, nodeR.Parent);
          end;
     group.NodeAssoc:=TNodeCL(nodeR.Parent);
    end
  else group.NodeAssoc:=nodeR;
 end;

end.
