unit BarreIc;
// Dl 29/04/00 modif gestion des Timer

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, jpeg,CompCadreIma2, CompCadreIma;

type
  TBarreIcones = class(TForm)
    Panel1: TPanel;
    FlecheG: TImage;
    FlecheD: TImage;
    TimerG: TTimer;
    TimerD: TTimer;
    CadreImage21: TCadreImage2;
    CadreImage22: TCadreImage2;
    CadreImage23: TCadreImage2;
    CadreImage24: TCadreImage2;
    BoutonPlanche: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure FlecheGMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheGMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TimeG(Sender:TObject);
    procedure TimeD(Sender:TObject);
    procedure DeplacementGauche;
    procedure DeplacementDroit;
    procedure FormCreate(Sender: TObject);
    procedure BoutonPlancheClick(Sender: TObject);

  private
    { Dclarations prives }
    FSelection:TStringList;  // liste des noms des taxons slectionns

    Images : array[0..3] of TCadreImage2;
    procedure SetSelection(Sel:TStringList);
    procedure AfficheIcones;
  public
    { Dclarations publiques }
    Premiere : integer;                 // index de la premire image
    procedure AfficheEspece(N: integer);
    property Selection:TStringList write SetSelection;
  end;

var
  BarreIcones: TBarreIcones;

implementation
uses Donnees, PhylObs, PhylChoi, PhylComp, PhylPlch, PhylMain;

{$R *.DFM}

procedure TBarreIcones.FormCreate(Sender: TObject);
var
   i:integer;
begin
    TimerG.Interval:=100; // millisecondes
    TimerG.Enabled:=false;
    TimerD.Interval:=100;
    TimerD.Enabled:=false; 
    Images[0]:=CadreImage21;
    Images[1]:=CadreImage22;
    Images[2]:=CadreImage23;
    Images[3]:=CadreImage24;
    Premiere:=0;
    for i:=0 to 3 do
    with Images[i] do
    begin
       OnClick:=ImageClick;
       Tag:=i;    // l'index de Taxons commence  0
    end;
    FSelection:=TStringList.Create;
end;


procedure TBarreIcones.FormShow(Sender: TObject);
begin
{   if FormPrinc.Activite='Observer' then
           Selection:=FormObs.Selection
   else if FormPrinc.Activite='Comparer' then
           Selection:=FormComp.Selection
    else if FormPrinc.Activite='Choisir' then
           Selection:=FormChoisir.Selection; }
   AfficheIcones;
end;

procedure TBarreIcones.ImageClick(Sender: TObject);
var
   NumEsp:integer;
   NomEsp:string;
   ind:integer;
begin
   NumEsp:= TCadreImage2(Sender).Tag;
   AfficheEspece(NumEsp);
   NomEsp:= Taxons.GetNom(NumEsp);
   ind:= FSelection.IndexOf(NomEsp);
   if (ind = -1) then
     begin
        FSelection.Add(NomEsp);
        if (FormPrinc.Activite='Comparer') and (FSelection.Count > 4)
        or (FormPrinc.Activite='Observer') and (FSelection.Count > 1)
          then FSelection.Delete(0);
     end
   else
     FSelection.Delete(ind);
   AfficheIcones;
end;

procedure TBarreIcones.AfficheEspece(N:integer);
begin
   if (Parent.Name='FormObs') then
      FormObs.AfficheEspece(N)
   else if (Parent.Name='FormChoisir') then
      FormChoisir.AfficheEspece(N)
   else if (Parent.Name='FormComp') then
      FormComp.AfficheEspece(N);
end;

procedure TBarreIcones.FlecheGMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementGauche;
  TimerG.Enabled:=true;
end;

procedure TBarreIcones.AfficheIcones;
// affiche les icones  partir de Premiere
var
    i:integer;
    NomTaxon:string;
begin
    for i:=0 to 3 do
    with Images[i] do
    begin
     Tag:=Premiere+i;
     NomTaxon:= Taxons.GetNom(Tag);
     Affiche(Taxons.GetIcone(Tag),NomTaxon);
     Selected:=(FSelection.IndexOf(NomTaxon) <> -1)
    end;
end;


procedure TBarreIcones.DeplacementGauche;

begin
  if (Premiere>0) then
  begin
     Premiere:=Premiere-1;
     AfficheIcones;
  end;
end;

procedure TBarreIcones.FlecheDMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementDroit;
  TimerD.Enabled:=true;
end;

procedure TBarreIcones.DeplacementDroit;
begin
  if (Premiere < Taxons.NbTaxons-4) then
  begin
    Premiere:=Premiere+1;
    AfficheIcones;
  end;
end;


procedure TBarreIcones.FlecheGMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerG.Enabled:=false;
end;

procedure TBarreIcones.FlecheDMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerD.Enabled:=false;
end;


procedure TBarreIcones.TimeG(Sender:TObject);
begin
   DeplacementGauche;
end;

procedure TBarreIcones.TimeD(Sender:TObject);
begin
   DeplacementDroit;
end;

procedure TBarreIcones.BoutonPlancheClick(Sender: TObject);
begin
   FormPlanche.Hide;
   FormPlanche.Show;
end;

procedure TBarreIcones.SetSelection(Sel: TStringList);
begin
   FSelection:=Sel;
   Hide;
   Show;
end;

end.
