unit CompCadreIma;
// 28/11/99 modif AfficheLegende pour ajustement  la largeur du texte

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCadreImage=class(TPanel)
     Image:TImage;
     Legende:TImage;
  public
     constructor Create(AOwner: TComponent);override;
     procedure LoadFromFile(NomFichier:string);
     procedure AfficheLegende(Texte:string;CoulFond:TColor;ValTransp:boolean);
  end;
procedure Register;


implementation

constructor TCadreImage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Parent:=TWinControl(AOwner);
  Color:=clWhite;
  Image:=TImage.Create(Self);
  with Image do
  begin
    Parent:=Self;
    Enabled:=False;
    Align:= alClient;
    Center:=True;
  end;
end;

procedure TCadreImage.LoadFromFile(NomFichier:string);
begin
  Image.Picture.LoadFromFile(NomFichier);
end;

procedure TCadreImage.AfficheLegende(Texte:string;CoulFond:TColor;ValTransp:boolean);
// si ValTransp=true, la lgende s'affiche en surimpression
//                    et CoulFond n'est pas prise en compte
// sinon la lgende s'affiche sur un rectangle de couleur CoulFond
var
   NbBiseaux:integer;
   LargeurBord:integer;
   Place:integer;
begin
  NbBiseaux:=0;
  if (BevelInner <> bvNone) then inc(NbBiseaux);
  if (BevelOuter <> bvNone) then inc(NbBiseaux);
  LargeurBord := NbBiseaux*BevelWidth + BorderWidth;
  if (BorderStyle = bsSingle) then LargeurBord:=LargeurBord+5;

  Legende.Free;
  Legende:=TImage.Create(Self);
  with Legende do
  begin
    Parent:=Self;
     Enabled:=False;
     Legende.Canvas.Font:=Self.Font;
    // affichage de la lgende en bas du cadre
     Height:=Canvas.TextHeight(Texte);
     Width:=Canvas.TextWidth(Texte);
     Top := Self.Height - Height - LargeurBord;
     Place := Self.Width - 2*LargeurBord - Width;
     if (Place < 0) then Place:=0;
     Left:=Trunc((Place)/2)+LargeurBord ;
     Transparent:=ValTransp;
     if not Transparent then
     begin
        Legende.Canvas.Brush.Color:=CoulFond;
       // Canvas.FillRect(BoundsRect);
     end;

     Canvas.TextOut(0,0,Texte);
  end;
end;


procedure Register;
begin
   RegisterComponents('Phylo',[TCadreImage]);
end;

end.
