unit CompCadreIma2;
// Un TCompCadreIma2 est un TPanel contenant un TImage et un TLabel
// Pour afficher une image avec lgende : Affiche(NomFichier,Legende)
// Si NomFichier='' on affiche la lgende avec une Image blanche
// Si Legende='' on affiche seulement l'image
// La fonte de la lgende est la mme que celle du TPanel
//(on peut donc la modifier facilement)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCadreImage2=class(TPanel)
  private
     Image:TImage;
     FClientR:TRect;
     FLegende:TLabel;
     FSelected:boolean;
     procedure AjusteZoneClient;
     procedure Clique(Sender:TObject);
     procedure AfficheLegende(L: string);
     procedure SetSelected(Value: boolean);
     procedure AfficheEtat; // change apparence du bouton en fn de l'tat (selectionne ou non)
  public
     constructor Create(AOwner: TComponent);override;
     destructor Destroy;override;
     procedure Affiche(NomFichier:string;Legende:string);
     property Selected:boolean read FSelected write SetSelected;
  end;

procedure Register;


implementation

constructor TCadreImage2.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Parent:=TWinControl(AOwner);
  Color:=clWhite; // pourrait tre fixe  l'extrieur
  Caption:='';

  Image:=TImage.Create(Self);
  Image.Parent:=Self;
  Image.OnClick:=Clique;

  FLegende:=TLabel.Create(Self);
  FLegende.Parent:=Self;
  FLegende.Autosize:=true;
  FLegende.Visible:=false;
  FLegende.OnClick:=Clique;

  Selected:=false;
end;

procedure TCadreImage2.Clique(Sender:TObject);
begin
   if Assigned(OnClick) then Self.Onclick(Self);
end;   

procedure TCadreImage2.AjusteZoneClient;
begin
  FClientR:=ClientRect;
  AdjustClientRect(FClientR);
end;

procedure TCadreImage2.Affiche(NomFichier:string;Legende:string);
begin
  AjusteZoneClient;
  Image.Left:=FClientR.Left;
  Image.Top:=FClientR.Top;
  Image.Width:=FClientR.Right-FClientR.Left;
  Image.Height:=FClientR.Bottom-FClientR.Top-FLegende.Canvas.TextHeight(Legende);
  Image.Center:=True;
  if (NomFichier <> '') then Image.Picture.LoadFromFile(NomFichier)
                        else Image.Picture:=nil;
  AfficheLegende(Legende);
end;

procedure TCadreImage2.AfficheLegende(L: string);
begin
//  AjusteZoneClient;
  FLegende.Caption:=L;
  FLegende.Alignment:=taCenter;
  if L='' then FLegende.Height:=0;
  FLegende.Left:=FClientR.Left;
  FLegende.Top:=FClientR.Bottom-FLegende.Height;
  FLegende.Width:=FClientR.Right-FClientR.Left;
  FLegende.Visible:=True;
end;

procedure Register;
begin
   RegisterComponents('Phylo',[TCadreImage2]);
end;

destructor TCadreImage2.Destroy;
begin
   Image.Free;
   FLegende.Free;
   inherited Destroy;
end;

procedure TCadreImage2.SetSelected(Value: boolean);
begin
   FSelected:=Value;
   AfficheEtat;
end;

procedure TCadreImage2.AfficheEtat;
begin
   if FSelected then
     begin
       FLegende.Color:=clBlue;
     end
   else
     begin
       FLegende.Color:=clWhite;
     end;  
end;

end.
