unit CustomGraph;
{$S-,W-,R-}
{$C PRELOAD}
{$R CURSORS.RES}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   ListArray;

type

 TCanClic = procedure ( WPoint : TPoint ; var ret :boolean) of object;
 TClicObject = procedure (WPoint:TPoint) of object;

 TCurPrioritys = set of (crPage,crObjet,crActif);

 PCursorObj=^TCursorObj;
 TCursorObj= record
              index:integer;
              Name:string;
              end;

 TScrollDirection = (noscroll,scrollRight,ScrollLeft,ScrollUp, ScrollDown);
 TCursorIndex = (crDown,crMove,crDrag,crUp);

//******************************************************************************/

TGraphControl = class;
TGraphObject = class;

//******************************************************************************/

TActiveObject = class(TObject)
 private

 FParent       : TGraphControl;
 FParentObject : TGraphObject;
 CurDown       : TCursorObj;

 protected

 FStartPt : TPoint;
 FEndPt   : TPoint;

 function GetPCursorObj(index:TCursorIndex):PCursorObj;

 public
 property Parent       : TGraphControl read FParent write FParent;
 property ParentObject : TGraphObject read FParentObject write FParentObject;

 property StartPt      : TPoint read FStartPt write FStartPt;
 property EndPt        : TPoint read FEndPt write FEndPt;

 procedure Draw (NewPoint :TPoint); virtual ; // doit tre redfinie pour chaque object actif
 procedure paint(NewPoint :TPoint);
 procedure Hide ;
 destructor Destroy;override;
 constructor create (AParent:TGraphControl );virtual;

 end;

//******************************************************************************/
TLineGrow=class (TActiveObject)
 public
  constructor createLine (AParent:TGraphControl; APoint:TPoint);
  procedure Draw (NewPoint :TPoint); override;
 end;

TRectGrow=class (TActiveObject)
 public
  procedure Draw (NewPoint :TPoint); override;
 end;

TEllipseGrow=class (TActiveObject)
 public
  procedure Draw (NewPoint :TPoint); override;
 end;
//******************************************************************************/

TGraphPage =class(TObject)
 private

  FOrgX     :integer;
  FOrgY     :integer;

  FWidth    :integer;
  FHeight   :integer;

  FBackGrdColor:TColor;

  FParent   :TGraphControl;
  FCoeffScaleW : double ;
  FCoeffScaleH : double;

 protected
   FPage     :TListArray;
   FScale:double;

   Flag_CreateObjects:boolean;
   Flag_CreateCoordObjects:boolean;
   Flag_CreateInfoGraph:boolean;

  function GetPageWidth :integer; virtual;
  procedure SetPageWidth(width:integer); virtual;
  function GetPageHeight :integer; virtual;
  procedure SetPageHeight(height:integer); virtual;

  function GetClicObject(PagePoint :TPoint):TGraphObject;

 public

 constructor Create(AParent: TGraphControl);virtual;
 destructor Destroy; override;
 
 property Parent : TGraphControl read FParent write FParent;

 property BackGrdColor :TColor read FBackGrdColor write FBackGrdColor;
 property OrgX :integer read FOrgX write FOrgX;
 property OrgY :integer read FOrgY write FOrgY;
 property Width :integer read GetPageWidth write SetPageWidth;
 property Height :integer read GetPageHeight write SetPageHeight;

 property  CoeffScaleW:double read FCoeffScaleW write FCoeffScaleW;
 property  CoeffScaleH :double read FCoeffScaleH write FCoeffScaleH;

 Procedure CreateObjects;virtual;
 Procedure DeleteObjects;virtual;
 Procedure ChangeGraphObjects;virtual;
 procedure ChangeCoordGraphObjects;
 procedure ChangeInfoGraph;
  procedure CreateInfoGraph(ACanvas:TCanvas); virtual;
 Procedure CreateCoordObjects(ACanvas:TCanvas);virtual;

 procedure Paint(ACanvas:TCanvas);virtual;

 end;

//*******************************************************************************/

TGraphObject = class(TObject)

 private

 FPenColor:TColor;
 FPenWidth:integer;
 FPenStyle: TPenStyle;

 FBrushColor:TColor;
 FBrushStyle:TBrushStyle;

 FOrgX:integer;
 FOrgY:integer;

 FParent:TGraphPage;
 FParentObject : TGraphObject;
 FAssocObject : Pointer;

 CurDown:TCursorObj;
 CurMove:TCursorObj;
 CurUp:TCursorObj;
 CurDrag:TCursorObj;

  protected

  // jfr modifie le 10/04/00
  // fonction rajoute
 function MouseDownRight( Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;virtual;

 function MouseDown(Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;virtual;
 function MouseMove(Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;
 function MouseDrag(Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;
 function MouseUp(Button: TMouseButton; Shift: TShiftState;APoint:TPoint):TGraphObject;virtual;

 function PtInObject(APoint:TPoint):boolean;virtual;
 function GetPCursorObj(index:TCursorIndex):PCursorObj;
 function CreateActiveObject(Apoint :TPoint): TActiveObject;virtual;


 public

constructor Create(AParent: TGraphPage);virtual;

property Parent : TGraphPage read FParent write FParent;

property ParentObject :TGraphObject read FParentObject write FParentObject;
property AssocObject : Pointer read FAssocObject write FAssocObject;

property OrgX :integer read FOrgX write FOrgX;
property OrgY :integer read FOrgY write FOrgY;

property PenColor : TColor read FPenColor write FPenColor;
property PenWidth : integer read FPenWidth write FPenWidth;
property PenStyle : TPenStyle read FPenStyle write FPenStyle;

property BrushColor: TColor read FBrushColor write FBrushColor;
property BrushStyle: TBrushStyle read FBrushStyle write FBrushStyle;

procedure Paint(ACanvas:TCanvas);virtual;//S'occupe de TPen et de TBrush puis appelle Draw
procedure Draw(ACanvas:TCanvas);virtual;

end;




//*********************************************************************************/

TGraphControl = class(TCustomControl)
  private

  DrawingMode :boolean;
  FTimer:boolean;
  FListPage :TList;

  FScrollDirection: TScrollDirection;

  FClicDownObject : TGraphObject;
  FClicUpObject   : TGraphObject;
  FMouseMoveObject: TGraphObject;
  FMouseDragObject: TGraphObject;

  FActiveObject :TActiveObject;

  FCanClicDown : TCanClic;
  FCanClicActivate : TCanClic;

 // jfr modifie le 10/04/00
  FRespClicDownRight: TClicObject;

  FRespClicDown : TClicObject;
  FRespClicUp : TClicObject;
  FRespMouseMove : TClicObject;
  FRespMouseDrag :TClicObject;
  FRespActiveObjectUp:TClicObject;

  FMouseExit:TClicObject;
  FMouseEnter:TClicObject;

  FCursor:array[0..3] of TCursorObj;

  //************************** variables de mise en page **********************//
  // Les objets graphiques s'affichent sur une page virtuelle dont les dimensions sont
  // fixes par FPageWidth et FPageHeight. Les scrolls n'ont de sens que si les
  // dimensions de cette page sont suprieures  celles de la fentre client.
  // Par dfaut l'affichage de la page se fait de telle faon que son origine graphique
  // concide avec l'origine de la fentre : POriginX:=0, POriginY:=0.


  // Les six valeurs suivantes sont calcules par CalcRange avant chaque
  // affichage qu'il soit normal (paint) ou  la suite d'un scroll (paintscroll)

  POriginX : integer; // Coordonne (en pixel) X de la page affiche dans le coin
                     // suprieur gauche de la fentre : dpend de HScrollCount
  POriginY : integer; // Coordonne (en pixel) Y de la page affiche dans le coin
                     // suprieur gauche de la fentre : dpend de VScrollCount

  XRange :integer; // Etendue maximale d'un scroll horizontal : = PageWidth-ClientWidth
  YRange :integer; // Etendue maximale d'un scroll vertical : = PageHeight-ClientHeight
                   // Ces deux valeurs sont calcules par CalcRange

  VRange : integer; // valeur maximum de VScrollCount calcul par CalcRange
  HRange : integer; // valeur maximum de HScrollCount calcul par CalcRange

  FUScrollV: integer; //unit de scrolling verticale;
  FUScrollH: integer; // Unit de scrolling horizontale

  HScrollCount : integer; // compteur des scrolls horizontaux
  VScrollCount : integer; // compteur des scrolls verticaux

  FPageIndex : integer;
  FCurPrioritys :TCurPrioritys;

  FSurface : TBitmap;
  FBackSurface :TBitmap;

  FBackGrdColor:TColor;
  // Les deux fonctions suivantes sont  redfinir dans une grille : si le nombre
  // de colonne est fix alors Getpagewidth retourne ce nombre multipli
  // par la largeur des colonnes. Sinon c'est la dernire colonne remplie qui sert
  // de nombre de colonne. Mme chose pour les lignes


  // CalcRange : calcule les six valeurs de scroll  partir des units de scroll
  // (FUScrollV-H) des compteurs de scroll(H-VScrollCount)
  //et de la taille des pages et de la fentre
  procedure CalcRange; virtual;
  procedure SetScrollBar; // Rinitialise les barres de scroll

  procedure WMVScroll(var Msg: TWMVScroll); message WM_VSCROLL;
  procedure WMHScroll(var Msg: TWMHScroll); message WM_HSCROLL;
  procedure WMSize(var Msg: TWMSize); message WM_SIZE;
  procedure WMTimer(var Msg: TWMTimer); message WM_TIMER;

       { *******************  ******************** ********************}
       { ******************* Dclarations protges ********************}
       { *******************  ******************** ********************}

 protected
 // jfr modifie le 10/04/00
  // fonction rajoute
  procedure MouseDownRight(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); virtual;

  procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  procedure MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
  procedure CreateParams(var Params: TCreateParams); override;
  procedure Paint; override;

  // Fonction appele par ScrollTo. Elle initialise la surface cache,
  // appelle  PaintPage(surface.canvas), puis effectue la copie vers l'cran
  procedure PaintScroll;virtual;

  // Ces deux fonctions retournent 'true' par dfaut. Pour changer ce comportement
  // il suffit de dfinir une fonction du type MyCanClic..(TPoint, var boolean) et
  // de l'attribuer a FOnCanClic.. dans le constructeur d'une classe drive ou
  // de dfinir l'venement dans l'inspecteur d'objet

  function CanClicDown (WPoint :TPoint) : boolean;virtual;
  function CanClicActivate (WPoint :TPoint): boolean;virtual;

  // jfr modifie le 10/04/00
  // fonction rajoutee
  procedure RespClicDownRight(ClientPoint:TPoint);virtual;
  procedure RespClicDown(ClientPoint :TPoint);virtual;
  procedure RespClicUp(ClientPoint:TPoint);virtual;
  procedure RespMouseMove(ClientPoint :TPoint);virtual;
  procedure RespMouseDrag(ClientPoint :TPoint);virtual;
  procedure RespActiveObjectUp(ClientPoint :TPoint);virtual;


  function MouseExit(point:TPoint):boolean;
  function MouseEnter(point:TPoint):boolean;
  function MouseOutClient(point:TPoint):boolean;

  function GetActivePage :TGraphPage;
  function GetPageCount :integer;

  public { ************************ Dclarations public ********************* }

  constructor Create(AOwner: TComponent); override;

   procedure DeletePage (index:integer);
   procedure InsertPage (index:integer; AGraphPage :TGraphPage);
   procedure AddPage (AGraphPage :TGraphPage);
   function  GetPage(index:integer):TGraphPage;

  procedure SetCursor(indexCurs :integer; AName :string; crtype:TCursorIndex);
  procedure ChangeScale(TypeZoom:string);
  
  property PageCount :integer read GetPageCount;
  property ActivePage :TGraphPage read GetActivePage ;
  property ClicDownObject : TGraphObject read FClicDownObject ;
  property ClicUpObject   : TGraphObject read FClicUpObject  ;
  property MouseMoveObject: TGraphObject read FMouseMoveObject  ;
  property MouseDragObject: TGraphObject read FMouseDragObject  ;
  property ActiveObject :TActiveObject read FActiveObject write FActiveObject;
  
  published { ************************** Dclarations publies ***************}

  property Align;
  property OnCanClicDown :TCanClic read FCanClicDown write FCanClicDown ;
  property OnCanClicActivate :TCanClic read FCanClicActivate write FCanClicActivate ;
  property OnMouseUp;

  // jfr modifie le 10/04/00
  property OnRespClicDownRight:TClicObject read FRespClicDownRight write FRespClicDownRight;
  property OnRespClicDown:TClicObject read FRespClicDown write FRespClicDown;
  property OnRespClicUp: TClicObject read FRespClicUp write FRespClicUp;
  property OnRespMouseMove: TClicObject read FRespMouseMove write FRespMouseMove ;

  property OnMouseExit:TClicObject read FMouseExit write FMouseExit;
  property OnMouseEnter:TClicObject read FMouseEnter write FMouseEnter;

  property CurPrioritys: TCurPrioritys read FCurPrioritys write FCurPrioritys
                          default[crObjet,crActif];
  end;

procedure Register;

 //******************************************************************************/
//******************************************************************************/
//                           implementation
//******************************************************************************/
//******************************************************************************/


implementation

{*****************************************************************************
                            TActiveObject
*****************************************************************************}
procedure TActiveObject.Draw (NewPoint :TPoint); // doit tre redfinie pour chaque object actif
begin
end;
{*****************************************************************************}
procedure TActiveObject.paint(NewPoint :TPoint);
begin
  with Parent.canvas do begin
   pen.mode:=pmnotxor;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 draw(NewPoint);
end;
{*****************************************************************************}
procedure TActiveObject.Hide;
var
Apoint:TPoint;
 begin

 APoint.x:=0;
 APoint.y:=0;

  with Parent.canvas do begin
   pen.mode:=pmnotxor;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 draw(APoint);
end;

destructor TActiveObject.Destroy;
 begin
 with Parent.canvas do begin
   pen.mode:=pmcopy;
   pen.color:=clblack;
   brush.style:=bsClear;
  end;
 inherited destroy;
end;
{*****************************************************************************}
function TActiveObject.GetPCursorObj(index:TCursorIndex):PCursorObj;
begin
 case index of
  crdown : result := @CurDown;
  end;
end;
{*****************************************************************************}
constructor TActiveObject.create (AParent:TGraphControl);
 begin
  FParent:=AParent;
  FParentObject:=nil;
  CurDown.Index:=0; CurDown.name:='';
 end;
 {*****************************************************************************
                            TLineGrow
*****************************************************************************}
constructor TLineGrow.createLine (AParent:TGraphControl; APoint:TPoint);
 begin
  inherited create(AParent);
  FStartPt.x:=APoint.x;
  FStartPt.y:=APoint.y;
  FEndPt.x:=APoint.x;
  FEndPt.y:=APoint.y;
 end;

procedure TLineGrow.Draw (NewPoint :TPoint);
 begin
 if(NewPoint.x<>0) and (NewPoint.y<>0) then begin
  FEndPt.x:=NewPoint.x;
  FEndPt.y:=NewPoint.y;
 end;
 
 with Parent.Canvas do begin
  moveTo(FStartPt.x,FStartPt.y);
  LineTo (FEndPt.x,FEndPt.y);
  end;
end;
{*****************************************************************************
                            TRectGrow
*****************************************************************************}
procedure TRectGrow.Draw (NewPoint :TPoint);
 begin
  FEndPt.x:=FEndPt.x+NewPoint.x;
  FEndPt.y:=FEndPt.y+NewPoint.y;

  Parent.Canvas.Rectangle(FStartPt.x,FStartPt.y,FEndPt.x,FEndPt.y);
 end;

{*****************************************************************************
                            TRectGrow
*****************************************************************************}

procedure TEllipseGrow.Draw (NewPoint :TPoint);
begin
  FEndPt.x:=FEndPt.x+NewPoint.x;
  FEndPt.y:=FEndPt.y+NewPoint.y;
  Parent.Canvas.Ellipse(FStartPt.x,FStartPt.y,FEndPt.x,FEndPt.y);
 end;

{*****************************************************************************
                              TGraphPage
 *****************************************************************************}
constructor TGraphPage.Create(AParent: TGraphControl);
 begin
  FParent:=AParent;
  FPage:=TListArray.create;

  FCoeffScaleW:=0;
  FCoeffScaleH:=0;

  FWidth:=AParent.Clientwidth;
  FHeight:=AParent.Clientheight;

  FBackGrdColor:=Clwhite;
  Flag_CreateObjects:=false;
  Flag_CreateCoordObjects:=false;
  Flag_CreateInfoGraph:=false;

 end;

 destructor TGraphPage.Destroy;
 begin
  inherited ;
  DeleteObjects;
  FPage.free;
  end;
{*****************************************************************************}
procedure TGraphControl.ChangeScale(TypeZoom:string);
begin
// JFR modifie le 10/07/00
 if ActivePage=nil then exit;
 
 if typezoom='plus' then
 begin
  ActivePage.CoeffScaleW:=ActivePage.CoeffScaleW + 0.5;
  ActivePage.CoeffScaleH:=ActivePage.CoeffScaleH + 0.5;
 end;

 if typezoom='moins' then
 begin
   if ActivePage.CoeffScaleW >0 then ActivePage.CoeffScaleW:=ActivePage.CoeffScaleW - 0.5;
   if ActivePage.CoeffScaleH >0 then ActivePage.CoeffScaleH:=ActivePage.CoeffScaleH- 0.5;
  end;
   ActivePage.Height:=trunc(ClientHeight * ActivePage.CoeffScaleH + ClientHeight);
   ActivePage.Width:=trunc(ClientWidth+ClientWidth * ActivePage.CoeffScaleW);

   ActivePage.ChangeInfoGraph;
end;
{*****************************************************************************}
procedure TGraphPage.ChangeInfoGraph;
begin
  Flag_CreateInfoGraph:=false;
  Flag_CreateCoordObjects:=false;
end;
{*****************************************************************************}
procedure TGraphPage.ChangeCoordGraphObjects;
begin
  Flag_CreateCoordObjects:=false;
end;
{*****************************************************************************}
procedure TGraphPage.ChangeGraphObjects;
begin

 if Flag_CreateObjects=true then DeleteObjects;
 // La fonction deleteObjects met Flag_CreateObjects:=false et
                               // Flag_CreateCoordObjects:=false;

end;
{*****************************************************************************}
function TGraphPage.GetPageWidth :integer;
begin
 result:=FWidth;
end;
//*****************************************************************************/
procedure TGraphPage.SetPageWidth(width:integer);
begin
FWidth:=width;
end;
//*****************************************************************************/
function TGraphPage.GetPageHeight:integer;
begin
 result:=FHeight;
end;
//*****************************************************************************/
procedure TGraphPage.SetPageHeight(height:integer);
begin
FHeight:=height;
end;
//*******************************************************************************/
Procedure TGraphPage.CreateObjects;
begin
Flag_CreateObjects:=true;
Flag_CreateCoordObjects:=false;
end;

Procedure TGraphPage.DeleteObjects;
 begin
  Flag_CreateObjects:=false;
  Flag_CreateCoordObjects:=false;
end;

//*******************************************************************************/
Procedure TGraphPage.CreateInfoGraph(ACanvas:TCanvas);
begin
Flag_CreateInfoGraph:=true;
Flag_CreateCoordObjects:=false;
end;
//*******************************************************************************/
Procedure TGraphPage.CreateCoordObjects(ACanvas:TCanvas);
begin
Flag_CreateCoordObjects:=true;
end;

//*******************************************************************************/
procedure TGraphPage.Paint(ACanvas :TCanvas);

var
obj : TGraphObject;
nbLayer,noLayer :integer;
nbObj,noObj:integer;

begin

// Cette fonction cre un appel  CreateCoordObjects(ACanvas) car elle met
// le drapeau Flag_CreateCoordObjects:=false;
if not Flag_CreateObjects then CreateObjects;

// Comme la prcdante cette fonction cre un appel  CreateCoordObjects(ACanvas) 
// car elle met le drapeauFlag_CreateCoordObjects:=false;
if not Flag_CreateInfograph then CreateInfoGraph(ACanvas);

if not Flag_CreateCoordObjects then CreateCoordObjects(ACanvas);

nbLayer:=FPage.RowCount;
for nolayer:=0 to nbLayer-1  do
 begin
  nbObj:=FPage.ColCount[nolayer];
   for noObj:=0 to nbObj-1 do
    begin
      obj:=TGraphObject(FPage.Items[noLayer,noObj]);
      if obj <> nil then  obj.paint(ACanvas);
    end;
 end;
end;
//******************************************************************************/
function TGraphPage.GetClicObject(PagePoint :TPoint):TGraphObject;
var
IsObj:boolean;
obj : TGraphObject;
nbLayer,noLayer :integer;
nbObj,noObj:integer;

begin

// Si la page a t dcale les coordones du point de cliquage (coordonnes fentres)
// doivent tre modifie

IsObj:=false;
obj:=nil;
nbLayer:=FPage.RowCount;
for nolayer:=nbLayer-1 downto 0 do
 begin
  nbObj:=FPage.ColCount[nolayer];
   for noObj:=0 to nbObj-1 do
    begin
      obj:=TGraphObject(FPage.Items[noLayer,noObj]);
      if obj <> nil then
          begin
          IsObj:=obj.PtInObject(PagePoint);
          if IsObj<>false then break;
          end;
    end;
   if IsObj<>false then break;
 end;
if IsObj<>false then result:=obj
else result:=nil;
end;


{ *****************************************************************************
                              TGraphObject
*****************************************************************************}
constructor TGraphObject.Create(AParent:TGraphPage);
begin
FParent:=AParent;

FParentObject:=nil;
FAssocObject:=nil;

FPenColor:=clblack;
FPenWidth:=1;
FPenStyle:= psSolid;

FBrushColor:=clblack;
FBrushStyle:=bsSolid;

FOrgX:=0;
FOrgY:=0;

CurDown.Index:=0; CurDown.name:='';
CurUp.Index:=0;   CurUp.name:='';
CurMove.Index:=0; CurMove.name:='';
CurDrag.Index:=0; CurDrag.name:='';
end;

//*******************************************************************************/

procedure TGraphObject.Draw(ACanvas:TCanvas);
begin
end;
//*******************************************************************************/

procedure TGraphObject.Paint(ACanvas:TCanvas);
var
 OldPen:TPen;
 OldBrush:TBrush;

begin
 Oldpen:=TPen.Create;
 OldBrush:=TBrush.Create;

 Oldpen.Assign(ACanvas.pen);
 Oldbrush.Assign(ACanvas.brush);

 ACanvas.pen.color:=FPenColor;
 ACanvas.pen.width:=FPenWidth;
 ACanvas.pen.Style:=FPenStyle;

 ACanvas.brush.style:=FBrushStyle;
 ACanvas.brush.color:=FBrushColor;

 Draw(ACanvas);     // Fonction de dessin proprement dit

 ACanvas.pen.Assign(Oldpen);
 ACanvas.brush.Assign(Oldbrush);

 Oldpen.free;
 OldBrush.free;
end;
{******************************************************************************}
// jfr modifie le 10/04/00
  // fonction rajoute
function TGraphObject.MouseDownRight(Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;
 begin
  Result := self;
 end;
 {******************************************************************************}
function TGraphObject.MouseDown(Button: TMouseButton; Shift: TShiftState; APoint:TPoint):TGraphObject;
 begin
  Result := self;
 end;
 {******************************************************************************}
function TGraphObject.MouseMove(Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
 {******************************************************************************}
function TGraphObject.MouseDrag(Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
 {******************************************************************************}
function TGraphObject.MouseUp(Button: TMouseButton; Shift: TShiftState;APoint:TPoint):TGraphObject;
begin
Result := self;
end;
{******************************************************************************}
function TGraphObject.PtInObject(APoint:TPoint):boolean;
begin
result:= false;
end;
 {******************************************************************************}
function TGraphObject.GetPCursorObj(index:TCursorIndex):PCursorObj;
begin
 case index of
  crdown : result := @CurDown;
  crmove : result := @CurMove;
  crup   : result := @CurUp;
  crDrag : result := @CurDrag;
 end;
 end;

 {******************************************************************************}
function TGraphObject.CreateActiveObject(Apoint :TPoint): TActiveObject;
begin
result := nil;
end;

{ *****************************************************************************
                              TGraphControl
*****************************************************************************}

constructor TGraphControl.Create(AOwner: TComponent);
var
i:integer;

begin
  inherited Create(AOwner);

  FListPage:=TList.create;
  FPageIndex:=0;

  HScrollCount:=0;
  VScrollCount:=0;

  FUScrollV:=10;
  FUScrollH:=10;

  FSurface:= TBitmap.create;
  FBackSurface:=TBitmap.create;

  FBackGrdColor:=clLtgray;

  FCanClicDown:=nil;
  FCanClicActivate:=nil;

  // jfr modifie le 10/04/00
  FRespClicDownRight:=nil;
  FRespClicDown := nil;
  FRespClicUp :=nil ;
  FRespMouseMove :=nil ;
  FRespMouseDrag := nil;
  FRespActiveObjectUp:=nil;

  FMouseExit:=nil;
  FMouseEnter:=nil;


  for i:=0 to 3 do begin
  FCursor[i].index:=crArrow;
  FCursor[i].name:='';
  end;
  

  FScrollDirection:=noscroll;
  DrawingMode :=false;

  FTimer:=false;

  FClicDownObject:=nil;
  FClicUpObject:=nil;
  FActiveObject:=nil;
  FMouseMoveObject :=nil;
  FMouseDragObject:=nil;
  
  invalidate;
end;
//*******************************************************************************/
procedure TGraphControl.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or WS_BORDER;

   end;
end;
//*******************************************************************************/
function TGraphControl.GetPageCount :integer;
begin
 result:=FListPage.Count;
end;
//******************************************************************************/
procedure TGraphControl.DeletePage (index:integer);
var
AGraphPage :TGraphPage;
begin
  AGraphPage:=FListPage.Items[index];
  FListPage.delete(index);
  AgraphPage.free;
end;
//******************************************************************************/
procedure TGraphControl.InsertPage (index:integer; AGraphPage :TGraphPage);
begin
  FListPage.Insert(index,AGraphPage);
end;
//*******************************************************************************/
procedure TGraphControl.AddPage (AGraphPage :TGraphPage);
begin
  FListPage.Add(AGraphPage);
end;

//*******************************************************************************/
function TGraphControl.GetPage(index:integer):TGraphPage;
 begin
  if (PageCount=0) or (index<0) or (index>=PageCount) then result:=nil
  else result:=FListPage[index];
 end;
//*******************************************************************************/
function TGraphControl.GetActivePage :TGraphPage;
begin
  result:=GetPage(FPageIndex);
end;
//******************************************************************************/
procedure TGraphControl.PaintScroll;
var
w,h,ph,pw :integer;

begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;
 
h:=clientheight;
w:=clientwidth;

FSurface.Height:=h;
FSurface.Width:=w;

ph:=ActivePage.Height;
pw:=ActivePage.Width;

CalcRange; // fonction qui calcule POriginX et POriginY et qui s'occupe des barres
            // de scroll

// Cette fonction n'tant utilise que si la taille de la page est suprieure
// ou gale  celle de la fentre client, il est inutile de repeindre le fond
// de cette fentre comme dans la fonction paint.



// Ce test est en principe inutile puisqu'il ne peut y avoir de scroll quand la taille
// de la page est infrieure  celle de la fentre ; mais il est plus "joli"
// de repeindre la fentre par cette technique de double buffer, aussi la fonction
// paintscroll peut tre appele en dehors de contexte de scroll
 if (ph<h) or (pw<w) then
 begin

  with FSurface.canvas do begin
   brush.style:=bssolid;

   brush.color:=FBackGrdColor;
   FillRect(RECT(0,0,w,h));

   SetViewportOrgEx(FSurface.canvas.handle,- POriginX, -POriginY,nil);
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,pw,ph));
  end;
 end

else begin

  with FSurface.canvas do begin
   brush.style:=bssolid;
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,w,h));
   SetViewportOrgEx(FSurface.canvas.handle,- POriginX, -POriginY,nil);
  end;
end;



ActivePage.Paint(FSurface.canvas);

// Pour viter que la copie elle mme se fasse avec le dcalage
 SetViewportOrgEx(FSurface.canvas.handle, 0, 0,nil);

Canvas.CopyRect(RECT(0,0,w,h),FSurface.canvas,RECT(0,0,w,h));

SetViewportOrgEx(canvas.handle, 0,0,nil);

end;

//******************************************************************************/
procedure TGraphControl.Paint;
var
w,h :integer;
pw,ph: integer;

begin
h:=clientheight;
w:=clientwidth;

if ActivePage=nil then begin
   with canvas do begin
    brush.style:=bssolid;
    brush.color:=FBackGrdColor;
    FillRect(RECT(0,0,w,h));
   end;
 exit;
 end;

ph:=ActivePage.Height;
pw:=ActivePage.Width;

CalcRange ; // fonction qui calcule POriginX et POriginY et qui s'occupe des barres
            // de scroll



if (ph<h) or (pw<w) then
 begin

  with canvas do begin
   brush.style:=bssolid;

   brush.color:=clred;//FBackGrdColor;
   FillRect(RECT(0,0,w,h));

   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(ActivePage.OrgX,ActivePage.OrgY,ActivePage.OrgX+ActivePage.width,
            ActivePage.OrgY+ActivePage.Height));
   end;
 end

else begin
  with canvas do begin
   brush.style:=bssolid;
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,w,h));
  end;
end;

SetViewportOrgEx(canvas.handle,-POriginX, -POriginY,nil);

ActivePage.Paint(canvas);

// Pour viter que la copie se fasse avec le dcalage
SetViewportOrgEx(canvas.handle, 0, 0,nil);
end;

//******************************************************************************/
procedure TGraphControl.SetScrollBar;
begin
if HandleAllocated then
 begin
 SetScrollRange(Handle,sb_horz,0,XRange,false);
 SetScrollPos(Handle,sb_horz,POriginX,true);

 SetScrollRange(Handle,sb_vert,0,YRange,false);
 SetScrollPos(Handle,sb_vert,POriginY,true);
 end;
end;

//******************************************************************************/
procedure TGraphControl.CalcRange;
begin

// c'est une fonction cl car elle dtermine la possibilit de scroll, l'emplacement
// de la page dans la fentre, et met  jour les scrollbar

XRange:=ActivePage.Width-clientwidth; // Pagewidth est une proprit faisant appel  GetPageWidth

// Dans le cas ou la page est moins large que le fentre, la scrollbar horizontale
// doit disparatre car XRange=0 et tout scroll horizontal est impossible
// puisque HRange=0. (Un scroll  la souris (wmtimer) ou par les flche (wmshcroll)
//  modifie  HScrollCount et le rend <0 ou >HRange)

if (XRange<=0) then
 begin
   HRange:=0;
   POriginX:=-ActivePage.OrgX;
 end
else begin
 HRange:=(XRange div FUScrollH)+1;
 POriginX:=HScrollCount*FUScrollH;
 end;

YRange:=ActivePage.Height-clientheight; // Pagewidth est une proprit faisant appel  GetPageWidth

if (YRange<=0) then
 begin
   VRange:=0;
   POriginY:=-ActivePage.OrgY;
 end
else begin
  VRange:=(YRange div FUScrollV)+1;
  POriginY:=VScrollCount*FUScrollV;
end;

 SetScrollBar;
end;
//******************************************************************************/
procedure TGraphControl.WMSize(var Msg: TWMSize);
begin
  inherited;
  if ActivePage=nil then exit;

  ActivePage.Height:=trunc(ClientHeight * ActivePage.CoeffScaleH + ClientHeight);
  ActivePage.Width:=trunc(ClientWidth+ClientWidth * ActivePage.CoeffScaleW);

   ActivePage.ChangeInfoGraph;

 PaintScroll;                                     
end;


//******************************************************************************/
procedure TGraphControl.WMHScroll(var Msg: TWMHScroll);
begin

if ActivePage=nil then exit;

case Msg.ScrollCode of

 sb_LineUp :HScrollCount := HScrollCount-1;  // Flche gauche
 sb_LineDown :HScrollCount := HScrollCount+1; // Flche droite

 sb_PageUp : HScrollCount := HScrollCount-2;
 sb_PageDown : HScrollCount := HScrollCount+2;

 sb_Top : HScrollCount :=0;
 sb_bottom :HScrollCount:=HRange;

 sb_ThumbPosition,
 sb_ThumbTrack : HScrollCount:=Msg.Pos div FUScrollH;
 end;

 // Rappel si l'une des dimensions(hauteur ou largeur) de la page est infrieure
//  celle de la fentre client, HRange=0 ou VRange=0 et le scroll ne se fait pas
// puisque Paintscroll n'est pas appel
 if (HScrollCount > HRange)or (HScrollCount <0) then
  begin
   if (HScrollCount > HRange) then HScrollCount := HRange;
   if (HScrollCount <0)    then  HScrollCount :=0;
   end                           // Dans ce cas le scroll n'a pas lieu d'tre
 else
 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end
 else  PaintScroll;    // Fonction qui provoque le dfilement de la fentre
                       // aprs avoir fait appel  CalcRange
 end;


//******************************************************************************/
procedure TGraphControl.WMTimer(var Msg: TWMTimer);
var
comptH,comptV:integer;
begin
comptH:=0;
comptV:=0;

if ActivePage=nil then exit;

if FScrollDirection=noScroll then exit;
case FScrollDirection  of
  ScrollRight: comptH:=-1;
  ScrollLeft : comptH:=1;
  ScrollUp   : comptV:=+1;
  ScrollDown : comptV:=-1;
 end;

HScrollCount := HScrollCount+comptH;
VScrollCount := VScrollCount+comptV;

// Dans les deux cas suivants le scroll n'a pas lieu d'tre
// Rappel si l'une des dimensions(hauteur ou largeur) de la page est infrieure
//  celle de la fentre client, HRange=0 ou VRange=0 et le scroll ne se fait pas
// puisque Paintscroll n'est pas appel

if (HScrollCount > HRange)or (HScrollCount <0) then
  begin
   if (HScrollCount > HRange) then HScrollCount := HRange;
   if (HScrollCount <0)    then  HScrollCount :=0;
   end
 else
 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end
 else
 begin
  PaintScroll;
  // Comme la page est redessine en mmoire  partir des objets graphiques sans
  // tenir compte de l'objet actif, il est inutile d'effacer l'objet actif avant
  // de le dessiner
   if FActiveObject<>nil then
     begin
      FActiveObject.FStartPt.x:= FActiveObject.FStartPt.x-(comptH*FUScrollH);
      FActiveObject.FStartPt.y:= FActiveObject.FStartPt.y-(comptV*FUScrollV);
     FActiveObject.paint(Point(0,0));
     end;
  end;

end;


//******************************************************************************/
function TGraphControl.MouseEnter(point:TPoint):boolean;
begin
 if (FTimer)and(point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
  then begin
   KillTimer(Handle,1);
   FTimer:=false;
  result:=true
  end
 else result:=false;
end;
//********************************************************************************/
{function TGraphControl.MouseExit(point:TPoint):boolean;
begin
 if FTimer then
   begin
    KillTimer(Handle,1);
    FTimer:=false;
   end;
 if (point.x>=0) and (point.x<Clientwidth) and (point.y>=0) and (point.y<=Clientheight)
  then begin
  if FActiveObject<>nil then
    begin
     FActiveObject.FEndPt.x:=point.x;
     FActiveObject.FEndPt.y:=point.y;
    end;
  result:=false
  end
 else begin
   SetTimer(Handle, 1, 1, nil);
   FTimer:=true;
   result:=true;
   if point.x<0 then FScrollDirection:=scrollright
   else if point.x>=Clientwidth then FScrollDirection:=scrollleft
   else if point.y<0 then  FScrollDirection:=scrolldown
   else if point.y>Clientheight then FScrollDirection:=scrollUp;
   if FActiveObject<>nil then
    begin
     FActiveObject.FEndPt.x:=point.x;
     FActiveObject.FEndPt.y:=point.y;
    end;
   end;
if Assigned(FMouseExit) then FMouseExit(point);
end;

 }

function TGraphControl.MouseOutClient(point:TPoint):boolean;
begin
 result:=false;
 if FTimer then
   begin
     if (point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
        then result:=false
     else begin
       result:=true;
       if point.x<=0 then FScrollDirection:=scrollright
       else if point.x>=Clientwidth then FScrollDirection:=scrollleft
       else if point.y<=0 then  FScrollDirection:=scrolldown
       else if point.y>=Clientheight then FScrollDirection:=scrollUp;
     if FActiveObject<>nil then
      begin
       FActiveObject.FEndPt.x:=point.x;
       FActiveObject.FEndPt.y:=point.y;
      end;
   end;
end;
end;

function TGraphControl.MouseExit(point:TPoint):boolean;
begin
 result:=false;
 if not FTimer then
   begin
     if (point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
     then result:=false
   else begin
   SetTimer(Handle, 1, 1, nil);
   FTimer:=true;
   result:=true;
   if point.x<=0 then FScrollDirection:=scrollright
   else if point.x>=Clientwidth then FScrollDirection:=scrollleft
   else if point.y<=0 then  FScrollDirection:=scrolldown
   else if point.y>=Clientheight then FScrollDirection:=scrollUp;
   if FActiveObject<>nil then
    begin
     FActiveObject.FEndPt.x:=point.x;
     FActiveObject.FEndPt.y:=point.y;
    end;
   end;
end;   
if Assigned(FMouseExit) then FMouseExit(point);
end;

//******************************************************************************/
procedure TGraphControl.WMVScroll(var Msg: TWMVScroll);
begin

if ActivePage=nil then exit;

case Msg.ScrollCode of

 sb_LineUp :VScrollCount := VScrollCount-1;  // Flche gauche
 sb_LineDown :VScrollCount := VScrollCount+1; // Flche droite

 sb_PageUp : VScrollCount := VScrollCount-2;
 sb_PageDown : VScrollCount := VScrollCount+2;

 sb_Top : VScrollCount :=0;
 sb_bottom :VScrollCount:=VRange;

 sb_ThumbPosition,
 sb_ThumbTrack : VScrollCount:=Msg.Pos div FUScrollV;
 end;

 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end   // Dans ce cas le scroll n'a pas lieu d'tre

 else  PaintScroll;    // Fonction qui provoque le dfilement de la fentre
end;

//*****************************************************************************/
function TGraphControl.CanClicDown(WPoint:TPoint) : boolean;
begin
Result:=true;
If Assigned(FCanClicDown) then FCanClicDown(WPoint,Result);
end;
//*****************************************************************************/
function TGraphControl.CanClicActivate(WPoint:TPoint) : boolean;
begin
Result:=true;
If Assigned(FCanClicActivate) then FCanClicActivate(WPoint,Result);
end;

//********************************************************************************/
procedure TGraphControl.MouseUp(Button :TMouseButton; Shift: TShiftState;X,Y:Integer);
 var
 ClicObj: TGraphObject;
 PagePoint :TPoint;
 ClientPoint,nullPoint :TPoint;
 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

 PCurs:=nil;

 nullPoint.x:=0;
 nullPoint.y:=0;

 ClientPoint.X:=X; // pour tenir compte du scrolling ventuel;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

 if  FTimer then
  begin
   KillTimer(Handle,1);
   FTimer:=false;
  end;


 if FActiveObject<>nil then FActiveObject.Hide;

 ClicObj:=ActivePage.GetClicObject(PagePoint);

 if ClicObj<>nil then
   begin
     ClicObj:=ClicObj.MouseUp(Button,shift,PagePoint);
     if ClicObj <> nil then FClicUpObject :=ClicObj
     else FClicUpObject :=nil;
   end
  else FClicUpObject :=nil;

 if (crObjet in CurPrioritys) and (FClicUpObject<>nil)
      then PCurs:=FClicUpObject.GetPCursorObj(crUp);

 // Donc l'application a  sa disposition pour rpondre
 // - L'objet,si il existe, sur lequel  eu lieu le premier clic de souris : FclicdownObject
 // - Le dernier objet,si il existe, sur lequel la souris a t dplac : FClicDragObject
 // - l'objet, si il existe, o a lieu le clic Up :FClicUpObject.
 // - L'objet actif qui a ses coordonnes en 'mmoire'

 RespClicUp(ClientPoint);
 if FActiveObject <> nil then FActiveObject.free;

 paintScroll;

 DrawingMode:=false;
 FActiveObject:=nil;
 FClicDownObject:=nil;
 FClicUpObject:=nil;
 FMouseMoveObject :=nil;
 FMouseDragObject:=nil;
 inherited MouseUp(Button, Shift, X, Y);
end;

//*****************************************************************************/
// jfr modifie le 10/04/00
// Fonction minimale cre dans l'urgence pour le clic droit
procedure TGraphControl.MouseDownRight(Button :TMouseButton; Shift: TShiftState;X,Y:Integer);
 var
 PagePoint :TPoint;
 ClicObj: TGraphObject;
 ClientPoint :TPoint;

  begin
   FClicDownObject:=nil;
   FClicUpObject:=nil;
   FActiveObject:=nil;
   FMouseMoveObject :=nil;
   FMouseDragObject:=nil;

 ClientPoint.X:=X; // pour tenir compte du scrolling ventuel;
 ClientPoint.Y:=Y;
 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

 ClicObj:=ActivePage.GetClicObject(PagePoint);
 if ClicObj <> nil then
   begin
     ClicObj:=ClicObj.MouseDownRight(Button,shift,PagePoint);
     FClicDownObject :=ClicObj;
     FClicUpObject:=ClicObj;

     // devrait ne pas tre inclue dans ce if then
     RespClicDownRight(ClientPoint);
   end;



  FClicDownObject:=nil;
  FClicUpObject:=nil;
 inherited MouseDown(Button, Shift, X, Y);
 end;

// jfr modifie le 10/04/00
// modification   if (Button=mbRight)then  begin ... end
//*****************************************************************************/
procedure TGraphControl.MouseDown(Button :TMouseButton; Shift: TShiftState;X,Y:Integer);
 var
 ClicObj: TGraphObject;
 PagePoint :TPoint;
 ClientPoint :TPoint;
 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;
 if FTimer=true then exit;

 if (Button=mbRight)then
   begin
   MouseDownRight(Button, Shift,X,Y);
   exit;
   end;

 PCurs:=nil;

 ClientPoint.X:=X; // pour tenir compte du scrolling ventuel;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

 FClicDownObject:=nil;
 FClicUpObject:=nil;
 FActiveObject:=nil;
 FMouseMoveObject :=nil;
 FMouseDragObject:=nil;

 DrawingMode:=false;

 // L'application peut interdire toute rponse  un clic

 if not CanClicDown(ClientPoint) then exit;


 ClicObj:=ActivePage.GetClicObject(PagePoint);
 if ClicObj <> nil then
   begin
     ClicObj:=ClicObj.MouseDown(Button,shift,PagePoint);

     // Cette fonction doit permettre  un objet de garder les coordonnes de la souris
     // Cette fonction est trs importante : elle peut changer la nature de l'objet
     // qui rpond. Par exemple si le clic a lieu sur une poigne d'un objet
     // redimensionnable, la poigne va retourner par dfaut son objet pere c.a.d
     // l'objet redimensionnable lui mme.
     // Cette fonction peut galement forcer un objet  se redessiner (cas d'un
     // bouton qui s'enfonce par exemple ; dans ce cas
     // l'objet doit se redessiner en forant le raffichage de la fentre par la
     // fonction UpdateWindow(Parent.FHandle) pour que l'object actif soit ensuite
     // redessin

       if ClicObj <> nil then
        begin
         FClicDownObject :=ClicObj;
         FClicUpObject:=ClicObj;

         // CreateActiveObject cre un objet actif et initialise ces coordonnes
         if CanClicActivate(ClientPoint)then
            FActiveObject:=ClicObj.CreateActiveObject(PagePoint) ;
        end;
   end;
   // Mme si le clic de souris a eu lieu en dehors d'un objet, l'application
   // peut crer un objet actif  condition d'initialiser ces coordonnes

   RespClicDown(ClientPoint);

   if FActiveObject<> nil then
     begin
       DrawingMode:=true;
       // on dessine pour la premire fois l'objet actif
       FActiveObject.paint(ClientPoint);

      if crActif in CurPrioritys then PCurs:=FActiveObject.GetPCursorObj(crdown);
     end
   else
     begin
      if (crObjet in CurPrioritys) and (FClicDownObject<>nil)
      then PCurs:=FClicDownObject.GetPCursorObj(crdown);
     end;

inherited MouseDown(Button, Shift, X, Y);
end;
//******************************************************************************/
procedure TGraphControl.MouseMove(Shift: TShiftState; X, Y: Integer);
var
 ClicObj: TGraphObject;

 PagePoint :TPoint;
 nullPoint :TPoint;
 ClientPoint :TPoint;

 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

 PCurs:=nil;

 nullPoint.x:=0;
 nullPoint.y:=0;

 ClientPoint.X:=X;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

if not DrawingMode  then  // la souris se dplace sans qu'il y ait eu de clic au pralable
 begin
   FMouseDragObject:=nil;
   ClicObj:=ACtivePage.GetClicObject(PagePoint);

   if ClicObj<> nil then
     begin
      ClicObj:=ClicObj.MouseMove(shift,PagePoint);
      if ClicObj<> nil then FMouseMoveObject:=ClicObj
      else FMouseMoveObject:=nil;
    end
   else FMouseMoveObject:=nil;
  // l'application peut crer une rponse au dplacement de la souris
  // sans que le curseur passe sur un  objet.

  RespMouseMove(ClientPoint);

 if (crObjet in CurPrioritys)and (FMouseMoveObject<>nil)
  then  PCurs:=FMouseMoveObject.GetPCursorObj(crmove);

 end;

 if DrawingMode  then  // la souris se dplace avec un clic au pralable
  begin
  // si le mouvement de la souris a lieu en dehors de l'aire client c'est
  // le timer qui rentre en jeu
 // if (MouseEnter(ClientPoint)=false) and (FActiveObject<> nil) then FActiveObject.Hide;

  if MouseExit(ClientPoint)=true then exit;
  if MouseOutClient(ClientPoint)=true then exit;

  FMouseMoveObject:=nil;

 // l'objet actif doit s'effacer aprs ce premier appel;
  if MouseEnter(ClientPoint) then  PaintScroll

  else

  if FActiveObject<> nil then FActiveObject.Hide;

   ClicObj:=ActivePage.GetClicObject(PagePoint);
   if ClicObj<> nil then
    begin
      ClicObj:=ClicObj.MouseDrag(shift,PagePoint);
     // si un objet rpond en se redessinant il doit le faire par l'intermdiaire
     // de la mthode paint en appelant InvalidateRect et update cf essaipmxor
     if ClicObj<> nil then FMouseDragObject:=ClicObj
     else FMouseDragObject:=nil;
   end
  else FMouseDragObject:=nil;

 // l'application peut crer une rponse au dplacement de la souris avec le
 // bouton gauche enfonc sans que le curseur passe sur un  objet.

 RespMouseDrag(ClientPoint);

 // Attention il est important que le mode pmnotxor soit mis car l'objet  pu
 // se redessiner par la procdure ClicObj.MouseDrag ou l'application a pu modifier
 // le canvas au cours de la rponse RespMouseDrag

 // l'objet actif se redessine  une nouvelle position.

 if FActiveObject<> nil then FActiveObject.paint(ClientPoint);

 if (crActif in CurPrioritys) and (FMouseDragObject<>nil)
                  then PCurs:=FActiveObject.GetPCursorObj(crdown);

 if (crObjet in CurPrioritys)and (FMouseDragObject<>nil)
                  then PCurs:=FMouseDragObject.GetPCursorObj(crdrag);

 end;

//inherited MouseMove(Shift, X, Y);
end;

//******************************************************************************/
procedure TGraphControl.SetCursor(indexCurs :integer; AName :string; crtype:TCursorIndex);
var
ind:integer;
begin
 case crtype of
  crdown : ind := 0;
  crmove : ind := 1;
  crup   : ind := 2;
  crDrag : ind := 3;
 end;
 FCursor[ind].index:=indexCurs;
 FCursor[ind].Name:=AName;
 end;
//******************************************************************************/
// Si DrawCursor(nil,crdown)  c'est le curseur du clicdown
// de la page qui est pass sinon si DrawCursor(cursor,crdown) deux possibilits :
// si cursor.index:=0 alors  c'est le curseur  du clicdown
// de la page qui est pass sinon c'est le curseur 'cursor' qui est utilis.
// Les curseurs d'un objet graphique sont initialis  curseurs.index=0 par dfaut
// ceux de la page  FCursor.index:=crarrow et FCursor.name:='';

{procedure TGraphControl.DrawCursor(Pcursor:PCursorObj;typeCurs :TCursorIndex);
var
PCurs:PCursorObj;
ind:integer;
Cur: HCURSOR;
begin
PCurs:=PCursor;

if (Pcursor=nil) or (PCursor^.index=0) then
begin
 case typeCurs of
  crdown : ind := 0;
  crmove : ind := 1;
  crup   : ind := 2;
  crDrag : ind := 3;
 end;
new(PCurs);

PCurs^.Index:=FCursor[ind].index;
PCurs^.Name:=FCursor[ind].Name;
end;

if (PCurs^.name='') then screen.cursor:=PCurs^.index

else begin
     cur:= LoadCursor(HInstance, PChar(PCurs^.Name));
     Screen.Cursors[PCurs^.index] :=cur;
     Screen.Cursor:= PCurs^.index ;
     end;
dispose(PCurs);
end;

 }

// jfr modifie le 10/04/00
// fonction rajoutee
 //******************************************************************************/
procedure TGraphControl.RespClicDownRight(ClientPoint:TPoint);
 begin
  If Assigned(FRespClicDownRight) then FRespClicDownRight(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl.RespClicDown(ClientPoint:TPoint);
 begin
  If Assigned(FRespClicDown) then FRespClicDown(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl.RespClicUp(ClientPoint:TPoint);
 begin
  If Assigned(FRespClicUp) then FRespClicUp(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl.RespMouseMove(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseMove) then FRespMouseMove(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl.RespMouseDrag(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseDrag) then FRespMouseDrag(ClientPoint);
 end;
 //******************************************************************************/
procedure TGraphControl.RespActiveObjectUp(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseDrag) then FRespMouseDrag(ClientPoint);
 end;


procedure Register;
begin
  RegisterComponents('phylo', [TGraphControl]);
end;

end.
