unit group2;

interface
 uses
   SysUtils, Classes, GraphObject,ListArray2,typedef;

type

 TGroup = class(TObject)
  private

   FListItems :TstringList;
   FChildsGroup : TList;
   FParent : TGroup;
   FCaption :string;
   FObject :TObject;
   
  function GetChild (index:integer ): TGroup ;

  public
   Tabdata  :TStrListArray;
   NodeAssoc: TObject; // Pour la construction de l'arbre aprs un regroupement

   constructor CreateGroup(AData :TStrListArray);
   destructor destroy; override;

   procedure Sort(CaracName :string);
   property AObject :TObject read FObject write FObject;
   property ListItems :TstringList read FListItems write FListItems;
   property ChildsGroup : TList read FChildsGroup write FChildsGroup;
   property Child[Index: Integer]: TGroup read GetChild;
   property Parent : TGroup read FParent write FParent;
   property Caption :string read FCaption  write FCaption ;

  end;

TTreeGroup = class(TModel)

 private
  FSortList : TStringList;
  function GetSortItem(index:integer):string;

 public
  Tabdata :TStrListArray;

  constructor CreateTreeGroup(data :TStrListArray);
  destructor Destroy; override;

  procedure AddSort(CaracName : string);
  procedure DeleteSort(CaracName :string);
  procedure Sort(CaracName :string);
  procedure CreateFirstGroup;
  procedure CreateGroupPro(caracname :string);
  property SortItem[index:integer] : string read GetSortItem;
   
 end;



implementation

constructor TGroup.CreateGroup(AData :TStrListArray);
 begin
  FListItems:=TStringList.create;
  FChildsGroup:=TList.create;
  FParent:=Nil;
  FCaption:='';
  TabData:=Adata;
 end;

destructor TGroup.destroy;
begin
 FListItems.free;
 FChildsGroup.free;
 inherited destroy;
end;

procedure TGroup.Sort(CaracName :String);
var
  noCol,noRow, index ,nostate: integer;
  Taxon, State :string;
  StateList :TStringList;
  group :Tgroup;
begin
  StateList:=TStringList.create;

  if ChildsGroup.count>0 then ChildsGroup.clear;

  noCol:=TabData.indexOfCol(CaracName);
  if noCol >=0 then
    begin
     for index:=0 to FListItems.Count-1 do
     begin
      Taxon:=FListItems[index];
      noRow:=TabData.indexOfRow(Taxon);
      State:=TabData.StrItems[noRow,noCol];

      noState:=StateList.IndexOf(State);
      if noState>=0 then // L'tat est dj rfrenc donc le groupe fils
        begin            // correspondant existe et on y rajoute le taxon
          group:=ChildsGroup.Items[noState];
          group.FListItems.Add(Taxon);
        end
      else
        begin                      // l'tat n'est pas rfrenc
          StateList.add(State);    // donc on l'ajoute  la StateList
          group:=TGroup.createGroup(TabData); // et on cre un groupefils correspondant
          group.FListItems.Add(Taxon);
          group.Parent:=self;
          group.Caption:=state;
          ChildsGroup.Add(group)
        end;
    end;
   end;
 end;

 //***************************************************************************/
 //*****************************************************************************/
 function TGroup.GetChild (index:integer ): TGroup ;
 begin
   result:=nil;
   if index< FChildsGroup.Count then Result:=TGroup(FChildsGroup.Items[index]);
  end;
//***************************************************************************/

constructor TTreeGroup.CreateTreeGroup(data :TStrListArray);
 begin
  FSortList:=TStringList.Create;
  FSortList.add(''); // correspond  l'emplacement du premier groupe qui n'est ->
  Tabdata:=data;      // -> pas le rsultat d'un tri
  inherited CreateModel;
  CreateFirstGroup;
 end;
//***************************************************************************/
destructor TTreeGroup.Destroy;
 begin
  FSortList.free;
  inherited destroy;
 end;

//***************************************************************************/
procedure TTreeGroup.AddSort(CaracName : string); // Cre des groupes par un tri
begin
  FSortList.add(CaracName); // Liste o sont recenss les tris successifs
  Sort(CaracName);  // Creation des nouveaux groupes issus du tri
end;
//***************************************************************************/
procedure TTreeGroup.Sort(CaracName : string);
var
 LastRow, child :integer;
 nbCol , index :integer;
 group :TGroup;

 begin

 LastRow:=RowCount-1;
 nbCol:=ColCount[LastRow];

 for index :=0 to nbCol-1 do
    begin
      group:=TGroup(Items[LastRow,index]);
      group.Sort(caracname);  // Cre des groupes fils et remplit la FChildsGroup
                              // de chaque groupe, puis les groupes fils sont
       for child:=0 to group.FChildsGroup.count-1 do   // ajouts au TabGroup
         AddItem(LastRow+1,group.FChildsGroup.items[child]);

    end;
 end;

//*******************************************************************************/
procedure TTreeGroup.CreateGroupPro(caracname :string);
var
 LastRow,nbcol,nocol,col,index,norow :integer;
 Taxon,state :string;
 group,groupPro : TGroup;
begin
 LastRow:=RowCount-1;
 nbCol:=ColCount[LastRow];

 noCol:=TabData.indexOfCol(CaracName);

 for col :=0 to nbCol-1 do
    begin
      group:=TGroup(Items[LastRow,col]);
      groupPro:=TGroup.CreateGroup(TabData);
      groupPro.Caption:=caracName;
      groupPro.Parent:=group;

       for index:=0 to group.ListItems.Count-1 do
         begin
           Taxon:=group.ListItems[index];
           noRow:=TabData.indexOfRow(Taxon);
           state:=TabData.StrItems[noRow,noCol];
           groupPro.ListItems.Add(state);
          end;
     end;
 end;
//*******************************************************************************/
procedure TTreeGroup.CreateFirstGroup;
var
 row :integer;
 taxon :string;
 FirstGroup :Tgroup;
 begin
   FirstGroup:=TGroup.CreateGroup(Tabdata);
   for row:=1 to TabData.RowCount-1 do
    begin
    taxon:=TabData.StrItems[row,0];
    if trim(taxon)<>'' then FirstGroup.FListItems.Add(Taxon);
    end;
    AddItem(0,FirstGroup);
 end;

//*******************************************************************************/
function TTreeGroup.GetSortItem(index:integer):string;
begin
 result:=FSortList[index];
end;
//*******************************************************************************/
procedure TTreeGroup.DeleteSort(CaracName :string);
var
 index, i :integer;
 group:TGroup;
 cont:integer;
  begin
  index:=FSortList.IndexOf(CaracName);
  if index>=1 then
   begin
    FSortList.Delete(index);
    ClearRows(1,toDelete);

    group:=TGroup(Items[0,0]);     // jfr modifie le 07/09/00
    group.FChildsgroup.delete(0);
    group.FChildsgroup.count:=0;
    
    for i:=1 to FSortList.Count-1 do Sort(FSortList[i]);
    { if FSortList.count=1 then
     begin
      group:=TGroup(Items[0,0]);     // jfr modifie le 07/09/00
      group.FChildsgroup.delete(0);
      group.FChildsgroup.count:=0;
      end;  }
    //ClearRows(index,toDelete);       
   // for i:=index to FSortList.Count-1 do Sort(FSortList[i]);
  end;
end;



end.
