unit PhylArbre;

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CustomGraph, GraphControlTreeCL, Grids, MyNewgrid,fenarbre,
  ExtCtrls, Buttons,typedef,listarray2;

type
  TFormArbre = class(TForm)
    TabGrid1: TTabGrid;
    GCT1: TGraphControlTreeCL;
    Splitter1: TSplitter;
    panel1: TPanel;
    GroupBox1: TGroupBox;
    LongTot: TEdit;
    LongPart: TEdit;
    Label4: TLabel;
    Panel2: TPanel;
    auto: TSpeedButton;
    code: TSpeedButton;
    zoommois: TSpeedButton;
    zoomplus: TSpeedButton;
    legendes: TButton;
    Label3: TLabel;
    LegendeGroupBox: TGroupBox;
    Optionslegendes: TButton;
    ouvrircode: TOpenDialog;
    annuler: TSpeedButton;
    normal: TSpeedButton;
    pivoter: TSpeedButton;
    Enraciner: TSpeedButton;
    procedure Button2Click(Sender: TObject);
    procedure legendesClick(Sender: TObject);
    procedure TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GCT1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ActionClick(Sender: TObject);
    procedure OptionslegendesClick(Sender: TObject);
    procedure codeClick(Sender: TObject);
    procedure autoClick(Sender: TObject);
    procedure annulerClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure zoomplusClick(Sender: TObject);
    procedure zoommoisClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  NameOfFlagTaxonPro: string;
    { Dclarations prives }
  public
   ModeAfficheCarac :boolean
    { Dclarations publiques }
  end;

var
  FormArbre: TFormArbre;

implementation

uses optionleg, optioncode, code, PhylMain, PhylChoi, PhylTrier, group2;

{$R *.DFM}


procedure TFormArbre.Button2Click(Sender: TObject);
begin
GCT1.InitTree(TabGrid1);
LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;


procedure TFormArbre.legendesClick(Sender: TObject);
begin
   if legendes.Caption='Afficher'then
   begin
   legendes.Caption:='Effacer';
   GCT1.TreePage.Flag_Legende:=true;
   GCT1.TreePage.CreateLeg;
   GCT1.TreePage.ChangeCoordGraphObjects;
   optionsLegendes.Enabled:=true;
   end
   else
     begin
     legendes.Caption:= 'Afficher';
      GCT1.TreePage.Flag_Legende:=false;
      GCT1.TreePage.DeleteLeg;
      optionslegendes.enabled:=false;
      end;
   GCT1.invalidate;
end;

procedure TFormArbre.TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
col,row :integer;
AName :string;
begin
TabGrid1.MouseToCell(X,Y,col,row);
if (row=0) and (col<>0) then

 begin
  if ModeAfficheCarac=true then
  begin
     if TabGrid1.InvalidateCol[col]=false then AName:=''
      else AName:=TabGrid1.Cells[col,row];

     if AName='' then
      begin
      if GCT1.TreePage.Flag_Legende=true then
        begin
          GCT1.TreePage.Flag_Legende:=false ;
          GCT1.TreePage.DeleteLeg;
          legendes.Caption:='Afficher';
        end ;
       legendes.Enabled:=False ;
      end
    else legendes.Enabled:=True;

    GCT1.OnChangeSelectCarac(AName);
    GCT1.invalidate;
   LongTot.Text:=intToStr(GCT1.TreeTotalLength);
   LongPart.Text:=intToStr(GCT1.TreeUnitLength);
  end
  else
   begin
    AName:=TabGrid1.Cells[col,row];
    GCT1.OnChangeListCarac(nil, AName);
    LongTot.Text:=intToStr(GCT1.TreeTotalLength);
    LongPart.Text:=intToStr(GCT1.TreeUnitLength);
   end;
 end;
if (row<>0) and (col=0) then
 begin
  AName:=TabGrid1.Cells[col,row];

// le clic a eu lieu sur une cellule slectionne mais il la dselectionne  automaatiquement
  if TabGrid1.SelectRow[row]=false then
   begin   
      GCT1.DeleteTaxon(AName);
     LongTot.Text:=intToStr(GCT1.TreeTotalLength);
     LongPart.Text:=intToStr(GCT1.TreeUnitLength);

   end
     else  // le clic a eu lieu sur une cellule non selectionne au dpart
      begin
       if GCT1.NameOfFlagTaxonPro='' then
        begin
         GCT1.AddTaxonPro(AName);
         NameOfFlagTaxonPro:=AName;
         TabGrid1. SelectRow[row]:=False;
         // La cellule reste dselectionne tant que le taxon provisoire n'est pas rajout
        end;
        TabGrid1. SelectRow[row]:=False;
      end;
  end;
end;

//******************************************************************************/

procedure TFormArbre.GCT1MouseUp(Sender: TObject; Button: TMouseButton;
                              Shift: TShiftState; X, Y: Integer);
var
  row :integer;
begin
// La deuxime condition traduit le fait que le greffage russi d'un taxon
// provisoire conduit  sa suppression
if (NameOfFlagTaxonPro<>'') and (GCT1.NameOfFlagTaxonPro='') then
 begin
  row:=TabGrid1.IndexOfRow(NameOfFlagTaxonPro);
  if row<>-1 then
   begin
    //TabGrid1.InvalidateRow[row]:=false;
    TabGrid1. SelectRow[row]:=true;
    TabGrid1.MyInvalidateCell(0,row);
    GCT1.AddTaxonToDataList(row);
    end;
   NameOfFlagTaxonPro:='';
 end;

LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

//******************************************************************************/
procedure TFormArbre.ActionClick(Sender: TObject);
begin
  if sender = enraciner
        then GCT1.OnFlagRoot
  else if sender =pivoter
        then GCT1.OnFlagSwap
  else if sender = normal
        then GCT1.OnFlagNormal;
end;

//******************************************************************************/

procedure TFormArbre.OptionslegendesClick(Sender: TObject);
var
res :integer;
begin
 case GCT1.TreePage.TypeEtat  of
  NEtatDown :FicheOptionLeg.EtatDownRadio.Checked:=true;
  NEtatUp : FicheOptionLeg.EtatUpRadio.Checked:=true;
  NEtatMPR : FicheOptionLeg.EtatMPRRadio.Checked:=true;
  end;

  case GCT1.TreePage.TypeLegende  of
   texte :FicheOptionLeg.TexteRadio.Checked:=true;
   codeL : FicheOptionLeg.codeRadio.Checked:=true;
  end;

 res:=FicheOptionLeg.showModal;

 if res<>mrcancel then
 begin

  if  FicheOptionLeg.EtatDownRadio.Checked=true then GCT1.TreePage.TypeEtat := NEtatDown
  else if  FicheOptionLeg.EtatUpRadio.Checked=true  then GCT1.TreePage.TypeEtat := NEtatUp
  else if  FicheOptionLeg.EtatMPRRadio.Checked=true then GCT1.TreePage.TypeEtat :=  NEtatMPR;

  if FicheOptionLeg.TexteRadio.Checked=true then GCT1.TreePage.TypeLegende := texte
  else if FicheOptionLeg.codeRadio.Checked=true  then GCT1.TreePage.TypeLegende := codeL;

  GCT1.TreePage.DeleteLeg;
  GCT1.TreePage.CreateLeg;
  GCT1.TreePage.ChangeCoordGraphObjects;

  GCT1.Invalidate;
 end;

 end;
//******************************************************************************/

procedure TFormArbre.codeClick(Sender: TObject);
var
res,rescod,compt,No :integer;
newtabcod :TstrListArray;
begin
 rescod:=mrcancel;
 res:=FicheOptioncode.showModal;
 if res<>mrcancel then
  begin
    if FicheOptionCode.ouvrirbouton.Checked=true then
      begin
       if ouvrircode.execute then
          begin
           FicheCode.Codegrid1.LoadfromFile(ouvrircode.filename);
           rescod:=FicheCode.ShowModal;
          end;
      end
     else   // On utilise le fichier de codage cr par dfaut
      begin
          FicheCode.Codegrid1.cells[0,0]:='CARACTERE';
          FicheCode.Codegrid1.cells[1,0]:='TYPE';

          compt:=2; No:=1;
          while (compt <= GCT1.TabCod.ColCount[0]) do
           begin
             FicheCode.Codegrid1.cells[compt,0]:='ETAT'+IntToStr(No);
             FicheCode.Codegrid1.cells[compt+1,0]:='CODE'+IntToStr(No);
           compt:=compt+2;
           No:=No+1;
           end;
          FicheCode.Codegrid1.CopyFromAListArray(0,1,GCT1.TabCod);

          rescod:=FicheCode.ShowModal;
      end;
   if rescod<>mrcancel then
     begin
      newtabcod:=TstrListArray.createListArray;
      FicheCode.Codegrid1.CopyToAListArray(0,1,newtabcod);
      GCT1.OnChangeTabCod(newtabcod);
      LongTot.Text:=intToStr(GCT1.TreeTotalLength);
      LongPart.Text:=intToStr(GCT1.TreeUnitLength);
      end;
  end;

end;

procedure TFormArbre.autoClick(Sender: TObject);
begin
 GCT1.OnChangeAuto;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.annulerClick(Sender: TObject);
begin
 GCT1.UndoTreeAction;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.FormCreate(Sender: TObject);
begin
NameOfFlagTaxonPro:='';
ModeAfficheCarac:=true ;
end;


procedure TFormArbre.zoomplusClick(Sender: TObject);
begin
GCT1.OnChangeScale('plus');
end;

procedure TFormArbre.zoommoisClick(Sender: TObject);
begin
GCT1.OnChangeScale('moins');
end;

procedure TFormArbre.FormShow(Sender: TObject);
var
ListArray:TStrListArray;
TreeGroup:TTreeGroup;
begin
   ListArray:=TStrListArray.createlistArray;
if FormPrinc.ATri<>nil then
 begin
  FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);
  TabGrid1.copyFromAlistArray(0,0,ListArray);
  TabGrid1.SelectAllRow(true);
  FormTri.TabGrid1.CopyListSelectCol(TabGrid1.ListSelectCol);
   TabGrid1.Invalidate;

  TreeGroup:=TTreeGroup(FormTri.GraphTri1.Model);
  GCT1.InitTreeGroup(FormTri.TabGrid1,TreeGroup);
 end
 else
 begin
  FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);
  TabGrid1.copyFromAlistArray(0,0,ListArray);

   TabGrid1.SelectAllCol(true);
   TabGrid1.SelectAllRow(true);

  GCT1.InitTree(FormArbre.TabGrid1);

 end;
   LongTot.Text:=intToStr(FormArbre.GCT1.TreeTotalLength);
   LongPart.Text:=intToStr(FormArbre.GCT1.TreeUnitLength);

  ListArray.free;
end;

end.
 