unit BarreIc;
// Dl 29/04/00 modif gestion des Timer

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, jpeg,CompCadreIma2;

type
  TBarreIcones = class(TForm)
    Panel1: TPanel;
    FlecheG: TImage;
    FlecheD: TImage;
    TimerG: TTimer;
    TimerD: TTimer;
    CadreImage21: TCadreImage2;
    CadreImage22: TCadreImage2;
    CadreImage23: TCadreImage2;
    CadreImage24: TCadreImage2;
    BoutonPlanche: TBitBtn;
    CadreImage25: TCadreImage2;
    procedure FormShow(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure FlecheGMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheGMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TimeG(Sender:TObject);
    procedure TimeD(Sender:TObject);
    procedure DeplacementGauche;
    procedure DeplacementDroit;
    procedure FormCreate(Sender: TObject);
    procedure BoutonPlancheClick(Sender: TObject);

  private
    { Dclarations prives }
    FSelection:TStringList;  // liste des noms des taxons slectionns

    Images : array[0..3] of TCadreImage2;
    procedure SetSelection(Sel:TStringList);
    
  public
    { Dclarations publiques }
    Premiere : integer;                 // index de la premire image
    procedure AfficheEspece(N: integer);
    procedure AfficheIcones;
    property Selection:TStringList read FSelection write SetSelection ;
  end;

var
  BarreIcones: TBarreIcones;

implementation
uses Donnees, PhylObs, PhylChoi, PhylComp, PhylPlch, PhylMain;

{$R *.DFM}

procedure TBarreIcones.FormCreate(Sender: TObject);
var
   i:integer;
begin
    TimerG.Interval:=100; // millisecondes
    TimerG.Enabled:=false;
    TimerD.Interval:=100;
    TimerD.Enabled:=false; 
    Images[0]:=CadreImage21;
    Images[1]:=CadreImage22;
    Images[2]:=CadreImage23;
    Images[3]:=CadreImage24;
    Premiere:=0;
    for i:=0 to 3 do
    with Images[i] do
    begin
       OnClick:=ImageClick;
       Tag:=i;    // l'index de Taxons commence  0
    end;
    FSelection:=TStringList.Create;
end;

procedure TBarreIcones.FormShow(Sender: TObject);
begin
if(Pos('Observer',FormPrinc.Activite)<>0) then
 Selection:=FormObs.Selection
else
if(Pos('Comparer',FormPrinc.Activite)<>0) then
 Selection:=FormComp.Selection 
else
 if FormPrinc.Activite='Choisir'
  then Selection:=FormChoisir.Selection;  
{  if FormPrinc.Activite='Observer' then        // jfr modifie 15 octobre 2001
           Selection:=FormObs.Selection
   else if FormPrinc.Activite='Comparer' then
           Selection:=FormComp.Selection
    else if FormPrinc.Activite='Choisir' then
           Selection:=FormChoisir.Selection; }
   AfficheIcones;
end;

procedure TBarreIcones.ImageClick(Sender: TObject);
var
   NumEsp:integer;
   NomEsp:string;
   ind:integer;
begin
   with FormPrinc do                    // jfr modifie septembre 2001
       begin
   //if(Pos('Arbre',Activite)=0) and (Pos('Classer',Activite)=0)
   //    then begin Arbre1.Enabled:=false; Classer1.Enabled:=false;  end;    // jfr modifie 16 octobre 2001
   //if(Pos('Arbre',Activite)=0) or (Pos('Classer',Activite)=0) then Arbre1.Enabled:=false;
   //if(Pos('Arbre',Activite)=0) or (Pos('Classer',Activite)=0) then Classer1.Enabled:=false;
   // jfr modifie 15 octobre 2001
        end;
   NumEsp:= TCadreImage2(Sender).Tag;
   AfficheEspece(NumEsp);
   NomEsp:= Taxons.GetNom(NumEsp);
   ind:= FSelection.IndexOf(NomEsp);
   if (ind = -1) then
     begin
        FSelection.Add(NomEsp);
        if ((pos('Comparer',FormPrinc.Activite)<>0)and (FSelection.Count > 4))
        //if (FormPrinc.Activite='Comparer')
        or ((pos('Observer',FormPrinc.Activite)<>0)and (FSelection.Count > 1))
         //((FormPrinc.Activite='Observer') and (FSelection.Count > 1))
          then FSelection.Delete(0);
     end
   else
     FSelection.Delete(ind);
   AfficheIcones;
end;

procedure TBarreIcones.AfficheEspece(N:integer);
begin
   if (Parent.Name='FormObs') then
      FormObs.AfficheEspece(N)
   else if (Parent.Name='FormChoisir') then
      FormChoisir.AfficheEspece(N)
   else if (Parent.Name='FormComp') then
      FormComp.AfficheEspece(N);
end;

procedure TBarreIcones.FlecheGMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementGauche;
  TimerG.Enabled:=true;
end;

procedure TBarreIcones.AfficheIcones;
// affiche les icones  partir de Premiere
var
    i:integer;
    NomTaxon:string;
begin
    for i:=0 to 3 do
    with Images[i] do
    begin
     Tag:=Premiere+i;
     NomTaxon:= Taxons.GetNom(Tag);
     Affiche(Taxons.GetIcone(Tag),NomTaxon);
     Selected:=(FSelection.IndexOf(NomTaxon) <> -1)
    end;
end;


procedure TBarreIcones.DeplacementGauche;

begin
  if (Premiere>0) then
  begin
     Premiere:=Premiere-1;
     AfficheIcones;
  end;
end;

procedure TBarreIcones.FlecheDMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementDroit;
  TimerD.Enabled:=true;
end;

procedure TBarreIcones.DeplacementDroit;
begin
  if (Premiere < Taxons.NbTaxons-4) then
  begin
    Premiere:=Premiere+1;
    AfficheIcones;
  end;
end;


procedure TBarreIcones.FlecheGMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerG.Enabled:=false;
end;

procedure TBarreIcones.FlecheDMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerD.Enabled:=false;
end;


procedure TBarreIcones.TimeG(Sender:TObject);
begin
   DeplacementGauche;
end;

procedure TBarreIcones.TimeD(Sender:TObject);
begin
   DeplacementDroit;
end;

procedure TBarreIcones.BoutonPlancheClick(Sender: TObject);
begin
   FormPlanche.Hide;
   FormPlanche.Show;
end;

procedure TBarreIcones.SetSelection(Sel: TStringList);
begin
   FSelection:=Sel;
   //invalidate;
   //if visible=true
   // then Hide;      // jfr modifie 15 octobre 2001
   // Show;
end;

end.
