unit ListArray;

interface

uses
  SysUtils,Classes,typedef;

type

TListArray = class(TObject)
 private
 ListRow:TList;
 FDelete:TModif;

 function GetRowCount: integer;
 function GetColCount(row:integer): integer;

 protected

 function SetItem(ARow:integer ;ACol : integer; value :pointer):pointer; // *** fait
 procedure PutItem(ARow:integer ;ACol : integer; value :pointer); // Appel setItem
 function GetItem(Arow,ACol :integer) :pointer ;     // *** fait

 {function DeleteItemRow(ACol:integer;list:TList; TypeTrim:TTrim):pointer; }

 

 function SetRow(ARow:integer; List:TList): TList;  // *** fait
 procedure PutRow(ARow:integer; List:TList); // Appel setRow (cf property)
 procedure AddRow(List:TList);
 function GetRow(ARow:integer): Tlist;
 procedure ExchangeRow(ARow1,ARow2 :integer);
 
 Procedure InsertRow(Index:integer;List:TList);

 procedure ClearRows(firstRow:integer;TypeModif:TModif);
 procedure MoveRow(FromIndex, ToIndex: integer);

 function ModifRow(Row:integer;modif:TTrim;SaveList:Tlist):boolean;
 function ModifRow_Col(ARow:integer;FromCol,ToCol:integer;modif:TTrim;
                       SaveList:TList):boolean;
 function ModifListRow_Col(FromRow,ToRow:integer;FromCol,ToCol:integer;modif:TTrim;
                           SaveTab:TListArray):boolean;

 function GetCol(ACol:integer; sublist:TList): boolean;
 function GetColRow(ACol:integer; FromRow:integer; sublist:TList): boolean;
 function SetCol(ACol:integer; NewCol,OldCol :TList): boolean;
 function SetColRow(ACol,ARow:integer; NewCol,OldCol :TList):boolean;
 procedure ExchangeCol(ACol1, ACol2 :integer);


 public
 
 function DeleteItem(ARow,ACol:integer;TypeTrim:TTrim):pointer;
 function DeleteRow(ARow :integer;TypeTrim:TTrim):TList;
 constructor create;virtual;
 destructor Destroy; override;
 function IndexOfItem(value:pointer; var ARow :integer;var ACol :Integer):boolean;
  Procedure ClearRow(ARow:integer);
 function GetMaxFillColOfRow(row:integer):integer;
 procedure GetMaxDim(var MaxRow:integer;var MaxCol:integer);
 procedure ClearListArray(Typemodif:TModif);

 function AddItem(ARow :integer; value : pointer):integer;
 property Items[ARow,ACol :integer]:pointer read GetItem write PutItem;
 property Row[ARow :integer]:TList read GetRow write PutRow;
 property RowCount:integer read GetRowCount;
 property ColCount[row:integer]:integer read GetColCount;
 property IsDelete :TModif read FDelete write FDelete;

 end;

PstrItem=^TStrItem;
TStrItem=record
  FObject :TObject;
  FString :string;
  end;

TStrListArray = class(TListArray)
 protected
  procedure SetString (ARow:integer; ACol:integer; const AString:string);
  function GetString (ARow:integer; ACol:integer):string;

  procedure SetObject (ARow:integer; ACol:integer; AObject:TObject);
  function GetObject (ARow:integer; ACol:integer):TObject;
 public
 constructor create;override;
 constructor CopyCreate(AStrListArray:TstrListArray);
 property StrItems[ARow,ACol:integer]:string read GetString write SetString;
 end;


function NewStrItem(const Astring:string ; AObject:TObject): PStrItem;
procedure DisposeStrItem(P:PStrItem);
function SetPointer(index:integer; List:TList; value:pointer):pointer;
function EnsureList(var index1 :integer; var index2 :integer; subList:TList):boolean;
procedure InsertPointer(index:integer; List:TList; value:pointer);
procedure ExchangePointer(FromIndex, ToIndex:integer;List:TList );
function PeekRight(List:TList):pointer;

implementation
//*****************************************************************************/
function NewStrItem(const Astring:string ; AObject:TObject): PStrItem;
begin
 new(result);
 result^.FObject:=AObject;
 result^.FString :=AString;
end;
//*****************************************************************************/
procedure DisposeStrItem(P:PStrItem);
begin
 dispose (P);
end;
//*****************************************************************************/
function PeekRight(List:TList):pointer;
 begin
  if List.count>=1 then
    begin
      result:=List.Items[List.Count-1];
      List.Delete(List.Count-1);
    end
  else result:=nil;
 end;

//*****************************************************************************/
function EnsureList(var index1 :integer; var index2 :integer; subList:TList):boolean;
begin
Result:=true;
if index1+1>sublist.count then
 begin Result:=false;
       exit;
 end;
if index1=-1 then index1:=0;
if ( index2=-1) or (index2+1>sublist.count) then index2:=sublist.count-1;
end;
//*****************************************************************************/
procedure InsertPointer(index:integer; List:TList; value:pointer);
begin
 if index+1 > List.Count then SetPointer(index,list,value)
 else List.insert(index,value);
end;

//*****************************************************************************/
function SetPointer(index:integer; List:TList; value:pointer):pointer;
var
  i:integer;
begin
  result:=NIL;

  if index+1 > List.Count then for i:=List.Count to index do List.Add(NIL);
  if List.Items[index] <> NIL then result:=List.Items[index];
  List.Items[index]:=value;
end;

//*****************************************************************************/
procedure ExchangePointer(FromIndex, ToIndex:integer;List:TList );
var
 p:pointer ;
 begin
 p:=setPointer(FromIndex,List,Nil);
 p:=SetPointer(ToIndex,List,p);
 SetPointer(FromIndex,List,p);
end;


//******************************************************************************/
constructor TListArray.create;
begin
ListRow:=Tlist.Create;
FDelete:=nodelete;
end;
//******************************************************************************/
destructor TListArray.destroy;
begin
 ClearListArray(FDelete);
end;
//******************************************************************************/

function TListArray.IndexOfItem(value:pointer;var ARow :integer;var ACol :Integer):boolean;
var
row,col :integer;
sublist:TList;
begin
Result:=false;
for row:=0 to ListRow.count-1 do
 begin
 sublist:=TList(ListRow.Items[row]);
 if sublist<>nil then
  begin
   for col:=0 to sublist.count-1 do
   begin
    Result:=true; ARow:=row; ACol:=col;
    break;
   end;
  end;
  if Result=true then break;
 end;
end;
//*******************************************************************************
// Cette fonction renvoie un pointeur sur l'objet situ  la ligne 'ARow' et  la
// colonne 'ACol'. Les valeurs de 'ACol' et 'ARow' sont vrifies ainsi que l'existence
// d'une liste correspondant  'ARow': en cas de problme la fonction renvoie 'nil'.
// Si TypeTrim vaut 'noTrim' un pointeur 'nil' remplace le pointeur original.
// Si TypeTrim vaut 'Trim' ou 'TrimMem' la liste correspondant  la ligne 'ARow'
// est remanie.
// Si Typetrim vaut 'TrimMem' la mmoire correspondant au pointeur libre.

function TListArray.DeleteItem(ARow,ACol:integer;TypeTrim:TTrim):pointer;
 var
 sublist:TList;
 begin
 Result:=nil;

 if ARow+1 > ListRow.Count then Exit;
 if ListRow.Items[ARow] = nil then Exit;

 sublist:=TList(ListRow.Items[ARow]);
 if sublist=nil then exit;
 if ACol+1>sublist.Count then Exit;

 Result:=sublist.Items[ACol];

 if (TypeTrim=noTrim) then sublist.Items[ACol]:=nil;
 if (TypeTrim=toTrim) or (TypeTrim=TrimMem)
    then sublist.delete(ACol); // Remanie la liste et dcrmente FCount

 if TypeTrim=TrimMem then sublist.Capacity:=sublist.Count; // libre la mmoire
 end;
//******************************************************************************/
function TListArray.AddItem(ARow :integer; value :pointer):integer;
var
  i:integer;
  sublist:TList;
begin
if ARow+1 > ListRow.Count then
    for i:=ListRow.Count to ARow do  ListRow.Add(NIL);

if ListRow.Items[ARow] = NIL then  ListRow.Items[ARow]:=TList.Create;
sublist:=TList(ListRow.Items[ARow]);
sublist.add(value);
result:=sublist.count-1;
end;
//******************************************************************************/
procedure TListArray.PutItem(ARow,ACol : integer; value :pointer);
begin
SetItem(ARow,ACol,value);
end;
//******************************************************************************/
function TListArray.SetItem(ARow,ACol : integer; value :pointer):pointer;
 (* give back the pointer to the previously stored element to let the caller dispose it *)
var
  i:integer;
  sublist:TList;

 begin
  result:=NIL;

  if ARow+1 > ListRow.Count then
    for i:=ListRow.Count to ARow do  ListRow.Add(NIL);

  if ListRow.Items[ARow] = NIL then  ListRow.Items[ARow]:=TList.Create;

  sublist:=TList(ListRow.Items[ARow]);

  if ACol+1 > sublist.Count then
   for i:=sublist.Count to ACol do sublist.Add(NIL);

  if sublist.items[ACol] <> NIL then result:=sublist.items[ACol];

  sublist.Items[ACol]:=value;
 end;

 //****************************************************************************/

function TListArray.GetItem(ARow,ACol : integer):pointer;
 var
  sublist: TList;
begin
  Result:=NIL;
  if (ARow+1 > ListRow.Count) or (ACol<0) or (ARow<0) then Exit;
  if ListRow.Items[ARow] = NIL then Exit;

  sublist:=TList(ListRow.Items[ARow]);
  if ACol+1 > sublist.Count then Exit;

  Result:=sublist.Items[ACol];
end;
//*****************************************************************************/
procedure TListArray.AddRow(List:TList );
begin
ListRow.Add(List);
end;
//*****************************************************************************/
procedure TListArray.PutRow(ARow:integer; List:TList );
begin
SetRow(ARow,List);
end;
//*****************************************************************************/
function TListArray.SetRow(ARow:integer; List:TList ): TList;
var
  i:integer;

begin
  result:=NIL;

  if ARow+1 > ListRow.Count then
    for i:=ListRow.Count to ARow do ListRow.Add(NIL);

  if ListRow.Items[ARow] <> NIL then result:=TList(ListRow.Items[ARow]);

  ListRow.Items[ARow]:=List;
end;
//******************************************************************************
// Cette fonction retourne un pointeur sur une liste situe  la ligne 'ARow'
// En cas de dbordement, la fonction renvoie 'nil'
function TListArray.GetRow(ARow:integer): TList;
begin
  Result:=nil;
  if (ARow <ListRow.Count) or (ARow>=0) then
    if ListRow.Items[ARow]<> NIL then Result:=TList(ListRow.Items[ARow]);
end;
//*******************************************************************************
procedure  TListArray.ExchangeRow(Arow1,Arow2 :integer);
begin
 ExchangePointer(ARow1,ARow2,ListRow);
end;
//*******************************************************************************
procedure TListArray.MoveRow(FromIndex, ToIndex: integer);
var
  p: pointer;
begin
  p:=SetPointer(FromIndex,ListRow,NIL);
  ListRow.Delete(FromIndex);

  while ToIndex>ListRow.count do ListRow.add(NIL); // attention aux effets de bord

  ListRow.Insert(ToIndex,p);
end;

//*******************************************************************************
// Cette fonction enlve une ligne de la liste ListRow et la remanie si TypeTrim
//  vaut 'Trim'ou 'TrimMem'. La mmoire correspondant au pointeur est libre si
//  Typetrim vaut TrimMem mais pas la mmoire correspondant  la ligne

function TListArray.DeleteRow(ARow :integer;TypeTrim:TTrim):TList;
begin
result:=GetRow(ARow);

if (ARow +1>ListRow.Count) or (ARow<0) then Exit;
if (TypeTrim=noTrim) then ListRow.Items[ARow]:=nil;
if (TypeTrim=toTrim) or (TypeTrim=TrimMem)
    then ListRow.delete(ARow); // Remanie la liste et dcrmente FCount
if TypeTrim=TrimMem then ListRow.Capacity:=ListRow.Count;
end;
//*******************************************************************************

procedure TListArray.ClearRow(ARow :integer);
var
 sublist:TList;
begin
 sublist:=GetRow(ARow);
 if sublist<>nil then sublist.clear;
end;
//*******************************************************************************/
procedure TListArray.ClearRows(firstRow:integer;TypeModif:TModif);
var
row,col,compt:integer;
value :pointer;
sublist:TList;
begin
if TypeModif=todelete then begin
for row:=firstRow to ListRow.Count-1 do begin
  sublist:=getRow(row);
   if sublist<>nil then begin
    for col:=0 to sublist.count-1 do begin
     value:=Items[row,col];
     if value<>nil then dispose(value);
 end;end; end; end;

compt:=ListRow.Count-1;
while compt>=firstRow do begin
 sublist:=deleteRow(compt,TrimMem);
 if sublist<>nil then sublist.clear;
 compt:=ListRow.Count-1;
 end;
end;

//*******************************************************************************/
procedure TListArray.ClearListArray(TypeModif:TModif);
 begin
  ClearRows(0,TypeModif);
 end;

//*******************************************************************************
Procedure TListArray.InsertRow(Index:integer;List:TList);
begin
InsertPointer(index,ListRow,List);
end;
//*******************************************************************************
// Comme TList ne fait que grer des pointeurs, il faut ventuellement les dtruire
// ' la main' . Pour dtruire les objets points il faut les rcuprer :
// c'est le rle de 'savelist' qui rcupre les pointeurs et donc permet ensuite
// de dtruire les objets correspondant.
// Syntaxe :
//   - pour remanier le tableau et dtruire des objets :
//         SaveListe:=TListCreate;
//         bool:=deleteRowcol(row,fcol,tocol,saveliste);
//         if bool then cleanlist(Saveliste);
//         SaveListe.free;
//   - pour remanier le tableau sans dtruire les objets :
//         bool:=deleteRowcol(row,fcol,tocol,nil);
//
function TListArray.ModifRow(Row:integer;modif:TTrim;SaveList:Tlist):boolean;
begin
result:=ModifRow_Col(Row,0,-1,modif,SaveList);
end;

//******************************************************************************/
function TListArray.ModifRow_Col(ARow :integer;FromCol,ToCol:integer; modif:TTrim;
                                 SaveList:Tlist):boolean;
var
sublist: TList;
i:integer;

begin
Result:=false;
 if (ARow+1>ListRow.Count) or (ARow<0) then exit;

 sublist:=ListRow.Items[ARow];

 if sublist=nil then  exit;
 if not EnsureList(FromCol,ToCol,sublist)then exit;
 
 Result:=true;
 if SaveList<>nil then for i:= FromCol To ToCol do SaveList.Add(sublist.Items[i]);

 for i:=fromCol to ToCol   do
   if modif=noTrim then sublist.Items[i]:=nil;

 if (modif=toTrim) or (modif=TrimMem) then sublist.Count:=fromcol+1;
 if (modif=TrimMem) then sublist.Capacity:=fromcol+1;

end;

//********************************************************************************/
function TListArray.ModifListRow_Col(FromRow,ToRow:integer;
                                    FromCol,ToCol:integer;
                                    modif:TTrim;
                                    SaveTab:TListArray):boolean;
var
listsave:TList;
row:integer;
ret:boolean;

begin
Result:=false;

if not EnsureList(FromRow,ToRow,ListRow) then  Exit;

for row:=FromRow to ToRow do
 begin
   if (SaveTab<>nil) then listsave:=TList.Create else listsave:=nil;

   ret:=ModifRow_Col(row,FromCol,ToCol,modif,listsave);

   if not ret then
     begin
      if (SaveTab<>nil) then begin listsave.free; SaveTab.ListRow.Add(nil);end;
     end
   else  begin Result:=true ;if (SaveTab<>nil)then SaveTab.ListRow.Add(listsave);end;
  end;
end;

//*****************************************************************************
// Diffrentes techniques peuvent tre employes pour cette fonction : par exemple
// on pouurrait utiliser la proprit LCells, mais cela serait certainement plus lent
{ modalit d'appel   list:=TListCreate;
                     retour:= GetCol(col,list);
                     }

function TListArray.GetCol(ACol:integer; sublist:TList): boolean;
begin
result:=GetColRow(ACol,0,sublist);
end;


{****************************************************************************}
function TListArray.GetRowCount: integer;
begin
result:=ListRow.Count;
end;
{****************************************************************************}
function TListArray.GetColCount(row:integer): integer;
var
subList:TList;

begin
result:=0;
sublist:=getRow(row);
if sublist=nil then exit;
result:=SubList.Count;
end;

{****************************************************************************}
function TListArray.GetMaxFillColOfRow(row:integer):integer;
var
col:integer; max:integer;
subList:TList;
value:pointer;

begin
result:=0;
sublist:=getRow(row);

if sublist=nil then exit;

max:=-1;
for col:=0 to sublist.Count-1 do
 begin
  value:=Items[row,col];
  if value<> nil then max:=col;
 end;
 result:=max+1;
end;

{******************************************************************************}
procedure TListArray.GetMaxDim(var MaxRow:integer;var MaxCol:integer);
var
row,nbcol:integer;
begin
MaxRow:=-1;
MaxCol:=0;

for row:=0 to ListRow.Count-1 do
  begin
   nbcol:=GetMaxFillColOfRow(row);
   if MaxCol<nbcol then MaxCol:=nbcol;
   if nbcol>0 then MaxRow:=row;
   end;
 MaxRow:=MaxRow+1;  
end;

//*****************************************************************************
function TListArray.GetColRow(ACol:integer; FromRow:integer; sublist:TList): boolean;
var
list :TList;
maxcol,maxrow,i:integer;
begin
 Result:=false;

 GetMaxDim(maxrow,maxcol);

 if (ACol+1>maxcol) or (sublist=nil) then Exit;
 if (FromRow+1>maxrow) or (FromRow<0) then Exit;

  for i:=FromRow to ListRow.Count-1 do
   begin
   list:=GetRow(i);
   if list<>nil then sublist.add(list.Items[ACol])
                else sublist.add(nil);
   end;
 Result:=true;

end;


{ Le contenu d'une liste 'NewCol' est copi dans le Tableau  la colonne 'ACol'
   partir de la ligne 'ARow'. On rcupre dans oldCol les anciens pointeurs
  pour pouvoir dtruire les objets points. Si on ne veut pas les dtruire,
   il suffit de passer OldCol='nil'. Si pas de problme la fonction retourne true
 }

function TListArray.SetColRow(ACol:integer; ARow:integer; NewCol,OldCol:TList): boolean;
var
i,j:integer;
list:TList;
temp :pointer;

begin
 if (ACol<0) or (NewCol=nil) or (NewCol.count=0) then begin Result:=false; Exit; end;

 for i:=0 to NewCol.Count-1 do
    begin
   list:=GetRow(ARow);

   if list=nil then
    begin list:=TList.Create;
           ListRow.Items[ARow]:=list;
    end;

   if ACol>=list.Count then for j:=list.Count to ACol do list.Add(NIL);

   temp:=list.Items[ACol];
   if OldCol<>nil then OldCol.add(temp);
   list.Items[ACol]:=NewCol.Items[i];
   ARow:=ARow+1;
   end;

 Result:=true;
end;

//*******************************************************************************
function TListArray.SetCol(ACol:integer; NewCol,OldCol:TList): boolean;
begin
 result:=SetColRow(ACol,0,NewCol,OldCol);
end;

//*******************************************************************************
procedure  TListArray.ExchangeCol(ACol1,ACol2:integer);
var
  i:integer;
  sublist:TList;
begin
  for i:=ListRow.Count-1 downto 0 do begin
    sublist:=TList(ListRow.Items[i]);
    if sublist=NIL then begin sublist:=TList.Create; ListRow.Items[i]:=sublist; end;
    ExchangePointer(ACol1,ACol2,sublist);
    end;
  end;

procedure TStrListArray.SetString (ARow:integer; ACol:integer; const AString:string);
var
 p:PStrItem;
 obj:TObject;
begin
 p:=PstrItem(Items[Arow,Acol]);
 if p=nil then obj:=nil else obj:=p^.FObject;

 p:=NewStrItem(Astring,obj);
 p:=SetItem(ARow,ACol,p);

 if (p<>nil) and (IsDelete=todelete) then DisposeStrItem(p);
end;


function TStrListArray.GetString (ARow:integer; ACol:integer):string;
var
 p:PStrItem;
begin
 p:=PstrItem(Items[Arow,Acol]);
 if p=nil then result:='' else result:=p^.FString;
end;




function TStrListArray.GetObject (ARow:integer; ACol:integer):TObject ;
 var
 p:PStrItem;
begin
 p:=PstrItem(Items[Arow,Acol]);
 if p=nil then result:=nil else result:=p^.FObject;
end;

procedure TStrListArray.SetObject (ARow:integer; ACol:integer; AObject:TObject);
var
 p:PStrItem;
 obj:TObject;
begin
 p:=PstrItem(Items[Arow,Acol]);
 if p<>nil then p^.FObject:=AObject
 else if AObject<>nil then
    SetItem(ARow,ACol,NewStrItem('',AObject));
end;

constructor TStrListArray.create;
begin
 inherited create;
 IsDelete:=toDelete;
 end;

constructor TStrListArray.Copycreate(AStrListArray:TStrListArray) ;
var
col,row :integer;
str :string;
begin
 inherited create;
 IsDelete:=toDelete;
  for row:=0 to AStrListArray.RowCount-1 do
   begin
     for col:=0 to AStrListArray.ColCount[row]-1 do
       begin
        str:=AStrListArray.StrItems[row,col];
        if str<>'' then strItems[row,col]:=str;
        end;
   end;
end;

end.
