unit MyNewGrid;
interface
// le 12 /10 /98 : ListSelectRow et ListSelectCol ont t remplacs par FList...
// le 12 /10 /98 : Deux nouvelles proprits ont t crees : ListSelectRow et ListSelectCol
// le 22/10 creation de procedure CopyToAListArray(AListArray :TStrListArray);
// le 22/10 modification de CreateTabcod et supression de FTabcod
// Dl 9/11/99 modif TMolGrid.Aligner : chargement direct de clustalw.exe
//            s'il est ds le rpertoire courant (prog)
// Dl 30/04/00 modif gestion des exceptions dans TTabGrid.SaveToFile
//             Il faudra peut-tre modifier les autres procdures de sauvegarde
//             de la mme manire

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids,strbox,ListArray2,typedef,phylmain,donnees,StdCtrls;

type

  TypeNuc=set of Char;

  TMyCustomGrid = class(TStringGrid)
  private

  FAlignValue:TMyAlign;

  FRowSelect:boolean; // Flag indiquant que les lignes peuvent tre slectionnes
  FColSelect:boolean; // Flag indiquant que les colonnes peuvent tre slectionnes

  FOneRowSelect : boolean;
  FOneColSelect :boolean;

  FColInvalidate :boolean;
  FRowInvalidate :boolean;

  FRowSelectAll:boolean;
  FColSelectAll:boolean;

  FColorSelect:TColor;
  FListArray :TStrListArray;
  
  FCompare:TCompare;
  FActiveEdit:boolean;

  FOnMouseDown: TMouseEvent;

  FListSelectRow :TStrings;
  FListSelectCol :TStrings;
  // nouveau le 31/03/99

  FColorText :TColor;
  
  function IsSelectRow(row :longint):boolean;
  function IsSelectCol(col :longint):boolean;

  function IsInvalidateCol(col :longint):boolean;
  function IsInvalidateRow(row :longint):boolean;



  procedure SetInvalidateRow(row:longint; Invalide:boolean);
  procedure SetInvalidateCol(col:longint; Invalide:boolean);

  

  procedure FillCell(Color:TColor ; Rect :TRect);
  procedure RoundCell(ColorL:TColor;ColorR:TColor;Rect:TRect);

  protected  {*** protected***}

  function GetMaxFillRow : integer;
  function GetMaxFillColOfRow(row:integer):integer;
  function GetMaxFillCol :integer;

  function TextWidth(ACol,ARow:integer): integer;virtual;

  procedure DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);virtual;
  

  procedure SelfMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  procedure SetActiveEdit(active :boolean);

  procedure Click;override;

  public  {****public****}

  constructor Create(AOwner:TComponent);override;
  destructor Destroy; override;

  function  NbSelectRow: integer;
  procedure SelectAllRow(select:boolean);
  procedure SelectAllCol(select:boolean);
   procedure SetSelectRow(row:longint; select:boolean);
  procedure SetSelectCol(col:longint; select:boolean);
  function IndexOfRow(NameOfRow :string):integer;
  procedure MyInvalidateCell(ACol, ARow: Longint); // dans l'urgence
  procedure AdjustColWidths;
  procedure AdjustColWidth(ACol:integer);

  function Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream;
  procedure CSV2Contents(data:TStream; csv:char; range:TGridRect);
  procedure Contents2CSVClipboard(csv:char; range:TGridRect);
  procedure ClipboardCSV2Contents(csv:char; range:TGridRect);

  procedure CopyToClipboard;
  procedure CopyFromClipboard;
  procedure CopyListSelectCol(AListSelectCol :TStrings);

  procedure CopyToListArray;
  procedure CopyToAListArray(left :integer; top :integer; AListArray :TStrListArray);
  procedure CopyFromListArray(left :integer;top :integer);
  procedure CopyFromAListArray(left :integer;top :integer; AListArray :TStrListArray);

  property MaxFillRow : integer read GetMaxFillRow;
  property MaxFillCol :integer read GetMaxFillCol;
  property MaxFillColOfRow[index:longint]:integer read GetMaxFillColOfRow;

  property SelectCol[index:longint]:boolean read IsSelectCol write SetSelectCol;
  property SelectRow[index:longint]:boolean read IsSelectRow write SetSelectRow;

  property InvalidateCol[index:longint]:boolean read IsInvalidateCol write SetInvalidateCol;
  property InvalidateRow[index:longint]:boolean read IsInvalidateRow write SetInvalidateRow;

  property AllColSelect : boolean read FColSelectAll  write SelectAllCol;
  property AllRowSelect : boolean read FRowSelectAll write SelectAllRow;
  property ListArray :TStrListArray read FListArray write FListArray;

  property ListSelectRow :TStrings read FListselectRow;
  property ListSelectCol :TStrings read FListselectCol;

  procedure SaveToFile(const filename:string);virtual; abstract;
  procedure LoadFromFile(const filename:string);virtual ;abstract;

  function CanDeSelectRow(lim:integer) : boolean;

  published

  property _AlignValue:TMyALign read FAlignValue write FAlignValue;
 
  property _RowSelect :boolean read FRowSelect write FRowselect;
  property _ColSelect :boolean read FColSelect write FColSelect;

  property _OneRowSelect :boolean read FOneRowSelect write FOneRowSelect;
  property _OneColSelect :boolean read FOneColSelect write FOneColselect;

  property _RowInvalidate :boolean read FRowInvalidate write FRowInvalidate;
  property _ColInvalidate :boolean read FColInvalidate write FColInvalidate;

  property _ColorSelect : TColor read FColorSelect write FColorSelect;
  property _ActiveEdit :boolean read FActiveEdit write SetActiveEdit;
  property _Compare :TCompare read FCompare write FCompare ;
  property _ColorText :Tcolor read FColorText write FColorText;

  property OnMouseDown: TMouseEvent read FOnMouseDown write FOnMouseDown;

  end;

{******************************************************************************}
 TTabGrid = class(TMyCustomGrid)
  private

  FTextVertical:boolean;
  FMultiline :boolean;

  protected

  function TextHeight(ACol,ARow:integer): integer;
  function TextWidth(ACol,ARow:integer): integer;override;

  procedure AdjustRowHeights;
  procedure AdjustRowHeight(Arow :integer);

  procedure DrawCellTextVertical(ACol,ARow:longint; ARect :TRect);
  procedure DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState); override;
  procedure Paint; override;

   public

  FFileName :string;  // modifi le 03/06/99
  constructor Create(AOwner:TComponent);override;

  procedure CreateTabCod(ATabCod : TstrListArray);
  procedure SaveToFile(const filename:string);override;
  procedure LoadFromFile(const filename:string);override;

  published
  property _Multiline :boolean read FMultiline write FMultiline;
  property _TextVertical :boolean read FTextVertical write FTextVertical;
  end;

 {******************************************************************************}
 {******************************************************************************}

 TMolGrid = class(TMyCustomGrid)
  private
  { A rajouter }

  FTypeMol :TTypeMolecule;
  FTypeSetMol:TTypeSetMolecule;

  // jfr modifie le 10/04/00  procedure est devenue function
  function LoadAlnMol(filename :string; TabMol:TStrings) :boolean ;
  function LoadPirMol(filename :string; AListArray:TstrListArray):TTypeMolecule;

  protected

  procedure DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState); override;
  procedure Paint; override;

  procedure LoadFromFileALN(const filename:string);
  procedure LoadFromFilePIR(const filename:string);
  procedure LoadFromFileBAS(const filename:string);

  procedure DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);override;
  procedure DrawCellTextbis(ACol, ARow: Longint; ARect: TRect; Option :longint);
  procedure SaveToAln(lines :TStringList);

  public

  constructor Create(AOwner:TComponent);override;

  //procedure SaveToFile(const filename:string); override;
  procedure LoadFromFile(const filename:string);override;
  procedure SaveToFilePIR(filename:string);
  procedure SaveToFileALN(filename:string);
  procedure LoadFromFiles(files :TStrings);

  function GetTypeMol(chaine :String):TTypeMolecule;

  procedure MyAligner(auto:boolean);
  procedure MyAlignerOld(auto:boolean);       //jfr modifie le 08/07/02 pour dll clustal

  property TypeMol :TTypeMolecule read FTypeMol write FTypeMol;
  property TypeSetMol:TTypeSetMolecule read FTypeSetMol write FTypeSetMol;

  published
  end;

{******************************************************************************}
procedure Stream2Clipboard(stream:TStream; format:integer);
procedure Clipboard2Stream(stream:TStream; format:integer);

procedure Register;

implementation
uses code,phylMol;

var
colorrectbis:TColor;

procedure InitAlign( pathtemp :Pchar; P_nombre:integer ;P_dna:integer;P_quick:integer);stdcall; external 'anagen32.dll';
Function Aligner(WinHandle :HWND ):integer;stdcall; external'anagen32.dll';
procedure DonneeAlign(no_seq :integer;   sequ:PChar);stdcall; external'anagen32.dll';
procedure ResultAlign( len :integer; no_seq :integer;  seq1:Pchar);stdcall; external'anagen32.dll';

//**********function GetPointer(index: integer; memblock: THandle):pointer;
function GetPointer(index: integer; memblock: THandle):pointer;
begin
  result:=pointer(longint(GlobalLock(memblock))+index);
  end;

(*@/// function min(x,y: longint):longint; *)
function min(x,y: longint):longint;
begin
  if x<y then result:=x
         else result:=y;
  end;
(*@\\\*)
(*@/// function max(x,y: longint):longint; *)
function max(x,y: longint):longint;
begin
  if x>y then result:=x
         else result:=y;
  end;
(*@\\\*)

{ Write a string into a stream }
(*@/// procedure String2Stream(stream:TMemorystream; const s:string); *)
procedure String2Stream(stream:TMemorystream; const s:string);
begin
  stream.write(s[1],length(s));
  end;
  (*@/// procedure Stream2Clipboard(stream:TStream; format:integer); *)

procedure Stream2Clipboard(stream:TStream; format:integer);
const
  max_write = $8000;    (* must obey ($10000 mod max_write = 0) for Delphi 1 *)
var
  size: longint;
  s: word;
  curpos: longint;
  Memblock: THandle;
  FClipboardWindow: THandle;
begin
  FClipboardWindow := Application.Handle;
  if FClipboardWindow = 0 then
    FClipboardWindow := AllocateHWnd(NIL);
  OpenClipboard(FClipboardWindow);

  stream.seek(0,0);
  size:=stream.size;
  stream.seek(0,0);
  MemBlock:=GlobalAlloc(gmem_moveable or gmem_zeroinit,size+1);
  curpos:=0;
  while curpos+1<size do begin
    s:=stream.read(getPointer(curpos,MemBlock)^,min(max_write,size-curpos));
    inc(curpos,s);
    GlobalUnLock(MemBlock);
    if s=0 then BREAK;
    end;
  char(getPointer(curpos,memblock)^):=#0;
  GlobalUnLock(MemBlock);
  EmptyClipBoard;
  SetClipBoardData(format,memblock);

  CloseClipboard;
  if FClipboardWindow<>Application.Handle then
    DeallocateHWnd(FClipboardWindow);
  end;
(*@\\\*)
(*@/// procedure Clipboard2Stream(stream:TStream; format:integer); *)
procedure Clipboard2Stream(stream:TStream; format:integer);
const
  max_read = $8000;   (* must obey ($10000 mod max_read = 0) for Delphi 1 *)
var
  size: longint;
  curpos: longint;
  Memblock: THandle;
  FClipboardWindow: THandle;
begin
  FClipboardWindow := Application.Handle;
  if FClipboardWindow = 0 then
    FClipboardWindow := AllocateHWnd(NIL);
  OpenClipboard(FClipboardWindow);

  stream.seek(0,0);
  MemBlock:=GetClipboardData(format);
  size:=GlobalSize(Memblock);
  curpos:=0;
  while curpos+1<size do begin
    stream.write(getPointer(curpos,MemBlock)^,min(max_read,size-curpos-1));
    inc(curpos,min(max_read,size-curpos-1));
    GlobalUnLock(MemBlock);
    end;

  CloseClipboard;
  if FClipboardWindow<>Application.Handle then
    DeallocateHWnd(FClipboardWindow);
  end;
(*@\\\0000001024*)
(*@\\\0000000F01*)

(*@\\\*)


//*****************************************************************************/
procedure TMyCustomGrid.Click;
begin
  if ((FCompare<>NoCompare) and FActiveEdit) then invalidate;
  inherited Click;
end;

{******************************************************************************
                         Constructeur
 ******************************************************************************}
constructor TMyCustomGrid.Create(AOwner:TComponent);
var
index:integer;
begin
inherited Create(AOwner);
colorrectbis:=clblue;
options:=[goFixedVertLine,goFixedHorzLine,
          goVertLine,goHorzLine,goRangeSelect];

FListSelectRow:=TStringList.create;
FListSelectCol:=TStringList.Create;

FListArray:=nil;
FRowSelect:=true;
FColSelect:=true;

FColInvalidate:=false;
FRowInvalidate:=false;

FOneRowSelect:=false;
FOneColSelect:=true;

FColorSelect:=clLtGray;
FAlignValue:=alLeft;
FActiveEdit:=false;
DefaultDrawing:=true;

FRowSelectAll:=false;
FColSelectAll:=false;
FColorText:=clRed;

Inherited OnMouseDown:=SelfMouseDown;

FOnMouseDown:=nil;
FCompare:=NoCompare;

FColSelectAll:=false;
FRowSelectAll:=true;

EditorMode:=false;

for index:=0 to RowCount-1 do FListSelectRow.Add('N');
for index:=0 to ColCount-1 do FListSelectCol.Add('N');

end;
{******************************************************************************
                         Destructeur
 ******************************************************************************}
destructor TMyCustomGrid.Destroy;
begin
FListSelectRow.Free;
FListSelectCol.Free;

inherited Destroy;
end;
{******************************************************************************
                         Destructeur
 ******************************************************************************}
procedure TMyCustomGrid.CopyToAListArray(left :integer;top :integer;AListArray :TStrListArray);
var
col,row,nocol,norow:integer;
begin

nocol:=0; 
if AListArray=nil then exit;
if AlistArray.RowCount>0
    then AListArray.ClearListArray(toDelete); // rajout le 12/12/98

for col:=left to ColCount-1 do
 begin
  norow:=0;
  for row:=top to RowCount-1 do
   begin
     AListArray.StrItems[norow,nocol]:=Cells[col,row];
     norow:=norow+1;
   end;
   nocol:=nocol+1;
 end;
end;

procedure TMyCustomGrid.MyInvalidateCell(ACol, ARow: Longint);
begin
  InvalidateCell(ACol, ARow);
end;

function TMyCustomGrid.IndexOfRow(NameOfRow :string):integer;
var
row:integer;
 begin
  result:=-1;
  for row:=0 to RowCount-1 do
    if Cells[0,row]=NameOfRow then begin result:=row ; break;end;
 end;

procedure TMyCustomGrid.CopyToListArray;
var
col,row:integer;
begin
if FListArray=nil then FListArray:=TStrListArray.CreateListArray;
 for col:=0 to ColCount-1 do
 begin
  for row:=0 to RowCount-1 do
     ListArray.StrItems[row,col]:=Cells[col,row];
 end;
end;
{******************************************************************************
 ******************************************************************************}
procedure TMyCustomGrid.CopyFromAListArray(left :integer;top :integer; AListArray :TStrListArray);
 var
AString :string;
col,row:integer;
MaxCol,MaxRow:integer;

begin
if AListArray=nil then Exit;
AListArray.GetMaxDim(MaxRow,MaxCol);

// rajout le 12/12/98 : avant : ColCount:=MaxCol+left; sans condition ; idem pour rowcount
// ncessit par le chargement des molcules une par une a  partir d'un listarray

if ColCount<MaxCol+left+1 then ColCount:=MaxCol+left;  // +1 car left reprsente un indice et non une quantit
if RowCount<MaxRow+top+1 then RowCount:=MaxRow+top;   // idem

if ColCount>MaxCol+left  then ColCount:=MaxCol+left;  // +1 car left reprsente un indice et non une quantit
if RowCount>MaxRow+top  then RowCount:=MaxRow+top;   // idem

for col:=0 to Maxcol-1 do
 begin
  for row:=0 to MaxRow-1 do
  begin
       Astring:=AListArray.StrItems[row ,col ];
       if AString<>'' then Cells[col+left,row+top]:=AString
                      else Cells[col+left,row+top]:='';
  end;
 end;
 AdjustColWidths;
end;

{******************************************************************************
 ******************************************************************************}
procedure TMyCustomGrid.CopyFromListArray(left :integer;top :integer);
var
AString :string;
col,row:integer;
MaxCol,MaxRow:integer;

begin
if FListArray=nil then Exit;
ListArray.GetMaxDim(MaxRow,MaxCol);

ColCount:=MaxCol+left+1;  // +1 car left reprsente un indice et non une quantit
RowCount:=MaxRow+top+1;   // idem

for col:=0 to ColCount-1 do
 begin
  for row:=0 to RowCount-1 do
  begin
   if (col<left) or (row<top) then Cells[col,row]:=''
   else begin
       Astring:=ListArray.StrItems[row-top,col-left];
       if AString<>'' then Cells[col,row]:=AString
                      else Cells[col,row]:='';
        end;
  end;
 end;
end;




{******************************************************************************
                         MouseDown
 ******************************************************************************}
{procedure TMyCustomGrid.SelfMouseDown(Sender:TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
row,col,i:longint;
begin
 MouseToCell(X,Y,col,row);
 // La slection d'une cellule n'est possible que si elle n'est pas redimensionnable
 // ou dplaable
 if ((FGridState<>gsRowsizing) and (FGridState<>gsColSizing)
 and (FGridState<>gsRowmoving)and (FGridState<>GsColMoving))then
  begin
  // Le clic a lieu dans une entte de ligne dans une colonne fixe
  if(FixedCols>0) and (row<>0) and (col<FixedCols) then
   begin
   if (FRowInvalidate)  then    // mode validation/invalidation
    begin
      // avant d'tre invalide une cellule va tre dselectionne
      if IsSelectrow(row)then SetSelectrow(col,false);
      if IsInvalidaterow(row) then SetInvalidaterow(row,false)
      else SetInvalidaterow(row,true);
      InvalidateCell(col,row);
   end
  else
  if (FRowSelect) then        // mode slection/dselection
   begin
     if FOneRowSelect then   // Une seule slection permise  la fois
      begin
       for i:=0 to FListSelectRow.count-1 do
        begin
        if IsSelectRow(i) then
        begin
         SetSelectRow(i,false);
         InvalidateCell(col,i);end;
        end;
      SetSelectRow(row,true);
      end else
     if IsSelectRow(row) then SetSelectRow(row,false) else SetSelectRow(row,true);
     InvalidateCell(col,row);
   end;
  end ;
 //  le clic a lieu dans une ligne fixe (la premire par exemple) et
 // dans une entte de colonne
 if (FixedRows>0) and (col<>0) and (row<FixedRows)then
  begin
 if (button=mbRight)  then
   begin
     if FColInvalidate=true then
     begin
      for i:=0 to FListSelectCol.count-1 do
        begin
         if (IsInvalidateCol(i))and (i<>col) then
          begin
           SetInvalidateCol(i,false);
           InvalidateCell(i,row);
           end;
         end;
      // une cellule ne peut etre invalide que si elle est selectionne
      if IsSelectCol(col)then
        begin
          if IsInvalidateCol(col)
           then SetInvalidateCol(col,false)
           else SetInvalidateCol(col,true);
          InvalidateCell(col,row);
        end;
       end;
   end
 else if (FColSelect) then
   begin
     // Une seule slection possible : si une autre cellule est slectionne son
     // tat est invers.
     if FOneColSelect then
      begin
       for i:=0 to FListSelectCol.count-1 do
        begin
        if (IsSelectCol(i))and (i<>col) then
         begin
          SetSelectCol(i,false);
          InvalidateCell(i,row);
          end;
        end;
     //  le clic sur une cellule dj slectionne inverse alors son tat
      if IsSelectCol(col)then SetSelectcol(col,false)else SetSelectcol(col,true);
     end else
     begin
     // On recherche l'existence de cellules invalides
      // que l'on valide mais qu'on laisse slectionnes
       for i:=0 to FListSelectCol.count-1 do
        begin
        if (IsInvalidateCol(i))and (i<>col) then
         begin
          SetInvalidateCol(i,false);
          InvalidateCell(i,row);
          end;
        end;
       if IsSelectCol(col) then SetSelectCol(col,false) else SetSelectCol(col,true);
       InvalidateCell(col,row);
     end;  
   end;
 end;
 end;
 if( Assigned(FOnMouseDown)) then FOnMouseDown(self,Button, Shift, X, Y);

end; }

procedure TMyCustomGrid.SelfMouseDown(Sender:TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
row,col,i:longint;
begin
 MouseToCell(X,Y,col,row);
 // La slection d'une cellule n'est possible que si elle n'est pas redimensionnable
 // ou dplaable
 if ((FGridState<>gsRowsizing) and (FGridState<>gsColSizing)
 and (FGridState<>gsRowmoving)and (FGridState<>GsColMoving))then
  begin
  // Le clic a lieu dans une entte de ligne dans une colonne fixe
  if(FixedCols>0) and (row<>0) and (col<FixedCols) then
   begin
   If (EnleverTaxon = 'non') then exit;
   if (FRowInvalidate)  then    // mode validation/invalidation
    begin
      // avant d'tre invalide une cellule va tre dselectionne
      if IsSelectrow(row)then SetSelectrow(col,false);
      if IsInvalidaterow(row) then SetInvalidaterow(row,false)
      else SetInvalidaterow(row,true);
      InvalidateCell(col,row);
   end
  else
  if (FRowSelect) then        // mode slection/dselection
   begin
     if FOneRowSelect then   // Une seule slection permise  la fois
      begin
       for i:=0 to FListSelectRow.count-1 do
        begin
        if IsSelectRow(i) then
        begin
         SetSelectRow(i,false);
         InvalidateCell(col,i);end;
        end;
      SetSelectRow(row,true);
      end else
      if IsSelectRow(row) then
         begin
          //if NbSelectRow>2 then     // jfr modifie le 28 septembre 2001 . Le problme est trait par
           SetSelectRow(row,false);   // la fonction TreeClGR.mousedown
         end
      else SetSelectRow(row,true);
     InvalidateCell(col,row);
   end;
  end ;
 //  le clic a lieu dans une ligne fixe (la premire par exemple) et
 // dans une entte de colonne
 if (FixedRows>0) and (col<>0) and (row<FixedRows)then
  begin

 // JFR modifie le 07/07/00 pour changer l'effet du bouton gauche et du bouton droit
 // Cette modification doit tre combine avec celle de TreeCLGR ligne 114
 if (button=mbleft)  then
   begin
     if FColInvalidate=true then
     begin
      for i:=0 to FListSelectCol.count-1 do
        begin
         if (IsInvalidateCol(i))and (i<>col) then
          begin
           SetInvalidateCol(i,false);
           InvalidateCell(i,row);
           end;
         end;
      // une cellule ne peut etre invalide que si elle est selectionne
      if IsSelectCol(col)then
        begin
          if IsInvalidateCol(col)
           then SetInvalidateCol(col,false)
           else SetInvalidateCol(col,true);
          InvalidateCell(col,row);
        end;
       end;
   end
 else if (FColSelect) then        // clic bouton gauche
   begin
     // Une seule slection possible : si une autre cellule est slectionne son
     // tat est invers.
     if FOneColSelect then
      begin
       for i:=0 to FListSelectCol.count-1 do
        begin
        if (IsSelectCol(i))and (i<>col) then
         begin
          SetSelectCol(i,false);
          InvalidateCell(i,row);
          end;
        end;
     //  le clic sur une cellule dj slectionne inverse alors son tat
      if IsSelectCol(col)then SetSelectcol(col,false)else SetSelectcol(col,true);
     end else
     begin
     // On recherche l'existence de cellules invalides
      // que l'on valide mais qu'on laisse slectionnes
       for i:=0 to FListSelectCol.count-1 do
        begin
        if (IsInvalidateCol(i))and (i<>col) then
         begin
          SetInvalidateCol(i,false);
          InvalidateCell(i,row);
          end;
        end;
       if IsSelectCol(col) then SetSelectCol(col,false) else SetSelectCol(col,true);
       InvalidateCell(col,row);
     end;
   end;
 end;
 end;
 if( Assigned(FOnMouseDown)) then FOnMouseDown(self,Button, Shift, X, Y);

end;

{******************************************************************************
                         FillCell
 ******************************************************************************}
procedure TMyCustomGrid.FillCell(color :TColor ; Rect :TRect);
var
 OldPstyle: TPenStyle;
 OldBstyle :TBrushStyle;
 OldPenColor :TColor;
 OldBrushColor :TColor;

begin
 with canvas do begin

    OldPstyle:=Pen.Style;
    OldBstyle:=Brush.style;
    OldPenColor:=Pen.color;
    OldBrushColor:=Brush.color;

    Pen.Style:=psclear;
    Brush.Style:=bssolid;

    brush.color:=Color;
    Rectangle(Rect.Left,Rect.top,Rect.Right+1,Rect.Bottom+1);

    Pen.Style:=OldPstyle;
    Brush.style:=OldBstyle;
    Pen.color:=OldPenColor;
    Brush.color:=OldBrushColor;
  end;
end;

//******************************************************************************/
function TMyCustomGrid.TextWidth(ACol,ARow:integer): integer;
const
  min_width = 4;
 var
  width: integer;
  str: string;                          
begin
  str:=Cells[ACol, ARow];
  width:=0;
  if (trim(str)<>'') then
  begin
   width:=Canvas.TextWidth(str)+(2*min_width);
   if width<=min_width then width:=0;
  end;
 Result:= width;
end;

//******************************************************************************/
procedure TMyCustomGrid.AdjustColWidths;
var
ACol:integer;
begin
  for ACol:=0 to ColCount-1 do AdjustColWidth(ACol);
end;

//******************************************************************************/
procedure TMyCustomGrid.AdjustColWidth(ACol:integer);
var
  max: longint;
  width: longint;
  ARow: longint;
begin
  max:=0;
  if ACol>=ColCount then EXIT;
  if Cols[ACol].count>0 then begin  // Si la colonne est vide c'est inutile de calculer
   for ARow:=0 to RowCount-1 do
    begin
     width:=textwidth(ACol,ARow);
     if max<width then max:=width;
    end;
   if max=0 then max:=ColWidths[ACol];
   ColWidths[ACol]:=max;
   end;
  end;

//******************************************************************************/
procedure TMyCustomGrid.RoundCell(colorL :TColor ;colorR :TColor; Rect :TRect);
 var
 OldPstyle: TPenStyle;
 OldPenColor :TColor;

 begin

 with canvas do begin
 OldPstyle:=Pen.Style;
 OldPenColor:=Pen.color;

 Pen.Style:=psSolid;
 Pen.Color:=ColorL;

  MoveTo(Rect.Left,Rect.Bottom);
  LineTo(Rect.Left,Rect.Top+2);
  LineTo(Rect.Right,Rect.Top+2);

  MoveTo(Rect.Left+1,Rect.Bottom);
  LineTo(Rect.Left+1,Rect.Top+1);
  LineTo(Rect.Right-1,Rect.Top+1);

  Pen.Color:=ColorR;

    MoveTo(Rect.Right-1,Rect.top+1);
    LineTo(Rect.Right-1,Rect.bottom-1);
    LineTo(Rect.left,Rect.bottom-1);

    MoveTo(Rect.Right-2,Rect.top+1);
    LineTo(Rect.Right-2,Rect.bottom-2);
    LineTo(Rect.left,Rect.bottom-2);
  
   Pen.Style:=OldPstyle;
   Pen.color:=OldPenColor;
   end;
end;

{ ****************************************************************************}

function TMyCustomGrid.GetMaxFillRow : integer;
var
row, max ,nbcol:integer;
begin
max:=-1;
for row:=0 to rowcount-1 do
  begin
  nbcol:=GetMaxFillColOfRow(row);
  if (nbcol>0) then max:=row;
  end;
result:=max+1;
end;

{****************************************************************************}
function TMyCustomGrid.GetMaxFillColOfRow(row:integer):integer;
var
col:integer;
max:integer;
str:string;

begin
max:=-1;
for col:=0 to ColCount-1 do
 begin
  str:=cells[col,row];
  if ((str<>'') and (Trim(str)<>''))then max:=col;
 end;
 result:=max+1;
end;
{******************************************************************************}

function TMyCustomGrid.GetMaxFillCol :integer;
var
row,col,maxrow,max:integer;
str:string;
begin

maxrow:=GetMaxFillRow;
max:=-1;

for row:=0 to maxrow-1 do
  begin
   for col:=0 to ColCount-1 do
    begin
     str:=cells[col,row];
     if ((str<>'') and (Trim(str)<>''))then
      begin
       if max<col then max:=col;
      end;
    end;
  end;
result:=max+1;
end;

{*******************************************************************************}

procedure TMyCustomGrid.SetActiveEdit(active :boolean);
begin
if not active then
 begin
  Options:=Options-[goEditing];
  Options:=Options-[goAlwaysShowEditor];
  FActiveEdit:=false;
 end
else begin

  Options:=Options+[goEditing];
  FActiveEdit:=true;
 end;
end;
//******************************************************************************/
function TMyCustomGrid.IsInvalidateRow(row :longint):boolean;
begin
Result:=false;
if row>=FListSelectRow.Count then exit;
if FListSelectRow[row]='I' then Result:=true;
end;
//******************************************************************************/
function TMyCustomGrid.IsInvalidateCol(col :longint):boolean;
begin
Result:=false;
if col>=FListSelectCol.Count then exit;
if FListSelectCol[col]='I' then Result:=true;
end;
//******************************************************************************/
procedure TMyCustomGrid.SetInvalidateRow(row:longint; invalide:boolean);
var
index:integer;
begin
if (row>=FListSelectRow.Count) then
 begin
  for index:=FListSelectRow.Count-1 to row do FListSelectRow.add('N');
 end;
if invalide then FListSelectRow[row]:='I' else FListSelectRow[row]:='N';
end;
//******************************************************************************/
procedure TMyCustomGrid.SetInvalidateCol(col:integer;invalide:boolean);
var
index:integer;
begin
if (col>=FListSelectCol.Count) then
 begin
  for index:=FListSelectCol.Count-1 to col do FListSelectCol.add('N');
 end;
if invalide then FListSelectCol[col]:='I' else FListSelectCol[col]:='Y';
end;

//*******************************************************************************/
function TMyCustomGrid.NbSelectRow: integer;
 var
 index,tot:integer;
 begin
 tot:=0;
 for index:=0 to FListSelectRow.Count-1 do
  if FListSelectRow[index]='Y' then inc(tot);
 result:=tot;
 end;
//******************************************************************************/
function TMyCustomGrid.IsSelectRow(row :longint):boolean;
begin
Result:=false;
if (row>=FListSelectRow.Count) or (row<0) then exit;
if FListSelectRow[row]='Y' then Result:=true;
end;
//******************************************************************************/
function TMyCustomGrid.IsSelectCol(col :longint):boolean;
begin
Result:=false;
if (col>=FListSelectCol.Count) or (col<0) then exit;
if (FListSelectCol[col]='Y') or (FListSelectCol[col]='I') then Result:=true;
end;
//******************************************************************************/
procedure TMyCustomGrid.SetSelectRow(row:longint; select:boolean);
var
index:integer;
begin
if (row<0) then exit;    // jfr modifie le 10/04/00    : ligne rajoute
if (row>=FListSelectRow.Count) then
 begin
  for index:=FListSelectRow.Count-1 to row do FListSelectRow.add('N');
 end;
if select then FListSelectRow[row]:='Y' else FListSelectRow[row]:='N';
end;

//******************************************************************************/
procedure TMyCustomGrid.CopyListSelectCol(AListSelectCol :TStrings);
var
index :integer;
 begin
  AListSelectCol.Clear;
  for index:=0 to FListSelectCol.count-1 do
    AListSelectCol.add(FListSelectCol[index]);
 end;
//******************************************************************************/
procedure TMyCustomGrid.SetSelectCol(col:integer;select:boolean);
var
index:integer;
begin
if (col<0) then exit;  // jfr modifie le 10/04/00    : ligne rajoute
if (col>=FListSelectCol.Count) then
 begin
  for index:=FListSelectCol.Count-1 to col do FListSelectCol.add('N');
 end;
if select then FListSelectCol[col]:='Y' else FListSelectCol[col]:='N';
end;

//******************************************************************************/
function TMyCustomGrid.CanDeSelectRow(lim:integer) : boolean;
 var
 tot,index:integer;
 begin
 tot:=0;
 for index:=0 to FListSelectRow.Count-1 do
  begin
    if IsSelectRow(index) then tot:=tot+1;
  end;
 if tot>lim then result:=true else result:=false;
 end;

 //******************************************************************************/
procedure TMyCustomGrid.SelectAllRow(select:boolean);
var
row:integer;
begin
 FListSelectRow.clear;
 FListSelectRow.add('N');
 for row:=1 to MaxFillRow-1 do
 begin
   if select=true then FListSelectRow.add('Y')
   else FListSelectRow.add('N');
 end;
end;
//******************************************************************************/
procedure TMyCustomGrid.SelectAllCol(select:boolean);  // modifi le 11/01/99
var
col:integer;
begin
 FListSelectCol.clear;
 FListSelectCol.add('N');
 for col:=1 to MaxFillCol-1 do // jfr modifie le 07/07/00 MaxFillColofRow[0]
 begin                         // modifi le 16/02
 if select=true then FListSelectCol.add('Y')
 else FListSelectCol.add('N');
 end;
end;

//*****************************************************************************/
(*@\\\*)
(*@/// function TMyCustomGrid.Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream; *)
function TMyCustomGrid.Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream;
var
  ACol,ARow: integer;
  s: string;
begin
  if data<>NIL then
    result:=data
  else
    result:=TMemorystream.Create;
  if (range.right<range.left) or (range.right<0) then range.right:=self.colcount-1;
  if range.left<0 then range.left:=0;
  if (range.bottom<range.top) or (range.bottom<0) then range.bottom:=self.rowcount-1;
  if range.top<0 then range.top:=0;
  for ARow:=range.top to range.bottom do begin
    s:='';
    for ACol:=range.left to range.right do
      s:=s+cells[ACol,ARow]+csv;
    String2Stream(result,s+#13#10);
    end;
  end;
(*@\\\*)
(*@/// procedure TMyCustomGrid.CSV2Contents(data:TStream; csv:char; range:TGridRect); *)
procedure TMyCustomGrid.CSV2Contents(data:TStream; csv:char; range:TGridRect);
var
  h: TStringlist;
  i,ACol,ARow: integer;
  s: string;
begin
  if data=NIL then EXIT;
  if Range.Top<0 then Range.top:=0;
  if Range.left<0 then Range.left:=0;
  if Range.Bottom<range.top then range.bottom:=maxint;
  if Range.right<range.left then range.right:=maxint;
  h:=NIL;
  try
    h:=TStringlist.Create;
    data.seek(0,0);
    h.loadfromstream(data);
    ARow:=range.top;
    i:=0;
    while (i<h.count) and (ARow<=Range.bottom) do begin
      if ARow>=RowCount then RowCount:=RowCount+1;
      ACol:=range.left;
      s:=h.strings[i]+csv;
      while (ACol<=range.right) and (length(s)>1) and (s[1]<>#7) do begin   // (s[1]<>#7)
        if ACol>=ColCount then ColCount:=ColCount+1;    // jfr corrig corriger le 12/12/01
        cells[ACol,ARow]:=copy(s,1,pos(csv,s)-1);
        s:=copy(s,pos(csv,s)+1,length(s));
        inc(ACol);
        end;
      inc(ARow);
      inc(i);
      end;
  AdjustColWidths;
  finally
    h.free;
    end;
  end;

(*@/// procedure TMyCustomGrid.Contents2CSVClipboard(csv:char; range:TGridRect); *)
procedure TMyCustomGrid.Contents2CSVClipboard(csv:char; range:TGridRect);
var
  h: TMemorystream;
begin
  h:=NIL;
  try
    h:=TMemorystream.Create;
    Contents2CSV(h,csv,range);
    Stream2Clipboard(h,cf_text);
  finally
    h.free;
    end;
  end;
(*@\\\000000091F*)
(*@/// procedure TMyCustomGrid.ClipboardCSV2Contents(csv:char; range:TGridRect); *)
procedure TMyCustomGrid.ClipboardCSV2Contents(csv:char; range:TGridRect);
var
  h: TMemorystream;
begin
  h:=NIL;
  try
    h:=TMemorystream.Create;
    Clipboard2Stream(h,cf_text);
    CSV2Contents(h,csv,range);
  finally
    h.free;
    end;
  end;
(*@\\\000000081F*)

(*@/// procedure TMyCustomGrid.CopyToClipboard; *)
procedure TMyCustomGrid.CopyToClipboard;
var
  rect: TGridRect;
begin
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  Contents2CSVClipboard(#7,rect);
  end;
(*@\\\*)
(*@/// procedure TMyCustomGrid.CopyFromClipboard; *)
procedure TMyCustomGrid.CopyFromClipboard;
var
  rect: TGridRect;
begin
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  ClipboardCSV2Contents(#9,rect);
  end;
(*@\\\*)
{******************************************************************************
                        DrawCellText
 ******************************************************************************}
procedure TMyCustomGrid.DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);
var
  width,high: integer;
  Left,Top: integer;
  FirstMode:Integer;
  ident:boolean;
  AlignValue: TMyAlign;
  str,strfirst: string;

begin
  Top:=Arect.Top+2;

  ident:=false;
  Str:=Cells[Acol,Arow];

  { Si le Flag FCompare <> NoCompare le texte de la cellule est compar  celui
  de la cellule de la premire ligne  condition que la cellule n'appartienne
  pas  une ligne ou une colonne fixe }
 if (FColInvalidate ) and (ARow<FixedRows) and (IsInvalidateCol(ACol)=true)
 then Canvas.Font.Color:=clwhite;

 if (FRowInvalidate ) and (ACol<FixedCols) and (IsInvalidateRow(ARow)=true)
 then Canvas.Font.Color:=clwhite;

 if ( (FCompare<>NoCompare) and (ACol>=FixedCols)and(ARow>=FixedRows))then
  begin
    strfirst:=Cells[Acol,1];
    if ((trim(str)<>'')and (Str=strfirst)) then
     begin
      if FCompare=ColorText   then Canvas.Font.Color:=FColorText
                              else FillCell(FColorText,ARect);
      end
     else Canvas.Font.color:=clblack;
  end;

 FirstMode:=SetBkMode(Canvas.Handle,transparent);

  width:=Canvas.TextWidth(str);
  high:=Canvas.TextHeight(str);

  case FAlignValue of
   alLeft: Left:=ARect.Left+2;
   alCenter: begin width:=( (Arect.Right-ARect.Left)-width ) div 2;
                   Left:=ARect.Left+width;
             end;
   alRight: Left:=ARect.Right-width-2;
  end;

  ExtTextOut(Canvas.Handle, Left, Top,option,
      @ARect, PChar(Str), length(str), nil);

  Canvas.Font.color:=clblack;
 SetBkMode(Canvas.Handle,FirstMode);
end;

// jfr modifie le 30/04/02
procedure TMolGrid.DrawCellTextbis(ACol, ARow: Longint; ARect: TRect; Option :longint);
var
  width,high: integer;
  Left,Top: integer;
  FirstMode:Integer;
  ident:boolean;
  AlignValue: TMyAlign;
  str,strfirst: string;

begin
  Top:=Arect.Top+2;

  ident:=false;
  Str:=Cells[Acol,Arow];

  Canvas.Font.Color:=clblue;

 FirstMode:=SetBkMode(Canvas.Handle,transparent);

  width:=Canvas.TextWidth(str);
  high:=Canvas.TextHeight(str);

  case FAlignValue of
   alLeft: Left:=ARect.Left+2;
   alCenter: begin width:=( (Arect.Right-ARect.Left)-width ) div 2;
                   Left:=ARect.Left+width;
             end;
   alRight: Left:=ARect.Right-width-2;
  end;

  ExtTextOut(Canvas.Handle, Left, Top,option,
      @ARect, PChar(Str), length(str), nil);

  Canvas.Font.color:=clblack;
 SetBkMode(Canvas.Handle,FirstMode);
end;
//******************************************************************************/
//******************************************************************************/
                              {TabGrid}
//******************************************************************************/
//******************************************************************************/
constructor TTabGrid.Create(AOwner:TComponent);
begin
inherited Create(AOwner);

FTextVertical:=false;
FMultiline:=false;
end;

{******************************************************************************
                         DrawCell
 ******************************************************************************}
procedure TTabGrid.DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState);
  begin
     // Affichage des cellules appartenant  des lignes ou des colonnes Fixes
     if ((Acol<FixedCols) or (ARow<FixedRows)) then
     begin
      FillCell(clLtGray,ARect);
      if (((Acol<FixedCols)and (SelectRow[ARow]))
          or  ((ARow<FixedRows)and (SelectCol[ACol])))
         then RoundCell(clGray,clWhite,ARect)
         else RoundCell(clWhite,clGray,ARect);
       DrawCellText(Acol,Arow,ARect,ETO_CLIPPED);

       if (FTextVertical and (FixedRows=1) and (ARow<FixedRows)) then
       DrawCellTextVertical(Acol,Arow,ARect );
      end
    // Affichage des cellules normales
    else
     begin
       if not defaultDrawing then FillCell(clWhite,ARect);
       DrawCellText(ACol,ARow,ARect,ETO_CLIPPED);
     end;

    if Assigned(OnDrawCell) then OnDrawCell(Self, ACol, ARow, ARect, AState);
 end;


{******************************************************************************
                         Paint
 ******************************************************************************}
 procedure TTabGrid.Paint;
var
Rect:TRect;
select:boolean;
row,col:integer;

begin
inherited Paint;

if(FixedCols>0) then
begin
 for row:=0 to RowCount-1 do
  begin
   for col:=0 to FixedCols-1 do
    begin
     Rect:=CellRect(col,row);
     //Rect.bottom:=Rect.top+RowHeights[row];   // modifi le 6/02/98
     FillCell(clLtGray,Rect);
     if IsSelectRow(row) then RoundCell(clGray,clWhite,Rect)
                         else RoundCell(clWhite,clGray,Rect);
     DrawCellText(col,row,Rect,ETO_CLIPPED);
    end;
  end;
end;

if(FixedRows>0) then
begin
 for col:=0 to colCount-1 do
  begin
   for row:=0 to FixedRows-1 do
    begin
     Rect:=CellRect(col,row);
     if Rect.left<>Rect.right then       // modifi le 6/02/98
       Rect.Right:=Rect.Left+ColWidths[col];
     FillCell(clLtGray,Rect);
     if IsSelectCol(col) then RoundCell(clGray,clWhite,Rect)
                         else RoundCell(clWhite,clGray,Rect);
     if (Row=0) and (FTextVertical) then drawcellTextVertical(col,row,Rect)
     else
      DrawCellText(col,row,Rect,ETO_CLIPPED);
    end;
  end;
end;
end;


{*******************************************************************************}
procedure TTabGrid.SaveToFile(const filename:string);
var
  data: TMemoryStream;
  rect: TGridRect;
begin
  data:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    data:=Contents2CSV(data,#7,rect);
    data.savetofile(filename);
// modif DL 30/04/00
  except
    on EFCreateError do
       ShowMessage('Erreur  la cration du fichier'+#13#10+
                    '(Si le fichier existe dj,'+
                    ' il est peut-tre en "lecture seule")');
  else
       data.free;
  end;
end;
(*@\\\*)
//******************************************************************************/
(*@/// procedure TTabGrid.LoadFromFile(const filename:string); *)
procedure TTabGrid.LoadFromFile(const filename:string);
var
  data: TFileStream;
  rect: TGridRect;
begin
  data:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    data:=TFileStream.Create(filename,fmOpenRead);
    CSV2Contents(data,#7,rect);
  finally
    data.free;
    end;
  end;
(*@\\\*)

//******************************************************************************/
procedure TTabGrid.AdjustRowHeights;
var
ARow :integer;
begin
  for ARow:=0 to RowCount-1 do AdjustRowHeight(Arow);
end;
//******************************************************************************/
procedure TTabGrid.AdjustRowHeight(Arow :integer);
var
max,ACol,height :integer;

 begin
  max:=0;
  if ARow>=RowCount then EXIT;
  if Rows[ARow].count>0 then begin  // Si la ligne est vide c'est inutile de calculer
   for ACol:=0 to ColCount-1 do
    begin
     height:=textHeight(ACol,ARow);
     if max<height then max:=height;
    end;
   RowHeights[ARow]:=max;
   end;
  end;
//******************************************************************************/
function TTabGrid.TextWidth(ACol,ARow:integer): integer;
const
  min_width = 4;
 var
  width: integer;
  str: string;
begin
  str:=Cells[ACol, ARow];
  width:=0;
  if (trim(str)<>'') then
  begin
  if (FMultiLine and (GetNbWord(str,#32)>1))then
    width:=Canvas.TextWidth(GetLargestWord(str,#32))+(2*min_width)
  else 
    width:=Canvas.TextWidth(str)+(2*min_width);

  if width<=min_width then width:=0;
  end;
 Result:= width;
end;
//******************************************************************************/
function TTabGrid.TextHeight(ACol,ARow:integer): integer;
const
  min_height = 4;
var
  height,l: integer;
  str: string;
begin
  str:=Cells[ACol, ARow];
  height:=min_height;
  height:=Canvas.TextHeight(str)+height;
  if FMultiLine then height:=height*GetNbWord(str,#32);
  if height<=min_height then height:=0;
  result:= height;
end;
//******************************************************************************/
procedure TTabGrid.DrawCellTextVertical(ACol,ARow:longint; ARect :TRect);
var
NewFont, OldFont :TFont;
LogFont :TLogFont;
Str :string;
FirstMode:Integer;

begin
Str:=Cells[Acol,Arow];
NewFont:=TFont.Create;
OldFont:=TFont.Create;

NewFont.Assign(Canvas.Font);
OldFont.Assign(Canvas.Font);

NewFont.name:='times new roman';
NewFont.Height:=25;

GetObject(NewFont.Handle,sizeof(Logfont),@Logfont);
Logfont.lfEscapement:=900;
Logfont.lfOrientation:=900;

NewFont.Handle:=CreateFontIndirect(Logfont);

Canvas.Font.Assign(NewFont);
NewFont.free;

FirstMode:=SetBkMode(Canvas.Handle,transparent);

ExtTextOut(Canvas.Handle,ARect.left+2,ARect.Bottom+2,ETO_CLIPPED,
      @ARect, PChar(@str[1]), length(str), nil);

SetBkMode(Canvas.Handle,FirstMode);

Canvas.Font.Assign(OldFont);
OldFont.free;
end;
//******************************************************************************//
//******************************************************************************//

procedure TTabGrid.CreateTabCod(ATabCod :TStrListArray); // modifi le 03/06/99
var
 row,cptRow, col, cptCol, NbCol,code,i,k, index:integer;
 Liststr : TStringList;
 Astring,newstr,strcode,str,strpro,inputstring ,nombis:string;
 trouve :boolean;

 begin
 trouve:=false;
 if FFileName<>'' then
  begin
      inputstring:=FFileName;
      inputstring:=inputstring+'.cod';
      Nombis:= ExtractFileName(inputstring);
      inputstring:=chemincodage+Nombis;
      if not FileExists(inputstring)  then
       begin
        Nombis:= ExtractFileName(inputstring);
       inputstring:=searchFile(GetCurrentDir,Nombis,'');
       end;
       if (inputstring<>'') then
       begin
        for col:=0 to FicheCode.Codegrid1.ColCount-1 do
           begin
              for row:=0 to FicheCode.Codegrid1.RowCount-1 do
                 begin
                  FicheCode.Codegrid1.Cells[col,row]:='';
                 end;
            end;
        FicheCode.Codegrid1.LoadfromFile(inputstring);
        FicheCode.Codegrid1.CopyToAListArray(0,1,ATabcod);
        trouve:=true;
       end;
  end;

 if not trouve then
  begin
    cptRow:=0;
 // Cre toutes les entres pour chaque caractre
   for col:=1 to ColCount-1 do
    begin
     Astring:=Cells[col,0];
     if (Astring<>'') and (trim(Astring)<>'') then
       begin
         ATabCod.STrItems[cptRow,0]:=Astring;
         ATabCod.StrItems[cptRow,1]:='0';
         cptRow:=cptRow+1;
       end;
    end;
  cptRow:=0;

   for col:=1 to ColCount-1 do
    begin
     Astring:=Cells[col,0];
     if (Astring<>'') and (trim(Astring)<>'') then
       begin
         cptCol:=2;
         for row:=1 to RowCount-1 do
           begin
             newstr:=Cells[col,row];
             // jfr modifie le 29/04/02 : and (newstr<>'?') rajoute
              if (newstr<>'') and (trim(newstr)<>'') and (newstr<>'?')then
               begin
                 ListStr:=GetListWord(newStr,'/');
                     for i:=0 to ListStr.count-1 do
                      begin
                        str:=ListStr[i];
                        if (str<>'') and (trim(str)<>'') then
                            begin
                            // On vrifie que l'tat du caractre n'est pas
                            // dj dans TabCod
                              Trouve:=false;
                               for k:=0 to ATabCod.ColCount[cptRow]-1 do
                                begin
                                 strPro:=ATabCod.StrItems[cptRow,k];
                                 if strpro=str then
                                  begin trouve:=true;break; end;
                                end;
                                if trouve=false then
                                 begin
                                  ATabCod.StrItems[cptRow,cptCol]:=str;
                                   code:=(cptCol div 2)-1;
                                   strcode:=IntTostr(code);
                                   ATabCod.strItems[cptRow,cptCol+1]:=strcode;
                                   cptCol:=cptCol+2;
                                 end;
                            end;
                       end;
                  ListStr.free;
                end;
            end;
         cptRow:=cptRow+1;
 end;end;end;end;



//******************************************************************************//
//******************************************************************************}
constructor TMolGrid.Create(AOwner:TComponent);
begin
 FTypeMol:=nul;    // Type adn, arn, prot
 FTypeSetMol:=notalign; // align ou pas
inherited Create(AOwner);
end;

//******************************************************************************//
// jfr modifie le 10/04/00
// Pour tenir compte des carctres prsents '-' dans les molcules alignes qui empeche
// la reconnaissance du type adn ou arn

function TMolGrid.GetTypeMol(chaine :string):TTypeMolecule;
var
 i:integer;
begin
 result:=adn;
 for i:=1 to length(chaine)-1 do
  begin
   if ((chaine[i]='-') or (chaine[i]=' ') or (chaine[i]='*')) then continue; // rajout
  if (chaine[i]='A') or (chaine[i]='a')
   or (chaine[i]='T')or (chaine[i]='t')
   or (chaine[i]='C')or (chaine[i]='c')
   or (chaine[i]='G')or (chaine[i]='g') then continue
   else begin result:=arn ; break;end;
  end;
  if result=arn then
  begin
    for i:=1 to length(chaine)-1 do
      begin
       if ((chaine[i]='-') or (chaine[i]=' ') or (chaine[i]='*')) then continue;   // rajout
      if (chaine[i]='A') or (chaine[i]='a')
       or (chaine[i]='U')or (chaine[i]='u')
       or (chaine[i]='C')or (chaine[i]='c')
       or (chaine[i]='G')or (chaine[i]='g') then continue
      else begin result:=prot ; break;end;
      end;
  end;    
 end;
//******************************************************************************/
 procedure TMolGrid.DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);
var
  width,high: integer;
  Left,Top: integer;
  FirstMode:Integer;
  ident:boolean;
  AlignValue: TMyAlign;
  str,strfirst: string;
  OldAlign :TMyAlign;
  options:integer;

begin
  Top:=Arect.Top+4;  // jfr modifie le  07/07/00 avant +2
  OldAlign:=_AlignValue;

  ident:=false;

  if ((ARow=0)and (ACol<>0)and((Acol mod 5)=0)) then
    begin str:=IntToStr(ACol);
    if (FColInvalidate ) and (ARow<FixedRows) and (IsInvalidateCol(ACol)=true)
    then  Canvas.Font.Color:=clwhite;
     width:=Canvas.TextWidth(str);
     if width>ARect.right-ARect.Left-2 then _ALignValue:=alright
     else _ALignValue:=alcenter;
     end

else if (ARow=0) then
  begin  // exit
        //else  Str:=Cells[Acol,Arow];

  { Si le Flag FCompare <> NoCompare le texte de la cellule est compar  celui
  de la cellule de la premire ligne  condition que la cellule n'appartienne
  pas  une ligne ou une colonne fixe }

 // jfr modifie le 07/07/00
 // les  lignes suivantes ont t rajoutes

 if (FColInvalidate ) and (ARow<FixedRows) and (IsInvalidateCol(ACol)=true)
 then
  begin
       Canvas.Font.Color:=clwhite;
       str:=IntToStr(ACol);
       width:=Canvas.TextWidth(str);
       if width>ARect.right-ARect.Left-2 then _ALignValue:=alright
       else _ALignValue:=alcenter;
  end
    else
      if (FRowInvalidate ) and (ACol<FixedCols) and (IsInvalidateRow(ARow)=true)
       then Canvas.Font.Color:=clwhite
      else exit;

 // fin du rajout de 07/07/00
 end
 else  Str:=Cells[Acol,Arow];
 
 if ( (FCompare<>NoCompare) and (ACol>=FixedCols)and(ARow>=FixedRows))then
  begin
    strfirst:=Cells[Acol,1];
    if ((trim(str)<>'')and (Str=strfirst)) then
     begin
      if FCompare=ColorText then Canvas.Font.Color:=FColorText
                             else FillCell(FColorText,ARect);
      end
     else Canvas.Font.color:=clblack;
  end;

 // jfr modifie le 07/07/00 pour que les enttes de colonnes correspondent  celles
 // des Tabgrids
 // Les six lignes suivantes remplacent la ligne: FirstMode:=SetBkMode(Canvas.Handle,transparent);

 if (ACol>=FixedCols)and(ARow<FixedRows) then
  begin
   Canvas.Brush.Color:=clLtGray ;
   _AlignValue:=alcenter;
   end
 else FirstMode:=SetBkMode(Canvas.Handle,transparent);

  width:=Canvas.TextWidth(str);
  high:=Canvas.TextHeight(str);

  case _AlignValue of
   alLeft: Left:=ARect.Left+2;
   alCenter: begin width:=( (Arect.Right-ARect.Left)-width ) div 2;
                   Left:=ARect.Left+width;
             end;
   alRight: Left:=ARect.Right-width;
  end;


  ExtTextOut(Canvas.Handle, Left, Top,option, @ARect, PChar(Str), length(str), nil);

  Canvas.Font.color:=clblack;
 // fr modifie le 07/07/00 pour que les enttes de colonnes correspondent  celles
 // des Tabgrids
 // Les deux lignes suivantes remplacent la ligne : FirstMode:=SetBkMode(Canvas.Handle,FirsMode );

   if (ACol>=FixedCols)and(ARow<FixedRows) then
   else SetBkMode(Canvas.Handle,FirstMode);

 _ALignValue:=OldAlign;

end;
//******************************************************************************//
procedure TMolGrid.DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState);
  begin

     // Affichage des cellules appartenant  des lignes ou des colonnes Fixes
     if ((Acol<FixedCols) or (ARow<FixedRows)) then
     begin
         FillCell(clLtGray,ARect);
        if (Acol<FixedCols)then
         begin
           if (SelectRow[Arow])
            then RoundCell(clGray,clWhite,ARect)
            else RoundCell(clWhite,clGray,ARect);
          end;

         if (ARow<FixedRows) then
         begin
          if (SelectCol[ACol])
            then RoundCell(clGray,clWhite,ARect)
            else
            RoundCell(clLtGray,clLtGray,ARect);

         end;
          if  (ARow>=FixedRows)
           then DrawCellText(Acol,Arow,ARect,ETO_CLIPPED);
     end

    // Affichage des cellules normales
    else
    begin
     if not defaultDrawing then FillCell(clWhite,ARect);
     DrawCellText(ACol,ARow,ARect,ETO_CLIPPED);
     end;

    if Assigned(OnDrawCell) then OnDrawCell(Self, ACol, ARow, ARect, AState);
 end;

//******************************************************************************}
procedure TMolGrid.Paint;
var
Rect:TRect;
select:boolean;
row,col,larg,MaxRow,Maxcol:integer;
stop:integer;

begin
inherited Paint;      // appelle "paint" qui appelle "drawcells" qui appelle "drawcell"
MaxRow:=TopRow+VisibleRowcount;
Maxcol:=LeftCol+VisibleColCount;

if(FixedCols>0) then
begin
 for row:=TopRow to MaxRow-1 do
  begin
   for col:=0 to FixedCols-1 do
    begin
     Rect:=CellRect(col,row);
     Rect.bottom:=Rect.top+RowHeights[row];
     FillCell(clLtGray,Rect);
     if IsSelectRow(row) then
                            begin
                              RoundCell(clGray,clWhite,Rect);
                              DrawCellText(col,row,Rect,ETO_CLIPPED);   
                              end
                         else
                         begin
                         // jfr modifie le 30/04/02
                          RoundCell(clWhite,clGray,Rect); DrawCellTextbis(col,row,Rect,ETO_CLIPPED);
                          end

    end;    
  end;
  if MaxRow<RowCount then begin
   for col:=0 to FixedCols-1 do
     begin
      Rect.top:=Rect.bottom;
      Rect.bottom:=Rect.top+RowHeights[MaxRow];
      FillCell(clLtGray,Rect);
      if IsSelectRow(Maxrow) then RoundCell(clGray,clWhite,Rect)
                            else RoundCell(clWhite,clGray,Rect);
      DrawCellText(col,Maxrow,Rect,ETO_CLIPPED);
   end;
   end;
end;

if(FixedRows>0) then
begin
  // Cette partie doit tre limite aux colonnes visibles, sinon Rect est nul et
 // l'affichage se fait dans la premiere cellule (0,0)
 for col:=leftcol to MaxCol-1 do
  begin
     Rect:=CellRect(col,0);
     Rect.Right:=Rect.Left+ColWidths[col];
     Rect.left:=Rect.left-1;   // Pour effacer les lignes noires dessines entre les cellules
     Rect.Right:=Rect.Right+1;
     FillCell(clLtGray,Rect);
  // jfr modifie le 07/07/00 pour que les enttes de colonnes correspondent  celles
  // des Tabgrids

     if IsSelectCol(col) then
      RoundCell(clGray,clWhite,Rect)
     else RoundCell(clWhite,clGray,Rect);
  end;

 if MaxCol<ColCount then
  begin
     Rect.left:=Rect.Right;
     Rect.Right:=Rect.Left+ColWidths[Maxcol];
     FillCell(clLtGray,Rect);
  // jfr modifie le 07/07/00 pour que les enttes de colonnes correspondent  celles
  // des Tabgrids
     if IsSelectCol(col) then RoundCell(clGray,clWhite,Rect)
                         else  RoundCell(clWhite,clGray,Rect)
  end;

  for col:=leftcol to MaxCol-1 do
  begin
     Rect:=CellRect(col,0);
     Rect.Right:=Rect.Left+ColWidths[col];
    DrawCellText(col,0,Rect,0);
  end;

 if MaxCol<ColCount then
  begin
    Rect.left:=Rect.Right+1;
     Rect.Right:=Rect.Left+ColWidths[Maxcol];
    DrawCellText(maxcol,0,Rect,0);
  end;

end;
end;

// jfr modifie le 10/04/00
function TMolGrid.LoadPirMol(filename :string; AListArray:TstrListArray): TTypeMolecule;
 var
 line :string;
 countcol, countrow :integer;
 indexrow,col :integer;
 MolStrings:TStringList;


 begin
  FTypeMol:=nul ;

  MolStrings:=TStringlist.create;
  try
  MolStrings.LoadFromFile(fileName);

  countcol:=0;
  countrow:=-1;

  Line:=MolStrings[0];
  line:=trimleft(line);
  // Pour tenir compte de mauvais formats de molcules (RTF, Word etc.)
  if ((ord(line[1])<32) or (ord(line[1])>126) or (ord(line[2])<32) or (ord(line[2])>126)) then
   begin
    result:=FTypeMol;
    exit;
   end;
  if ((line[1]='{') and (line[2]='\') and (line[3]='r'))   then
     begin
     result:=FTypeMol;
     exit;
   end;
  for indexrow:=0 to MolStrings.count-1 do
    begin
      Line:=MolStrings[indexrow];
      line:=trimleft(line);

      if line='' then continue;
      if (line[1]='>') or (line[1]=';') then         // nouvelle molcule
         begin
           inc(countrow);
           countcol:=0;
           if (line[1]='>') then line :=stripfirsttoken(line,'>')
           else   line :=stripfirsttoken(line,';');
           if line<>'' then line :=trimright(line);
           AListArray.strItems[countrow,countcol]:=line;
           inc(countcol);
         end
       else
         begin
            for col:=1  to Length(line) do
              begin
                if FTypeMol=nul then FTypeMol:=GetTypeMol(line);
                AListArray.strItems[countrow,countcol]:=line[col];
                inc(countcol);
              end;
       end;
   end;
 finally
  MolStrings.free;
 end;
 result:=FTypeMol;
end;


// jfr modifie le 10/04/00
function TMolGrid.LoadAlnMol(filename :string; TabMol:TStrings):boolean ;
 var
 Line,MolName:string;
 MolStrings:TStringList;
 TabMolName:TStringList;
 index:integer;
 indextab ,lon:integer;

begin
   MolStrings:=TStringList.create;
   TabMolName:=TStringList.create;
   result:=true;
  try
   MolStrings.LoadFromFile(fileName);

   Line:=MolStrings[0];
  line:=trimleft(line);
  // Pour tenir compte de mauvais formats de molcules (RTF, Word etc.)
  if ((ord(line[1])<32) or (ord(line[1])>126) or (ord(line[2])<32) or (ord(line[2])>126)) then
   begin
    result:=false;
    exit;
   end;
  if ((line[1]='{') and (line[2]='r') and (line[3]='t'))   then
     begin
     result:=false;
     exit;
   end;

   for index:=1 to MolStrings.count-1 do // la premire ligne est ignor
    begin
      Line:=MolStrings[index];
      if line='' then continue ; // si la ligne est vide, on passe  la suivante
      //MolName:=copy(line,0,16);
      MolName:=GetFirstword(line);

      indextab:=TabMolName.IndexOf(MolName);
      if indextab=-1 then      // si le nom de la molcule n'existe pas encore
           begin
           TabMolName.add(MolName);
           TabMol.add(Line);
           end
       else
        //TabMol[indextab]:=TabMol[indextab]+copy(line,17,60);;
        TabMol[indextab]:=TabMol[indextab]+GetLastToken(line,' ');
     end;
  finally
  MolStrings.free;
  TabMolName.free;
  end;
end;

procedure TMolGrid.LoadFromFile(const FileName:string);
var
Ext:string;
begin
 Ext:= ExtractFileExt(FileName);
 if Ext='.aln' then LoadFromFileALN(FileName)
 else if Ext='.bas' then LoadFromFileBAS(FileName)
 else if Ext='.pir' then LoadFromFilePIR(FileName);
end;

//******************************************************************************/
procedure TMolGrid.LoadFromFileBAS(const Filename :string);
begin
 LoadFromFilePIR(Filename);
end;

// jfr modifie le 10/04/00
// Pour tenir compte de mauvais formats de molcules
procedure TMolGrid.LoadFromFilePIR(const Filename :string);
var
AListArray :TStrListArray;
Tm:TTextMetric;
index:integer;
begin
 if FileName='' then Exit;
 TypeSetMol:=notalign;
 AListArray :=TStrListArray.createListArray;
 try
    LoadPirMol(filename,AlistArray);
     if (FTypeMol=nul) then          // Quand le format des molcules est inconnu
      begin
          ShowMessage('Format du fichier de molcules non valide');
          exit;
       end;
    CopyFromAListArray(0,1,AlistArray);
    AdjustColWidth(0);

   if (GetTextMetrics(Canvas.handle,Tm)) then
     begin
       for index:=1 to ColCount-1 do ColWidths[index]:=Tm.TmMaxCharWidth+4;
     end;
  finally
    AlistArray.free;
  end;
end;

// jfr modifie le 10/04/00
// Pour tenir compte de mauvais formats de molcules
procedure TMolGrid.LoadFromFiles(Files :Tstrings); // Fonction appele par "Ajouter Mol"
var
 name,filepro :string;
 dep, index :integer;
 AListArray :TStrListArray;
 Tm:TTextMetric;
 TempTypeMol,Temp:TTypeMolecule;
 Rect :TRect;

begin
 if Files=nil then Exit;
 AListArray :=TStrListArray.createListArray;
 TempTypeMol:=FTypeMol;

 try
  dep:=GetMaxFillRow;
  if dep=0 then dep:=1;              // Pour les tableaux vides

 for index:=0 to Files.count-1 do
  begin
   name:=Files[index];
   LoadPirMol(name,AlistArray);
    if (FTypeMol=nul) then          // Quand le format des molcules est inconnu
      begin
          ShowMessage('Format du fichier de molcules inconnu');
          FTypeMol:=TempTypeMol;
          TempTypeMol:=nul;
          break;
       end;

  If (TempTypeMol<>nul) and (TempTypeMol<>FTypeMol) then
    begin
      Application.MessageBox('Types des molcules incompatibles','Erreur de fichier',MB_OK);
      FTypeMol:=TempTypeMol;
      break;
    end
   else TempTypeMol:=FTypeMol;

   CopyFromAListArray(0,dep,AlistArray);
   AlistArray.ClearRow(0);
   inc(dep)
   end;

  if tempTypeMol<>nul then
   begin
    RowCount:=dep;                    // pour tenir compte de la ligne compteur
    AdjustColWidth(0);
    if (GetTextMetrics(Canvas.handle,Tm)) then
     begin
      for index:=1 to ColCount-1 do ColWidths[index]:=Tm.TmMaxCharWidth+4;
     end;
   end;
  finally
    AlistArray.free;
  end;
   TypeSetMol:=notalign;
end;

// jfr modifie le 10/04/00
procedure TMolGrid.LoadFromFileALN(const Filename :string);
var
i,j :integer;
lon,max :integer;
TabMol :TStringList;
Tm:TTextMetric;
temp : string;
 vide :boolean;
 countrow :integer;
 chaine :string;
 result :boolean;

 begin
 FTypeMol:=nul;

 if FileName='' then Exit;
 countrow:=0;
 TabMol:=TStringList.Create;
 try
  result:=LoadAlnMol(filename,TabMol);
  if (result=false) then          // Quand le format des molcules est inconnu
      begin
          ShowMessage('Format du fichier de molcules non valide');
          exit;
       end;

   max:=0;
   for i:=0 to TabMol.Count-1 do
     begin

    temp:=copy(TabMol[i],0,16);
    if (temp='') or (trim(temp)='') then
     begin
       vide:=true;
       for j:=17 to lon  do
        begin
         temp:=copy(TabMol[i],j,1);
         if (temp<>'') and (trim(temp)<>'')
                       and (trim(temp)<>'*')
                       and (trim(temp)<>'.')
                       and (trim(temp)<>':')
          then begin vide:=false; break; end;
        end;
      if vide=true then continue;
     end;

   inc(countrow);

   Cells[0,i+1]:=GetFirstWord(TabMol[i]);
   chaine:=GetLastToken(TabMol[i],' ');

   if FTypeMol=nul then FTypeMol:=GetTypeMol(chaine);

   lon:=length(chaine);
   if lon>max then max:=lon;

   for j:=1 to length(chaine)  do
       Cells[j,i+1]:=chaine[j];

   end;


   RowCount:=Countrow+1 ;
   ColCount:=max+1; // Le nom de la molcule est sur 16 caractres
                    // mais ne correspond en fait qu' une cellule
   AdjustColWidth(0);

   if (GetTextMetrics(Canvas.handle,Tm)) then
    begin
     for i:=1 to ColCount-1 do ColWidths[i]:=Tm.TmMaxCharWidth+4;
    end;

   TypeSetMol:=setalign;
   finally
    TabMol.free;
   end;
end;


procedure TMolGrid.MyAlignerOld(auto:boolean);
var
inputstring :string;
outputstring,FileNameALign,FilePath,filetemp :string;
StartInfo : TStartupInfo;
ProcessInformation : TProcessInformation;
result :boolean;
OpenDialog: TOpenDialog;
index,Attributs,Resultat:integer;
retour :boolean;
Hwnd :THandle;
SearchRec:TSearchRec;
NomCourt:array[0..MAX_PATH-1]of char;
Nom: array[0..MAX_PATH-1] of Char;

begin
inputstring:=inputbox('Nom du fichier align','Entrez le nom du fichier align (sans suffixe)','');
if inputstring='' then exit;
// On retire le suffixe si il en a t rentr un
index:= pos('.',inputstring);
if ( index > 0 )then inputstring:=shorten(inputstring,length(inputstring)-index+1);

// on charge clustalw.exe directement s'il est ds le rpertoire courant (prog)
// (modif DL 9/11/99)
if FileExists('clustalw.exe') then
  FileNameAlign:=ExpandFileName('clustalw.exe')
else
  begin
       Opendialog:=TOpenDialog.create(self);
       Opendialog.Title:='Choix du programme pour aligner';
       Opendialog.FileName:='clustal*' ;
       Opendialog.defaultExt:='.exe';
       OpenDialog.Filter := 'files (*.exe)|*.EXE';
       Opendialog.execute;
       FileNameAlign:=ExpandFileName(Opendialog.filename);
  end;
FilePath:=ExtractFilePath(FileNameAlign);

SaveToFilePIR(FilePath+inputstring);

// jfr modifie septembre 2001 /INFILE= a t rajout
if auto=true then outputstring:=FileNameAlign+' '+'/INFILE='+inputstring+'.pir' //+'/align/'
else
 outputstring:=FileNameAlign;  //+' '+FilePath+inputstring+'.pir';

screen.cursor:=crHourGlass;
  result:=true;
  ZeroMemory(@StartInfo, sizeof(StartInfo)); // rempli de 0 StartInfo
  StartInfo.cb:=sizeof(StartInfo);
  if CreateProcess(nil,Pchar(outputstring),nil,nil,true,0,nil,nil,StartInfo,ProcessInformation)
  then
  begin
   retour:=true;
    while retour  do begin
     Hwnd:=FindWindow(nil,'Termin - clustalw');
     if HWnd<>0 then
       begin
         retour:=false;
        //PostMessage(hWnd ,WM_CLOSE,0,0);
       end;
     end;
  WaitForSingleObject(ProcessInformation.hProcess, INFINITE)// attend que l'application dsigne par le handle ProcessInformation.hProcess soit termine
  end
  else result:=false;

screen.cursor:=crArrow;
inputstring:=FilePath+inputstring+'.aln';
LoadFromFileALN(inputstring);
TypeSetMol:=setalign;
end;


procedure TMolGrid.MyAligner(auto:boolean);
var
ARow,ACol,i,j,len:integer;
s,temp:string;
mylist:TStringlist;
essai:PChar;
dnaflag:integer;
nuc:Typenuc;

begin
nuc:=['A','T','C','G','U','a','c','g','t','u','*','-','_'];
dnaflag:=1;
mylist:=Tstringlist.Create;
for ARow:=1 to rowcount-1 do
   begin
    
    if (cells[0,ARow]<>'')and (trim(cells[0,ARow])<>'')
     then begin
           s:='';
           for ACol:=1 to colcount-1 do
             begin
               temp:= cells[ACol,ARow];
               if (temp<>'') then temp:=trim(temp);     // jfr modifie le 06/09/02
                 if (temp='') then temp:='-';          // pour corriger un probleme lie au case vide dans une molcule d'ADN
               temp[1]:=upcase(temp[1]);
               if (dnaflag=1)and (not(temp[1] in nuc)) then dnaflag:=0;
               s:=s+temp;
             end;
           s:=uppercase(s);
           mylist.add(s);
           end;
    end;

InitAlign( PChar(CheminAlign),mylist.count ,dnaflag,1);

for i:=0 to mylist.count-1 do 
     begin
      s:=mylist[i];
      DonneeAlign(i+1,PChar(s)) ;
     end;
   
  len:=Aligner(self.Handle);
  essai:=stralloc(len);

for i:=0 to mylist.count-1 do 
     begin
      ResultAlign(len , i+1, essai ) ;
      for j:=0 to len-1  do
      begin
       if essai[j]='_' then essai[j]:='-';
       Cells[j+1,i+1]:=essai[j];
       end;
       
     end;
mylist.free;
TypeSetMol:=setalign;
end;

procedure TMolGrid.SaveToAln(lines :TStringList);
var
 nbiter, col, row ,iter:integer;
 tabname :TStringlist;
 line :string;
 bool :boolean;

 begin
  tabname:=TStringList.create;

  for row:=1 to rowcount-1 do tabname.add(cells[0,row]);

  nbiter:=(colcount-1) div 60;
  if (colcount-1)-(nbiter*60)>0 then nbiter:=nbiter+1;

  for iter:=0 to nbiter-1 do
    begin
      for row:=0 to rowcount-2 do
        begin
         line:=tabname[row];
         if line<>''then
         begin
          line :=trim(line);
          line:=LeftSet(line,15,bool);
          end;
          for col:=1 to 60 do
            begin
             line:=line+cells[col+(60*iter),row+1];
            end;
         line:=trimright(line);
         lines.add(line);
        end;
      lines.add('');
    end;
  tabname.free;
 end;

procedure TMolGrid.SaveToFileALN( filename:string);
var
 data : TMemoryStream;
 lines :TStringList;
 line ,ext: string;
 index :integer;
begin
 data:=TMemorystream.Create;
 lines:=TStringList.Create;

 SaveToAln(lines);
 String2Stream(data,'CLUSTAL W (1.8) multiple sequence alignment'+#13#10);
 String2Stream(data,#13#10);
 String2Stream(data,#13#10);
 
  for index:= 0 to lines.count-1 do
   begin
    line:=lines[index];
    String2Stream(data,line+#13#10);
   end;
 try

 if pos('.aln.aln',filename)>0 then filename:=shorten(filename,4);

 Ext:= ExtractFileExt(FileName);
 if Ext='' then filename:=filename+'.aln';

  data.savetofile(filename);
  finally
    data.free;
    lines.free;
    end;
 end;

procedure TMolGrid.SaveToFilePIR( filename:string);
var
  data: TMemoryStream;
  ACol,ARow,compt: integer;
  s,temp,ext: string;
  vide :boolean;
  
begin
  data:=TMemorystream.Create;

  for ARow:=1 to rowcount-1 do
   begin
    s:='> ';
    if (cells[0,ARow]<>'')and (trim(cells[0,ARow])<>'')
     then
       begin
       temp:=trim(cells[0,ARow]);
       temp:=ReplaceChars(temp,' ','-');
       s:=s+temp;
       end
    else
     begin         // On teste si la ligne n'est pas completement vide
     vide:=true;
      for ACol:=1 to colcount-1 do
        begin
          //if (cells[0,ARow]<>'')and (trim(cells[0,ARow])<>'')
          if (cells[Acol,ARow]<>'')and (trim(cells[ACol,ARow])<>'')   // jfr modifie le 08/07/02
            then begin vide:=false ; break;end;
        end;
      if vide=true then continue;
     end;
    String2Stream(data,s+#13#10);
    s:='';

    compt:=0;
    for ACol:=1 to colcount-1 do
     begin
       if (cells[0,ARow]<>'') and (trim(cells[0,ARow])<>'') then
         s:=s+cells[ACol,ARow]
       else s:=s+' ';
      inc(compt);
      if compt=70 then begin
                       String2Stream(data,s+#13#10);
                       compt:=0;s:='';
                       end;
     end;
     String2Stream(data,s+#13#10);
    end;                         
 try
 if pos('.pir.pir',filename)>0 then filename:=shorten(filename,4);

 Ext:= ExtractFileExt(FileName);
 if Ext='' then filename:=filename+'.pir';
  data.savetofile(filename);
  finally
    data.free;
    end;
 end;

procedure Register;
begin
  RegisterComponents('phylo',[TTabGrid,TMolGrid]);
end;

end.

