unit Prtgrids;

{ By Paul Toth tothpaul@multimania.com }
{ http://www.multimania.com/tothpaul  }

{ Just a little Unit to print a Grid :) }

{
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}

interface

Uses
 Forms,Grids,Printers, Controls, SysUtils, Graphics, Classes, DBGrids;

Procedure PrtGrid(Grid:TStringGrid; PrtTitle, PrtText:string);

implementation

Procedure PrtGrid(Grid:TStringGrid; PrtTitle, PrtText:string);
 Type
  TCols=Array[0..20] of integer;
 Var
  Rapport:Integer;
  r,c:longint;
  cols:^TCols;
  y:integer;
  MargeLeft,Margetop,MargeRight:integer;
  StrDate:String;
  TextDown:integer;
  Procedure VerticalLines;
   Var
    c:LongInt;
   begin
     With Printer.Canvas do begin
      For c:=0 to Grid.ColCount-1 do begin
       MoveTo(Cols^[c],MargeTop+TextDown);
       LineTo(Cols^[c],y);
      end;
      MoveTo(MargeRight,MargeTop+TextDown);
      LineTo(MargeRight,y);
     end;
   end;
  Procedure PrintRow(r:longint);
   Var
    c:longint;
   begin
    With Printer.Canvas do begin
     For c:=0 to Grid.ColCount do TextOut(Cols^[c]+10,y+10,Grid.Cells[c,r]);
     inc(y,TextDown);
     MoveTo(MargeLeft,y); LineTo(MargeRight,y);
    end;
   end;
  Procedure Entete;
   begin
    With Printer.Canvas do begin
     Font.Style:=[fsBold];

     TextOut(MargeLeft,MargeTop,PrtText);
     TextOut(MargeRight-TextWidth(StrDate),MargeTop,StrDate);
     y:=MargeTop+TextDown;

     Brush.Color:=clSilver;
     FillRect(Rect(MargeLeft,y,MargeRight,y+TextDown));
     MoveTo(MargeLeft,y); LineTo(MargeRight,y);
     PrintRow(0);
     Brush.Color:=clWhite;

     Font.Style:=[];
    end;
   end;
 begin
  Screen.Cursor:=crHourGlass;
  GetMem(Cols,Grid.ColCount*SizeOf(Integer));
  StrDate:='Imprim le '+DateToStr(Date);
  With Printer do begin
   Rapport:=PageWidth div Grid.Width;
   Title:=PrtTitle;
   BeginDoc;
   With Canvas do begin
    Font:=Grid.Font;
    TextDown:=TextHeight(StrDate)*3 div 2;
   end;
   MargeLeft:=PageWidth div 25;
   MargeTop :=PageHeight div 25;
   MargeRight:=PageWidth-MargeLeft;
   { calcul des Cols }
   Cols^[0]:=MargeLeft;
   For c:=1 to Grid.ColCount-1 do begin
     Cols^[c]:=Cols^[c-1]+Grid.ColWidths[c-1]*Rapport;
   end;
   Entete;
   For r:=1 to Grid.RowCount-1 do begin
    PrintRow(r);
    if y>=(PageHeight-MargeTop) then begin
     VerticalLines;
     NewPage;
     Entete;
    end;
   end;
   VerticalLines;
   EndDoc;
  end;
  FreeMem(Cols,Grid.ColCount*SizeOf(Integer));
  Screen.Cursor:=crDefault;
 end;

end.
