unit PhylArbre;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CustomGraph, GraphControlTreeCL, Grids, MyNewgrid,fenarbre,
  ExtCtrls, Buttons,typedef,listarray;

type
  TFormArbre = class(TForm)
    TabGrid1: TTabGrid;
    OpenDialog1: TOpenDialog;
    GCT1: TGraphControlTreeCL;
    Button1: TButton;
    Button2: TButton;
    Splitter1: TSplitter;
    panel1: TPanel;
    GroupBox1: TGroupBox;
    LongTot: TEdit;
    LongPart: TEdit;
    Label4: TLabel;
    Panel2: TPanel;
    auto: TSpeedButton;
    code: TSpeedButton;
    zoommois: TSpeedButton;
    zoomplus: TSpeedButton;
    legendes: TButton;
    Label3: TLabel;
    LegendeGroupBox: TGroupBox;
    Optionslegendes: TButton;
    ouvrircode: TOpenDialog;
    annuler: TSpeedButton;
    normal: TSpeedButton;
    pivoter: TSpeedButton;
    Enraciner: TSpeedButton;
    Splitter2: TSplitter;
    Panel3: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure legendesClick(Sender: TObject);
    procedure TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GCT1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ActionClick(Sender: TObject);
    procedure OptionslegendesClick(Sender: TObject);
    procedure codeClick(Sender: TObject);
    procedure autoClick(Sender: TObject);
    procedure annulerClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure zoomplusClick(Sender: TObject);
    procedure zoommoisClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  NameOfFlagTaxonPro: string;
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FormArbre: TFormArbre;

implementation

uses optionleg, optioncode, code, PhylMain, PhylChoi;

{$R *.DFM}


procedure TFormArbre.Button1Click(Sender: TObject);
begin
if opendialog1.execute then
Tabgrid1.LoadfromFile(opendialog1.filename);
end;

procedure TFormArbre.Button2Click(Sender: TObject);
begin
GCT1.InitTree(TabGrid1);
LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;


procedure TFormArbre.legendesClick(Sender: TObject);
begin
   if legendes.Caption='Afficher'then
   begin
   legendes.Caption:='Effacer';
   GCT1.TreePage.Flag_Legende:=true;
   GCT1.TreePage.CreateLeg;
   GCT1.TreePage.ChangeCoordGraphObjects;
   optionsLegendes.Enabled:=true;
   end
   else
     begin
     legendes.Caption:= 'Afficher';
      GCT1.TreePage.Flag_Legende:=false;
      GCT1.TreePage.DeleteLeg;
      optionslegendes.enabled:=false;
      end;
   GCT1.invalidate;
end;

procedure TFormArbre.TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
col,row :integer;
AName :string;
begin
TabGrid1.MouseToCell(X,Y,col,row);
if (row=0) and (col<>0) then
 begin
  if not TabGrid1.SelectCol[col] then AName:=''
  else AName:=TabGrid1.Cells[col,row];

  if AName='' then
   begin
    if GCT1.TreePage.Flag_Legende=true then
       begin
         GCT1.TreePage.Flag_Legende:=false ;
         GCT1.TreePage.DeleteLeg;
        legendes.Caption:='Afficher';
       end ;
    legendes.Enabled:=False ;
   end
   else legendes.Enabled:=True;

  GCT1.OnChangeSelectCarac(AName);
  GCT1.invalidate;
  LongTot.Text:=intToStr(GCT1.TreeTotalLength);
  LongPart.Text:=intToStr(GCT1.TreeUnitLength);
 end;

if (row<>0) and (col=0) then
 begin
  AName:=TabGrid1.Cells[col,row];
  // Le clic a invalid la cellule obligatoirement si elle n'tait pas invalide
  if TabGrid1.InvalidateRow[row] then
   begin   // donc le clic a eu lieu sur une cellule valide
      GCT1.DeleteTaxon(AName);
     LongTot.Text:=intToStr(GCT1.TreeTotalLength);
     LongPart.Text:=intToStr(GCT1.TreeUnitLength);
   end
     else  // le clic a eu lieu sur une cellule invalide qui est donc devenue valide
      if GCT1.NameOfFlagTaxonPro='' then
       begin GCT1.AddTaxonPro(AName);NameOfFlagTaxonPro:=AName; end;
      // La cellule doit redevenir invalide et ne sera valide qu'aprs un greffage russi
      TabGrid1.InvalidateRow[row]:=true;
  end;
end;

//******************************************************************************/

procedure TFormArbre.GCT1MouseUp(Sender: TObject; Button: TMouseButton;
                              Shift: TShiftState; X, Y: Integer);
var
  row :integer;
begin
// La deuxime condition traduit le fait que le greffage russi d'un taxon
// provisoire conduit  sa suppression
if (NameOfFlagTaxonPro<>'') and (GCT1.NameOfFlagTaxonPro='') then
 begin
  row:=TabGrid1.IndexOfRow(NameOfFlagTaxonPro);
  if row<>-1 then
   begin
    TabGrid1.InvalidateRow[row]:=false;
    TabGrid1.MyInvalidateCell(0,row);
    GCT1.AddTaxonToDataList(row);
    end;
   NameOfFlagTaxonPro:='';
 end;

LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

//******************************************************************************/
procedure TFormArbre.ActionClick(Sender: TObject);
begin
  if sender = enraciner
        then GCT1.OnFlagRoot
  else if sender =pivoter
        then GCT1.OnFlagSwap
  else if sender = normal
        then GCT1.OnFlagNormal;
end;

//******************************************************************************/

procedure TFormArbre.OptionslegendesClick(Sender: TObject);
var
res :integer;
begin
 case GCT1.TreePage.TypeEtat  of
  NEtatDown :FicheOptionLeg.EtatDownRadio.Checked:=true;
  NEtatUp : FicheOptionLeg.EtatUpRadio.Checked:=true;
  NEtatMPR : FicheOptionLeg.EtatMPRRadio.Checked:=true;
  end;

  case GCT1.TreePage.TypeLegende  of
   texte :FicheOptionLeg.TexteRadio.Checked:=true;
   codeL : FicheOptionLeg.codeRadio.Checked:=true;
  end;

 res:=FicheOptionLeg.showModal;

 if res<>mrcancel then
 begin

  if  FicheOptionLeg.EtatDownRadio.Checked=true then GCT1.TreePage.TypeEtat := NEtatDown
  else if  FicheOptionLeg.EtatUpRadio.Checked=true  then GCT1.TreePage.TypeEtat := NEtatUp
  else if  FicheOptionLeg.EtatMPRRadio.Checked=true then GCT1.TreePage.TypeEtat :=  NEtatMPR;

  if FicheOptionLeg.TexteRadio.Checked=true then GCT1.TreePage.TypeLegende := texte
  else if FicheOptionLeg.codeRadio.Checked=true  then GCT1.TreePage.TypeLegende := codeL;

  GCT1.TreePage.DeleteLeg;
  GCT1.TreePage.CreateLeg;
  GCT1.TreePage.ChangeCoordGraphObjects;

  GCT1.Invalidate;
 end;

 end;
//******************************************************************************/

procedure TFormArbre.codeClick(Sender: TObject);
var
res,rescod,compt,No :integer;
newtabcod :TstrListArray;
begin
 rescod:=mrcancel;
 res:=FicheOptioncode.showModal;
 if res<>mrcancel then
  begin
    if FicheOptionCode.ouvrirbouton.Checked=true then
      begin
       if ouvrircode.execute then
          begin
           FicheCode.Codegrid1.LoadfromFile(ouvrircode.filename);
           rescod:=FicheCode.ShowModal;
          end;
      end
     else   // On utilise le fichier de codage cr par dfaut
      begin
          FicheCode.Codegrid1.cells[0,0]:='CARACTERE';
          FicheCode.Codegrid1.cells[1,0]:='TYPE';

          compt:=2; No:=1;
          while (compt <= GCT1.TabCod.ColCount[0]) do
           begin
             FicheCode.Codegrid1.cells[compt,0]:='ETAT'+IntToStr(No);
             FicheCode.Codegrid1.cells[compt+1,0]:='CODE'+IntToStr(No);
           compt:=compt+2;
           No:=No+1;
           end;
          FicheCode.Codegrid1.CopyFromAListArray(0,1,GCT1.TabCod);

          rescod:=FicheCode.ShowModal;
      end;
   if rescod<>mrcancel then
     begin
      newtabcod:=TstrListArray.create;
      FicheCode.Codegrid1.CopyToAListArray(0,1,newtabcod);
      GCT1.OnChangeTabCod(newtabcod);
      LongTot.Text:=intToStr(GCT1.TreeTotalLength);
      LongPart.Text:=intToStr(GCT1.TreeUnitLength);
      end;
  end;

end;

procedure TFormArbre.autoClick(Sender: TObject);
begin
 GCT1.OnChangeAuto;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.annulerClick(Sender: TObject);
begin
 GCT1.UndoTreeAction;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.FormCreate(Sender: TObject);
begin
FormPrinc.Fille(Self);
NameOfFlagTaxonPro:='';
end;

procedure TFormArbre.zoomplusClick(Sender: TObject);
begin
GCT1.OnChangeScale('plus');
end;

procedure TFormArbre.zoommoisClick(Sender: TObject);
begin
GCT1.OnChangeScale('moins');
end;

procedure TFormArbre.FormShow(Sender: TObject);
begin
   FormChoisir.Tabgrid1.copyTolistArray;
   Tabgrid1.ListArray:=FormChoisir.TabGrid1.listarray;
   TabGrid1.copyFromListArray(0,0);
   GCT1.InitTree(TabGrid1);
LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

end.
