unit PhylDef;
// Dl 19/10/99 Gestion de plusieurs mots dans le glossaire (AfficheDefinition)
//    16/11/99 Cration d'une fiche avec ListBox (PhylGlo) au lieu du menu
//             PhylDef affiche la dfinition

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFormDefinition = class(TForm)
    Memo1: TMemo;
    procedure FormPaint(Sender: TObject);
  private
    { Dclarations prives}
  public
    { Dclarations publiques}
    procedure AfficheDefinition(Terme:string);
  end;

var
  FormDefinition: TFormDefinition;
   FicGlossaire : string;
const

  CarGlossaire='<';

implementation

uses PhylMain, Menus;

{$R *.DFM}



procedure TFormDefinition.AfficheDefinition(Terme:string);
var
  f:TextFile;
  Ligne,Nombis:string;
  Trouve, Fini: boolean;
  ListeTermes:TStringList;
begin
   Terme:=Trim(Terme);   // pour enlever les blancs au dbut et  la fin
   if (length(Terme) > 1) and (Terme[2]='''') then  // pour enlever l' et d'
      if (upCase(Terme[1])='L') or (upCase(Terme[1])='D')  then
        Terme:=copy(Terme,3,length(Terme));
   FicGlossaire:='Glossaire.txt';
   Nombis:= ExtractFileName(FicGlossaire);      // jfr modifie le 27/05/02
   FicGlossaire:=searchFile(GetCurrentDir,Nombis,'');

   if not FileExists(FicGlossaire) then
   begin
      ShowMessage('Fichier '+FicGlossaire+ 'non trouv');
      exit;
   end;
   AssignFile(f,FicGlossaire);
   Reset(f);
   Trouve:=false;
   ListeTermes:=TStringList.Create;
   while not (eof(f)) and not Trouve do
   begin
      readln(f,Ligne);
      if (Ligne <> '') and (Ligne[1] = CarGlossaire) then
      begin
         ListeTermes.CommaText:=copy(Ligne,2,length(Ligne));
         if (ListeTermes.IndexOf(Terme) <> -1) then Trouve:=true;
      end;
   end;

   Self.Memo1.Lines.Clear;
   if Trouve then
     Self.Caption:=ListeTermes[0] // 1er mot
   else
     Self.Caption:=Terme;  
   ListeTermes.Free;

   Fini:=false;
   if Trouve then
     while not eof(f) and not Fini do
     begin
        readln(f,Ligne);
        if (Ligne <> '') and (Ligne[1] = CarGlossaire) then
          Fini:=true
        else
          Self.Memo1.Lines.Add(Ligne);
     end;

   CloseFile(f);
   Self.Show;
end;

procedure TFormDefinition.FormPaint(Sender: TObject);
begin
 SetFocus;
end;

end.
