 unit TreeCLGR;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CustomGraph, GraphControlTreeCL, Grids, MyNewgrid,fenarbre,
  ExtCtrls, Buttons,typedef,listarray2, Menus,FenEtatCarac,Donnees;

type
  TFormArbre = class(TForm)
    GCT1: TGraphControlTreeCL;
    Splitter1: TSplitter;
    panel1: TPanel;
    GroupBox1: TGroupBox;
    LongTot: TEdit;
    LongPart: TEdit;
    Label4: TLabel;
    Panel2: TPanel;
    zoommois: TSpeedButton;
    zoomplus: TSpeedButton;
    Label3: TLabel;
    ouvrircode: TOpenDialog;
    annuler: TSpeedButton;
    normal: TSpeedButton;
    pivoter: TSpeedButton;
    Enraciner: TSpeedButton;
    TabGrid1: TTabGrid;
    PopupMenu1: TPopupMenu;
    Code: TMenuItem;
    Optionslegendes: TMenuItem;
    Splitter2: TSplitter;
    SpeedButton1: TSpeedButton;
    Legendes: TSpeedButton;
    Panel3: TPanel;
    ScrollBox1: TScrollBox;
    LabelCarac: TLabel;
    Fontedestaxons1: TMenuItem;
    FontDialog1: TFontDialog;
    Afficherleslongueurs1: TMenuItem;
//    procedure Button2Click(Sender: TObject);
    procedure AfficheCodeColor(name:string);
    procedure AfficheAColor(etat:string; aColor:TColor; index:integer );
    procedure removelabel;
    procedure legendesClick(Sender: TObject);
    procedure TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GCT1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ActionClick(Sender: TObject);
    procedure OptionslegendesClick(Sender: TObject);
    procedure codeClick(Sender: TObject);
    procedure autoClick(Sender: TObject);
    procedure annulerClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure zoomplusClick(Sender: TObject);
    procedure zoommoisClick(Sender: TObject);
    procedure ChargeTabGrid(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure LoadTree(FileName:string);
    procedure SaveTree(FileName:string);
    function GetTabName(FileName:string):string;
    procedure GCT1RespClicDownRight(WPoint: TPoint);
    procedure GCT1BeforeInsert(sender: TObject);
    procedure Fontedestaxons1Click(Sender: TObject);
    procedure Afficherleslongueurs1Click(Sender: TObject); //rcupre le nom de la matrice associe  un arbre
  private
  NameOfFlagTaxonPro: string;
    { Dclarations prives }
  public
   ModeAfficheCarac :boolean ;

    { Dclarations publiques }
  end;

var
  FormArbre: TFormArbre;

implementation

uses optionleg, optioncode, code, PhylMain, PhylChoi, PhylTrier,group2,
  phylClasser;

{$R *.DFM}


{procedure TFormArbre.Button2Click(Sender: TObject);
begin
GCT1.InitTree(TabGrid1);
LongTot.Text:=intToStr(GCT1.TreeTotalLength);
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;   }


procedure TFormArbre.legendesClick(Sender: TObject);
begin
   if legendes.Tag=0 then
   begin
     legendes.Tag:=1;
     GCT1.TreePage.Flag_Legende:=true;
     GCT1.TreePage.CreateLeg;
     GCT1.TreePage.ChangeCoordGraphObjects;
     optionsLegendes.Enabled:=true;
   end
   else
     begin
      legendes.Tag:= 0;
      GCT1.TreePage.Flag_Legende:=false;
      GCT1.TreePage.DeleteLeg;
      optionslegendes.enabled:=false;
     end;
   GCT1.invalidate;
end;

procedure TFormArbre.removelabel;
var
i:integer;
Temp:TComponent;

begin
for I := ScrollBox1.ComponentCount - 1 downto 0 do
  begin
    Temp := ScrollBox1.Components[I];
    if (Temp is TControl) then
    begin
      ScrollBox1.RemoveComponent(Temp);
      Temp.free;
    end;
 end;
 LabelCarac.Caption:='';
end;

procedure TFormArbre.AfficheCodeColor(name:string);
var
compt,noRow,index,code : integer;
etat,codeStr : string;
aColor:TColor;

begin

compt:=2;
index:=0;


noRow:= GCT1.TabCod.IndexOfRow(name);

removelabel;
LabelCarac.Caption:=name;

ScrollBox1.invalidate;

while (compt <= (GCT1.TabCod.ColCount[noRow])) do
  begin

   etat:=GCT1.TabCod.StrItems[noRow,compt];
   if ((etat<>'') and (Trim(etat)<>''))     then
    begin
     codeStr:=GCT1.TabCod.StrItems[noRow,compt+1];
     code:=StrToInt(codeStr);
     aColor:=NodeColor[code+1];

     AfficheAColor(etat,aColor,index);
    end;
   index:=index+1;
   compt:=compt+2;
  end;
end;

procedure TFormArbre.AfficheAColor(etat:string; aColor:TColor; index:integer );
var
Instance1:TControl;
Instance2:TControl;

begin
Instance1:=TLabel.Create(ScrollBox1);
Instance1.parent:=ScrollBox1;
instance1.name:='';
instance1.top:=10+(index*10)+(index*20);
instance1.left:=10;
instance1.Height:=20;
instance1.width:=20;
(instance1 as TLabel).Color:=aColor;

Instance2:=TLabel.Create(ScrollBox1);
Instance2.parent:=ScrollBox1;
(instance2 as TLabel).Caption:=etat;
instance2.top:=10+(index*10)+(index*20);
instance2.left:=10+20+10;
end;


Procedure TFormArbre.TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
col,row :integer;
AName :string;
begin

TabGrid1.MouseToCell(X,Y,col,row);
if (row=0) and (col<>0) then     // selection des caractres
 begin
 // JFR modifie le 07/07/00 pour changer l'effet du bouton gauche et du bouton droit
 // Cette modification doit tre combine avec celle de MynewGrid ligne 674
  if (button=mbleft)  then
     begin
      if TabGrid1.InvalidateCol[col]=false then AName:=''
        else AName:=TabGrid1.Cells[col,row];
          if AName='' then  begin
            if GCT1.TreePage.Flag_Legende=true then
              begin
                GCT1.TreePage.Flag_Legende:=false ;
                GCT1.TreePage.DeleteLeg;
              end ;
             legendes.Enabled:=False ;
             OptionsLegendes.Enabled:=false;
          end
          else legendes.Enabled:=True;

         
           GCT1.OnChangeSelectCarac(AName);
           GCT1.invalidate;
           LongTot.Text:=intToStr(GCT1.TreeTotalLength);
           LongPart.Text:=intToStr(GCT1.TreeUnitLength);

           if AName='' then removelabel
           else AfficheCodeColor(AName);

           ScrollBox1.Invalidate;


      end
    else
   begin
     if TabGrid1.SelectCol[col]=false then AName:=''
      else AName:=TabGrid1.Cells[col,row];

     if AName='' then
      begin
      if GCT1.TreePage.Flag_Legende=true then
        begin
          GCT1.TreePage.Flag_Legende:=false ;
          GCT1.TreePage.DeleteLeg;
//          legendes.Caption:='Afficher';
        end ;
       legendes.Enabled:=False ;
      end
    else legendes.Enabled:=True;

    GCT1.OnChangeListCarac(nil, AName);
    GCT1.invalidate;

   removelabel ;

   LongTot.Text:=intToStr(GCT1.TreeTotalLength);
   LongPart.Text:=intToStr(GCT1.TreeUnitLength);
 end; end;

if (row<>0) and (col=0) then
 begin
  AName:=TabGrid1.Cells[col,row];
    If (EnleverTaxon = 'non') then exit;
// le clic a eu lieu sur une cellule slectionne mais il la dselectionne  automatiquement
  if TabGrid1.SelectRow[row]=false then
   begin
     if TabGrid1.canDeselectRow(1)=false then    // jfr modifie le 28 septembre 2001
       begin                                     // pour empecher la dselection quand il ne reste plus que 2 taxons dans l'arbre
       Tabgrid1.SelectRow[row]:=true;            // Rappel la fonction Selfmousedown de myNewgrid qui est appele avant celle ci
       Tabgrid1.MyInvalidateCell(col,row);       // a dselectionn automatiquement la cellule; il faut donc la reselectionner
       exit;                                     //   Pour cette raison aussi on appelle canDeselectRow(1) et non pas (2) 
       end;
      GCT1.DeleteTaxon(AName);
     LongTot.Text:=intToStr(GCT1.TreeTotalLength);
     LongPart.Text:=intToStr(GCT1.TreeUnitLength);

   end
     else  // le clic a eu lieu sur une cellule non selectionne au dpart
      begin
       if GCT1.NameOfFlagTaxonPro='' then
        begin
         GCT1.AddTaxonPro(AName);
         NameOfFlagTaxonPro:=AName;
         TabGrid1. SelectRow[row]:=False;
         // La cellule reste dselectionne tant que le taxon provisoire n'est pas rajout
        end;
        TabGrid1. SelectRow[row]:=False;
      end;
  end;
end;



//******************************************************************************/

procedure TFormArbre.GCT1MouseUp(Sender: TObject; Button: TMouseButton;
                              Shift: TShiftState; X, Y: Integer);
var
  row :integer;
begin
// La deuxime condition traduit le fait que le greffage russi d'un taxon
// provisoire conduit  sa suppression
LongPart.Text:=intToStr(GCT1.TreeUnitLength);
LongTot.Text:=intToStr(GCT1.TreeTotalLength);

end;

//******************************************************************************/
procedure TFormArbre.ActionClick(Sender: TObject);
begin
  if sender = enraciner
        then GCT1.OnFlagRoot
  else if sender =pivoter
        then GCT1.OnFlagSwap
  else if sender = normal
        then GCT1.OnFlagNormal;
end;

//******************************************************************************/

procedure TFormArbre.OptionslegendesClick(Sender: TObject);
var
res :integer;
begin
 case GCT1.TreePage.TypeEtat  of
  NEtatDown :FicheOptionLeg.EtatDownRadio.Checked:=true;
  NEtatUp : FicheOptionLeg.EtatUpRadio.Checked:=true;
  NEtatMPR : FicheOptionLeg.EtatMPRRadio.Checked:=true;
  end;

  case GCT1.TreePage.TypeLegende  of
   texte :FicheOptionLeg.TexteRadio.Checked:=true;
   codeL : FicheOptionLeg.codeRadio.Checked:=true;
  end;

 res:=FicheOptionLeg.showModal;

 if res<>mrcancel then
 begin

  if  FicheOptionLeg.EtatDownRadio.Checked=true then GCT1.TreePage.TypeEtat := NEtatDown
  else if  FicheOptionLeg.EtatUpRadio.Checked=true  then GCT1.TreePage.TypeEtat := NEtatUp
  else if  FicheOptionLeg.EtatMPRRadio.Checked=true then GCT1.TreePage.TypeEtat :=  NEtatMPR;

  if FicheOptionLeg.TexteRadio.Checked=true then GCT1.TreePage.TypeLegende := texte
  else if FicheOptionLeg.codeRadio.Checked=true  then GCT1.TreePage.TypeLegende := codeL;

  GCT1.TreePage.DeleteLeg;
  GCT1.TreePage.CreateLeg;
  GCT1.TreePage.ChangeCoordGraphObjects;

  GCT1.Invalidate;
 end;

 end;
//******************************************************************************/

procedure TFormArbre.codeClick(Sender: TObject);
var
res,rescod,compt,No :integer;
newtabcod :TstrListArray;
begin
 rescod:=mrcancel;
 res:=FicheOptioncode.showModal;
 if res<>mrcancel then
  begin
    if FicheOptionCode.ouvrirbouton.Checked=true then
      begin
       if ouvrircode.execute then
          begin
           FicheCode.Codegrid1.LoadfromFile(ouvrircode.filename);
           rescod:=FicheCode.ShowModal;
          end;
      end
     else   // On utilise le fichier de codage cr par dfaut
      begin
          FicheCode.Codegrid1.cells[0,0]:='CARACTERE';
          FicheCode.Codegrid1.cells[1,0]:='TYPE';

          compt:=2; No:=1;
          while (compt <= GCT1.TabCod.ColCount[0]) do
           begin
             FicheCode.Codegrid1.cells[compt,0]:='ETAT'+IntToStr(No);
             FicheCode.Codegrid1.cells[compt+1,0]:='CODE'+IntToStr(No);
           compt:=compt+2;
           No:=No+1;
           end;
          FicheCode.Codegrid1.CopyFromAListArray(0,1,GCT1.TabCod);

          rescod:=FicheCode.ShowModal;
      end;
   if rescod<>mrcancel then
     begin
      newtabcod:=TstrListArray.createListArray;
      FicheCode.Codegrid1.CopyToAListArray(0,1,newtabcod);
      GCT1.OnChangeTabCod(newtabcod);
      LongTot.Text:=intToStr(GCT1.TreeTotalLength);
      LongPart.Text:=intToStr(GCT1.TreeUnitLength);
      end;
  end;

end;

procedure TFormArbre.autoClick(Sender: TObject);
begin
 GCT1.OnChangeAuto;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.annulerClick(Sender: TObject);
begin
 GCT1.UndoTreeAction;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

procedure TFormArbre.FormCreate(Sender: TObject);
begin
NameOfFlagTaxonPro:='';
ModeAfficheCarac:=true ;
Panel2.Left:=Screen.Width-Panel2.Width-10; // Outils  droite de l'cran
GroupBox1.Left:=Screen.Width-GroupBox1.Width-10; // GroupBox aussi
FormPrinc.Fille(Self);
end;

procedure TFormArbre.zoomplusClick(Sender: TObject);
begin
GCT1.OnChangeScale('plus');
end;

procedure TFormArbre.zoommoisClick(Sender: TObject);
begin
GCT1.OnChangeScale('moins');
end;

procedure TFormArbre.ChargeTabGrid(Sender: TObject);
{ DL 10/02/99 correspond  arbreclick pour JFR}

var
ListArray:TStrListArray;
TreeGroup:TTreeGroup;
begin
   ListArray:=TStrListArray.createlistArray;
if FormPrinc.AClasse<>nil then
 begin
  FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);
// ajout DL 20/02/98
   TabGrid1.RowCount:=FormChoisir.TabGrid1.RowCount;
   TabGrid1.ColCount:=FormChoisir.TabGrid1.ColCount;
  TabGrid1.copyFromAlistArray(0,0,ListArray);
  TabGrid1.SelectAllRow(true);
  FormClasser.TabGrid1.CopyListSelectCol(TabGrid1.ListSelectCol);
   TabGrid1.Invalidate;
     // jfr modifie le 19/12/05 pour le nouveau tri par boite
  GCT1.InitTreeBoite(TabGrid1,FormClasser.GraphTri21.treeBoite);            // jfr modifie le 10/09/00   avant : formTri.tabgrid1
 end
 else
if FormPrinc.ATri<>nil then
 begin
  FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);
// ajout DL 20/02/98
   TabGrid1.RowCount:=FormChoisir.TabGrid1.RowCount;
   TabGrid1.ColCount:=FormChoisir.TabGrid1.ColCount;
  TabGrid1.copyFromAlistArray(0,0,ListArray);
  TabGrid1.SelectAllRow(true);
  FormTri.TabGrid1.CopyListSelectCol(TabGrid1.ListSelectCol);
   TabGrid1.Invalidate;
  TreeGroup:=TTreeGroup(FormTri.GraphTri1.Model);  // jfr modifie le 19/12/05 pour le nouveau tri par boite
  GCT1.InitTreeGroup(TabGrid1,TreeGroup);            // jfr modifie le 10/09/00   avant : formTri.tabgrid1
 end
 else
 begin
  FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);
// ajout DL 20/02/98
   TabGrid1.RowCount:=FormChoisir.TabGrid1.RowCount;
   TabGrid1.ColCount:=FormChoisir.TabGrid1.ColCount;

   TabGrid1.copyFromAlistArray(0,0,ListArray);

    TabGrid1.SelectAllCol(true);
    TabGrid1.SelectAllRow(true);

    GCT1.InitTree(TabGrid1);
 end;
    LongTot.Text:=intToStr(GCT1.TreeTotalLength);
  LongPart.Text:=intToStr(GCT1.TreeUnitLength);

  ListArray.free;
end;

procedure TFormArbre.SpeedButton1Click(Sender: TObject);
begin
 GCT1.FirstTreeAction;
 LongTot.Text:=intToStr(GCT1.TreeTotalLength);
 LongPart.Text:=intToStr(GCT1.TreeUnitLength);
end;

function TFormArbre.GetTabName(FileName: string): string;
//rcupre le nom de la matrice associe  un arbre
// on peut sans doute faire mieux
var
  strlist:TStringList;
  data: TFileStream;
begin
  try
    strlist:=TStringlist.Create;
    data:=TFileStream.Create(filename,fmOpenRead);
    data.seek(0,0);
    Strlist.loadfromstream(data);
    GetTabName:= ExtractFilePath(filename)+StrList.strings[0];
  finally
    strlist.free;
    data.free;
  end;
end;

procedure TFormArbre.LoadTree(FileName:string);
var
strlist:TStringList;
data: TFileStream;
strTree : string;
FicTab: string;
begin
  data:=NIL;
  strlist:=nil;
  try
    strlist:=TStringlist.Create;
    data:=TFileStream.Create(filename,fmOpenRead);

    data.seek(0,0);
    Strlist.loadfromstream(data);
    strtree:= StrList.strings[1];
    GCT1.OnChangeTree(strTree);
  finally
  strlist.free;
  data.free;
  end;
end;

procedure TFormArbre.SaveTree(FileName:string);
 begin
  // jfr modifie le 10/04/00
  // voir PhylMain
end;

// jfr modifie le 10/04/00
// Fonction ajoute
procedure TFormArbre.GCT1RespClicDownRight(WPoint: TPoint);
var
res  :integer;
newtabcod :TstrListArray;
begin

if ((GCT1.ClicDownObject is TLegende)=false) then     // jfr modifie le 29/04/02 la condition a t rajout
  begin
 newtabcod:=GCT1.TreePage.CreateListCarac(TGraphNode(GCT1.ClicDownObject));
 FicheEtatCarac.CaracGrid1.CopyFromAListArray(0,1,newTabCod);
 res:=FicheEtatCarac.showModal;
 end;
 
end;

procedure TFormArbre.GCT1BeforeInsert(sender: TObject);  // attention  la date de modification
var
row:integer;
begin
if (NameOfFlagTaxonPro<>'') {and (GCT1.NameOfFlagTaxonPro='') }then
 begin
  row:=TabGrid1.IndexOfRow(NameOfFlagTaxonPro);
  if row<>-1 then
   begin

    TabGrid1. SelectRow[row]:=true;
    TabGrid1.MyInvalidateCell(0,row);
    GCT1.AddTaxonToDataList(row);
    end;
   NameOfFlagTaxonPro:='';
 end;

end;

// jfr modifie octobre 2001 : procedure rajoute
procedure TFormArbre.Fontedestaxons1Click(Sender: TObject);
var
essai:string ;
begin
    if FontDialog1.execute then begin
    essai:= FontDialog1.Font.Name;
    GCT1.Treepage.FFontTaxon.lfHeight:=FontDialog1.Font.Height;
    if (fsItalic in FontDialog1.Font.style) then GCT1.Treepage.FFontTaxon.lfItalic := 1
    else  GCT1.Treepage.FFontTaxon.lfItalic := 0;

    if (fsBold in FontDialog1.Font.style) then GCT1.Treepage.FFontTaxon.lfweight:= FW_BOLD
    else  GCT1.Treepage.FFontTaxon.lfweight:= FW_NORMAL;

    if (fsUnderline in FontDialog1.Font.style) then GCT1.Treepage.FFontTaxon.lfUnderline := 1
    else  GCT1.Treepage.FFontTaxon.lfUnderline := 0;

    strPCopy(GCT1.Treepage.FFontTaxon.lfFaceName,essai);
    GCT1.Treepage.DeleteObjects;
    GCT1.Treepage.ChangeInfoGraph ;
    GCT1.invalidate;
    end;
end;

procedure TFormArbre.Afficherleslongueurs1Click(Sender: TObject);
begin
if (GroupBox1.Visible=false) then
begin
    GroupBox1.visible:=true;
     Afficherleslongueurs1.Caption:='Masquer les longueurs';
 end
 else begin
     GroupBox1.visible:=false;
     Afficherleslongueurs1.Caption:='Afficher les longueurs';
 end
end;

end.

