unit boitebis;

interface

uses
  SysUtils,Classes,listarray2,GraphObject;


type
TNodeBoiteG =class;

TNodeBoite = class(TObject)
  public

 nodeAssocG : TnodeBoiteG;
 nodeChilds : TList;
 nodeParent : TNodeBoite ;
 niveau : integer ;

 taxons : TStringList;
 taxonsLibres : TStringList;

 caracteres : TStringList;
 premier_caractere : String ;

 constructor create ;
 destructor Destroy; override;
 function Inclut(nodep : TNodeBoite) : boolean;
 function IntersectIncomplet(nodef : TNodeBoite) : boolean;
 function getIndex(): integer;
 function defineNiveau() : integer;
 function getChild(index:integer):TNodeBoite;
 function getFrereGauche(): TNodeBoite;
 function ChildsIntersectIncomplet(nodep : TNodeBoite) : boolean;
 function  egal(nodep : TNodeBoite) : boolean;
 procedure  arrangeFilsDuPere(nodePere :TNodeBoite) ;
 procedure  CreerTaxonsLibres();
  
 procedure DeleteNodeG();
 procedure creerNodeG();

 end;

//*****************************************************************************/
 TTreeBoite = class(TObject)
  public

 root:TNodeBoite;
 lastNode : TnodeBoite;
 tabdata :TStrListArray;
 nodeTemp :TNodeBoite;

 niveauxDefinis :boolean ;
 niveauxDefinisG :boolean ;

constructor createBoite;

procedure  defineNodelevelG(aNodeG : TNodeBoiteG);
procedure  defineNodelevel(aNode : TNodeBoite);

procedure  annuleNodelevel(aNode : TNodeBoite);
procedure  annulerNiveaux();

procedure  annuleNodelevelG(aNodeG : TNodeBoiteG);
procedure  annulerNiveauxG();

procedure definirNiveaux()  ;
procedure definirNiveauxG()  ;

procedure  CreerNodeG();
procedure  CreerNodeGraphique( aNode:TNodeBoite);

procedure  DeleteNodeG();
procedure  DeleteNodeGraphique( aNode:TNodeBoite);
 
procedure CreerNodeTaxonsLibres( aNode:TNodeBoite );
procedure  CreerTaxonsLibres();
function ajouter_un_tri(caractere : String):boolean  ;
function enlever_un_tri(caractere : String):boolean ;
 function dernier_noeud_qui_inclut(newnode : TNodeBoite): TNodeBoite;
 function   getFirstNode(aNode:TNodeBoite ; caractere :String): TNodeBoite;
// Utilise pour la rcursion
 function   FirstNode( aNode :TNodeBoite ; caractere: String  ): TNodeBoite;
 procedure dni( nodep : TNodeBoite ; newnode : TNodeBoite);

end;


//*****************************************************************************/
TNodeBoiteG = class (TGraphObject)

   public
    nodeAssoc : TnodeBoite;
    larg : integer;
    haut : integer;

    nodeChildsG : TList;
    nodeParentG : TNodeBoiteG ;
    niveauG : integer ;
    taxonsG :TStringList;

    constructor create ;
    destructor Destroy; override;
    function defineNiveauG() : integer;
   end;

//*****************************************************************************/
//*****************************************************************************/

implementation
  
constructor TNodeBoite.create;
 begin
  nodeChilds:=Tlist.Create;
  taxons :=TStringList.Create;
  taxonslibres:= TStringList.Create;

  caracteres := TStringList.Create;

  nodeparent:=nil ;
  niveau := 0;
  end;

destructor TNodeBoite.Destroy;
begin
 nodeChilds.free;

 taxons.Free;
 taxonsLibres.Free;
 caracteres.Free;
 inherited destroy;
 end;


procedure TNodeBoite.CreerTaxonsLibres();
  var
   taxon, taxonf:  string;
   nodef :TNodeBoite;
   i,j,k  :integer;
   trouve : boolean;
   taxLibres :TStringList;
   begin
      taxLibres := TStringList.Create;
      for i:=0 to taxons.count-1 do
         taxLibres.Add(taxons[i]);
       for i:=0 to taxLibres.count-1 do
          begin
           taxon:= taxLibres[i];
               for j:=0 to nodechilds.count-1 do
                  begin
                    nodef := TNodeBoite( nodeChilds.Items[j])  ;
                     for k:=0 to nodef.taxons.count-1 do
                       begin
                           taxonf := nodef.taxons[k] ;
                           if ((taxon <> '') and (taxonf <> '') and (taxon = taxonf))then
                               begin
                                taxLibres[i]:= '';
                                break;
                               end;
                        end;
                    end;
           end;
         taxonsLibres.Clear;
         for i:=0 to taxLibres.count-1 do
          begin
            taxon:= taxLibres[i];
            if (taxon <> '') then taxonsLibres.add(taxon);
           end;
     taxLibres.Free;      
    end;

function TNodeBoite.IntersectIncomplet(nodef : TNodeBoite) : boolean;
var
 taxon, taxonf:  string;
 nb, nbf :integer;
 i,j,nbIntersect :integer;
 trouve : boolean;
 begin
  result:=true;
  nb:=taxons.Count;
  nbf := nodef.taxons.Count;
  nbIntersect :=0;

    for j:=0 to nbf-1 do
        begin
         taxonf := nodef.taxons[j] ;
         trouve :=false;
           for i:=0 to nb-1 do
             begin
               taxon := taxons[i] ;
               if ((taxon <> '') and (taxonf <> '') and (taxon = taxonf))then
                   begin
                    trouve := true ;
                    break;
                   end;
             end;
           if (trouve = true) then
                 begin
                   nbIntersect := nbIntersect +1;
                 end;
        end;
   if (nbIntersect = nbf) or (nbIntersect = 0) then result :=false
 end;

 // on a cr un noeud provisoire qui est totalement inclu dans son noeud pere mais
 // il n'est pas encore le fils de son pre
 // et on vrifie que ce noeud n'a pas d'intersection incomplete avec des noeuds fils dj existant

 function TNodeBoite.ChildsIntersectIncomplet(nodep : TNodeBoite) : boolean;
var

 nb  :integer;
 i   :integer;
 trouve : boolean;
 nodef : TNodeBoite   ;
 begin
      result := false;
      nb := nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                    nodef := TNodeBoite( nodeChilds.Items[i])  ;
                       if (nodef <> nil)  then
                        begin
                           trouve:=nodep.IntersectIncomplet(nodef)  ;
                              if (trouve = true) then
                                 begin
                                   result := true;
                                   break;
                                  end;
                         end;

                 end;
           end;
 end;

function TNodeBoite.egal(nodep : TNodeBoite) : boolean;
var
 taxon, taxonp:  string;
 nb, nbp :integer;
 i,j :integer;
 trouve : boolean;
 begin
  result:=true;
  nb:=taxons.Count;
  nbp := nodep.taxons.Count;
  if (nb <> nbp)then   result := false 
  else
    begin
    result := true;
      for j:=0 to nbp-1 do
        begin
         taxonp := nodep.taxons[j] ;
         trouve :=false;
          for i:=0 to nb-1 do
            begin
              taxon := taxons[i] ;
              if ((taxon <> '') and (taxonp <> '') and (taxon = taxonp))
                 then begin trouve :=true ;  break; end;
            end;
         if (trouve = false) then begin result:=false ; break; end;
        end;
     end;
 end;

 function TNodeBoite.Inclut(nodep : TNodeBoite) : boolean;
var
 taxon, taxonp:  string;
 nb, nbp :integer;
 i,j :integer;
 trouve : boolean;
 begin
   result:=false;
  nb:=taxons.Count;
  nbp := nodep.taxons.Count;
  if ((nb >= nbp) and (nb>0)) then
    begin
    result := true;
      for j:=0 to nbp-1 do
        begin
         taxonp := nodep.taxons[j] ;
         trouve :=false;
          for i:=0 to nb-1 do
            begin
              taxon := taxons[i] ;
              if ((taxon <> '') and (taxonp <> '') and (taxon = taxonp))
                 then trouve :=true ;
            end;
         if (trouve = false) then begin result:=false ; break; end;
        end;
     end;
 end;


procedure TNodeBoite.arrangeFilsDuPere(nodePere :TNodeBoite) ;
var
nodef :  TNodeBoite;
 nb,i: integer;
begin
 
  nb := nodePere.nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   nodef := TNodeBoite( nodePere.nodeChilds.Items[i])  ;
                   if (self.inclut(nodef)=true) then
                     begin
                       nodePere.nodeChilds.Items[i]:=nil;
                       nodef.nodeParent :=self;
                       self.nodeChilds.add(nodef)
                     end;
                  end;
            end;
nodePere.nodeChilds.pack;
end;

function TNodeBoite.defineNiveau() : integer;
var
node :  TNodeBoite;
niveauT,nb,i: integer;
begin
 result:=0;
 niveauT := 0;

   nb := nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   node := TNodeBoite( nodeChilds.Items[i])  ;
                    if ((node <> nil) and (node.niveau <> 0)) then
                      begin
                      if (nb=1) then  niveauT := niveauT + node.niveau +1
                      else niveauT := niveauT + node.niveau ;
                      end
                    else begin niveauT := 0 ; break; end;
                 end;
           end ;
          result := niveauT;
end;

function TNodeBoiteG.defineNiveauG() : integer;
var
nodeG :  TNodeBoiteG;
niveauT,nb,i: integer;

begin
 result:=0;
 niveauT := 0;

   nb := nodeChildsG.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   nodeG := TNodeBoiteG( nodeChildsG.Items[i])  ;
                    if ((nodeG <> nil) and (nodeG.niveauG <> 0)) then
                      begin
                       niveauT := niveauT + nodeG.niveauG ;
                      end
                    else begin niveauT := 0 ; break; end;
                 end;
           end ;
          result := niveauT;
end;

function TNodeBoite.getIndex():integer;
var
   parent :TNodeBoite;
   node :  TNodeBoite;
   nb,i:integer;
begin
  result:=-1;
     if  nodeParent <> NIL   then
        begin
        nb:=nodeParent.nodeChilds.count ;
        if nb>0  then
          begin
           for i:=0 to nb-1 do
              begin
               node:=TNodeBoite(nodeParent.nodeChilds.Items[i]);
               if (node <> nil) and (node = Self) then
                 begin
                   result := i;
                   break;
                 end;
               end;
           end;
         end;
end;

function TNodeBoite.getChild(index:integer): TNodeBoite;
var
  node :  TNodeBoite;
   nb :integer;
begin
  result:=nil;
  nb := nodeChilds.count ;
        if (nb>0) and (index<nb)  then
         result:=TNodeBoite( nodeChilds.Items[index]);
end;

function TNodeBoite.getFrereGauche(): TNodeBoite;
var
  node :  TNodeBoite;
   index,nb :integer;
begin
  result:=nil;
  index :=getIndex();
  if (index > 0) then
   begin
      if  nodeParent <> NIL   then
         result:=nodeParent.getChild(index-1);
   end;      
end;

//**********************************************************************************/
//Cration des noeuds graphiques : elle se fait  partir des noeuds normaux. Si un noeud a des taxons libres
// alors un noeud est cr sans quivalent

procedure TnodeBoite.DeleteNodeG();
var
 nodeG, nodeGF : TNodeBoiteG ;
   begin

     nodeG :=  nodeAssocG ;
     if (nodeG <> nil) then
     begin
       if ( taxonsLibres.count>0) then
         begin
           nodeGF := nodeG.nodeChildsG.Items[0];
            nodeGF.Free ;
        end;
      nodeG.Free;
     end;
     nodeAssocG := nil ;
 end;

//*****************************************************************************/
//**********************************************************************************/


constructor TTreeBoite.createBoite;
 begin

 root:=nil ;
 lastNode:=nil;
 niveauxDefinis:=false;
end;

procedure TTreeBoite.CreerNodeG();
begin
 CreerNodeGraphique(root);
 end;

procedure TTreeBoite.DeleteNodeG();
begin
 DeleteNodeGraphique(root);
 end;

procedure TTreeBoite.DeleteNodeGraphique( aNode:TNodeBoite);
 var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.deleteNodeG();
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then DeleteNodeGraphique(nodef);
      end;
  end;

procedure TTreeBoite.CreerNodeGraphique( aNode:TNodeBoite);
 var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.creerNodeG();
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then CreerNodeGraphique(nodef);
      end;
  end;

procedure TTreeBoite.CreerTaxonsLibres();
begin
 CreerNodeTaxonsLibres(root);
 end;

procedure TTreeBoite.CreerNodeTaxonsLibres(aNode : TNodeBoite);
var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.creerTaxonsLibres();
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then CreerNodeTaxonsLibres(nodef);
      end;
  end;

procedure TTreeBoite.annuleNodelevel(aNode : TNodeBoite);
var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.Niveau:=0;
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
         annuleNodelevel(nodef);
      end;
  end;

procedure TTreeBoite.annulerNiveaux();
 begin
  niveauxDefinis:=false;
  annuleNodeLevel(root);
 end;

procedure TTreeBoite.annuleNodelevelG(aNodeG : TNodeBoiteG);
var
  j :integer;
  nodefG :TNodeBoiteG;
  begin
  anodeG.NiveauG:=0;
   for j:=0 to anodeG.nodechildsG.Count-1 do
      begin
         nodefG := TnodeBoiteG(anodeG.nodechildsG.items[j]) ;
         annuleNodelevelG(nodefG);
      end;
  end;

procedure TTreeBoite.annulerNiveauxG();
 begin
  niveauxDefinisG:=false;
  annuleNodeLevelG(root.nodeAssocG);
 end;

procedure TTreeBoite.defineNodelevel(aNode : TNodeBoite);
var
  ret,j :integer;
  nodef :TNodeBoite;
 begin
   if (aNode.niveau=0) then
    begin
       if (anode.nodeChilds.count=0) then anode.niveau:=1
       else
         begin
           ret:=anode.defineNiveau();
           if (ret>0) then
             anode.niveau:=ret
           else begin
             niveauxDefinis:=false;
             for j:=0 to anode.nodechilds.Count-1 do
               begin
                nodef := TnodeBoite(anode.nodechilds.items[j]) ;
                defineNodelevel(nodef);
                end;
            end;
          end;
      end;
 end;

procedure TTreeBoite.defineNodelevelG(aNodeG : TNodeBoiteG);
var
  ret,j :integer;
  nodefG :TNodeBoiteG;
 begin
   if (aNodeG.niveauG=0) then
    begin
       if (anodeG.nodeChildsG.count=0) then anodeG.niveauG:=1
       else
         begin
           ret:=anodeG.defineNiveauG();
           if (ret>0) then
             anodeG.niveauG:=ret
           else begin
             niveauxDefinisG:=false;
             for j:=0 to anodeG.nodechildsG.Count-1 do
               begin
                nodefG := TnodeBoiteG(anodeG.nodechildsG.items[j]) ;
                defineNodelevelG(nodefG);
                end;
            end;
          end;
      end;
 end;

procedure TTreeBoite.definirNiveaux();
 begin
  niveauxDefinis:=false ;
   while(niveauxDefinis=false) do
     begin
       niveauxDefinis:= true;
       defineNodelevel(root);
     end;
end;

procedure TTreeBoite.definirNiveauxG();
 begin
  niveauxDefinisG:=false ;
   while(niveauxDefinisG=false) do
     begin
       niveauxDefinisG:= true;
       defineNodelevelG(root.nodeAssocG);
     end;
end;

//***************************************************************************************/
// Fonction qui retourne le premier noeud qui contient le caractere "caractere"
 function  TTreeBoite.getFirstNode(aNode:TNodeBoite ; caractere :String): TNodeBoite;
   begin
     nodeTemp:=nil;
     FirstNode(aNode, caractere);
     result:= nodeTemp;
   end;

// Utilise pour la rcursion
 function  TTreeBoite. FirstNode( aNode :TNodeBoite ; caractere: String  ): TNodeBoite;
  var
  nodename :String  ;
  index ,j :integer;
  NodeF :TNodeBoite ;
    begin
       index:= aNode.caracteres.indexof(caractere);
               if (index>=0) then
                 begin
                  if (nodeTemp=nil) then begin nodeTemp :=aNode;
                                               result:= nodeTemp;
                                          end ;
                  end
               else
               begin
                 for  j := 0 to aNode.nodeChilds.count-1 do
                   begin
                     if (nodeTemp<> nil)then break;
                      nodeF := TNodeBoite( aNode.nodeChilds.Items[j]);;
                      FirstNode(nodeF,caractere);
                     end;
                end;
  result:=nodeTemp;
  end;

function TTreeBoite.enlever_un_tri(caractere : String):boolean ;
var
node, nodeP, nodeF : TnodeBoite ;
index,i : integer;
begin
result := false;
  node := getFirstNode(root, caractere);
  if (node <> nil) then
    begin
      nodeP := node.nodeParent;
      if (nodeP <> nil) then
        begin
          result := true;
          try
          index := nodeP.nodeChilds.Remove(node);
          for i:=0 to node.nodechilds.count-1 do
             begin
               nodeF := node.nodechilds.items[i];
               nodeP.nodeChilds.Insert(index+i,nodeF);
               nodeF.nodeParent:=nodeP;
             end;
          except
           result := false;
          end; 
        end;

    end;
  node.Free;
end;

function TTreeBoite.ajouter_un_tri(caractere : String) :  boolean;
var
row,col, nb, i :integer;
taxon ,carac: String ;
node, nodeP : TNodeBoite ;
begin
result :=false;
node := TNodeBoite.create;
col :=  tabdata.IndexOfCol(caractere);
nb := tabdata.rowcount;
  for i:=1 to nb-1 do
    begin
        carac := tabdata.strItems[ i,col];
        if (carac <> '') then begin
         carac := lowercase(trim(carac));
         if (( carac = 'present') or ( carac = 'prsent')) then node.taxons.add(tabdata.strItems[ i,0]) ;
          end;
    end;
 if (node.taxons.Count>0) then
    begin
     node.caracteres.Add(caractere);
     nodeP :=  dernier_noeud_qui_inclut(node);
     // le dernier noeud qui inclut peut tre gal en "taxon" au noeud pere
     // si un des fils du futur pere contient en partie le nouveau noeud, il y a erreur
     if (nodeP.childsintersectIncomplet(node) = true) then  result:=false 
     else begin
          result:=true;
          if (node.egal(nodeP) = true ) then
           begin
            if (nodeP.caracteres.IndexOf(caractere)= -1)
              then nodeP.caracteres.Add(caractere) 
              else result:=false;
           end
          else
             begin
                 node.premier_caractere:=caractere;
                 // On regarde si les fils du futur pere ne sont pas inclus dans le nouveau noeud
                 // auquel cas on modifie la hirarchie
                 node.arrangeFilsDuPere(nodeP);
                 nodeP.nodeChilds.Add(node);
                 node.nodeParent := nodeP ;
              end;
          end;
     end;
end;



function TTreeBoite.dernier_noeud_qui_inclut(newnode : TNodeBoite): TNodeBoite;
begin
 lastNode := nil;
 dni(root,newnode);
 result:= lastNode;
end;

procedure TTreeBoite.dni( nodep : TNodeBoite ; newnode : TNodeBoite);
 var
 i,nb:integer;
 nodefils : TNodeBoite;
 begin
  if (nodep.Inclut(newnode)) then
   begin
   lastNode:=nodep;
    nb := nodep.nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
               begin
                 nodefils := TNodeBoite( nodep.nodeChilds.Items[i])  ;
                 if (nodefils <> nil)  then dni(nodefils,newnode);
               end;
            end;
   end;
 end;

//****************************************************************************/
constructor TNodeBoiteG.create;
 begin
  nodeChildsG:=Tlist.Create;
  nodeparentG:=nil ;
  niveauG := 0;
  end;

destructor TNodeBoiteG.Destroy;
begin
 nodeChildsG.free;
 inherited destroy;
 end;



end.
 