// DLL d'alignement multiple d'aprs clustal V, pour Anagne
// Erik Boucher de Crvecoeur - CNDP - 1996
// Ren Piquemal - avril 2000 - version 2 de Anagne d'aprs clustal W 1.8
// Erik Boucher de Crvecoeur - aout 2000 - correction d'un bug connu de clustal W 1.8

#include <stdio.h>
#include <string.h>
#include <windows.h>

#include "general.h"
#include "alig.h"
#include "def_param.h"	// paramtres par dfaut ****************************

// NUMRES repris de clustalw.h
#define NUMRES		32		/* max size of comparison matrix */

/* le chemin d'accs du fichier temporaire du dendrogramme */
char fichier_temporaire[FILENAMELEN+1];

// prototypes

extern void align(char *);

extern void init_interface(void);
extern void init_matrix(void);
extern void fill_chartab(void);

extern void alloc_aln(sint nseqs);
extern void free_aln(sint nseqs);

void alloc_seq(sint seq_no,sint length);
void free_seq(sint seq_no);

extern void *ckalloc(size_t);
extern void *ckfree(void *);
extern void p_encode(char *, char *, sint);
extern void n_encode(char *, char *, sint);

void FAR PASCAL InitAlign(char far *, int, int, int);
void FAR PASCAL DonneeAlign(int, char far *);
int FAR PASCAL Aligner(HWND);
void FAR PASCAL ResultAlign(int, int, char far *);

void ch_to_tab(char far *);
void coder(int, char far *);
void decoder(int, char *);

BOOL FAR PASCAL fnDialog(HWND, WORD, WORD, LONG);
void Centrer(HWND);
void Centrer_Sur_Ecran(HWND);
int DoMessages_TestInterrupt();

// variables externes

extern sint max_aln_length;
extern sint max_names;
extern char **names,**titles;
extern char *amino_acid_codes;
extern char *res_cat1[], *res_cat2[];

extern sint max_aa;

extern Boolean	dnaflag;
extern sint		wind_gap, ktup, window, signif;		// int->sint
extern float	gap_open, gap_extend;				// int->float
extern float	pw_go_penalty, pw_ge_penalty;

extern int	nseqs,nblocks;
extern int	*seqlen_array;
extern char **seq_array;
extern char seqname[];

// variables

int Echapp;			// tmoin d'arret en cours
char Buffer[200];

HWND hDlg;			// handle boite de dialogue



//========================== DLLMAIN ====================================
HINSTANCE LibInst;

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
    switch( dwReason )
	{
		case DLL_PROCESS_ATTACH:
    	//*******************************
		// initialisations pour Aligner()
		//*******************************
		LibInst=hInstance;

		init_interface();
		init_matrix();
		fill_chartab();
	}

    return 1;
}
//=======================================================================



//=======================================================================
//================ ALIGNEMENT MULTIPLE ==================================
//=======================================================================

void FAR PASCAL InitAlign(char far *pathtemp,int P_nombre,int P_dna,int P_quick)
{
	//--- rcupration des paramtres ----------------------------
	nseqs      = P_nombre;			// nombre de squences < MAXN
	dnaflag    = P_dna;			// true si squences nucliques
	quick_pairalign = P_quick;		// true si on utilise la mthode rapide pour l'alignement
								// par paires, comme faisait Clustal V (moins prcis)

	// modification de quelques paramtres par dfaut
	output_tree_clustal   = TRUE;		// FALSE;
	output_tree_phylip    = FALSE;		// TRUE;
	output_tree_distances = FALSE;		// FALSE;

	// initialisation du chemin du fichier intermdiaire pour le Tree
	strcpy(fichier_temporaire,pathtemp);
	strcat(fichier_temporaire,"~align.tmp");
	// strcpy(phylip_name,filename);

	// les fonctions de sortie utilisent seqname pour extraire le rpertoire courant
	strcpy(seqname,fichier_temporaire);

	// initialisation des tableaux de squences
	alloc_aln(nseqs);
}


//================ FONCTION PRINCIPALE : ALIGNER ========================

int FAR PASCAL Aligner( HWND WinHandle )
{
	int i;

	// petites modifications avant de lancer l'alignement
	max_aln_length *=2;	// deux fois la squence la plus longue ???

	for(i=1;i<=nseqs;i++)	// c'est comme a dans le code ???
		if(seqlen_array[i]>max_aln_length)
			max_aln_length=seqlen_array[i];

	if (max_names<10) max_names = 10;

	//--- creation fenetre de patience ----------------------------
	Echapp=GetAsyncKeyState(VK_ESCAPE);	//initialise le testeur clavier
	Echapp=0;
	hDlg = CreateDialog(LibInst,(LPSTR)ALIG,WinHandle,(FARPROC)fnDialog);

	//--- traitement --------------------------------------
	align(fichier_temporaire);

	//--- Fin de la fenetre de patience ----------------------------
	DestroyWindow(hDlg);

	// on calcule la longueur du consensus
	int len=0;
	for(i=1;i<=nseqs;i++)
		if (len < seqlen_array[i]) len = seqlen_array[i];

	// retour
	if (Echapp) return(-1);	else return(len);

	//****************************************************
	// NB : le cleanup est fait  la fin de ResultAlign()
	//****************************************************
}


// ============ GESTION DES CHAINES DE SEQUENCES ===========================

// ---------------------------------------------------------------------
// codage de la squence en integers vers seq_array -----------------
// ---------------------------------------------------------------------

void FAR PASCAL DonneeAlign(int no_seq, char far * sequ)
{
	int len;
	char * seq;

	if(no_seq==1)
	{
		max_aln_length =0;
		max_names = 0;
	}

	seq = (char *) ckalloc((strlen(sequ) + 2) * sizeof (char));
	alloc_seq(no_seq, strlen(sequ) + 2);

	// Att : petite manip car les seq_array commencent  1
	strcpy(&seq[1], sequ);

	len = strlen(&seq[1]);
	if (len > max_aln_length) max_aln_length = len;

	seq[len+1]=EOS;
	seqlen_array[no_seq]=len;                   /* store the length */

	/* 
		JULIE
		check sequence names are all different - otherwise phylip tree is confused.	
	*/
	sprintf(names[no_seq], "seq%d", no_seq);	// on donne  chaque squence un nom bidon diffrent
	if ((sint)strlen(names[no_seq]) > max_names) max_names = strlen(names[no_seq]);

	strcpy(titles[no_seq], "RP");	// titre bidon

    // encodage vers seq_array
	if(dnaflag)
		n_encode(seq, seq_array[no_seq], len); 	/* encode the sequence*/
	else										/* as ints  */
		p_encode(seq, seq_array[no_seq], len);

	ckfree((void *) seq);
}



// --------------------------------------------------------------------
// dcodage de seq_array vers la squence -----------------------------
// gnration du consensus --------------------------------------------
// et cleanup  la fin ------------------------------------------------
// --------------------------------------------------------------------

void FAR PASCAL ResultAlign(int len, int no_seq, char far * seq1)
{
	int i,j,k,l,val;
	sint fres = 1, fseq = 1, lseq = nseqs;
	sint catident1[NUMRES],catident2[NUMRES],ident;
	char c;

	// Att : les seq_array commencent  1, donc on les dcode vers seq1[i-1]

	switch(no_seq) {

	case 0:		// cration de la premire ligne "**** : * . ** *"

		for(i=1;i<=len;++i) {
			seq1[i-1]=' ';
			ident=0;
			for(j=1;res_cat1[j-1]!=NULL;j++) catident1[j-1] = 0;
			for(j=1;res_cat2[j-1]!=NULL;j++) catident2[j-1] = 0;
			for(j=fseq;j<=lseq;++j) {
				if((seq_array[fseq][i+fres-1] >=0) && 
				   (seq_array[fseq][i+fres-1] <= max_aa)) {
					if(seq_array[fseq][i+fres-1] == seq_array[j][i+fres-1])
					++ident;
					for(k=1;res_cat1[k-1]!=NULL;k++) {
					        for(l=0;(c=res_cat1[k-1][l]);l++) {
							if (amino_acid_codes[seq_array[j][i+fres-1]]==c)
							{
								catident1[k-1]++;
								break;
							}
						}
					}
					for(k=1;res_cat2[k-1]!=NULL;k++) {
					        for(l=0;(c=res_cat2[k-1][l]);l++) {
							if (amino_acid_codes[seq_array[j][i+fres-1]]==c)
							{
								catident2[k-1]++;
								break;
							}
						}
					}
				}
			}
			if(ident==lseq-fseq+1)
				seq1[i-1]='*';
			else if (!dnaflag) {
				for(k=1;res_cat1[k-1]!=NULL;k++) {
					if (catident1[k-1]==lseq-fseq+1) {
						seq1[i-1]=':';
						break;
					}
				}
				if(seq1[i-1]==' ')
					for(k=1;res_cat2[k-1]!=NULL;k++) {
						if (catident2[k-1]==lseq-fseq+1) {
							seq1[i-1]='.';
							break;
						}
					}
			}
		}

		break;


	default:		  // dcodage int -> lettre

		for(j=1;j<=len;++j) {
			if (j+fres-1<=seqlen_array[no_seq])
				val = seq_array[no_seq][j+fres-1];
			else val = -3;
			if((val == -3) || (val == 253)) break;
			else if((val < 0) || (val > max_aa))
					 seq1[j-1]='_';
				else seq1[j-1]=amino_acid_codes[val];
		}
		for(;j<=len;++j) seq1[j-1]='_';
		
		break;
	}	


	// *****************************************************
	// quand on a servi la dernire squence, on libre tout
	if(no_seq == nseqs)
	{
		// libration de la mmoire
		free_aln(nseqs);
	}
	// *****************************************************
}


// ==================== INTERFACE UTILISATEUR ==============================


// fonction de gestion de la boite de dialogue------------------------------
BOOL FAR PASCAL fnDialog(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message)
	{
		case WM_INITDIALOG :
			Centrer(hDlg);
			return (TRUE);
			break;

		case WM_COMMAND :
			Echapp=-1;
			break;
	}

	return (FALSE);
}



// fonctions de centrage de la boite de dialogue-----------------------------
void Centrer( HWND hWnd )
{
	 RECT Rect, Rect_Parent;
	 HWND hWnd_Parent;
	 int dx, dy, x, y, depx, depy;

	hWnd_Parent = GetParent( hWnd );
	if( !hWnd_Parent )
      { Centrer_Sur_Ecran( hWnd );
		return; }

	GetClientRect( hWnd_Parent, &Rect_Parent );
	GetWindowRect( hWnd, &Rect );
	dx = int(Rect.right - Rect.left);
	dy = int(Rect.bottom - Rect.top);
	x = (Rect_Parent.right - dx )/2;
	y = (Rect_Parent.bottom - dy )/2;
	GetWindowRect( hWnd_Parent, &Rect_Parent );
	depx = Rect_Parent.left + GetSystemMetrics( SM_CXBORDER )+x;
	depy = Rect_Parent.top + GetSystemMetrics( SM_CYBORDER ) + GetSystemMetrics( SM_CYCAPTION )+y;
	MoveWindow( hWnd, depx, depy, dx, dy, TRUE);
}


void Centrer_Sur_Ecran( HWND hWnd )
{
	RECT Rect;
    int dx, dy, x, y;

	GetWindowRect( hWnd, &Rect );
	dx = int(Rect.right - Rect.left);
	dy = int(Rect.bottom - Rect.top);
	x = ( GetSystemMetrics( SM_CXSCREEN ) - dx )/2;
	y = (GetSystemMetrics( SM_CYSCREEN ) - dy )/2;
	MoveWindow( hWnd, x, y, dx, dy, TRUE);
}


// ouverture de la file de messages et test d'interruption --------------
int DoMessages_TestInterrupt()
{
	MSG msg;

	if ( PeekMessage(&msg, NULL, 0 ,0 , PM_REMOVE) )
	{	TranslateMessage(&msg);
		DispatchMessage(&msg);		}

	if (GetAsyncKeyState(VK_ESCAPE)) Echapp=-1;

	if(Echapp)
	{
		MessageBox(hDlg,MES_INTERR,DLG_ERROR,MB_OK | MB_ICONEXCLAMATION);
	}

	return Echapp;
}
