/* appel de l'alignement multiple de clustal V */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <string.h>
#include <ctype.h>

#include "clustalw.h"
#include "alig.h"

/*
*       Prototypes
*/

extern void getstr(char *instr,char *outstr);

void reset(void);

/*
*        variables externes
*/

extern Boolean          percent,dnaflag;
extern int              wind_gap,ktup,window,signif;
extern int               dna_wind_gap, dna_ktup, dna_window, dna_signif;
extern int              prot_wind_gap,prot_ktup,prot_window,prot_signif;
extern int      gap_open,      gap_extend;
extern int  dna_gap_open,  dna_gap_extend;
extern float prot_gap_open, prot_gap_extend;
extern int boot_ntrials;                /* number of bootstrap trials */
extern short     *matptr,pam100mt[],pam250mt[],idmat[];
extern int              nseqs,nblocks;
extern FILE *   tree;
extern int *seqlen_array;
extern char **seq_array;
extern char ntrials;            /* number of bootstrap trials (trees.c) */

extern char** tableau_resultat;
extern char fichier_temporaire[FILENAMELEN+1];

extern HWND hDlg;			// handle boite de dialogue, dfini dans genlib.cpp

/*
* 	variables
*/

extern Boolean explicit_dnaflag;  /* Explicit setting of sequence type on comm.line*/
extern int  matnum;

static char *pam_matrix_name[] = {
		"PAM 100",
		"PAM 250",
		"Matrice d'identits",
		"Matrice de l'utilisateur"   };
		
FILE * sortie;

void reset()   /* remove gaps from older alignments (code = -1) */
{                     /* EXCEPT for gaps that were INPUT with the seqs.*/
	static int i,j,sl;                 /* which have  code = -2  */
	
	for(i=1;i<=nseqs;++i) {
		sl=0;
		for(j=1;j<=seqlen_array[i];++j) {
			if(seq_array[i][j] == -1) continue;
			++sl;
			seq_array[i][sl]=seq_array[i][j];
		}
		seqlen_array[i]=sl;
	}
}


char prompt_for_yes_no(char *title,char *prompt)
{
	char line[80];
	char lin2[80];

	fprintf(stdout,"\n%s\n",title);
	strcpy(line,prompt);
	strcat(line, "(y/n) ? [y]");
	getstr(line,lin2);
	if ((*lin2 != 'n') && (*lin2 != 'N'))
		return('y');
	else
		return('n');

}


/*
*	fatal()
*
*	Prints error msg to stdout and exits.
*	Variadic parameter list can be passed.
*
*	Return values:
*		none
*/

char StrOut[1024];

void fatal( char *msg,...)
{
	va_list ap;
	
	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	MessageBox(hDlg,StrOut,DLG_FATAL_ERROR,MB_OK | MB_ICONSTOP);

	Echapp=-1;
	exit(1);
}

/*
*	error()
*
*	Prints error msg to stdout.
*	Variadic parameter list can be passed.
*
*	Return values:
*		none
*/

void error( char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	MessageBox(hDlg,StrOut,DLG_ERROR,MB_OK | MB_ICONEXCLAMATION);

	Echapp=-1;
}

/*
*	warning()
*
*	Prints warning msg to stdout.
*	Variadic parameter list can be passed.
*
*	Return values:
*		none
*/

void warning( char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	MessageBox(hDlg,StrOut,DLG_WARNING,MB_OK | MB_ICONINFORMATION);
}

/*
*	info()
*
*	Prints info msg to stdout.
*	Variadic parameter list can be passed.
*
*	Return values:
*		none
*/

void info( char *msg,...)
{
	va_list ap;
	
	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	SetDlgItemText(hDlg,MES,(LPSTR)StrOut);
	//MessageBox(hDlg,StrOut,DLG_WARNING,MB_OK | MB_ICONINFORMATION);
}


// affichage des tapes de l'alignement 
void aff_patience( char *msg,...)
{
	va_list ap;
	
	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	SetDlgItemText(hDlg,PAT,(LPSTR)StrOut);
}


// affichage de la progression de l'alignement 
void aff_progress( char *msg,...)
{
	va_list ap;
	
	va_start(ap,msg);
	vsprintf(StrOut,msg,ap);
	va_end(ap);
	SetDlgItemText(hDlg,PRG,(LPSTR)StrOut);
}


// pour remplacer les fprintf(stdout,...) de debuggage
char Str[1024];

void aff_debug(char *msg,...)
{
	// si on a plus de 4 lignes, on retire la premire
	 int len;
	 GetDlgItemText(hDlg,DEB,Str,1024);
	 len = strlen(Str);

	 char * ch;
	 int nb=0;
	 for(ch = Str; ch < Str+len; ch++) if(*ch==0x0A) nb++;

	 ch = Str;
	 if(nb>3) {	 for(; ch < Str+len; ch++) if(*ch==0x0A) { ch=ch+1; break; }	 }
	 strcpy(StrOut,ch);

	// on rcupre le message
	 va_list ap;

	 va_start(ap,msg);
	 vsprintf(Str,msg,ap);
	 va_end(ap);

	// et on l'ajoute en dernire ligne
	 strcat(StrOut,Str);

	 SetDlgItemText(hDlg,DEB,(LPSTR)StrOut);
}
