 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0     Jan 2002   (C) Philippe Valadon       *
 *                                                  2000-2002              *
 *                                                                         *
 * Philippe Valadon   RasTop 2.0.3   Jan 2003   (C) Philippe Valadon       *
 *                                                  2000-2003              *
 *                                                                         * 
 * Christian DUQU    RasTop 2.0.3-VF  Oct. 2003  (C) Christian DUQU 2003 *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/


/////////////////////////////////////////////////////////////////////////////
// mainfrm.h 
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H_INCLUDED_)
#define AFX_MAINFRM_H_INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define		SELECTION_EMPTY		0
#define		SELECTION_NEW		1
#define		SELECTION_ADD		2
#define		SELECTION_REMOVE	3
#define		SELECTION_EXTRACT	4
#define		SELECTION_EXCLUDE	5

#include "pannel.h"
#include "selectbar.h"
#include "colorbar.h"

// CD - Octobre 2003 - Fentre d'cho
#include "echofrm.h"
// Fin fentre d'cho

/////////////////////////////////////////////////////////////////////////////
// CMainFrame mainframe

class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();

// Attributes
public:

// Operations
public:
	// Overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
	void SetSelection( int nMode, CString& sExpression);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected: 
	CToolBar	m_wndMainBar;
	CStatusBar	m_wndStatusBar;

public:	
	int			m_WndRestoreInit;
	CPannelBar  m_wndCommandBar;
	CSelectBar	m_wndSelectBar;
	CColorBar	m_wndColorBar;

	// CD - Octobre 2003 - Fentre d'cho
	CEchoFrm    m_wndEchoFrm;
	// Fin fentre d'cho

	CString		m_SelectString;
	COLORREF	m_crColour;
	CString		m_szCommandText;
	int			InfoSilentFlag;

	void ActivateCommandBar();
	void DesactivateCommandBar();
	CRasView* GetActiveRasView();
	CRect GetScreenClientCoor();
	void EnableMenus( int flag );

protected:

	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSysCommand( UINT nID, LPARAM lParam );	
	afx_msg void OnUpdateViewCommandBar(CCmdUI* pCmdUI);
	afx_msg void OnViewCommandBar();
	afx_msg LRESULT OnChangeColor(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSelectionNew();
	afx_msg void OnSelectionAdd();
	afx_msg void OnSelectionRemove();
	afx_msg void OnSelectionExtract();
	afx_msg void OnSelectionExclude();
	afx_msg void OnUpdateSelectionNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSelectionAdd(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSelectionRemove(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSelectionExtract(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSelectionExclude(CCmdUI* pCmdUI);
	afx_msg void OnViewSelectbar();
	afx_msg void OnUpdateViewSelectbar(CCmdUI* pCmdUI);
	afx_msg void OnViewColorbar();
	afx_msg void OnUpdateViewColorbar(CCmdUI* pCmdUI);
	
	// CD - Octobre 2003 - Fentre d'informations
	afx_msg void OnViewEchoFrm();
	afx_msg void OnUpdateViewEchoFrm(CCmdUI* pCmdUI);
	// Fin fentre d'informations

	afx_msg void OnClose();
	afx_msg void OnViewStatusBar();
	afx_msg void OnUpdateViewStatusBar(CCmdUI* pCmdUI);
	afx_msg void OnFilePreferences();
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnViewMenus();
	afx_msg void OnViewMainbar();
	afx_msg void OnUpdateViewMainbar(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewMenu(CCmdUI* pCmdUI);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnHelpRasTop();
	afx_msg void OnUpdateIndicatorChain(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorGroup(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorAtom(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorCoor(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorXCoor(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorYCoor(CCmdUI *pCmdUI);
	afx_msg void OnUpdateIndicatorZCoor(CCmdUI *pCmdUI);
	afx_msg void OnPickAtom();
	afx_msg void OnUpdatePickAtom(CCmdUI* pCmdUI);
	afx_msg void OnPickGroup();
	afx_msg void OnUpdatePickGroup(CCmdUI* pCmdUI);
	afx_msg void OnPickChain();
	afx_msg void OnUpdatePickChain(CCmdUI* pCmdUI);
	afx_msg void OnPickMolset();
	afx_msg void OnUpdatePickMolset(CCmdUI* pCmdUI);
	afx_msg void OnPickCentre();
	afx_msg void OnUpdatePickCentre(CCmdUI* pCmdUI);
	afx_msg void OnPickBond();
	afx_msg void OnUpdatePickBond(CCmdUI* pCmdUI);
	afx_msg void OnPickRotbond();
	afx_msg void OnUpdatePickRotbond(CCmdUI* pCmdUI);
	afx_msg void OnPickMonitor();
	afx_msg void OnUpdatePickMonitor(CCmdUI* pCmdUI);
	afx_msg void OnPickLabel();
	afx_msg void OnUpdatePickLabel(CCmdUI* pCmdUI);
	afx_msg void OnPickDistance();
	afx_msg void OnUpdatePickDistance(CCmdUI* pCmdUI);
	afx_msg void OnPickAngle();
	afx_msg void OnUpdatePickAngle(CCmdUI* pCmdUI);
	afx_msg void OnPickTorsion();
	afx_msg void OnUpdatePickTorsion(CCmdUI* pCmdUI);
	afx_msg void OnPickLight();
	afx_msg void OnUpdatePickLight(CCmdUI* pCmdUI);
	afx_msg void OnChangeCoordinates();
	afx_msg void OnUpdateChangeCoordinates(CCmdUI* pCmdUI);
	//}}AFX_MSG

protected:
	afx_msg LRESULT UpdateAllViews(WPARAM wParam, LPARAM lParam);
	afx_msg void OnCommandColor(UINT nID);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_MAINFRM_H_INCLUDED_)
