 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0.2   Oct 2002   (C) Philippe Valadon       *
 *                                                  2000-2002              *
 *                                                                         *
 * Philippe Valadon   RasTop 2.0.3   Jan 2003   (C) Philippe Valadon       *
 *                                                  2000-2003              *
 *                                                                         * 
 * Christian DUQU    RasTop 2.0.3-VF  Oct. 2003  (C) Christian DUQU 2003 *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/

/////////////////////////////////////////////////////////////
//rasgraphics.cpp
/////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "rastop.h"
#include "rasdoc.h"
#include "rasview.h"
#include "mainfrm.h"

#define GRAPHICS
#include "graphics.h"

HCURSOR CurrentCursor;
static int WaitStatus = 0;

void AllocateColourMap()
{
#ifdef EIGHTBIT			
    register COLORREF ref;      
    register int i;
	static int ColCount;
    
    if( ColourMap )
        ::DeleteObject(ColourMap);

    ColCount = 0;
    for( i=0; i<256; i++ )
        if( ULut[i] ) 
        {  Palette->palPalEntry[ColCount].peFlags = 0;
           Palette->palPalEntry[ColCount].peRed   = RLut[i];
           Palette->palPalEntry[ColCount].peGreen = GLut[i];
           Palette->palPalEntry[ColCount].peBlue  = BLut[i];

           BitInfo->bmiColors[ColCount].rgbBlue     = BLut[i];
           BitInfo->bmiColors[ColCount].rgbGreen    = GLut[i];
           BitInfo->bmiColors[ColCount].rgbRed      = RLut[i];
           BitInfo->bmiColors[ColCount].rgbReserved = 0;
           ColCount++;
        }   
    Palette->palNumEntries = ColCount;
    BitInfo->bmiHeader.biClrUsed = ColCount;   
    ColourMap = ::CreatePalette(Palette);

    for( i=0; i<256; i++ )
       if( ULut[i] )
       {   ref = RGB(RLut[i],GLut[i],BLut[i]);
		   Lut[i] = ::GetNearestPaletteIndex(ColourMap,ref);
       }
#endif
}

int CreateImage()
{
    register Long size;

    if( FBufHandle ) GlobalFree(FBufHandle);
    size = (Long)XRange*YRange*sizeof(Pixel)+16;
    FBufHandle = GlobalAlloc(GMEM_MOVEABLE,size);
    return( (int)FBufHandle );
}

void TransferImage()
{
#ifdef EIGHTBIT			
    HPALETTE OldCMap;
#endif
    HDC hDC;
        
    if( PixMap )
        ::DeleteObject(PixMap);

    BitInfo->bmiHeader.biWidth = XRange;
    BitInfo->bmiHeader.biHeight = YRange;
        
    hDC = ::GetDC(NULL);
    FBuffer = (Pixel  __huge*)GlobalLock(FBufHandle);

#ifdef EIGHTBIT			
    if( ColourMap )
    {   OldCMap = ::SelectPalette(hDC,ColourMap,FALSE);
		::RealizePalette(hDC);  /* GDI Bug?? */
    }
#endif
        
    PixMap = CreateDIBitmap( hDC, (BITMAPINFOHEADER __far *)BitInfo, 
                             CBM_INIT, FBuffer, BitInfo, DIB_RGB_COLORS);
        
#ifdef EIGHTBIT			
	if( ColourMap && OldCMap )                         
        ::SelectPalette(hDC,OldCMap,False);
#endif

    GlobalUnlock(FBufHandle);
    ::ReleaseDC(NULL,hDC);
}

void ClearImage()
{	if( PixMap && RefreshState )
    {   ::DeleteObject(PixMap);
        PixMap = NULL;
    }
}

void UpdateScrollBars()
{	GETFRAME
	if( UseSlabPlane || UseDepthPlane )
		pFrame->m_wndCommandBar.UpdatePannel();
	else
		pFrame->m_wndCommandBar.UpdateScrollBars();
}

void SetMouseUpdateStatus( int bool )
{	MouseUpdateStatus = bool;	}
                                             
void SetMouseCaptureStatus( int bool )
{	if( bool )
    {   if( !MouseCaptureStatus )
		{	GETFRAME
			GETVIEW
			if( pView != NULL )
				pView->SetCapture();
		}
    } else
        if( MouseCaptureStatus )
            ::ReleaseCapture();
    MouseCaptureStatus = bool;
}

int LookUpColour(char * name, int *r, int *g, int *b )
{   UnusedArgument(name);
    UnusedArgument(r);
    UnusedArgument(g);
    UnusedArgument(b);

    return False;
}    

void EnableMenus( int flag )
{	GETFRAME
	pFrame->EnableMenus( flag );
}

int OpenDisplay( HANDLE, int )
{	register int i,size;

    PixMap = NULL;
#ifdef EIGHTBIT			
    ColourMap = NULL;
#endif
    MouseCaptureStatus = False;
    MouseUpdateStatus = False;   
    UseHourGlass = True;
    DisableMenu = False;
	for( i=0; i<9; i++ )
		DialValue[i] = 0.0;

    ULut[0] = True;
    RLut[0] = GLut[0] = BLut[0] = 0;

	ClipBoardFactor = 2;
    ClipBoardSize = 0;

#ifdef EIGHTBIT			
     size = sizeof(LOGPALETTE) + 256*sizeof(PALETTEENTRY);
     Palette = (LOGPALETTE __far*)_fmalloc( size );
#else
    size = sizeof(BITMAPINFOHEADER);
#endif
    BitInfo = (BITMAPINFO __far*)_fmalloc( size );


#ifdef EIGHTBIT			
     if( !Palette || !BitInfo )
#endif
	if( !BitInfo )
        return( False );
        
#ifdef EIGHTBIT			
    Palette->palVersion = 0x300;
#endif   
    
    BitInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    BitInfo->bmiHeader.biCompression = BI_RGB;
    BitInfo->bmiHeader.biXPelsPerMeter = 0;
    BitInfo->bmiHeader.biYPelsPerMeter = 0;
    BitInfo->bmiHeader.biClrImportant = 0;
    BitInfo->bmiHeader.biSizeImage = 0;
#ifdef EIGHTBIT			
    BitInfo->bmiHeader.biBitCount = 8;
#else
    BitInfo->bmiHeader.biBitCount = 32;
#endif
    BitInfo->bmiHeader.biPlanes = 1;
#ifdef THIRTYTWOBIT			
    BitInfo->bmiHeader.biClrUsed = 0;
#endif
    /* Initialise Palette! */
    for( i=1; i<LutSize; i++ )
        ULut[i] = False;
    AllocateColourMap();

    return(true);                       
}

void CloseDisplay()
{	
#ifdef EIGHTBIT			
	if( ColourMap )
		::DeleteObject(ColourMap);
#endif
    if( PixMap )
        ::DeleteObject(PixMap);
}

void SetCanvasTitle( void )
{	GETFRAME
	GETVIEW
	if( pView==NULL )
		return;
	CRasDoc* pDoc = (CRasDoc *)pView->GetDocument( );
	if( pDoc==NULL )
		return;

	char buffer[80];
	char *src,*des;
	int i;

	des = buffer;
	i = 0;

	if( *SpaceName!='\0' )
	{	src = SpaceName;
		while( i<40 && *src)
		{	*des++ = *src++;
			i++;
		}
		if( i==40 )
			*(des-1) = '\46';

		if( pDoc->m_DocCopyNum > 1 )
		{	int temp = (int)des;
			des += sprintf(des," #%d", pDoc->m_DocCopyNum );
			i += (int)des - temp;
		}
	}

	if( strcmp(CurMolSet->title,SpaceName) || CurMolSet->copynum>1 )
	{	if( i )
		{	des += sprintf(des," - ");
			i +=3;
		}
		src = CurMolSet->title;
		while( i<76 && *src)
		{	*des++ = *src++;
			i++;
		}

		if( CurMolSet->copynum>1 )
			sprintf(des," #%d", CurMolSet->copynum );
		else
			*des = '\0';
	} else
		*des = '\0';

	buffer[80] = '\0';

    pDoc->SetTitle( buffer );
}

int  ClipboardImage( )
{	
    register BITMAPINFO __far *bitmap;
    register Pixel __huge *src;
    register Pixel __huge *dst;
    register long size,len;
    register HANDLE hand;
    register int cbfactor;
#ifdef EIGHTBIT			
    register int i;
#endif

	GETFRAME
	GETVIEW
	if( pView==NULL )
		return false;
	CRasDoc* pDoc = pView->GetDocument();
	pDoc->FixRange();

    /* Adjust ClipBoardFactor */
    cbfactor = pDoc->GetMaxCBFactor( );
    if( !cbfactor )
        return False;

    if( pView->OpenClipboard() )
    {	EmptyClipboard();
        if( PixMap )
        {	BeginWait();
			if( cbfactor != 1 )
			{	XRange = XRange*cbfactor;
				if( int dx = XRange%4 )
					XRange += 4-dx;	
				YRange = YRange*cbfactor;
				Range =  MinFun(XRange,YRange);
				ZRange = Range;
				HRange = YRange>>1;
				WRange = XRange>>1;
                RefreshState = True;
				ReDrawFlag |= RFReSize;
				ClearImage();
				RefreshScreen();
			}
			len = (Long)XRange*YRange*sizeof(Pixel);
#ifdef EIGHTBIT			
            size = sizeof(BITMAPINFOHEADER) + 256*sizeof(RGBQUAD);
#else
            size = sizeof(BITMAPINFOHEADER);
#endif
            hand=GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,size+len);
			if( hand )
            {   bitmap = (BITMAPINFO __far *)GlobalLock(hand);
                bitmap->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
                bitmap->bmiHeader.biWidth = XRange;
                bitmap->bmiHeader.biHeight = YRange;
                bitmap->bmiHeader.biPlanes = 1;
#ifdef EIGHTBIT			
                bitmap->bmiHeader.biBitCount = 8;
#else
                bitmap->bmiHeader.biBitCount = 32;
#endif
                bitmap->bmiHeader.biCompression = BI_RGB;
                bitmap->bmiHeader.biSizeImage = 0;
                bitmap->bmiHeader.biXPelsPerMeter = 0;
                bitmap->bmiHeader.biYPelsPerMeter = 0;
                bitmap->bmiHeader.biClrImportant = 0;
                bitmap->bmiHeader.biClrUsed = 0;

#ifdef EIGHTBIT			
                for( i=0; i<256; i++ )
                    if( ULut[i] )
                    {   bitmap->bmiColors[Lut[i]].rgbBlue  = BLut[i];
                        bitmap->bmiColors[Lut[i]].rgbGreen = GLut[i];
                        bitmap->bmiColors[Lut[i]].rgbRed   = RLut[i];
                    }
#endif
                /* Transfer the frame buffer */
                src = (Pixel __huge*)GlobalLock(FBufHandle);
#ifdef EIGHTBIT			
                dst = ((Pixel __huge*)bitmap)+size;
#else
                dst = ((Pixel __huge*)bitmap)+size/4;
#endif
				len = GlobalSize(FBufHandle)-16;
				memcpy(dst,src,(size_t)len);

                GlobalUnlock(FBufHandle);
                GlobalUnlock(hand);
                if( SetClipboardData(CF_DIB,hand) )
                    ClipBoardSize = len;
            }
			if( cbfactor != 1 )
			{	pDoc->FixRange();
				ReDrawFlag |= RFReSize;
                RefreshState = True;
				ClearImage();
				RefreshScreen();
			}

			EndWait();
        }

#ifdef EIGHTBIT			
        if( ColourMap )
        {   if( (hand = CreatePalette(Palette)) )
                SetClipboardData(CF_PALETTE,hand);
        }
#endif
        CloseClipboard();
    } else	
		return false;
return true;
}

static int ClipboardTransfer( int selection )
{	register int len, result, done;
	register int ok, size, sizebuf;
	register int i, plus;
    register HANDLE buf;
	register HANDLE clip;
	register char *src;
	register char *ptr;
    char buffer[80];

	GETFRAME
	GETVIEW
	if( pView==NULL )
		return false;

	BeginWait();
	done = 0;
	size = 0;
	ok = 0;

	while( !ok )
	{	ok = 1;
		if( size==0 )
		{	sizebuf = 1024;
		} else if( size==1 )
		{	sizebuf = 16*1024;
		} else if( size==2 )
		{	sizebuf = 128*1024;	
		} else
		{	WriteString(
				// CD - Octobbre 2003
				"Attention: Selection trop grande, impossible de copier dans le Presse-papiers!\n");
			EndWait();
			return false;
		}

		buf = GlobalAlloc(GHND,sizebuf);

		if( buf )
		{	WriteAtomSelection(NULL,-1);
			src = (char *)GlobalLock(buf);	
			len = 0;
			do
			{	ptr = src+len;
				if( selection )
					result = WriteAtomSelection(ptr,1);	
				else
					result = WriteScriptPosition(ptr,1);
				len = strlen(src);
				/*Get a larger buffer*/
				if( result && len>=(sizebuf-MAXBUFFLEN) )
				{	size++;
					GlobalUnlock(buf);
					ok = 0;
					break;
				}
			} while (result);

			if( !ok )
				continue;		
		
		    if( pView->OpenClipboard() )
		    {	plus = 0;
				ptr = src;
				if( *src++=='\n' )
					plus++;
				for( i=1;i<len;i++ )
				{	if( *src=='\n'&&*(src-1)!='\r' )
						plus++;
					*src++;
				}
				src = ptr;

				if( clip=GlobalAlloc(GMEM_DDESHARE,len+plus+2) )
				{	ptr = (char *)GlobalLock(clip);
					if( *src=='\n' )
						*ptr++ = '\r';
					*ptr++ = *src++;
					for( i=1;i<len;i++ )
					{	if( *src=='\n'&&*(src-1)!='\r' )
							*ptr++ = '\r';
						*ptr++ = *src++;
					}
                    *ptr = '\0';
					GlobalUnlock(clip);

		            EmptyClipboard();
					if( SetClipboardData(CF_TEXT,clip) )
                        ClipBoardSize = len+plus+2;
					CloseClipboard();

					done = 1;
				}
			}
				
			GlobalUnlock(buf);    
			InvalidateCmndLine();
			if( done )
			{	if( selection && FileDepth==-1 )
				{	if( SelectCount==0 )
						// CD - Octobre 2003
					{	WriteString("Zero atome selectionne copie dans le Presse-papiers!\n");
					} else if( SelectCount>1 )
					{   sprintf(buffer,"%ld atomes selectionnes copies dans le Presse-papiers!\n",
							(long)SelectCount);
						 WriteString(buffer);
					// CD - Octobre 2003
					} else WriteString("1 atome selectionne copie dans le Presse-papiers!\n");
		
				} else if( FileDepth==-1 )
					// CD - Octobre 2003
					WriteString("Position copiee dans le Presse-papiers!\n");
			}
		} else
		// CD - Octobre 2003
		{	WriteString("Attention: Mmoire insuffisante pour copier la selection!\n");
			done = 0;
		}
	}
	EndWait();
	return done;
}

int ClipboardSelection( )
{	return ClipboardTransfer(true);	}

int ClipboardPosition( )
{	return ClipboardTransfer(false);	}

int ClipboardPaste( )
{	register char *ptr;
	register char *des;
	register int len;
	register int clipboardtype;
    char buffer[80];

	GETFRAME
	GETVIEW
	if( pView==NULL )
		return false;

    InvalidateCmndLine();
	BeginWait();
				
	if( pView->OpenClipboard() )
	{	HANDLE data = GetClipboardData(CF_TEXT);
		ptr = (char*)GlobalLock(data);
		GlobalUnlock(data);	
		if( ptr==NULL )
		// CD - Octobre 2003
		{	WriteString("Attention: Le Presse-papiers ne contient aucune donnees!\n");
			CloseClipboard();
			EndWait();
			return true;
		}
		len = 0;
		des = CurLine;
		while( len<MAXBUFFLEN && *ptr!='\n' && *ptr )
		{	*des++ = *ptr++;
			len++;
		}
		if( len==MAXBUFFLEN || !*ptr )
		// CD - Octobre 2003
		{	WriteString("Attention: Commande invalide dans le Presse-papiers!\n");
			CloseClipboard();
			EndWait();
			return true;
		}
		*des = '\0';
		*ptr++;

		if( strstr(CurLine,"#!rasmol")==0 )
		{	if( FileDepth==-1 )
				// CD - Octobre 2003
				WriteString("Attention: Aucune commande valide dans le Presse-papiers!\n");
			CloseClipboard();
			EndWait();
			return true;
		}

		if( strstr(CurLine,"selection")!=0 )
		{	clipboardtype = 1;
		} else if( strstr(CurLine,"position")!=0 )
		{	clipboardtype = 2;
		} else if( strstr(CurLine, "script")!=0 )
		{	clipboardtype = 3;
		} else
			// CD - Octobre 2003
		{	WriteString("Attention: Commande inconnue dans le Presse-papiers!\n");
			CloseClipboard();
			EndWait();
			return true;
		}

        /* Make clipboard script-like */
        FileDepth++;

		while(1)
		{	/* pFrame->InfoSilentFlag = true; */
			len = 0;
			des = CurLine;
			while( len<MAXBUFFLEN && *ptr!='\n' && *ptr )
			{	*des++ = *ptr++;
				len++;
			}
			*des++ = '\n';
			*des = '\0';
			ExecuteCommand();
			if( !*ptr )
				break;
			*ptr++;
		}

        FileDepth--;
		/* pFrame->InfoSilentFlag = false; */

		if( clipboardtype==1 )
		{	if( FileDepth==-1 )
			{	if( SelectCount==0 )
					// CD - Octobre 2003
				{	WriteString("Aucune selection a coller depuis le Presse-papiers!\n");
				} else if( SelectCount>1 )
				{   sprintf(buffer,"%ld atomes selectionnes colles depuis le Presse-papiers!\n",
						(long)SelectCount);
					 WriteString(buffer);
				// CD - Octobre 2003
				} else WriteString("1 atome selectionne colle depuis le Presse-papiers!\n");
			}
		} else if( clipboardtype==2 )
		{	if( FileDepth==-1 )
				// CD - Octobre 2003
				WriteString("Position collee depuis le Presse-papiers!\n");
		} else if( clipboardtype==3 )
		{	if( FileDepth==-1 )
				// CD - Octobre 2003
				WriteString("Script colle depuis le Presse-papiers!\n");
		}

        if( DisplayMode )
            ReDrawFlag |= RFRefresh;
		pView->RefreshView();
		CloseClipboard();
	} else
	{	EndWait();
		return false;
	}

	EndWait();
	return true;
}

int  PrintImage( )
{	GETFRAME
	GETVIEW
	if( !pView )
		return false;
	pView->PrintImage( );
	return true;
}

void BeginWait(  )
{	WaitStatus++;
	GETFRAME
	pFrame->m_wndCommandBar.ChangeStatusLight(-1); 
	//Force cursor
	HCURSOR Cursor = AfxGetApp()->LoadStandardCursor(IDC_WAIT);
	CurrentCursor = ::GetCursor();
	::SetCursor(Cursor);
	if( ::ShowCursor(true)>= 1 )
		::ShowCursor(false);
}

void EndWait(  )
{	WaitStatus--;
	if( WaitStatus<0 )
		WaitStatus = 0;
	if( WaitStatus )
		return;

	GETFRAME
	pFrame->m_wndCommandBar.ChangeStatusLight(true); 

	if( FileDepth!=-1 )
		CurrentCursor = AfxGetApp()->LoadCursor(IDC_RASCURSOR);
	::SetCursor(CurrentCursor);
	if( ::ShowCursor(true)>= 1 )
		::ShowCursor(false);
}
