 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0     Jan 2002   (C) Philippe Valadon       *
 *                                                  2000-2002              *
 *                                                                         *
 * Naoum Salam       RasTop 2.0.1-VF May 2002  (C) Naoum Salam 2002      *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// mainfrm.cpp
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "RasTop.h"
#include "rasdoc.h"
#include "rasview.h"
#include "mainfrm.h"
#include "dialog.h"
#include "graphics.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// HTML Help

void InitHelpHTML( void )
{
	if( *HelpHTMLSource )
	{   ::ShellExecute(NULL, NULL, HelpHTMLSource, 
			NULL, _T("C:\\"),SW_SHOWNORMAL);
	} else
	{	InvalidateCmndLine();
       
// NS May 2002

	WriteString("Erreur: Emplacement de l'aide de RasTop inconnu!\n");
	}
}



/////////////////////////////////////////////////////////////////////////////
// Reset user-defined set Box

void ResetUserSetBox( void )
{	GETFRAME
	pFrame->m_wndSelectBar.ResetBox(true);
}


/////////////////////////////////////////////////////////////////////////////
//Writing routines to infoline

void WriteChar(int ch)
{	GETFRAME
	static CString templine;
	static char Buffer[256];
	static char *ptr = Buffer;
	static int i = 0;

	if( pFrame->InfoSilentFlag!=false )
	{	if( pFrame->InfoSilentFlag==-1 )
		{	if( i==0 )
			{	ptr = templine.GetBuffer( 32384 );
				*ptr++ = ch;
				i++;
			} else if( ch == EOF )
			{	*ptr = '\0';
				templine.ReleaseBuffer();
				pFrame->m_szCommandText += templine + '\n';
				i = 0;
			} else if( i == 32000 )
			{	*ptr = '\0';
				templine.ReleaseBuffer();
				pFrame->m_szCommandText += "  " + templine;
				i = 0;
				ptr = templine.GetBuffer( 32384 );
			} else
			{	*ptr++ = ch;
				i++;
			}
		} 
		return;
	}

	if ( ch<32 || ch>126 )
		if( ch!=0x07 && ch!=0x0D && ch!=0x0A )
			return;

    switch( ch )
    {	case(0x07): MessageBeep(0);
				 	break;		      		      
		case(0x0D): 
		case(0x0A):	if( ptr==Buffer && FileDepth!=-1 )
						*ptr++ = 0x20;	//space to create a \n on echo command
					*ptr = '\0';
					templine = Buffer;					
					pFrame->m_wndCommandBar.OnAddInfoline(templine);
					ptr = Buffer;
					break;  
		default:	*ptr++ = ch;
    } 
} 

void WriteString( char *ptr )
{	while( *ptr )
		WriteChar( *ptr++ );
}


/////////////////////////////////////////////////////////////////////////////
// Helpers for saving/restoring window state

static TCHAR BASED_CODE szSection[] = _T("Settings");
static TCHAR BASED_CODE szWindowPos[] = _T("WindowPos");
static TCHAR szFormat[] = _T("%u,%u,%d,%d,%d,%d,%d,%d,%d,%d");

static BOOL PASCAL NEAR ReadWindowPlacement(LPWINDOWPLACEMENT pwp)
{
	CString strBuffer = AfxGetApp()->GetProfileString(szSection, szWindowPos);
	if (strBuffer.IsEmpty())
		return false;

	WINDOWPLACEMENT wp;
	int nRead = _stscanf(strBuffer, szFormat,
		&wp.flags, &wp.showCmd,
		&wp.ptMinPosition.x, &wp.ptMinPosition.y,
		&wp.ptMaxPosition.x, &wp.ptMaxPosition.y,
		&wp.rcNormalPosition.left, &wp.rcNormalPosition.top,
		&wp.rcNormalPosition.right, &wp.rcNormalPosition.bottom);

	if (nRead != 10)
		return false;

	wp.length = sizeof wp;
	*pwp = wp;

	return true;
}

static void PASCAL NEAR WriteWindowPlacement(LPWINDOWPLACEMENT pwp)
{
	TCHAR szBuffer[sizeof("-32767")*8 + sizeof("65535")*2];

	wsprintf(szBuffer, szFormat,
		pwp->flags, pwp->showCmd,
		pwp->ptMinPosition.x, pwp->ptMinPosition.y,
		pwp->ptMaxPosition.x, pwp->ptMaxPosition.y,
		pwp->rcNormalPosition.left, pwp->rcNormalPosition.top,
		pwp->rcNormalPosition.right, pwp->rcNormalPosition.bottom);
	AfxGetApp()->WriteProfileString(szSection, szWindowPos, szBuffer);
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SYSCOMMAND( )
	ON_UPDATE_COMMAND_UI(ID_COMMANDVIEW, OnUpdateViewCommandBar)
	ON_COMMAND(ID_COMMANDVIEW, OnViewCommandBar)
	ON_MESSAGE(WM_COLOR, OnChangeColor)
	ON_COMMAND(ID_SELECTION_NEW, OnSelectionNew)
	ON_COMMAND(ID_SELECTION_ADD, OnSelectionAdd)
	ON_COMMAND(ID_SELECTION_REMOVE, OnSelectionRemove)
	ON_COMMAND(ID_SELECTION_EXTRACT, OnSelectionExtract)
	ON_COMMAND(ID_SELECTION_EXCLUDE, OnSelectionExclude)
	ON_UPDATE_COMMAND_UI(ID_SELECTION_NEW, OnUpdateSelectionNew)
	ON_UPDATE_COMMAND_UI(ID_SELECTION_ADD, OnUpdateSelectionAdd)
	ON_UPDATE_COMMAND_UI(ID_SELECTION_REMOVE, OnUpdateSelectionRemove)
	ON_UPDATE_COMMAND_UI(ID_SELECTION_EXTRACT, OnUpdateSelectionExtract)
	ON_UPDATE_COMMAND_UI(ID_SELECTION_EXCLUDE, OnUpdateSelectionExclude)
	ON_COMMAND(ID_VIEW_SELECTBAR, OnViewSelectbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SELECTBAR, OnUpdateViewSelectbar)
	ON_COMMAND(ID_VIEW_COLORBAR, OnViewColorbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COLORBAR, OnUpdateViewColorbar)
	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_STATUS_BAR, OnViewStatusBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateViewStatusBar)
	ON_COMMAND(ID_FILE_PREFERENCES, OnFilePreferences)
	ON_WM_GETMINMAXINFO()
	ON_COMMAND(ID_VIEW_MENU, OnViewMenus)
	ON_COMMAND(ID_VIEW_TOOLBAR, OnViewMainbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateViewMainbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MENU, OnUpdateViewMenu)
	ON_WM_HELPINFO()
	ON_COMMAND(ID_HELP_RASMOL, OnHelpRasTop)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_CHAIN, OnUpdateIndicatorChain)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_GROUP, OnUpdateIndicatorGroup)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_ATOM, OnUpdateIndicatorAtom)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_COOR_NAME, OnUpdateIndicatorCoor)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_XCOOR, OnUpdateIndicatorXCoor)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_YCOOR, OnUpdateIndicatorYCoor)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_ZCOOR, OnUpdateIndicatorZCoor)
	ON_COMMAND(ID_PICK_ATOM, OnPickAtom)
	ON_UPDATE_COMMAND_UI(ID_PICK_ATOM, OnUpdatePickAtom)
	ON_COMMAND(ID_PICK_GROUP, OnPickGroup)
	ON_UPDATE_COMMAND_UI(ID_PICK_GROUP, OnUpdatePickGroup)
	ON_COMMAND(ID_PICK_CHAIN, OnPickChain)
	ON_UPDATE_COMMAND_UI(ID_PICK_CHAIN, OnUpdatePickChain)
	ON_COMMAND(ID_PICK_MOLSET, OnPickMolset)
	ON_UPDATE_COMMAND_UI(ID_PICK_MOLSET, OnUpdatePickMolset)
	ON_COMMAND(ID_PICK_CENTRE, OnPickCentre)
	ON_UPDATE_COMMAND_UI(ID_PICK_CENTRE, OnUpdatePickCentre)
	ON_COMMAND(ID_PICK_BOND, OnPickBond)
	ON_UPDATE_COMMAND_UI(ID_PICK_BOND, OnUpdatePickBond)
	ON_COMMAND(ID_PICK_ROTBOND, OnPickRotbond)
	ON_UPDATE_COMMAND_UI(ID_PICK_ROTBOND, OnUpdatePickRotbond)
	ON_COMMAND(ID_PICK_MONITOR, OnPickMonitor)
	ON_UPDATE_COMMAND_UI(ID_PICK_MONITOR, OnUpdatePickMonitor)
	ON_COMMAND(ID_PICK_LABEL, OnPickLabel)
	ON_UPDATE_COMMAND_UI(ID_PICK_LABEL, OnUpdatePickLabel)
	ON_COMMAND(ID_PICK_DISTANCE, OnPickDistance)
	ON_UPDATE_COMMAND_UI(ID_PICK_DISTANCE, OnUpdatePickDistance)
	ON_COMMAND(ID_PICK_ANGLE, OnPickAngle)
	ON_UPDATE_COMMAND_UI(ID_PICK_ANGLE, OnUpdatePickAngle)
	ON_COMMAND(ID_PICK_TORSION, OnPickTorsion)
	ON_UPDATE_COMMAND_UI(ID_PICK_TORSION, OnUpdatePickTorsion)
	ON_COMMAND(ID_PICK_LIGHT, OnPickLight)
	ON_UPDATE_COMMAND_UI(ID_PICK_LIGHT, OnUpdatePickLight)
	ON_COMMAND(ID_COORD_CHANGE, OnChangeCoordinates)
	ON_UPDATE_COMMAND_UI(ID_COORD_CHANGE, OnUpdateChangeCoordinates)
	ON_COMMAND(ID_SET_PREFERENCES, OnSetPreferences)
	//}}AFX_MSG_MAP

	ON_MESSAGE(WM_UPDATERASVIEW, UpdateAllViews)
	ON_COMMAND_RANGE(ID_COLOR, ID_COLOR+MAX_COLORS, OnCommandColor)

END_MESSAGE_MAP()

static UINT indicators[] =
{	/*ID_SEPARATOR,*/
	ID_INDICATOR_CHAIN_NAME,
	ID_INDICATOR_CHAIN,
	ID_INDICATOR_GROUP_NAME,
	ID_INDICATOR_GROUP,
	ID_INDICATOR_ATOM_NAME,
	ID_INDICATOR_ATOM,
    ID_INDICATOR_XCOOR,
    ID_INDICATOR_YCOOR,
    ID_INDICATOR_ZCOOR,
    ID_INDICATOR_COOR_NAME,
	ID_INDICATOR_NULL
};

CMainFrame::CMainFrame()
{	
	m_WndRestoreInit = 0;
	m_SelectString = "";
	m_szCommandText = "";
	InfoSilentFlag = false;
}

CMainFrame::~CMainFrame()	{}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{	cs.cx = 750;
	cs.cy = 550;
	return CMDIFrameWnd::PreCreateWindow(cs);
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{	
	if( CMDIFrameWnd::OnCreate(lpCreateStruct) == -1 )
		return -1;


	//Initial window placement
	WINDOWPLACEMENT wp;
	if( ReadWindowPlacement(&wp) )
	{	if( wp.showCmd == SW_SHOWMAXIMIZED )
			m_WndRestoreInit = 2;
		else
			m_WndRestoreInit = 1;
		SetWindowPlacement(&wp);
	}

	EnableDocking(CBRS_ALIGN_TOP);

	//Toolbar
	if( !m_wndMainBar.Create(this)||!m_wndMainBar.LoadToolBar(IDR_MAINFRAME) )
	{	TRACE0("Failed to create toolbar\n");
		return -1; 
	}
	m_wndMainBar.SetBarStyle(m_wndMainBar.GetBarStyle()|
		CBRS_TOOLTIPS|CBRS_FLYBY |CBRS_GRIPPER);
	m_wndMainBar.ModifyStyle(0,TBSTYLE_FLAT);
	m_wndMainBar.SetWindowText(_T("Main"));
	m_wndMainBar.EnableDocking(CBRS_ALIGN_TOP);
	DockControlBar(&m_wndMainBar,AFX_IDW_DOCKBAR_TOP);

	//SelectBar
	if( !m_wndSelectBar.Init(this) )
	{	TRACE0("Failed to create selectbar\n");
		return -1; 
	}
	m_wndSelectBar.SetWindowText(_T("Selection"));
	m_wndSelectBar.EnableDocking(CBRS_ALIGN_TOP );
	DockControlBar(&m_wndSelectBar,AFX_IDW_DOCKBAR_TOP);

	//Status bar
	if( !m_wndStatusBar.Create(this, WS_CHILD | CBRS_BOTTOM) ||
		!m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)) )
	{	TRACE0("Failed to create status bar\n");
		return -1;
	}

	int cx, panex; UINT st, id;
	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_CHAIN_NAME);
	if( panex!=-1 )
		m_wndStatusBar.SetPaneStyle( panex, SBPS_NOBORDERS);

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_CHAIN);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 140 );
	}
	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_GROUP_NAME);
	if( panex!=-1 )
		m_wndStatusBar.SetPaneStyle( panex, SBPS_NOBORDERS);

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_GROUP);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 100 );
	}
	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_ATOM_NAME);
	if( panex!=-1 )
		m_wndStatusBar.SetPaneStyle( panex, SBPS_NOBORDERS);

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_ATOM);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 120 );
	}

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_XCOOR);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 55 );
	}

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_YCOOR);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 55 );
	}

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_ZCOOR);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 55 );
	}

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_COOR_NAME);
	if( panex!=-1 )
	{	m_wndStatusBar.SetPaneStyle( panex, SBPS_NOBORDERS);
        m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, st, 80 );
	}

	panex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_NULL);
	if( panex!=-1 )
	{	m_wndStatusBar.GetPaneInfo( panex, id, st, cx );
		m_wndStatusBar.SetPaneInfo( panex, id, SBPS_DISABLED|SBPS_NOBORDERS,10);
	}

	//Color bar
	if( !m_wndColorBar.Init(this) )
	{	TRACE0("Failed to create color toolbar\n");
		return -1; 
	}

	CPoint point(550,150);
	FloatControlBar(&m_wndColorBar,point,CBRS_ALIGN_TOP );
	ShowControlBar(&m_wndColorBar,false, true);

	// Command bar
	long sizex = 800;

	CClientDC dc(GetDesktopWindow());
	sizex = dc.GetDeviceCaps(HORZRES);

	UINT IDPannel;
	if( sizex >= 1024 )
		IDPannel = IDD_COMMANDVIEW_BIG;
	else
		IDPannel = IDD_COMMANDVIEW;

	if( !m_wndCommandBar.Create(this, IDPannel,
		CBRS_BOTTOM|CBRS_TOOLTIPS|CBRS_FLYBY, IDPannel) )
	{	TRACE0("Failed to create pannel\n");
		return -1; 
	}

	/* Create Font */
	long lgpix = 120;
	lgpix = dc.GetDeviceCaps(LOGPIXELSX);

	int ls = 1;
	if( lgpix > 120 )
	    ls = 3;

    CDC pDisplay;
	if( !pDisplay.CreateCompatibleDC(NULL) )
		return -1;

	LOGFONT logFont;
	memset(&logFont, 0, sizeof(logFont));
	logFont.lfWeight = FW_NORMAL;
	logFont.lfPitchAndFamily = DEFAULT_PITCH | FF_SWISS;
	lstrcpy( logFont.lfFaceName, _T("Arial") );

	int height = -MulDiv(7+ls, pDisplay.GetDeviceCaps(LOGPIXELSY), 72);
	logFont.lfHeight = height;
	if( !m_wndCommandBar.m_FontPannel.CreateFontIndirect(&logFont) )
		return -1;

	height = -MulDiv(5+ls, pDisplay.GetDeviceCaps(LOGPIXELSY), 72);
	logFont.lfHeight = height;
	if( !m_wndCommandBar.m_FontBuddy.CreateFontIndirect(&logFont) )
		return -1;

	if(!m_wndCommandBar.OnInitDialogBar() )
	{	TRACE0("Failed to init CommandBar\n");
		return -1; 
	}

    // Verify IDPannel is the same in the registry
	CWinApp* pApp = AfxGetApp();
    int nBarID, nIndex,done;
    UINT bID;
    TCHAR szSection[256];

    done = 1;
    nBarID = pApp->GetProfileInt(_T("General-Summary"),_T("Bars"),0);
    if( nBarID == 0 )
        done = 0;
    for( nIndex=0; nIndex<nBarID; nIndex++ )
    {   wsprintf(szSection, "%s-Bar%d","General",nIndex);
        bID = pApp->GetProfileInt(szSection,"BarID", 0);
        if( (bID == IDD_COMMANDVIEW) || (bID == IDD_COMMANDVIEW_BIG) )
            if( bID != IDPannel )
                done = 0;
    }
	if( done )
	    LoadBarState(_T("General"));

	BOOL bView = (pApp->GetProfileInt(_T("General"),_T("Status"),1)!=0);
	ShowControlBar(&m_wndStatusBar, bView, false);
	bView = (AfxGetApp()->GetProfileInt(_T("General"),_T("Selection"),1)!=0);
	ShowControlBar(&m_wndSelectBar, bView, false);

	return 0;
}

void CMainFrame::OnSysCommand( UINT nID, LPARAM lParam )
{	
	CMDIFrameWnd::OnSysCommand( nID, lParam );

	static BOOL IconeFlag = false;

	//Allow decent restoring if initially maximized
	int x = ::GetSystemMetrics(SM_CXMAXIMIZED);
	int y = ::GetSystemMetrics(SM_CYMAXIMIZED);
	x = 750>x? x : 750;
	y = 500>y? y : 500;
	if( ((nID & 0xFFF0) == SC_RESTORE) && (m_WndRestoreInit == 2 ) && !IconeFlag )
	{	m_WndRestoreInit = 1;	//deactivate
		MoveWindow( 25, 25, x, y, TRUE );
	}

	IconeFlag = ((nID & 0xFFF0) == SC_MINIMIZE);

	//Stop spinmode on screensaver
	if( (nID & 0xFFF0) == SC_SCREENSAVE || (nID & 0xFFF0) == SC_MINIMIZE ) 
		m_wndCommandBar.ResetSpinMode();
}

void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
    POINT p;
	p.x = ::GetSystemMetrics(SM_CXMAXIMIZED);
	p.y = ::GetSystemMetrics(SM_CYMAXIMIZED);
	lpMMI->ptMaxSize = p;
	p.x = - ::GetSystemMetrics(SM_CXSIZEFRAME);
	p.y = - ::GetSystemMetrics(SM_CYSIZEFRAME);
    lpMMI->ptMaxPosition = p;
	
	CMDIFrameWnd::OnGetMinMaxInfo(lpMMI);
}

void CMainFrame::OnClose() 
{	SaveBarState(_T("General"));
	AfxGetApp()->WriteProfileInt( _T("General"),_T("Status"),
		(m_wndStatusBar.GetStyle() & WS_VISIBLE) != 0);
	AfxGetApp()->WriteProfileInt( _T("General"),_T("Selection"),
		(m_wndSelectBar.GetStyle() & WS_VISIBLE) != 0);

	WINDOWPLACEMENT wp;
	wp.length = sizeof wp;
	if( GetWindowPlacement(&wp) )
	{	wp.flags = 0;
		if (IsZoomed())
			wp.flags |= WPF_RESTORETOMAXIMIZED;
		WriteWindowPlacement(&wp);
	}

    if( ClipBoardSize > 1000000 )
    {   if( AfxMessageBox("Delete large clipboard data?", MB_YESNO) == IDYES )
        {   ::OpenClipboard(NULL);
            ::EmptyClipboard();
            ::CloseClipboard();
        }
    }

	CMDIFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
//Bars

/* ToolBar */
void CMainFrame::OnViewMainbar() 
{	BOOL bView = (m_wndMainBar.GetStyle() & WS_VISIBLE);
	ShowControlBar(&m_wndMainBar, !bView, false);
	if( !bView )
		DisableMenu = false;
}

void CMainFrame::OnUpdateViewMainbar(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( (m_wndMainBar.GetStyle() & WS_VISIBLE) != 0 );	}

/* SelectBar */
void CMainFrame::OnViewSelectbar() 
{	BOOL bView = (m_wndSelectBar.GetStyle() & WS_VISIBLE);
	ShowControlBar(&m_wndSelectBar, !bView, false);

	if( !bView )
		DisableMenu = false;
}

void CMainFrame::OnUpdateViewSelectbar(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( (m_wndSelectBar.GetStyle() & WS_VISIBLE) != 0 );	}

/* ColorBar */
void CMainFrame::OnViewColorbar() 
{	BOOL bView = (m_wndColorBar.GetStyle() & WS_VISIBLE);
	ShowControlBar(&m_wndColorBar, !bView, false);
}

void CMainFrame::OnUpdateViewColorbar(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( (m_wndColorBar.GetStyle() & WS_VISIBLE) != 0 );	}

/* CommandBar */
void CMainFrame::OnViewCommandBar() 
{	BOOL bView = (m_wndCommandBar.GetStyle() & WS_VISIBLE);
	ShowControlBar(&m_wndCommandBar, !bView, false);
	if( !bView )
		DisableMenu = false;
}

void CMainFrame::ActivateCommandBar()
{	ShowControlBar(&m_wndCommandBar, true, false);	
	DisableMenu = false;
}

void CMainFrame::DesactivateCommandBar()
{	ShowControlBar(&m_wndCommandBar, false, false);	}

void CMainFrame::OnUpdateViewCommandBar(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( (m_wndCommandBar.GetStyle() & WS_VISIBLE) != 0 );	}

/* StatusBar */
void CMainFrame::OnViewStatusBar() 
{	BOOL bView = (m_wndStatusBar.GetStyle() & WS_VISIBLE);
	ShowControlBar(&m_wndStatusBar, !bView, false);
	if( !bView )
		DisableMenu = false;
}

void CMainFrame::OnUpdateViewStatusBar(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( (m_wndStatusBar.GetStyle() & WS_VISIBLE) != 0 );	}

void CMainFrame::OnViewMenus() 
{	static BOOL MainBarFlag = true;
	static BOOL SelectBarFlag = true;
	static BOOL CommandBarFlag = true;
	static BOOL StatusBarFlag = true;

	//DisableMenu always False at beginning
	DisableMenu = !DisableMenu;

	if( DisableMenu )
	{	//memorize status
		MainBarFlag = m_wndMainBar.GetStyle() & WS_VISIBLE;
		SelectBarFlag = m_wndSelectBar.GetStyle() & WS_VISIBLE;
		CommandBarFlag = m_wndCommandBar.GetStyle() & WS_VISIBLE;
		StatusBarFlag = m_wndStatusBar.GetStyle() & WS_VISIBLE;

		if( MainBarFlag )		ShowControlBar(&m_wndMainBar, false, false);
		if( SelectBarFlag )		ShowControlBar(&m_wndSelectBar, false, false);
		if( CommandBarFlag )	ShowControlBar(&m_wndCommandBar, false, false);
		if( StatusBarFlag )		ShowControlBar(&m_wndStatusBar, false, false);
	} else
	{	if( MainBarFlag )		ShowControlBar(&m_wndMainBar, true, false);

		if( SelectBarFlag )		ShowControlBar(&m_wndSelectBar, true, false);
		if( CommandBarFlag && GetActiveRasView() )
								ShowControlBar(&m_wndCommandBar, true, false);
		if( StatusBarFlag )		ShowControlBar(&m_wndStatusBar, true, false);
	}

	RecalcLayout();
}

void CMainFrame::EnableMenus( int flag )
{	if( DisableMenu==flag )
		OnViewMenus();
}

void CMainFrame::OnUpdateViewMenu(CCmdUI* pCmdUI) 
{	pCmdUI->SetCheck( DisableMenu );	}


/*=======================*/
/* Status Bar Indicators */
/*=======================*/

void CMainFrame::OnUpdateIndicatorChain(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strChain;
	strChain = "";

	if( !Database || !QChain || !QMolSet || !QAtom )
	{	pCmdUI->SetText( strChain ); 
		return;
	}

	if( !QMolSet->visible && !DisplayMode )
		return;

	if( QMolSet->copynum!=1 )
		strChain.Format("%s #%d ",QMolSet->title,QMolSet->copynum);
	else
		strChain.Format("%s ",QMolSet->title);

	if( QChain->ident!=' ' )
    {	strChain += " Chain: ";
		strChain += QChain->ident;
	}

    CString strModel;
	strModel = "";
	if( QAtom->model )
		strModel.Format(" Model: %d",QAtom->model);
    pCmdUI->SetText( strChain+strModel ); 
}

void CMainFrame::OnUpdateIndicatorGroup(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strGroup;
	strGroup = "";

	if( !Database || !QGroup )
	{	pCmdUI->SetText( strGroup ); 
		return;
	}

	if( QMolSet && !QMolSet->visible && !DisplayMode )
		return;

	if (!(QGroup->serno == -9999))
	{	char *str = Residue[QGroup->refno];
		if( str[0]!=' ' )  strGroup += str[0];
        strGroup += str[1];
		strGroup += str[2];
	
		CString strSerno;
		strSerno.IsEmpty();
        strSerno.Format( " %d",QGroup->serno);
        if( !(QGroup->insert == ' ') && !(QGroup->insert=='\0') )
			strSerno += QGroup->insert;
		pCmdUI->SetText( strGroup+strSerno ); 
	}
}

void CMainFrame::OnUpdateIndicatorAtom(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strAtom;
	strAtom = "";

	if( !Database || !QAtom )
	{	pCmdUI->SetText( strAtom ); 
		return;
	}

	if( QMolSet && !QMolSet->visible && !DisplayMode )
		return;
	
	char *str = ElemDesc[QAtom->refno];

    int i = 0;
    while( str[i]!='\0' )
    {   strAtom += str[i]; 
        i++;
    }

    if( !(QAtom->altl == ' '))
    {   strAtom += ';';
        strAtom += QAtom->altl;
	}
    CString strSerno;
	strSerno = "";
    strSerno.Format( " %d", QAtom->serno ); 
    pCmdUI->SetText( strAtom+strSerno ); 
}

void CMainFrame::OnUpdateIndicatorXCoor(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strXcoor;
	strXcoor = "";
   
	if( !Database || !QAtom )
	{	pCmdUI->SetText( strXcoor ); 
		return;
	}

	if( QMolSet && !QMolSet->visible && !DisplayMode )
		return;
    strXcoor.Format( "x %.3f", QXCoor );
    pCmdUI->SetText( strXcoor ); 
}

void CMainFrame::OnUpdateIndicatorYCoor(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strYcoor;
	strYcoor = "";
   
	if( !Database || !QAtom )
	{	pCmdUI->SetText( strYcoor ); 
		return;
	}

	if( QMolSet && !QMolSet->visible && !DisplayMode )
		return;
    strYcoor.Format( "y %.3f", QYCoor );
    pCmdUI->SetText( strYcoor ); 
}

void CMainFrame::OnUpdateIndicatorZCoor(CCmdUI *pCmdUI)
{
    pCmdUI->Enable();

    CString strZcoor;
	strZcoor = "";
   
	if( !Database || !QAtom )
	{	pCmdUI->SetText( strZcoor ); 
		return;
	}

	if( QMolSet && !QMolSet->visible && !DisplayMode )
		return;
    strZcoor.Format( "z %.3f", QZCoor );
    pCmdUI->SetText( strZcoor ); 
}

void CMainFrame::OnUpdateIndicatorCoor(CCmdUI *pCmdUI)
{    pCmdUI->Enable();

// NS May 2002
    CString strCoor;
    if( SysCoor == MolCoor )
        strCoor = "moleculaire";
    else if( SysCoor == WorldCoor )
        strCoor = "univers";
    else if( SysCoor == ScreenCoor )
        strCoor = "ecran";
    else if( SysCoor == AbsCoor )
        strCoor = "absolut";
    else
        strCoor = " ";
    pCmdUI->SetText( strCoor ); 
}

/*==================*/
/* Picking Handlers */
/*==================*/

void CMainFrame::OnPickAtom() 
{	if( PickMode==PickAtom )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickAtom);
}

void CMainFrame::OnUpdatePickAtom(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickAtom );
	}
}

void CMainFrame::OnPickGroup() 
{	if( PickMode==PickGroup )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickGroup);
}

void CMainFrame::OnUpdatePickGroup(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickGroup );
	}
}

void CMainFrame::OnPickChain() 
{	if( PickMode==PickChain )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickChain);
}

void CMainFrame::OnUpdatePickChain(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickChain );
	}
}

void CMainFrame::OnPickMolset() 
{	if( PickMode==PickMolSet )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickMolSet);
}

void CMainFrame::OnUpdatePickMolset(CCmdUI* pCmdUI) 
{	if( Database==NULL || (MoleculeList && (MoleculeList->next==NULL)) )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickMolSet );
	}
}

void CMainFrame::OnPickCentre() 
{	if( PickMode==PickCentr )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickCentr);
}

void CMainFrame::OnUpdatePickCentre(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickCentr );
	}
}

void CMainFrame::OnPickBond() 
{	if( PickMode==PickBond )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickBond);
}

void CMainFrame::OnUpdatePickBond(CCmdUI* pCmdUI) 
{	if( Database == NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickBond );
	}
}

void CMainFrame::OnPickRotbond() 
{	if( PickMode==PickRBond )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickRBond);
}

void CMainFrame::OnUpdatePickRotbond(CCmdUI* pCmdUI) 
{	if( Database == NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickRBond );
	}
}

void CMainFrame::OnPickMonitor() 
{	if( PickMode==PickMonit )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickMonit);
}

void CMainFrame::OnUpdatePickMonitor(CCmdUI* pCmdUI) 
{	if( Database == NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickMonit );
	}
}

void CMainFrame::OnPickLabel() 
{	if( PickMode==PickLabel )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickLabel);
}

void CMainFrame::OnUpdatePickLabel(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickLabel );
	}
}

void CMainFrame::OnPickDistance() 
{	if( PickMode==PickDist )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickDist);
}

void CMainFrame::OnUpdatePickDistance(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickDist );
	}
}

void CMainFrame::OnPickAngle() 
{	if( PickMode==PickAngle )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickAngle);
}

void CMainFrame::OnUpdatePickAngle(CCmdUI* pCmdUI) 
{	if( Database==NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickAngle );
	}
}

void CMainFrame::OnPickTorsion() 
{	if( PickMode==PickTorsn )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickTorsn);
}

void CMainFrame::OnUpdatePickTorsion(CCmdUI* pCmdUI) 
{	if( Database == NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickTorsn );
	}
}

void CMainFrame::OnPickLight() 
{	if( PickMode==PickLight )
		::SetPickMode(PickIdent);
	else
		::SetPickMode(PickLight);
}

void CMainFrame::OnUpdatePickLight(CCmdUI* pCmdUI) 
{	if( Database == NULL )
	{	pCmdUI->Enable(false);
		pCmdUI->SetCheck(false);
	} else
	{	pCmdUI->Enable(true);
		pCmdUI->SetCheck( PickMode==PickLight );
	}
}
// NS 9 mai 2002
void CMainFrame::OnChangeCoordinates() 
{	if( Database==NULL )
		return;
	CRasView* pView = GetActiveRasView();
	if( pView==NULL )
		return;
     if( SysCoor == MolCoor )
    {	pView->ExecuteCommand( DisplayOff, "set coordinate world\n" );
        WriteString("Coordonnees : Univers.\n");
    } else if( SysCoor == WorldCoor )
    {	pView->ExecuteCommand( DisplayOff, "set coordinate screen\n" );
        WriteString("Coordonnees : Ecran.\n");
    } else if( SysCoor == ScreenCoor )
    {	pView->ExecuteCommand( DisplayOff, "set coordinate absolute\n" );
        WriteString("Coordonnees : Absolutes.\n");
    } else if( SysCoor == AbsCoor )
    {	pView->ExecuteCommand( DisplayOff, "set coordinate molecule\n" );
        WriteString("Coordonnees : Molecule.\n");
    }

    m_wndCommandBar.UpdatePannel();
}

void CMainFrame::OnUpdateChangeCoordinates(CCmdUI* pCmdUI) 
{	pCmdUI->Enable(true);
    pCmdUI->SetCheck(false);
}

/////////////////////////////////////////////////////////////////////////////

/*Active RasView*/
CRasView* CMainFrame::GetActiveRasView()
{	CMDIChildWnd *pChild = (CMDIChildWnd *) GetActiveFrame();
	if ( pChild == NULL )
		return NULL;
	CRasView *pView = (CRasView *) pChild->GetActiveView();
	if( pView == NULL )
		return NULL;
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CRasView)));
	return pView;
}

void CMainFrame::OnCommandColor(UINT nID)
{	m_wndColorBar.OnCommandHandler(nID);
}

LRESULT CMainFrame::OnChangeColor(WPARAM wParam, LPARAM lParam )
{	m_crColour = (COLORREF) wParam;
	return 0L;
}

/*Selections*/
void CMainFrame::SetSelection( int nMode, CString& sExpression)
{	if( Database==NULL )
		return;
	CRasView* pView = GetActiveRasView();
	if( pView==NULL )
		return;
	if( sExpression.IsEmpty() )
		return;

	switch(nMode)
	{ case(SELECTION_EMPTY)	:
	  case(SELECTION_NEW)	:	
		pView->ExecuteCommand( DisplayOn, "select (" + sExpression + ")\n" );
		break;
	  case(SELECTION_ADD)	:	
		pView->ExecuteCommand( DisplayOn, "select (" + sExpression + \
		") || selected\n" );
		break;
	  case(SELECTION_REMOVE):	
		pView->ExecuteCommand( DisplayOn, "select selected and not ("	+ \
		sExpression + ")\n" );
		break;
	  case(SELECTION_EXTRACT):	
		pView->ExecuteCommand( DisplayOn,"select (" + sExpression + \
		") && selected\n" );
		break;
	  case(SELECTION_EXCLUDE):		
		pView->ExecuteCommand( DisplayOn, 
							"select (" + sExpression + ") and not selected\n" );
		break;
	  default				:
		return;
	}
}

void CMainFrame::OnSelectionNew()
{	if( !Database ) return;
	if( m_SelectString.IsEmpty() )
		return;
	SetSelection( SELECTION_NEW, m_SelectString );
}

void CMainFrame::OnUpdateSelectionNew(CCmdUI* pCmdUI)
{	/*pCmdUI->Enable( Database != NULL );*/	}

void CMainFrame::OnSelectionAdd()
{	if( !Database ) return;
	if( m_SelectString.IsEmpty() )
		return;
	SetSelection( SELECTION_ADD, m_SelectString );
}

void CMainFrame::OnUpdateSelectionAdd(CCmdUI* pCmdUI)
{	/*pCmdUI->Enable( Database != NULL );*/	}

void CMainFrame::OnSelectionRemove()
{	if( !Database ) return;
	if( m_SelectString.IsEmpty() )
		return;
	SetSelection( SELECTION_REMOVE, m_SelectString );
}

void CMainFrame::OnUpdateSelectionRemove(CCmdUI* pCmdUI)
{	/*pCmdUI->Enable( Database != NULL );*/	}

void CMainFrame::OnSelectionExtract()
{	if( !Database ) return;
	if( m_SelectString.IsEmpty() )
		return;
	SetSelection( SELECTION_EXTRACT, m_SelectString );
}

void CMainFrame::OnUpdateSelectionExtract(CCmdUI* pCmdUI)
{	/*pCmdUI->Enable( Database!=NULL );*/	}

void CMainFrame::OnSelectionExclude()
{	if( !Database ) return;
	if( m_SelectString.IsEmpty() )
		return;
	SetSelection(SELECTION_EXCLUDE, m_SelectString);
}

void CMainFrame::OnUpdateSelectionExclude(CCmdUI* pCmdUI)
{	/*pCmdUI->Enable( Database!=NULL );*/	}


/*Preferences*/

void CMainFrame::OnFilePreferences() 
{	m_wndCommandBar.KillTimerPannel();
	CDialogPreference dlg;
	dlg.m_ZoomEdit = ClipBoardFactor;
	dlg.m_SequenceTrue = SeqFormat;
	dlg.m_SequenceFalse = !SeqFormat;
	dlg.m_coord_mol = (SysCoor==MolCoor);
	dlg.m_coord_world = (SysCoor==WorldCoor);
	dlg.m_coord_abs = (SysCoor==AbsCoor);
	dlg.m_coord_screen = (SysCoor==ScreenCoor);

	CString HelpSource = HelpHTMLSource;
	dlg.m_HelpSource = HelpSource;
	CString DefaultRepres = DefaultScriptName;
	dlg.m_DefaultRepres = DefaultRepres;

	if( dlg.DoModal()!=IDOK )
	{	m_wndCommandBar.SetTimerPannel();
		return;
	} 

	if( ClipBoardFactor != dlg.m_ZoomEdit )
	{	ClipBoardFactor = dlg.m_ZoomEdit;
		PrefsModified = true;
	}

	if( SeqFormat != dlg.m_SequenceTrue )
	{	SeqFormat = dlg.m_SequenceTrue;
		PrefsModified = true;
	}

    if(	dlg.m_coord_mol&(SysCoor!=MolCoor) )
    {   SysCoor = MolCoor;
        m_wndCommandBar.UpdatePannel();
		PrefsModified = true;
    } else if( dlg.m_coord_world&(SysCoor!=WorldCoor) )
    {   SysCoor = WorldCoor;
        m_wndCommandBar.UpdatePannel();
		PrefsModified = true;
    } else if( dlg.m_coord_screen&(SysCoor!=ScreenCoor) )
    {   SysCoor = ScreenCoor;
        m_wndCommandBar.UpdatePannel();
		PrefsModified = true;
    } else if( dlg.m_coord_abs&(SysCoor!=AbsCoor) )
    {   SysCoor = AbsCoor;
        m_wndCommandBar.UpdatePannel();
		PrefsModified = true;
    }

	if( !(DefaultRepres == dlg.m_DefaultRepres) )
	{	dlg.m_DefaultRepres.LockBuffer();
		strncpy(DefaultScriptName,dlg.m_DefaultRepres,241);
		dlg.m_DefaultRepres.UnlockBuffer();
		PrefsModified = true;
	}

	if( !(HelpSource == dlg.m_HelpSource) )
	{	dlg.m_HelpSource.LockBuffer();
		strncpy(HelpHTMLSource,dlg.m_HelpSource,247);
		dlg.m_HelpSource.UnlockBuffer();
		PrefsModified = true;
	}

	m_wndCommandBar.SetTimerPannel();
}

void CMainFrame::OnSetPreferences() 
{	m_wndCommandBar.KillTimerPannel();
	CDialogLoadPrefs dlg;

    CString PrefsPath = PrefFileName;
	dlg.m_PrefsPath = PrefsPath;

	if( dlg.DoModal()!=IDOK )
	{	m_wndCommandBar.SetTimerPannel();
		return;
	} 

	if( !(PrefsPath == dlg.m_PrefsPath) )
	{	dlg.m_PrefsPath.LockBuffer();
		strncpy(PrefFileName,dlg.m_PrefsPath,241);
		dlg.m_PrefsPath.UnlockBuffer();
		PrefsModified = true;
        ReadPrefs();
	}

   	m_wndCommandBar.SetTimerPannel();
}


BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{	int nDoc = 0;
	CMDIChildWnd *pChild = (CMDIChildWnd *) GetActiveFrame();
	CRasDoc* pDoc = (CRasDoc *) pChild->GetActiveDocument( );
	if( pDoc != NULL )
	{	CDocTemplate* pDocTemp;
		pDocTemp = pDoc->GetDocTemplate( );
		POSITION posdoc = pDocTemp->GetFirstDocPosition( );
		while(posdoc != NULL)
		{	pDoc = (CRasDoc *)pDocTemp->GetNextDoc(posdoc);
			nDoc++;
		}
	}

	//0x0000ff00 = 65280 - allow document switch through the menu when pause
	BOOL b = 
		(int) LOWORD(wParam) >= 65280 && (int) LOWORD(wParam) <= (65280 + nDoc -1);
	//allow to switch command pannel if paused
	if( (int) LOWORD(wParam)==ID_COMMANDVIEW )
		b = true;
	//same for full screen
	if( (int) LOWORD(wParam)==ID_VIEW_MENU )
		b = true;

	BOOL c = IsPaused && !b && !( (int) HIWORD(wParam) );
	if( c )
	{	WriteString("Type any key to continue the script or <Esc> to terminate\n");
		return true;
	}
	
	return CMDIFrameWnd::OnCommand(wParam, lParam);
}

LRESULT CMainFrame::UpdateAllViews(WPARAM wParam, LPARAM lParam)
{
	CRasView* pPrevView = NULL;
	CRasView* pNextView = NULL;
	CRasDoc* pPrevDoc;
	CRasDoc* pNextDoc;

	CMDIChildWnd *pChild = (CMDIChildWnd *) GetActiveFrame();
	pPrevDoc = (CRasDoc *) pChild->GetActiveDocument( );
	CDocTemplate* pDocTemp;
	pDocTemp = pPrevDoc->GetDocTemplate( );
	POSITION posdoc = pDocTemp->GetFirstDocPosition( );

	//Activate all views successively
	//to cause redrawing of each database.
	while( posdoc!=NULL )
	{	//Save data from previous
		pPrevView = GetActiveRasView();
		ASSERT( pPrevView!=NULL );
		if( pPrevView!=NULL )
		{	pPrevDoc = (CRasDoc *)pPrevView->GetDocument();
			pPrevDoc->ManageDisplay(false);
		}

		//Get the doc and the unique view
		pNextDoc = (CRasDoc *)pDocTemp->GetNextDoc(posdoc);
		POSITION posview = pNextDoc->GetFirstViewPosition( );
		pNextView = (CRasView *)pNextDoc->GetNextView( posview );
		ASSERT( posview==0 && pNextView!=NULL );

		pChild = (CMDIChildWnd *)pNextView->GetParentFrame( );
		pChild->MDIActivate();

		//Pseudo Onsize
		CRect rec;
		pNextView->GetWindowRect( (LPRECT) rec );
		if( int dx = rec.Width( )%4 )
			rec.right += 4-dx;
		pNextDoc->m_DataDisplay.Data_XRange = rec.Width( );
		pNextDoc->m_DataDisplay.Data_YRange = rec.Height( );
		pNextDoc->FixRange();
		if( Database )
        	ReDrawFlag |= RFReSize;
		pNextView->RefreshView();	
	}

	return 0L;
}

//Get available client area in screen coordinates
CRect CMainFrame::GetScreenClientCoor()
{	CRect rRecFrame;
	CRect rect;

	GetClientRect( (LPRECT) rRecFrame );
	ClientToScreen( (LPRECT) rRecFrame );

	if( (m_wndMainBar.GetStyle() & WS_VISIBLE) != 0 &&
		 !m_wndMainBar.IsFloating( ) )
	{	m_wndMainBar.GetWindowRect(&rect);
		rRecFrame.top = rect.bottom ;
	}

	if( (m_wndSelectBar.GetStyle() & WS_VISIBLE) != 0 )
	{	m_wndSelectBar.GetWindowRect(&rect);
		if( rect.bottom > rRecFrame.top )
			rRecFrame.top = rect.bottom ;
	}

	if( (m_wndCommandBar.GetStyle() & WS_VISIBLE) != 0 )
	{	m_wndCommandBar.GetWindowRect( &rect );
		rRecFrame.bottom = rect.top;
	} else if( (m_wndStatusBar.GetStyle() & WS_VISIBLE) != 0 )
	{	m_wndStatusBar.GetWindowRect( &rect );
		rRecFrame.bottom = rect.top;
	}

	return(rRecFrame);
}


/*======*/
/* Help */
/*======*/

void CMainFrame::OnHelpRasTop() 
{	InitHelpHTML();	}

/* Handle F1 key */
BOOL CMainFrame::OnHelpInfo(HELPINFO* pHelpInfo) 
{	OnHelpRasTop();
	return true;
}
