/*
 * Decompiled with CFR 0.152.
 */
package BioDynPackage;

import BioDynPackage.BioDyn;
import BioDynPackage.Connexel;
import BioDynPackage.Environnement;
import BioDynPackage.Moteur;
import BioDynPackage.Reaxel;
import BioDynPackage.UtilPointF;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.GroupLayout;

public class MoteurDeplacement
extends Moteur {
    public MoteurDeplacement() {
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void BioDynExec_Principale(String msg, ArrayList<BioDyn> lstManip) {
        super.BioDynExec_Principale(msg, lstManip);
        this.Deplacer();
        this.BioDynExec_Relayer(this._ListManipulesCourante);
    }

    void Deplacer() {
        Environnement bd_ctrl = this._env;
        this.DeplacerTout(bd_ctrl);
        bd_ctrl.labelTime.setText(new Integer(bd_ctrl._time).toString());
    }

    public void DeplacerTout(Environnement bd_ctrl) {
        for (int pos_in_list = bd_ctrl._liste_reaxels.size() - 1; pos_in_list >= 0; --pos_in_list) {
            Reaxel c = bd_ctrl._liste_reaxels.get(pos_in_list);
            if (c == null) continue;
            c._deja_assemble = false;
        }
        ArrayList<ArrayList<Reaxel>> lst_agregats = this.Assemblages(bd_ctrl);
        for (int pos_in_list = bd_ctrl._liste_connexel.size() - 1; pos_in_list >= 0; --pos_in_list) {
            Connexel c = bd_ctrl._liste_connexel.get(pos_in_list);
            if (c == null || !c.Impermeable) continue;
            int x0 = c.r0._x;
            int y0 = c.r0._y;
            int x1 = c.r1._x;
            int y1 = c.r1._y;
            bd_ctrl.TracerLigneConnexel(x0, y0, x1, y1, c, bd_ctrl._matrice_connexels);
        }
        ArrayList<Integer> lst_int = this._env.liste_entiers_melanges(lst_agregats.size());
        for (int a = 0; a < lst_agregats.size(); ++a) {
            Point direction = this.ChoixDeplacementAssemblage(bd_ctrl, lst_agregats.get(lst_int.get(a)));
            this.DeplacementAssemblage(bd_ctrl, lst_agregats.get(lst_int.get(a)), direction);
        }
    }

    ArrayList<ArrayList<Reaxel>> Assemblages(Environnement bd_ctrl) {
        ArrayList<ArrayList<Reaxel>> lst_agregats = new ArrayList<ArrayList<Reaxel>>();
        for (int pos_in_list = bd_ctrl._liste_reaxels.size() - 1; pos_in_list >= 0; --pos_in_list) {
            Reaxel c = bd_ctrl._liste_reaxels.get(pos_in_list);
            ArrayList<Reaxel> agregat = this.Assemblage(c);
            if (agregat == null) continue;
            lst_agregats.add(agregat);
        }
        return lst_agregats;
    }

    ArrayList<Reaxel> Assemblage(Reaxel r) {
        if (r._deja_assemble) {
            return null;
        }
        r._deja_assemble = true;
        ArrayList<Reaxel> lst_reaxels = new ArrayList<Reaxel>();
        lst_reaxels.add(r);
        for (int l = 0; l < r._cubes.size(); ++l) {
            ArrayList<Reaxel> lst_reaxels_tmp = this.Assemblage(r._cubes.get(l));
            if (lst_reaxels_tmp == null) continue;
            lst_reaxels.addAll(lst_reaxels_tmp);
        }
        if (lst_reaxels.size() == 0) {
            return null;
        }
        return lst_reaxels;
    }

    UtilPointF InteretEnRotation(Environnement bd_ctrl, Reaxel c, int x, int y) {
        UtilPointF interet_max = new UtilPointF(0.0f, 0.0f);
        UtilPointF interet = new UtilPointF(0.0f, 0.0f);
        double II_max = 9999.0;
        c.tourner(true);
        for (int rot = -1; rot < 2; ++rot) {
            double II = 0.0;
            for (int sous_case = 0; sous_case < 8; ++sous_case) {
                double charge = c._charges_[sous_case];
                double champ = bd_ctrl._matrice_champs[x][y][sous_case];
                double I = Math.pow(champ * charge, 1.0);
                II += I;
            }
            interet.X = (float)Math.pow(Math.exp(-II) / (Math.exp(II) + Math.exp(-II)), 1.0);
            if (rot != 0) {
                if (II < II_max) {
                    interet_max.X = interet.X;
                    interet_max.Y = rot;
                    II_max = II;
                }
            } else if (II <= II_max) {
                interet_max.X = interet.X;
                interet_max.Y = rot;
                II_max = II;
            }
            c.tourner(false);
        }
        c.tourner(true);
        c.tourner(true);
        return interet_max;
    }

    UtilPointF InteretEnPosition2(Environnement bd_ctrl, Reaxel c, int x, int y) {
        UtilPointF interet_max = new UtilPointF(0.0f, 0.0f);
        UtilPointF interet = new UtilPointF(0.0f, 0.0f);
        double II_max = 0.0;
        int dx = x - c._x;
        int dy = y - c._y;
        int sc0 = 0;
        int sc1 = 0;
        if (dx == 1 && dy == 0) {
            sc1 = 0;
        }
        if (dx == 1 && dy == -1) {
            sc1 = 1;
        }
        if (dx == 0 && dy == -1) {
            sc1 = 2;
        }
        if (dx == -1 && dy == -1) {
            sc1 = 3;
        }
        if (dx == -1 && dy == 0) {
            sc1 = 4;
        }
        if (dx == -1 && dy == 1) {
            sc1 = 5;
        }
        if (dx == 0 && dy == 1) {
            sc1 = 6;
        }
        if (dx == 1 && dy == 1) {
            sc1 = 7;
        }
        sc0 = (sc1 + 4) % 8;
        double c0 = c._charges_[sc0];
        double c1 = bd_ctrl._matrice_champs[x][y][sc1];
        double dc = c1 - c0;
        double II = (2.0 - (1.0 + Math.tanh(c0 * c1 / 100.0))) / 2.0;
        interet_max.X = (float)Math.pow(II, 10.0);
        return interet_max;
    }

    UtilPointF InteretEnPosition(Environnement bd_ctrl, Reaxel c, int x, int y) {
        UtilPointF interet_max = new UtilPointF(0.0f, 0.0f);
        UtilPointF interet = new UtilPointF(0.0f, 0.0f);
        double II_max = 0.0;
        double II = 0.0;
        for (int sous_case = 0; sous_case < 8; ++sous_case) {
            double charge = c._charges_[sous_case];
            double champ = bd_ctrl._matrice_champs[x][y][sous_case];
            double I = Math.pow(champ * charge, 1.0);
            II += I;
        }
        double res = 0.0;
        res = II < -1000.0 ? 1.0 : (II > 1000.0 ? 0.0 : Math.pow(Math.exp(-(II /= 50.0)) / (Math.exp(II) + Math.exp(-II)), 1.0));
        interet_max.X = interet.X = (float)res;
        return interet_max;
    }

    Point ChoixDeplacementAssemblage(Environnement bd_ctrl, ArrayList<Reaxel> agregat) {
        if (bd_ctrl._rnd.nextDouble() < 0.0 && agregat.size() == 1) {
            Reaxel cs = agregat.get(0);
            bd_ctrl.PlacerChampReaxel2(cs, cs._x, cs._y, false);
            UtilPointF interet_rot = this.InteretEnPosition2(bd_ctrl, cs, cs._x, cs._y);
            if ((double)interet_rot.Y > 0.5) {
                cs.tourner(false);
            }
            if ((double)interet_rot.Y < -0.5) {
                cs.tourner(true);
            }
            bd_ctrl.PlacerChampReaxel2(cs, cs._x, cs._y, true);
        }
        double proba_deplacement = 1.0;
        for (int r = 0; r < agregat.size(); ++r) {
            Reaxel c = agregat.get(r);
            proba_deplacement *= c._mobilite_translation;
        }
        if (bd_ctrl._rnd.nextDouble() < 1.0 - proba_deplacement) {
            return new Point(0, 0);
        }
        double FX = 0.0;
        double FY = 0.0;
        for (int r = 0; r < agregat.size(); ++r) {
            Reaxel c = agregat.get(r);
            int i = c._x;
            int j = c._y;
            double I = 0.0;
            double[][] I_charges = new double[3][3];
            int x0_env = i - 1;
            int x1_env = i + 1;
            int y0_env = j - 1;
            int y1_env = j + 1;
            for (int ii_env = x0_env; ii_env <= x1_env; ++ii_env) {
                for (int jj_env = y0_env; jj_env <= y1_env; ++jj_env) {
                    int xl_proba = ii_env - x0_env;
                    int yl_proba = jj_env - y0_env;
                    int xl_cube = xl_proba + 1;
                    int yl_cube = yl_proba + 1;
                    int new_x = ii_env;
                    int new_y = jj_env;
                    new_x = new_x < 0 ? (new_x += bd_ctrl._tailleX) : (new_x %= bd_ctrl._tailleX);
                    new_y = new_y < 0 ? (new_y += bd_ctrl._tailleY) : (new_y %= bd_ctrl._tailleY);
                    bd_ctrl.PlacerChampReaxel2(c, new_x, new_y, false);
                    UtilPointF interet = this.InteretEnPosition2(bd_ctrl, c, new_x, new_y);
                    bd_ctrl.PlacerChampReaxel2(c, new_x, new_y, true);
                }
            }
            double angle_thermic = Math.PI * 2 * bd_ctrl._rnd.nextDouble();
            double intensite_thermic = bd_ctrl._rnd.nextDouble();
            double[] dArray = bd_ctrl._matrice_migration_fx[i];
            int n = j;
            dArray[n] = dArray[n] + intensite_thermic * Math.cos(angle_thermic);
            double[] dArray2 = bd_ctrl._matrice_migration_fy[i];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + intensite_thermic * Math.sin(angle_thermic);
            double fx = bd_ctrl._matrice_migration_fx[i][j];
            double fy = bd_ctrl._matrice_migration_fy[i][j];
            FX += fx;
            FY += fy;
        }
        double intensite = Math.sqrt(FX * FX + FY * FY);
        int dx = 0;
        int dy = 0;
        if (bd_ctrl._rnd.nextDouble() < intensite) {
            double angle = Math.atan2(FY, FX);
            if (Math.abs(Math.cos(angle)) > 0.5) {
                dx = (int)Math.signum(Math.cos(angle));
                dy = 0;
            } else {
                dy = (int)Math.signum(Math.sin(angle));
                dx = 0;
            }
        }
        return new Point(dx, dy);
    }

    boolean DeplacementAssemblage(Environnement bd_ctrl, ArrayList<Reaxel> agregat, Point direction) {
        Reaxel n1;
        Reaxel n0;
        Connexel l;
        int ic;
        int j;
        int i;
        Reaxel c;
        int r;
        if (direction.getX() == 0.0 && direction.getY() == 0.0) {
            return false;
        }
        boolean possible = true;
        for (int r2 = 0; r2 < agregat.size(); ++r2) {
            Reaxel c2 = agregat.get(r2);
            bd_ctrl.GommerToutesLignesConnexels(c2, bd_ctrl._matrice_connexels);
            bd_ctrl._matrice_reaxels_futur[c2._x][c2._y] = null;
            if (!c2._selectionne) continue;
            possible = false;
        }
        int insere_impossible = -1;
        for (r = 0; r < agregat.size(); ++r) {
            c = agregat.get(r);
            i = (int)((double)c._x + direction.getX());
            j = (int)((double)c._y + direction.getY());
            i = i < 0 ? (i += bd_ctrl._tailleX) : (i %= bd_ctrl._tailleX);
            j = j < 0 ? (j += bd_ctrl._tailleY) : (j %= bd_ctrl._tailleY);
            if (possible && (bd_ctrl._matrice_reaxels_futur[i][j] != null || this._env._matrice_connexels[i][j] != null)) {
                if (c._insertion_lien != null) {
                    ic = this._env.IndexLienDansMatrice(c._insertion_lien, i, j, this._env._matrice_connexels);
                    if (ic == -1) {
                        possible = false;
                        insere_impossible = 1;
                        r = agregat.size();
                    } else {
                        l = this._env._matrice_connexels[i][j].get(ic);
                        n0 = l.r0;
                        n1 = l.r1;
                        if (!c._lst_connexels.contains(l) && bd_ctrl._matrice_reaxels_futur[i][j] == null) {
                            this._env.GommerLigneConnexel(n0._x, n0._y, n1._x, n1._y, l, this._env._matrice_connexels);
                            if (this._env._matrice_connexels[i][j] != null || c._lst_connexels.size() > 0 || !this._env.LigneLibreExcluExtremites(i, j, n0._x, n0._y, this._env._matrice_connexels) || !this._env.LigneLibreExcluExtremites(i, j, n1._x, n1._y, this._env._matrice_connexels)) {
                                possible = false;
                                insere_impossible = 2;
                                r = agregat.size();
                            }
                            this._env.TracerLigneConnexel(n0._x, n0._y, n1._x, n1._y, l, this._env._matrice_connexels);
                        } else {
                            possible = false;
                            insere_impossible = 2;
                            r = agregat.size();
                        }
                    }
                } else {
                    possible = false;
                    insere_impossible = 3;
                    r = agregat.size();
                }
            }
            if (!possible) continue;
            for (int l2 = 0; l2 < c._lst_connexels.size(); ++l2) {
                int y1;
                int x1;
                int y0;
                int x0;
                Connexel co = c._lst_connexels.get(l2);
                if (co.r0 == c) {
                    x0 = i;
                    y0 = j;
                    x1 = co.r1._x;
                    y1 = co.r1._y;
                } else {
                    x0 = co.r0._x;
                    y0 = co.r0._y;
                    x1 = i;
                    y1 = j;
                }
                if (!this._env.LigneLibreExcluExtremites(x0, y0, x1, y1, this._env._matrice_connexels)) {
                    possible = false;
                    insere_impossible = 5;
                    r = agregat.size();
                    continue;
                }
                if (this._env.LigneLibreExcluExtremites(x0, y0, x1, y1, this._env._matrice_reaxels_futur)) continue;
                possible = false;
                insere_impossible = 5;
                r = agregat.size();
            }
        }
        if (!possible) {
            direction.setLocation(0, 0);
        }
        for (r = 0; r < agregat.size(); ++r) {
            c = agregat.get(r);
            i = (int)((double)c._x + direction.getX());
            j = (int)((double)c._y + direction.getY());
            i = i < 0 ? (i += bd_ctrl._tailleX) : (i %= bd_ctrl._tailleX);
            j = j < 0 ? (j += bd_ctrl._tailleY) : (j %= bd_ctrl._tailleY);
            if (bd_ctrl._matrice_reaxels_futur[i][j] == null && this._env._matrice_connexels[i][j] == null) {
                c._x = i;
                c._y = j;
                bd_ctrl._matrice_reaxels_futur[i][j] = c;
            } else if (possible && this._env._matrice_connexels[i][j] != null) {
                ic = this._env.IndexLienDansMatrice(c._insertion_lien, i, j, this._env._matrice_connexels);
                if (ic >= 0) {
                    l = this._env._matrice_connexels[i][j].get(ic);
                    n0 = l.r0;
                    n1 = l.r1;
                    if (this._env.LigneLibreExcluExtremites(i, j, n0._x, n0._y, this._env._matrice_reaxels_futur) && this._env.LigneLibreExcluExtremites(i, j, n1._x, n1._y, this._env._matrice_reaxels_futur)) {
                        this._env.GommerLigneConnexel(n0._x, n0._y, n1._x, n1._y, l, this._env._matrice_connexels);
                        this._env.EnleverConnexel(l);
                        this._env.AjouterConnexel(n0, c, l._nom);
                        this._env.AjouterConnexel(c, n1, l._nom);
                    }
                }
                c._x = i;
                c._y = j;
                this._env._matrice_reaxels_futur[i][j] = c;
            } else {
                c._x = i;
                c._y = j;
                this._env._matrice_reaxels_futur[i][j] = c;
            }
            bd_ctrl.TracerToutesLignesConnexels(c, bd_ctrl._matrice_connexels);
        }
        return possible;
    }
}

