/*
 * Decompiled with CFR 0.152.
 */
package BioDynPackage;

import BioDynPackage.BioDyn;
import BioDynPackage.Environnement;
import BioDynPackage.Moteur;
import BioDynPackage.Reaction;
import BioDynPackage.Reaxel;
import BioDynPackage.WndEditElementDeReaction;
import bsh.Interpreter;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class MoteurReaction
extends Moteur {
    private JSlider jSlider_k;
    public JTextPane _description = new JTextPane();
    private double _k = 1.0;
    public ArrayList<String> reactifs = new ArrayList();
    public ArrayList<String> produits = new ArrayList();
    public int _type = 0;
    public ArrayList<Reaction> _reactionsPossibles = new ArrayList();
    private Interpreter _interpreteur = null;
    public JTextArea _code = new JTextArea();
    public boolean _code_parse = false;
    public ArrayList<WndEditElementDeReaction> _ListElementsReactions = new ArrayList();

    public MoteurReaction() {
        this.initComponents();
        this.button_move.setVisible(false);
        this.button_display_relations.setVisible(false);
        this.button_timer.setVisible(false);
        this.boxManipulated.setVisible(false);
        this.boxNames.setVisible(false);
        this.boxRelais.setVisible(false);
    }

    private void initComponents() {
        this.jSlider_k = new JSlider();
        this.setBackground(new Color(191, 251, 155));
        this.setTitre("Titre");
        this.jSlider_k.setBackground(new Color(191, 251, 155));
        this.jSlider_k.setPaintLabels(true);
        this.jSlider_k.setPaintTicks(true);
        this.jSlider_k.setToolTipText("Modifie la probabilite de la reaction");
        this.jSlider_k.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MoteurReaction.this.jSlider_kMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                MoteurReaction.this.jSlider_kMouseMoved(evt);
            }
        });
        this.jSlider_k.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
                MoteurReaction.this.jSlider_kCaretPositionChanged(evt);
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
            }
        });
        this.add(this.jSlider_k);
        this.jSlider_k.setBounds(1, 25, 237, 39);
    }

    private void jSlider_kCaretPositionChanged(InputMethodEvent evt) {
        this._k = (double)this.jSlider_k.getValue() / 100.0;
        String str = this.getEtiquettes() + ", p=" + Double.valueOf(this._k).toString();
        this.setTitre(str);
    }

    private void jSlider_kMouseDragged(MouseEvent evt) {
        this._k = (double)this.jSlider_k.getValue() / 100.0;
        String str = this.getEtiquettes() + ", p=" + Double.valueOf(this._k).toString();
        this.setTitre(str);
    }

    private void jSlider_kMouseMoved(MouseEvent evt) {
    }

    @Override
    public void BioDynExec_Principale(String msg, ArrayList<BioDyn> lstManip) {
        super.BioDynExec_Principale(msg, lstManip);
        this._reactionsPossibles = new ArrayList();
        if (this._type == 0) {
            this.simuler_semi_situee();
        }
        if (this._type == 1) {
            this.simuler_situee_abs();
        }
        if (this._type == 2) {
            this.simuler_complexe();
        }
        this._env.decrementer_nb_processus_a_traiter();
    }

    public void simuler_complexe() {
        if (this._code.getText().length() == 0) {
            return;
        }
        Reaction rp = new Reaction();
        rp._type = 2;
        rp._nom = this._etiquettes;
        if (!this._code_parse) {
            this._code_parse = true;
            this._interpreteur = new Interpreter();
        }
        try {
            this._interpreteur.set("reaction", (Object)rp);
            this._interpreteur.eval(this._code.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
        boolean possible = true;
        for (int j = this._env._liste_reaxels.size() - 1; j >= 0; --j) {
            rp = rp.cloner();
            Reaxel c_a = this._env._liste_reaxels.get(j);
            possible = true;
            if (c_a._selectionne) continue;
            int x0 = c_a._x;
            int y0 = c_a._y;
            double hasard = this._env._rnd.nextDouble();
            possible = hasard < this._k ? this._env.ReactionComplexe_possible(x0, y0, rp) : false;
            if (!possible) continue;
            rp.x_centre = x0;
            rp.y_centre = y0;
            this._reactionsPossibles.add(rp);
        }
    }

    public void simuler_situee_abs() {
        if (this.reactifs.size() > 0) {
            Environnement cliEnv = this._env;
            Point[] indexes = new Point[8];
            for (int p = 0; p < 8; ++p) {
                indexes[p] = new Point();
            }
            indexes[0].x = 1;
            indexes[0].y = 0;
            indexes[1].x = 1;
            indexes[1].y = -1;
            indexes[2].x = 0;
            indexes[2].y = -1;
            indexes[3].x = -1;
            indexes[3].y = -1;
            indexes[4].x = -1;
            indexes[4].y = 0;
            indexes[5].x = -1;
            indexes[5].y = 1;
            indexes[6].x = 0;
            indexes[6].y = 1;
            indexes[7].x = 1;
            indexes[7].y = 1;
            for (int j = cliEnv._liste_reaxels.size() - 1; j >= 0; --j) {
                int yb;
                int xb;
                Reaxel c_a = cliEnv._liste_reaxels.get(j);
                if (!c_a._nom.equals(this.reactifs.get(0)) || c_a._selectionne) continue;
                int x = c_a._x;
                int y = c_a._y;
                double hasard = cliEnv._rnd.nextDouble();
                if (!(hasard < this._k)) continue;
                boolean possible = true;
                for (int r = 1; r < this.reactifs.size(); ++r) {
                    xb = x + indexes[r - 1].x;
                    yb = y + indexes[r - 1].y;
                    if (xb < 0) {
                        xb += cliEnv._tailleX;
                    } else if (xb >= cliEnv._tailleX) {
                        xb -= cliEnv._tailleX;
                    }
                    if (yb < 0) {
                        yb += cliEnv._tailleY;
                    } else if (yb >= cliEnv._tailleY) {
                        yb -= cliEnv._tailleY;
                    }
                    if (!this.reactifs.get(r).equals("")) {
                        if (cliEnv._matrice_reaxels[xb][yb] != null) {
                            if (cliEnv._matrice_reaxels[xb][yb]._selectionne) {
                                possible = false;
                                r = this.reactifs.size();
                                continue;
                            }
                            if (cliEnv._matrice_reaxels[xb][yb]._nom.equals(this.reactifs.get(r))) continue;
                            possible = false;
                            r = this.reactifs.size();
                            continue;
                        }
                        if (this.reactifs.get(r).equals("vide")) continue;
                        possible = false;
                        r = this.reactifs.size();
                        continue;
                    }
                    if (r >= this.produits.size() || this.produits.get(r).equals("") || cliEnv._matrice_reaxels[xb][yb] == null && cliEnv._matrice_connexels[xb][yb] == null) continue;
                    possible = false;
                    r = this.reactifs.size();
                }
                if (!possible) continue;
                Reaction rp = new Reaction();
                this._reactionsPossibles.add(rp);
                rp._reactifs_noms.add(cliEnv._matrice_reaxels[x][y]._nom);
                rp._reactifs_pos.add(new Point(x, y));
                if (!this.produits.get(0).equals("")) {
                    rp._produits_noms.add(this.produits.get(0));
                    rp._produits_pos.add(new Point(x, y));
                }
                for (int r = 1; r < this.reactifs.size(); ++r) {
                    xb = x + indexes[r - 1].x;
                    yb = y + indexes[r - 1].y;
                    if (xb < 0) {
                        xb += cliEnv._tailleX;
                    } else if (xb >= cliEnv._tailleX) {
                        xb -= cliEnv._tailleX;
                    }
                    if (yb < 0) {
                        yb += cliEnv._tailleY;
                    } else if (yb >= cliEnv._tailleY) {
                        yb -= cliEnv._tailleY;
                    }
                    if (!this.reactifs.get(r).equals("")) {
                        rp._reactifs_noms.add(this.reactifs.get(r));
                        rp._reactifs_pos.add(new Point(xb, yb));
                    }
                    if (r >= this.produits.size() || this.produits.get(r).equals("")) continue;
                    rp._produits_noms.add(this.produits.get(r));
                    rp._produits_pos.add(new Point(xb, yb));
                }
            }
        }
    }

    public void simuler_semi_situee() {
        HashMap<String, Point> dico_rea = new HashMap<String, Point>();
        if (this.reactifs.size() > 0) {
            Environnement cliEnv = this._env;
            for (int j = cliEnv._liste_reaxels.size() - 1; j >= 0; --j) {
                int yb;
                int xb;
                int yy;
                int xx;
                Reaxel c_a = cliEnv._liste_reaxels.get(j);
                if (!c_a._nom.equals(this.reactifs.get(0)) || c_a._selectionne) continue;
                int x = c_a._x;
                int y = c_a._y;
                double hasard = cliEnv._rnd.nextDouble();
                if (!(hasard < this._k)) continue;
                boolean tousLesReactifs = true;
                ArrayList<Reaxel> listReactifs = new ArrayList<Reaxel>();
                listReactifs.add(cliEnv._matrice_reaxels[x][y]);
                for (int r = 1; r < this.reactifs.size(); ++r) {
                    boolean trouve = false;
                    if (!this.reactifs.get(r).equals("")) {
                        ArrayList<Reaxel> lst_reactifs_tmp = new ArrayList<Reaxel>();
                        for (xx = x - 1; xx <= x + 1; ++xx) {
                            for (yy = y - 1; yy <= y + 1; ++yy) {
                                if (x - xx != 0 && y - yy != 0) continue;
                                xb = xx;
                                yb = yy;
                                if (xx < 0) {
                                    xb = xx + cliEnv._tailleX;
                                } else if (xx >= cliEnv._tailleX) {
                                    xb = xx - cliEnv._tailleX;
                                }
                                if (yy < 0) {
                                    yb = yy + cliEnv._tailleY;
                                } else if (yy >= cliEnv._tailleY) {
                                    yb = yy - cliEnv._tailleY;
                                }
                                if (cliEnv._matrice_reaxels[xb][yb] != null) {
                                    if (cliEnv._matrice_reaxels[xb][yb]._selectionne || xb == x && yb == y || !cliEnv._matrice_reaxels[xb][yb]._nom.equals(this.reactifs.get(r)) || listReactifs.contains(cliEnv._matrice_reaxels[xb][yb])) continue;
                                    lst_reactifs_tmp.add(cliEnv._matrice_reaxels[xb][yb]);
                                    trouve = true;
                                    continue;
                                }
                                if (!this.reactifs.get(r).equals("vide")) continue;
                                boolean deja_present = false;
                                for (int re = 0; re < listReactifs.size(); ++re) {
                                    if (((Reaxel)listReactifs.get((int)re))._x != xb || ((Reaxel)listReactifs.get((int)re))._y != yb) continue;
                                    deja_present = true;
                                    re = listReactifs.size();
                                }
                                if (deja_present) continue;
                                Reaxel tmp_cube = new Reaxel();
                                tmp_cube._x = xb;
                                tmp_cube._y = yb;
                                lst_reactifs_tmp.add(tmp_cube);
                                trouve = true;
                            }
                        }
                        if (trouve) {
                            int n = cliEnv._rnd.nextInt(lst_reactifs_tmp.size());
                            listReactifs.add((Reaxel)lst_reactifs_tmp.get(n));
                        }
                    } else {
                        trouve = true;
                    }
                    if (trouve) continue;
                    tousLesReactifs = false;
                    r = this.produits.size();
                }
                boolean espace_pour_produits = false;
                ArrayList<Point> lst_pos = new ArrayList<Point>();
                int nb_produits_effectif = 0;
                if (tousLesReactifs) {
                    for (int pr = 0; pr < this.produits.size(); ++pr) {
                        if (this.produits.get(pr).equals("")) continue;
                        ++nb_produits_effectif;
                    }
                    for (xx = x - 1; xx <= x + 1; ++xx) {
                        for (yy = y - 1; yy <= y + 1; ++yy) {
                            if (x - xx != 0 && y - yy != 0) continue;
                            xb = xx;
                            yb = yy;
                            if (xx < 0) {
                                xb = xx + cliEnv._tailleX;
                            } else if (xx >= cliEnv._tailleX) {
                                xb = xx - cliEnv._tailleX;
                            }
                            if (yy < 0) {
                                yb = yy + cliEnv._tailleY;
                            } else if (yy >= cliEnv._tailleY) {
                                yb = yy - cliEnv._tailleY;
                            }
                            if (xx == x && yy == y) {
                                lst_pos.add(new Point(xb, yb));
                                continue;
                            }
                            if (cliEnv._matrice_reaxels[xb][yb] == null && cliEnv._matrice_connexels[xb][yb] == null) {
                                lst_pos.add(new Point(xb, yb));
                                continue;
                            }
                            if (!listReactifs.contains(cliEnv._matrice_reaxels[xb][yb])) continue;
                            lst_pos.add(new Point(xb, yb));
                        }
                    }
                    if (lst_pos.size() >= nb_produits_effectif) {
                        espace_pour_produits = true;
                    }
                }
                if (!espace_pour_produits) continue;
                Reaction rp = new Reaction();
                this._reactionsPossibles.add(rp);
                for (int r = 0; r < listReactifs.size(); ++r) {
                    int posx = 0;
                    int posy = 0;
                    if (listReactifs.get(r) != null) {
                        posx = ((Reaxel)listReactifs.get((int)r))._x;
                        posy = ((Reaxel)listReactifs.get((int)r))._y;
                        if (((Reaxel)listReactifs.get((int)r))._nom != null) {
                            rp._reactifs_noms.add(cliEnv._matrice_reaxels[posx][posy]._nom);
                            rp._reactifs_pos.add(new Point(posx, posy));
                        }
                    }
                    if (r >= this.produits.size() || this.produits.get(r).equals("")) continue;
                    rp._produits_noms.add(this.produits.get(r));
                    rp._produits_pos.add(new Point(posx, posy));
                    lst_pos.remove(new Point(posx, posy));
                }
                for (int p = listReactifs.size(); p < this.produits.size(); ++p) {
                    if (this.produits.get(p).equals("")) continue;
                    int pos = cliEnv._rnd.nextInt(lst_pos.size());
                    Point pt = (Point)lst_pos.get(pos);
                    rp._produits_noms.add(this.produits.get(p));
                    rp._produits_pos.add(new Point(pt.x, pt.y));
                    lst_pos.remove(pt);
                }
                int deltaReactifs = listReactifs.size() - 1;
                for (int ra = 0; ra < listReactifs.size(); ++ra) {
                    int pos_in_lst = cliEnv._liste_reaxels.indexOf(listReactifs.get(ra));
                    if (pos_in_lst >= 0 && pos_in_lst < j && ((Reaxel)listReactifs.get((int)ra))._nom != null) {
                        --deltaReactifs;
                    }
                    if (((Reaxel)listReactifs.get((int)ra))._nom != null) continue;
                    --deltaReactifs;
                }
                j -= deltaReactifs;
                if (!dico_rea.containsKey(this.getEtiquettes())) {
                    dico_rea.put(this.getEtiquettes(), new Point(cliEnv._time, 1));
                    continue;
                }
                Point pt = (Point)dico_rea.get(this.getEtiquettes());
                ++pt.y;
                dico_rea.put(this.getEtiquettes(), pt);
            }
        }
    }

    public void set_k(double k) {
        this._k = k;
        int val = (int)(k * 100.0);
        this.jSlider_k.setValue(val);
        this.setTitre(this.getEtiquettes() + ", p=" + Double.valueOf(this._k).toString());
    }

    public double get_k() {
        return this._k;
    }

    @Override
    public void sauvegarder(String abs_path, BufferedWriter saveStream) {
        super.sauvegarder(abs_path, saveStream);
        try {
            int i;
            for (i = 0; i < this.reactifs.size(); ++i) {
                saveStream.write("\treactif:" + this.reactifs.get(i) + "\n");
            }
            for (i = 0; i < this.produits.size(); ++i) {
                saveStream.write("\tproduit:" + this.produits.get(i) + "\n");
            }
            saveStream.write("\tk:" + Double.valueOf(this._k).toString() + "\n");
            saveStream.write("\ttype:" + Integer.valueOf(this._type).toString() + "\n");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }
}

