/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Object;
import idx3d.idx3d_Scene;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vertex;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class idx3d_3ds_Exporter {
    private idx3d_3ds_Exporter() {
    }

    public static void exportToStream(OutputStream outputStream, idx3d_Scene idx3d_Scene2) {
        System.out.println(">> Exporting scene to 3ds stream ...");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            idx3d_3ds_Exporter.exportScene(idx3d_Scene2, bufferedOutputStream);
            outputStream.close();
        }
        catch (Throwable throwable) {
            System.out.println(throwable + "");
        }
    }

    private static void writeString(String string, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        outputStream.write(byArray);
        outputStream.write(0);
    }

    private static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    private static void writeShort(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    private static void writeFloat(float f, OutputStream outputStream) throws IOException {
        idx3d_3ds_Exporter.writeInt(Float.floatToIntBits(f), outputStream);
    }

    private static void exportScene(idx3d_Scene idx3d_Scene2, OutputStream outputStream) throws IOException {
        idx3d_Scene2.rebuild();
        int n = 0;
        int n2 = 0;
        while (n2 < idx3d_Scene2.objects) {
            n += idx3d_Scene2.object[n2].name.length() + 1;
            n += 36 + 20 * idx3d_Scene2.object[n2].vertices + 8 * idx3d_Scene2.object[n2].triangles;
            ++n2;
        }
        idx3d_3ds_Exporter.writeShort(19789, outputStream);
        idx3d_3ds_Exporter.writeInt(12 + n, outputStream);
        idx3d_3ds_Exporter.writeShort(15677, outputStream);
        idx3d_3ds_Exporter.writeInt(6 + n, outputStream);
        int n3 = 0;
        while (n3 < idx3d_Scene2.objects) {
            idx3d_3ds_Exporter.exportObject(idx3d_Scene2.object[n3], outputStream);
            ++n3;
        }
    }

    private static void exportObject(idx3d_Object idx3d_Object2, OutputStream outputStream) throws IOException {
        int n = 2 + 12 * idx3d_Object2.vertices;
        int n2 = 2 + 8 * idx3d_Object2.triangles;
        int n3 = 2 + 8 * idx3d_Object2.vertices;
        idx3d_3ds_Exporter.writeShort(16384, outputStream);
        idx3d_3ds_Exporter.writeInt(30 + n + n2 + n3 + idx3d_Object2.name.length() + 1, outputStream);
        idx3d_3ds_Exporter.writeString(idx3d_Object2.name, outputStream);
        idx3d_3ds_Exporter.writeShort(16640, outputStream);
        idx3d_3ds_Exporter.writeInt(24 + n + n2 + n3, outputStream);
        idx3d_3ds_Exporter.writeShort(16656, outputStream);
        idx3d_3ds_Exporter.writeInt(6 + n, outputStream);
        idx3d_3ds_Exporter.writeShort(idx3d_Object2.vertices, outputStream);
        int n4 = 0;
        while (n4 < idx3d_Object2.vertices) {
            idx3d_3ds_Exporter.exportVertex(idx3d_Object2.vertex[n4], outputStream);
            ++n4;
        }
        idx3d_3ds_Exporter.writeShort(16672, outputStream);
        idx3d_3ds_Exporter.writeInt(6 + n2, outputStream);
        idx3d_3ds_Exporter.writeShort(idx3d_Object2.triangles, outputStream);
        int n5 = 0;
        while (n5 < idx3d_Object2.triangles) {
            idx3d_3ds_Exporter.exportTriangle(idx3d_Object2.triangle[n5], outputStream);
            ++n5;
        }
        idx3d_3ds_Exporter.writeShort(16704, outputStream);
        idx3d_3ds_Exporter.writeInt(6 + n3, outputStream);
        idx3d_3ds_Exporter.writeShort(idx3d_Object2.vertices, outputStream);
        int n6 = 0;
        while (n6 < idx3d_Object2.vertices) {
            idx3d_3ds_Exporter.exportMappingCoordinates(idx3d_Object2.vertex[n6], outputStream);
            ++n6;
        }
    }

    private static void exportVertex(idx3d_Vertex idx3d_Vertex2, OutputStream outputStream) throws IOException {
        idx3d_3ds_Exporter.writeFloat(idx3d_Vertex2.pos.x, outputStream);
        idx3d_3ds_Exporter.writeFloat(-idx3d_Vertex2.pos.y, outputStream);
        idx3d_3ds_Exporter.writeFloat(idx3d_Vertex2.pos.z, outputStream);
    }

    private static void exportTriangle(idx3d_Triangle idx3d_Triangle2, OutputStream outputStream) throws IOException {
        idx3d_3ds_Exporter.writeShort(idx3d_Triangle2.p1.id, outputStream);
        idx3d_3ds_Exporter.writeShort(idx3d_Triangle2.p2.id, outputStream);
        idx3d_3ds_Exporter.writeShort(idx3d_Triangle2.p3.id, outputStream);
        idx3d_3ds_Exporter.writeShort(0, outputStream);
    }

    private static void exportMappingCoordinates(idx3d_Vertex idx3d_Vertex2, OutputStream outputStream) throws IOException {
        idx3d_3ds_Exporter.writeFloat(idx3d_Vertex2.u, outputStream);
        idx3d_3ds_Exporter.writeFloat(idx3d_Vertex2.v, outputStream);
    }
}

