/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Math;

public final class idx3d_Color {
    public static final int ALPHA = -16777216;
    public static final int RED = 0xFF0000;
    public static final int GREEN = 65280;
    public static final int BLUE = 255;
    public static final int MASK7Bit = 0xFEFEFF;
    public static final int MASK6Bit = 0xFCFCFC;
    public static final int RGB = 0xFFFFFF;
    private static int pixel;
    private static int color;
    private static int overflow;
    private static int scale;
    private static int r;
    private static int g;
    private static int b;

    public static int random(int n, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        return idx3d_Color.getCropColor(n3 += (int)(idx3d_Math.random() * (float)n2), n4 += (int)(idx3d_Math.random() * (float)n2), n5 += (int)(idx3d_Math.random() * (float)n2));
    }

    public static final int random() {
        return (int)(Math.random() * 1.6777216E7);
    }

    public static int subneg(int n, int n2) {
        pixel = (n & 0xFEFEFF) + (n2 & 0xFEFEFF);
        overflow = ~pixel & 0x1010100;
        overflow -= overflow >> 8;
        return 0xFF000000 | ~overflow & pixel;
    }

    public static int getRed(int n) {
        return (n & 0xFF0000) >> 16;
    }

    private idx3d_Color() {
    }

    public static int getColor(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int getCropColor(int n, int n2, int n3) {
        return 0xFF000000 | idx3d_Math.crop(n, 0, 255) << 16 | idx3d_Math.crop(n2, 0, 255) << 8 | idx3d_Math.crop(n3, 0, 255);
    }

    public static int add(int n, int n2) {
        pixel = (n & 0xFEFEFF) + (n2 & 0xFEFEFF);
        overflow = pixel & 0x1010100;
        overflow -= overflow >> 8;
        return 0xFF000000 | overflow | pixel;
    }

    public static int mix(int n, int n2) {
        return 0xFF000000 | ((n & 0xFEFEFF) >> 1) + ((n2 & 0xFEFEFF) >> 1);
    }

    public static int multiply(int n, int n2) {
        if ((n & 0xFFFFFF) == 0) {
            return 0;
        }
        if ((n2 & 0xFFFFFF) == 0) {
            return 0;
        }
        r = (n >> 16 & 0xFF) * (n2 >> 16 & 0xFF) >> 8;
        g = (n >> 8 & 0xFF) * (n2 >> 8 & 0xFF) >> 8;
        b = (n & 0xFF) * (n2 & 0xFF) >> 8;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getAverage(int n) {
        return (((n & 0xFF0000) >> 16) + ((n & 0xFF00) >> 8) + (n & 0xFF)) / 3;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public static int sub(int n, int n2) {
        pixel = (n & 0xFEFEFF) + (~n2 & 0xFEFEFF);
        overflow = ~pixel & 0x1010100;
        overflow -= overflow >> 8;
        return 0xFF000000 | ~overflow & pixel;
    }

    public static int[] makeGradient(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray.length == 1) {
            int n2 = nArray[0];
            int n3 = 0;
            while (n3 < n) {
                nArray2[n3] = n2;
                ++n3;
            }
            return nArray2;
        }
        int n4 = 0;
        while (n4 < nArray.length - 1) {
            int n5 = nArray[n4];
            int n6 = nArray[n4 + 1];
            int n7 = n * n4 / (nArray.length - 1);
            int n8 = n * (n4 + 1) / (nArray.length - 1);
            int n9 = n8 - n7;
            int n10 = idx3d_Color.getRed(n5) << 16;
            int n11 = idx3d_Color.getGreen(n5) << 16;
            int n12 = idx3d_Color.getBlue(n5) << 16;
            int n13 = idx3d_Color.getRed(n6) << 16;
            int n14 = idx3d_Color.getGreen(n6) << 16;
            int n15 = idx3d_Color.getBlue(n6) << 16;
            int n16 = (n13 - n10) / n9;
            int n17 = (n14 - n11) / n9;
            int n18 = (n15 - n12) / n9;
            int n19 = n10;
            int n20 = n11;
            int n21 = n12;
            int n22 = n7;
            while (n22 < n8) {
                nArray2[n22] = idx3d_Color.getColor(n19 >> 16, n20 >> 16, n21 >> 16);
                n19 += n16;
                n20 += n17;
                n21 += n18;
                ++n22;
            }
            ++n4;
        }
        return nArray2;
    }

    public static int getGray(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = (n2 * 3 + n3 * 6 + n4) / 10;
        return 0xFF000000 | n5 << 16 | n5 << 8 | n5;
    }

    public static int getGreen(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static int inv(int n) {
        return 0xFF000000 | ~n;
    }

    public static int scale(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 255) {
            return n;
        }
        if (n2 == 127) {
            return (n & 0xFEFEFE) >> 1;
        }
        r = (n >> 16 & 0xFF) * n2 >> 8;
        g = (n >> 8 & 0xFF) * n2 >> 8;
        b = (n & 0xFF) * n2 >> 8;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int transparency(int n, int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        if (n3 == 255) {
            return n;
        }
        if (n3 == 127) {
            return idx3d_Color.mix(n, n2);
        }
        r = (n3 * ((n >> 16 & 0xFF) - (n2 >> 16 & 0xFF)) >> 8) + (n2 >> 16 & 0xFF);
        g = (n3 * ((n >> 8 & 0xFF) - (n2 >> 8 & 0xFF)) >> 8) + (n2 >> 8 & 0xFF);
        b = (n3 * ((n & 0xFF) - (n2 & 0xFF)) >> 8) + (n2 & 0xFF);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

