/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

public final class idx3d_Math {
    private static float[] sinus;
    private static float[] cosinus;
    private static boolean trig;
    public static float pi;
    private static float rad2scale;
    private static float pad;
    private static int[] fastRandoms;
    private static int fastRndPointer;
    private static boolean fastRndInit;

    public static final int crop(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static final float crop(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static final void clearBuffer(int[] nArray, int n) {
        int n2 = nArray.length - 1;
        int n3 = 1;
        int n4 = 1;
        nArray[0] = n;
        while (n3 < n2) {
            System.arraycopy(nArray, 0, nArray, n4, n3);
            n2 -= n3;
            n4 += n3;
            n3 <<= 1;
        }
        System.arraycopy(nArray, 0, nArray, n4, n2);
    }

    public static final float random() {
        return (float)(Math.random() * 2.0 - 1.0);
    }

    public static final float random(float f, float f2) {
        return (float)(Math.random() * (double)(f2 - f) + (double)f);
    }

    public static final float sin(float f) {
        if (!trig) {
            idx3d_Math.buildTrig();
        }
        return sinus[(int)((f + pad) * rad2scale) & 0xFFF];
    }

    public static final int fastRnd(int n) {
        if (n < 1) {
            return 0;
        }
        fastRndPointer = fastRndPointer + 1 & 0x1F;
        if (!fastRndInit) {
            fastRandoms = new int[32];
            int n2 = 0;
            do {
                idx3d_Math.fastRandoms[n2] = (int)idx3d_Math.random(0.0f, 1.6777215E7f);
            } while (++n2 < 32);
            fastRndInit = true;
        }
        return fastRandoms[fastRndPointer] & 1 << n - 1;
    }

    public static final float interpolate(float f, float f2, float f3) {
        float f4 = (1.0f - idx3d_Math.cos(f3 * pi)) * 0.5f;
        return f + f4 * (f2 - f);
    }

    private idx3d_Math() {
    }

    public static final float rad2deg(float f) {
        return f * 57.29578f;
    }

    private static void buildTrig() {
        System.out.println(">> Building idx3d_Math LUT");
        sinus = new float[4096];
        cosinus = new float[4096];
        int n = 0;
        do {
            idx3d_Math.sinus[n] = (float)Math.sin((float)n / rad2scale);
            idx3d_Math.cosinus[n] = (float)Math.cos((float)n / rad2scale);
        } while (++n < 4096);
        trig = true;
    }

    public static final void cropBuffer(int[] nArray, int n, int n2) {
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            nArray[n3] = idx3d_Math.crop(nArray[n3], n, n2);
            --n3;
        }
    }

    public static final void copyBuffer(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, idx3d_Math.crop(nArray.length, 0, nArray2.length));
    }

    public static final float pythagoras(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static final int pythagoras(int n, int n2) {
        return (int)Math.sqrt(n * n + n2 * n2);
    }

    public static final float randomWithDelta(float f, float f2) {
        return f + idx3d_Math.random() * f2;
    }

    public static final int fastRndBit() {
        return idx3d_Math.fastRnd(1);
    }

    static {
        pi = (float)Math.PI;
        rad2scale = 651.8986f;
        pad = 804.24774f;
    }

    public static final boolean inrange(int n, int n2, int n3) {
        return n >= n2 && n < n3;
    }

    public static final float deg2rad(float f) {
        return f * ((float)Math.PI / 180);
    }

    public static final float cos(float f) {
        if (!trig) {
            idx3d_Math.buildTrig();
        }
        return cosinus[(int)((f + pad) * rad2scale) & 0xFFF];
    }
}

