/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Camera;
import idx3d.idx3d_Matrix;
import idx3d.idx3d_Object;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vector;
import java.util.Enumeration;
import java.util.Vector;

public class idx3d_Vertex {
    public idx3d_Object parent;
    public idx3d_Vector pos = new idx3d_Vector();
    public idx3d_Vector pos2;
    public idx3d_Vector n = new idx3d_Vector();
    public idx3d_Vector n2;
    public int x;
    public int y;
    public int z;
    public float u;
    public float v;
    public int nx;
    public int ny;
    public int tx;
    public int ty;
    public boolean visible = true;
    int clipcode;
    public int id;
    private float fact;
    private Vector neighbor = new Vector();

    void resetNeighbors() {
        this.neighbor.removeAllElements();
    }

    public String toString() {
        return new String("<vertex  x=" + this.pos.x + " y=" + this.pos.y + " z=" + this.pos.z + " u=" + this.u + " v=" + this.v + ">\r\n");
    }

    public idx3d_Vertex() {
        this.pos = new idx3d_Vector(0.0f, 0.0f, 0.0f);
    }

    public idx3d_Vertex(float f, float f2, float f3) {
        this.pos = new idx3d_Vector(f, f2, f3);
    }

    public idx3d_Vertex(float f, float f2, float f3, float f4, float f5) {
        this.pos = new idx3d_Vector(f, f2, f3);
        this.u = f4;
        this.v = f5;
    }

    public idx3d_Vertex(idx3d_Vector idx3d_Vector2) {
        this.pos = idx3d_Vector2.getClone();
    }

    public idx3d_Vertex(idx3d_Vector idx3d_Vector2, float f, float f2) {
        this.pos = idx3d_Vector2.getClone();
        this.u = f;
        this.v = f2;
    }

    public void scaleTextureCoordinates(float f, float f2) {
        this.u *= f;
        this.v *= f2;
    }

    void project(idx3d_Matrix idx3d_Matrix2, idx3d_Matrix idx3d_Matrix3, idx3d_Camera idx3d_Camera2) {
        this.pos2 = this.pos.transform(idx3d_Matrix2);
        this.n2 = this.n.transform(idx3d_Matrix3);
        this.fact = (float)idx3d_Camera2.screenscale / idx3d_Camera2.fovfact / ((double)this.pos2.z > 0.1 ? this.pos2.z : 0.1f);
        this.x = (int)(this.pos2.x * this.fact + (float)(idx3d_Camera2.screenwidth >> 1));
        this.y = (int)(-this.pos2.y * this.fact + (float)(idx3d_Camera2.screenheight >> 1));
        this.z = (int)(65536.0f * this.pos2.z);
        this.nx = (int)(this.n2.x * 127.0f + 127.0f);
        this.ny = (int)(this.n2.y * 127.0f + 127.0f);
        if (this.parent.material == null) {
            return;
        }
        if (this.parent.material.texture == null) {
            return;
        }
        this.tx = (int)((float)this.parent.material.texture.width * this.u);
        this.ty = (int)((float)this.parent.material.texture.height * this.v);
    }

    public void setUV(float f, float f2) {
        this.u = f;
        this.v = f2;
    }

    void registerNeighbor(idx3d_Triangle idx3d_Triangle2) {
        if (!this.neighbor.contains(idx3d_Triangle2)) {
            this.neighbor.addElement(idx3d_Triangle2);
        }
    }

    public boolean equals(idx3d_Vertex idx3d_Vertex2) {
        return this.pos.x == idx3d_Vertex2.pos.x && this.pos.y == idx3d_Vertex2.pos.y && this.pos.z == idx3d_Vertex2.pos.z;
    }

    public boolean equals(idx3d_Vertex idx3d_Vertex2, float f) {
        return Math.abs(idx3d_Vector.sub(this.pos, idx3d_Vertex2.pos).length()) < f;
    }

    public idx3d_Vertex getClone() {
        idx3d_Vertex idx3d_Vertex2 = new idx3d_Vertex();
        idx3d_Vertex2.pos = this.pos.getClone();
        idx3d_Vertex2.n = this.n.getClone();
        idx3d_Vertex2.u = this.u;
        idx3d_Vertex2.v = this.v;
        return idx3d_Vertex2;
    }

    public void regenerateNormal() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Enumeration enumeration = this.neighbor.elements();
        while (enumeration.hasMoreElements()) {
            idx3d_Triangle idx3d_Triangle2 = (idx3d_Triangle)enumeration.nextElement();
            idx3d_Vector idx3d_Vector2 = idx3d_Triangle2.getWeightedNormal();
            f += idx3d_Vector2.x;
            f2 += idx3d_Vector2.y;
            f3 += idx3d_Vector2.z;
        }
        this.n = new idx3d_Vector(f, f2, f3).normalize();
    }

    void clipFrustrum(int n, int n2) {
        this.clipcode = 0;
        if (this.x < 0) {
            this.clipcode |= 1;
        }
        if (this.x >= n) {
            this.clipcode |= 2;
        }
        if (this.y < 0) {
            this.clipcode |= 4;
        }
        if (this.y >= n2) {
            this.clipcode |= 8;
        }
        if (this.pos2.z < 0.0f) {
            this.clipcode |= 0x10;
        }
        this.visible = this.clipcode == 0;
    }
}

