/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Math;
import idx3d.idx3d_Matrix;
import idx3d.idx3d_Vector;

public class idx3d_Camera {
    public idx3d_Matrix matrix = new idx3d_Matrix();
    public idx3d_Matrix normalmatrix = new idx3d_Matrix();
    boolean needsRebuild = true;
    public idx3d_Vector pos = new idx3d_Vector(0.0f, 0.0f, 0.0f);
    public idx3d_Vector lookat = new idx3d_Vector(0.0f, 0.0f, 0.0f);
    public float roll;
    float fovfact;
    int screenwidth;
    int screenheight;
    int screenscale;

    void rebuildMatrices() {
        if (!this.needsRebuild) {
            return;
        }
        this.needsRebuild = false;
        idx3d_Vector idx3d_Vector2 = idx3d_Vector.sub(this.lookat, this.pos);
        idx3d_Vector idx3d_Vector3 = new idx3d_Vector(0.0f, 1.0f, 0.0f);
        idx3d_Vector idx3d_Vector4 = idx3d_Vector.getNormal(idx3d_Vector3, idx3d_Vector2);
        idx3d_Vector3 = idx3d_Vector.getNormal(idx3d_Vector2, idx3d_Vector4);
        idx3d_Vector2.normalize();
        idx3d_Vector3.normalize();
        idx3d_Vector4.normalize();
        this.normalmatrix = new idx3d_Matrix(idx3d_Vector4, idx3d_Vector3, idx3d_Vector2);
        this.normalmatrix.rotate(0.0f, 0.0f, this.roll);
        this.matrix = this.normalmatrix.getClone();
        this.matrix.shift(this.pos.x, this.pos.y, this.pos.z);
        this.normalmatrix = this.normalmatrix.inverse();
        this.matrix = this.matrix.inverse();
    }

    public void lookAt(float f, float f2, float f3) {
        this.lookat = new idx3d_Vector(f, f2, f3);
        this.needsRebuild = true;
    }

    public void lookAt(idx3d_Vector idx3d_Vector2) {
        this.lookat = idx3d_Vector2;
        this.needsRebuild = true;
    }

    public final void rotate(float f, float f2, float f3) {
        this.pos = this.pos.transform(idx3d_Matrix.rotateMatrix(f, f2, f3));
        this.needsRebuild = true;
    }

    idx3d_Matrix getMatrix() {
        this.rebuildMatrices();
        return this.matrix;
    }

    idx3d_Matrix getNormalMatrix() {
        this.rebuildMatrices();
        return this.normalmatrix;
    }

    public final void rotate(idx3d_Vector idx3d_Vector2) {
        this.rotate(idx3d_Vector2.x, idx3d_Vector2.y, idx3d_Vector2.z);
    }

    public final void shift(float f, float f2, float f3) {
        this.pos = this.pos.transform(idx3d_Matrix.shiftMatrix(f, f2, f3));
        this.lookat = this.lookat.transform(idx3d_Matrix.shiftMatrix(f, f2, f3));
        this.needsRebuild = true;
    }

    public final void shift(idx3d_Vector idx3d_Vector2) {
        this.shift(idx3d_Vector2.x, idx3d_Vector2.y, idx3d_Vector2.z);
    }

    public void roll(float f) {
        this.roll += f;
        this.needsRebuild = true;
    }

    public static idx3d_Camera TOP() {
        idx3d_Camera idx3d_Camera2 = new idx3d_Camera();
        idx3d_Camera2.setPos(0.0f, -2.0f, 0.0f);
        return idx3d_Camera2;
    }

    public void setScreensize(int n, int n2) {
        this.screenwidth = n;
        this.screenheight = n2;
        this.screenscale = n < n2 ? n : n2;
    }

    public static idx3d_Camera RIGHT() {
        idx3d_Camera idx3d_Camera2 = new idx3d_Camera();
        idx3d_Camera2.setPos(-2.0f, 0.0f, 0.0f);
        return idx3d_Camera2;
    }

    public static idx3d_Camera FRONT() {
        idx3d_Camera idx3d_Camera2 = new idx3d_Camera();
        idx3d_Camera2.setPos(0.0f, 0.0f, -2.0f);
        return idx3d_Camera2;
    }

    public void setFov(float f) {
        this.fovfact = (float)Math.tan(idx3d_Math.deg2rad(f) / 2.0f);
    }

    public idx3d_Camera() {
        this.setFov(90.0f);
    }

    public idx3d_Camera(float f) {
        this.setFov(f);
    }

    public void setPos(float f, float f2, float f3) {
        this.pos = new idx3d_Vector(f, f2, f3);
        this.needsRebuild = true;
    }

    public void setPos(idx3d_Vector idx3d_Vector2) {
        this.pos = idx3d_Vector2;
        this.needsRebuild = true;
    }

    public static idx3d_Camera LEFT() {
        idx3d_Camera idx3d_Camera2 = new idx3d_Camera();
        idx3d_Camera2.setPos(2.0f, 0.0f, 0.0f);
        return idx3d_Camera2;
    }
}

