/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_ImageProducer;
import idx3d.idx3d_Math;
import idx3d.idx3d_Texture;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;

public class idx3d_Screen {
    public int[] pixel;
    public int width;
    public int height;
    int[] p;
    int w;
    int h;
    private Image image;
    private idx3d_ImageProducer producer;
    private ColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
    boolean antialias;
    private long timestamp;
    private long time;
    private int probes = 32;
    float FPS;

    private void performBench() {
        ++this.probes;
        if (this.probes > 32) {
            this.time = System.currentTimeMillis();
            this.FPS = 32.0f / ((float)(this.time - this.timestamp) / 1000.0f);
            this.timestamp = this.time;
            this.probes = 0;
        }
    }

    public void drawBackground(idx3d_Texture idx3d_Texture2, int n, int n2, int n3, int n4) {
        this.draw(this.p, this.w, this.h, idx3d_Texture2, n, n2, n3, n4);
    }

    public void draw(idx3d_Texture idx3d_Texture2, int n, int n2, int n3, int n4) {
        this.draw(this.pixel, this.width, this.height, idx3d_Texture2, n, n2, n3, n4);
    }

    private void draw(int[] nArray, int n, int n2, idx3d_Texture idx3d_Texture2, int n3, int n4, int n5, int n6) {
        if (idx3d_Texture2 == null) {
            return;
        }
        int n7 = n5;
        int n8 = n6;
        int n9 = n3;
        int n10 = n4;
        int n11 = idx3d_Texture2.width * 255;
        int n12 = idx3d_Texture2.height * 255;
        int n13 = idx3d_Texture2.width;
        int n14 = n11 / n7;
        int n15 = n12 / n8;
        int n16 = idx3d_Math.crop(-n9 * n14, 0, 255 * n11);
        int n17 = idx3d_Math.crop(-n10 * n15, 0, 255 * n12);
        int n18 = idx3d_Math.crop(n9 + n7, 0, n);
        int n19 = idx3d_Math.crop(n10 + n8, 0, n2);
        n9 = idx3d_Math.crop(n9, 0, n);
        n10 = idx3d_Math.crop(n10, 0, n2);
        n12 = n17;
        int n20 = n10;
        while (n20 < n19) {
            n11 = n16;
            int n21 = n20 * n;
            int n22 = (n12 >> 8) * n13;
            int n23 = n9;
            while (n23 < n18) {
                nArray[n23 + n21] = idx3d_Texture2.pixel[(n11 >> 8) + n22];
                n11 += n14;
                ++n23;
            }
            n12 += n15;
            ++n20;
        }
    }

    public idx3d_Texture asTexture() {
        return new idx3d_Texture(this.width, this.height, this.pixel);
    }

    public void add(idx3d_Texture idx3d_Texture2, int n, int n2, int n3, int n4) {
        this.add(this.pixel, this.width, this.height, idx3d_Texture2, n, n2, n3, n4);
    }

    private void add(int[] nArray, int n, int n2, idx3d_Texture idx3d_Texture2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n6;
        int n9 = n3;
        int n10 = n4;
        int n11 = idx3d_Texture2.width * 255;
        int n12 = idx3d_Texture2.height * 255;
        int n13 = idx3d_Texture2.width;
        int n14 = n11 / n7;
        int n15 = n12 / n8;
        int n16 = idx3d_Math.crop(-n9 * n14, 0, 255 * n11);
        int n17 = idx3d_Math.crop(-n10 * n15, 0, 255 * n12);
        int n18 = idx3d_Math.crop(n9 + n7, 0, n);
        int n19 = idx3d_Math.crop(n10 + n8, 0, n2);
        n9 = idx3d_Math.crop(n9, 0, n);
        n10 = idx3d_Math.crop(n10, 0, n2);
        n12 = n17;
        int n20 = n10;
        while (n20 < n19) {
            n11 = n16;
            int n21 = n20 * n;
            int n22 = (n12 >> 8) * n13;
            int n23 = n9;
            while (n23 < n18) {
                nArray[n23 + n21] = idx3d_Color.add(idx3d_Texture2.pixel[(n11 >> 8) + n22], this.pixel[n23 + n21]);
                n11 += n14;
                ++n23;
            }
            n12 += n15;
            ++n20;
        }
    }

    private void performAntialiasing() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.h >> 1) {
            int n3 = (n2 << 1) * this.w;
            int n4 = 0;
            while (n4 < this.w >> 1) {
                this.pixel[n] = ((this.p[n3] & 0xFCFCFC) >> 2) + ((this.p[n3 + 1] & 0xFCFCFC) >> 2) + ((this.p[n3 + this.w] & 0xFCFCFC) >> 2) + ((this.p[n3 + this.w + 1] & 0xFCFCFC) >> 2);
                ++n;
                n3 += 2;
                ++n4;
            }
            ++n2;
        }
    }

    public boolean antialias() {
        return this.antialias;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (this.antialias) {
            this.w = n * 2;
            this.h = n2 * 2;
            this.pixel = new int[n * n2];
            this.p = new int[this.w * this.h];
        } else {
            this.w = n;
            this.h = n2;
            this.pixel = new int[n * n2];
            this.p = this.pixel;
        }
        this.producer = new idx3d_ImageProducer(n, n2, this.cm, this.pixel);
        this.image = Toolkit.getDefaultToolkit().createImage(this.producer);
    }

    public void render() {
        if (this.antialias) {
            this.performAntialiasing();
        }
    }

    public void setAntialias(boolean bl) {
        if (this.antialias == bl) {
            return;
        }
        this.antialias = bl;
        if (this.antialias) {
            this.w = this.width * 2;
            this.h = this.height * 2;
            this.p = new int[this.w * this.h];
            return;
        }
        this.w = this.width;
        this.h = this.height;
        this.p = this.pixel;
    }

    public Image getImage() {
        this.producer.update();
        this.performBench();
        return this.image;
    }

    public final void clear(int n) {
        idx3d_Math.clearBuffer(this.p, n);
    }

    public idx3d_Screen(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.w = this.width;
        this.h = this.height;
        this.pixel = new int[n * n2];
        this.p = this.pixel;
        this.producer = new idx3d_ImageProducer(this.width, this.height, this.cm, this.pixel);
        this.image = Toolkit.getDefaultToolkit().createImage(this.producer);
    }
}

