/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_CoreObject;
import idx3d.idx3d_Edge;
import idx3d.idx3d_Material;
import idx3d.idx3d_Scene;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vector;
import idx3d.idx3d_Vertex;
import java.util.Enumeration;
import java.util.Vector;

public class idx3d_Object
extends idx3d_CoreObject {
    public Object userData;
    public String user;
    public Vector vertexData = new Vector();
    public Vector triangleData = new Vector();
    public int id;
    public String name = "";
    public boolean visible = true;
    public idx3d_Scene parent;
    private boolean dirty = true;
    idx3d_Vertex[] vertex;
    idx3d_Triangle[] triangle;
    public int vertices;
    public int triangles;
    public idx3d_Material material;

    public idx3d_Triangle triangle(int n) {
        return (idx3d_Triangle)this.triangleData.elementAt(n);
    }

    public void addTriangle(int n, int n2, int n3) {
        this.addTriangle(this.vertex(n), this.vertex(n2), this.vertex(n3));
    }

    public void rebuild() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.vertices = this.vertexData.size();
        this.vertex = new idx3d_Vertex[this.vertices];
        Enumeration enumeration = this.vertexData.elements();
        int n = this.vertices - 1;
        while (n >= 0) {
            this.vertex[n] = (idx3d_Vertex)enumeration.nextElement();
            --n;
        }
        this.triangles = this.triangleData.size();
        this.triangle = new idx3d_Triangle[this.triangles];
        enumeration = this.triangleData.elements();
        n = this.triangles - 1;
        while (n >= 0) {
            this.triangle[n] = (idx3d_Triangle)enumeration.nextElement();
            this.triangle[n].id = n;
            --n;
        }
        n = this.vertices - 1;
        while (n >= 0) {
            this.vertex[n].id = n;
            this.vertex[n].resetNeighbors();
            --n;
        }
        int n2 = this.triangles - 1;
        while (n2 >= 0) {
            idx3d_Triangle idx3d_Triangle2 = this.triangle[n2];
            idx3d_Triangle2.p1.registerNeighbor(idx3d_Triangle2);
            idx3d_Triangle2.p2.registerNeighbor(idx3d_Triangle2);
            idx3d_Triangle2.p3.registerNeighbor(idx3d_Triangle2);
            --n2;
        }
        this.regenerate();
    }

    public void addTriangle(idx3d_Vertex idx3d_Vertex2, idx3d_Vertex idx3d_Vertex3, idx3d_Vertex idx3d_Vertex4) {
        this.addTriangle(new idx3d_Triangle(idx3d_Vertex2, idx3d_Vertex3, idx3d_Vertex4));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<object id=" + this.name + ">\r\n");
        int n = 0;
        while (n < this.vertices) {
            stringBuffer.append(this.vertex[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void regenerate() {
        int n = 0;
        while (n < this.triangles) {
            this.triangle[n].regenerateNormal();
            ++n;
        }
        n = 0;
        while (n < this.vertices) {
            this.vertex[n].regenerateNormal();
            ++n;
        }
    }

    public idx3d_Vector max() {
        if (this.vertices == 0) {
            return new idx3d_Vector(0.0f, 0.0f, 0.0f);
        }
        float f = this.vertex[0].pos.x;
        float f2 = this.vertex[0].pos.y;
        float f3 = this.vertex[0].pos.z;
        int n = 1;
        while (n < this.vertices) {
            if (this.vertex[n].pos.x > f) {
                f = this.vertex[n].pos.x;
            }
            if (this.vertex[n].pos.y > f2) {
                f2 = this.vertex[n].pos.y;
            }
            if (this.vertex[n].pos.z > f3) {
                f3 = this.vertex[n].pos.z;
            }
            ++n;
        }
        return new idx3d_Vector(f, f2, f3);
    }

    public idx3d_Vector getCenter() {
        idx3d_Vector idx3d_Vector2 = this.max();
        idx3d_Vector idx3d_Vector3 = this.min();
        return new idx3d_Vector((idx3d_Vector2.x + idx3d_Vector3.x) / 2.0f, (idx3d_Vector2.y + idx3d_Vector3.y) / 2.0f, (idx3d_Vector2.z + idx3d_Vector3.z) / 2.0f);
    }

    public void scaleTextureCoordinates(float f, float f2) {
        this.rebuild();
        int n = 0;
        while (n < this.vertices) {
            this.vertex[n].scaleTextureCoordinates(f, f2);
            ++n;
        }
    }

    public void matrixMeltdown() {
        this.rebuild();
        int n = this.vertices - 1;
        while (n >= 0) {
            this.vertex[n].pos = this.vertex[n].pos.transform(this.matrix);
            --n;
        }
        this.regenerate();
        this.matrix.reset();
        this.normalmatrix.reset();
    }

    public void removeDuplicateVertices() {
        this.rebuild();
        Vector<idx3d_Edge> vector = new Vector<idx3d_Edge>();
        int n = 0;
        while (n < this.vertices) {
            int n2 = n + 1;
            while (n2 < this.vertices) {
                if (this.vertex[n].equals(this.vertex[n2], 1.0E-4f)) {
                    vector.addElement(new idx3d_Edge(this.vertex[n], this.vertex[n2]));
                }
                ++n2;
            }
            ++n;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.edgeCollapse((idx3d_Edge)enumeration.nextElement());
        }
        this.removeDegeneratedTriangles();
    }

    private void edgeCollapse(idx3d_Edge idx3d_Edge2) {
        idx3d_Vertex idx3d_Vertex2 = idx3d_Edge2.start();
        idx3d_Vertex idx3d_Vertex3 = idx3d_Edge2.end();
        if (!this.vertexData.contains(idx3d_Vertex2)) {
            return;
        }
        if (!this.vertexData.contains(idx3d_Vertex3)) {
            return;
        }
        this.rebuild();
        int n = 0;
        while (n < this.triangles) {
            idx3d_Triangle idx3d_Triangle2 = this.triangle(n);
            if (idx3d_Triangle2.p1 == idx3d_Vertex3) {
                idx3d_Triangle2.p1 = idx3d_Vertex2;
            }
            if (idx3d_Triangle2.p2 == idx3d_Vertex3) {
                idx3d_Triangle2.p2 = idx3d_Vertex2;
            }
            if (idx3d_Triangle2.p3 == idx3d_Vertex3) {
                idx3d_Triangle2.p3 = idx3d_Vertex2;
            }
            ++n;
        }
        this.vertexData.removeElement(idx3d_Vertex3);
    }

    public void removeTriangleAt(int n) {
        this.triangleData.removeElementAt(n);
    }

    public idx3d_Vertex vertex(int n) {
        return (idx3d_Vertex)this.vertexData.elementAt(n);
    }

    public void removeVertex(idx3d_Vertex idx3d_Vertex2) {
        this.vertexData.removeElement(idx3d_Vertex2);
    }

    public void meshSmooth() {
        this.rebuild();
        Math.sqrt(3.0);
        int n = 0;
        while (n < this.triangles) {
            idx3d_Triangle idx3d_Triangle2 = this.triangle(n);
            idx3d_Vertex idx3d_Vertex2 = idx3d_Triangle2.p1;
            idx3d_Vertex idx3d_Vertex3 = idx3d_Triangle2.p2;
            idx3d_Vertex idx3d_Vertex4 = idx3d_Triangle2.p3;
            idx3d_Vector idx3d_Vector2 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex3.pos, idx3d_Vertex2.pos));
            idx3d_Vector idx3d_Vector3 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex4.pos, idx3d_Vertex3.pos));
            idx3d_Vector idx3d_Vector4 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex2.pos, idx3d_Vertex4.pos));
            float f = idx3d_Vector.sub(idx3d_Vector2, idx3d_Vertex2.pos).length();
            float f2 = idx3d_Vector.sub(idx3d_Vector3, idx3d_Vertex3.pos).length();
            float f3 = idx3d_Vector.sub(idx3d_Vector4, idx3d_Vertex4.pos).length();
            idx3d_Vector idx3d_Vector5 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex2.n, idx3d_Vertex3.n));
            idx3d_Vector idx3d_Vector6 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex3.n, idx3d_Vertex4.n));
            idx3d_Vector idx3d_Vector7 = idx3d_Vector.scale(0.5f, idx3d_Vector.add(idx3d_Vertex4.n, idx3d_Vertex2.n));
            float f4 = 0.5f * (idx3d_Vertex2.u + idx3d_Vertex3.u);
            float f5 = 0.5f * (idx3d_Vertex2.v + idx3d_Vertex3.v);
            float f6 = 0.5f * (idx3d_Vertex3.u + idx3d_Vertex4.u);
            float f7 = 0.5f * (idx3d_Vertex3.v + idx3d_Vertex4.v);
            float f8 = 0.5f * (idx3d_Vertex4.u + idx3d_Vertex2.u);
            float f9 = 0.5f * (idx3d_Vertex4.v + idx3d_Vertex2.v);
            float f10 = 1.0f - idx3d_Vector5.length();
            float f11 = 1.0f - idx3d_Vector6.length();
            float f12 = 1.0f - idx3d_Vector7.length();
            idx3d_Vector5.normalize();
            idx3d_Vector6.normalize();
            idx3d_Vector7.normalize();
            idx3d_Vertex idx3d_Vertex5 = new idx3d_Vertex(idx3d_Vector.sub(idx3d_Vector2, idx3d_Vector.scale(f * f10, idx3d_Vector5)), f4, f5);
            idx3d_Vertex idx3d_Vertex6 = new idx3d_Vertex(idx3d_Vector.sub(idx3d_Vector3, idx3d_Vector.scale(f2 * f11, idx3d_Vector6)), f6, f7);
            idx3d_Vertex idx3d_Vertex7 = new idx3d_Vertex(idx3d_Vector.sub(idx3d_Vector4, idx3d_Vector.scale(f3 * f12, idx3d_Vector7)), f8, f9);
            this.addVertex(idx3d_Vertex5);
            this.addVertex(idx3d_Vertex6);
            this.addVertex(idx3d_Vertex7);
            idx3d_Triangle2.p2 = idx3d_Vertex5;
            idx3d_Triangle2.p3 = idx3d_Vertex7;
            this.addTriangle(idx3d_Vertex3, idx3d_Vertex6, idx3d_Vertex5);
            this.addTriangle(idx3d_Vertex4, idx3d_Vertex7, idx3d_Vertex6);
            this.addTriangle(idx3d_Vertex5, idx3d_Vertex6, idx3d_Vertex7);
            ++n;
        }
        this.removeDuplicateVertices();
    }

    public void removeTriangle(idx3d_Triangle idx3d_Triangle2) {
        this.triangleData.removeElement(idx3d_Triangle2);
    }

    public void tilt(float f) {
        this.rebuild();
        int n = 0;
        while (n < this.vertices) {
            this.vertex[n].pos = idx3d_Vector.add(this.vertex[n].pos, idx3d_Vector.random(f));
            ++n;
        }
        this.regenerate();
    }

    public void addVertex(idx3d_Vertex idx3d_Vertex2) {
        idx3d_Vertex2.parent = this;
        this.vertexData.addElement(idx3d_Vertex2);
        this.dirty = true;
    }

    public void addVertex(float f, float f2, float f3) {
        this.addVertex(new idx3d_Vertex(f, f2, f3));
    }

    public void addVertex(float f, float f2, float f3, float f4, float f5) {
        idx3d_Vertex idx3d_Vertex2 = new idx3d_Vertex(f, f2, f3);
        idx3d_Vertex2.setUV(f4, f5);
        this.addVertex(idx3d_Vertex2);
    }

    public idx3d_Vector getDimension() {
        idx3d_Vector idx3d_Vector2 = this.max();
        idx3d_Vector idx3d_Vector3 = this.min();
        return new idx3d_Vector(idx3d_Vector2.x - idx3d_Vector3.x, idx3d_Vector2.y - idx3d_Vector3.y, idx3d_Vector2.z - idx3d_Vector3.z);
    }

    public void removeDegeneratedTriangles() {
        this.rebuild();
        int n = 0;
        while (n < this.triangles) {
            if (this.triangle[n].degenerated()) {
                this.removeTriangleAt(n);
            }
            ++n;
        }
        this.dirty = true;
        this.rebuild();
    }

    public void detach() {
        idx3d_Vector idx3d_Vector2 = this.getCenter();
        int n = 0;
        while (n < this.vertices) {
            this.vertex[n].pos.x -= idx3d_Vector2.x;
            this.vertex[n].pos.y -= idx3d_Vector2.y;
            this.vertex[n].pos.z -= idx3d_Vector2.z;
            ++n;
        }
        this.shift(idx3d_Vector2);
    }

    public void removeVertexAt(int n) {
        this.vertexData.removeElementAt(n);
    }

    public idx3d_Vector min() {
        if (this.vertices == 0) {
            return new idx3d_Vector(0.0f, 0.0f, 0.0f);
        }
        float f = this.vertex[0].pos.x;
        float f2 = this.vertex[0].pos.y;
        float f3 = this.vertex[0].pos.z;
        int n = 1;
        while (n < this.vertices) {
            if (this.vertex[n].pos.x < f) {
                f = this.vertex[n].pos.x;
            }
            if (this.vertex[n].pos.y < f2) {
                f2 = this.vertex[n].pos.y;
            }
            if (this.vertex[n].pos.z < f3) {
                f3 = this.vertex[n].pos.z;
            }
            ++n;
        }
        return new idx3d_Vector(f, f2, f3);
    }

    public idx3d_Object getClone() {
        idx3d_Object idx3d_Object2 = new idx3d_Object();
        this.rebuild();
        int n = 0;
        while (n < this.vertices) {
            idx3d_Object2.addVertex(this.vertex[n].getClone());
            ++n;
        }
        n = 0;
        while (n < this.triangles) {
            idx3d_Object2.addTriangle(this.triangle[n].getClone());
            ++n;
        }
        idx3d_Object2.name = this.name + " [cloned]";
        idx3d_Object2.material = this.material;
        idx3d_Object2.matrix = this.matrix.getClone();
        idx3d_Object2.normalmatrix = this.normalmatrix.getClone();
        idx3d_Object2.rebuild();
        return idx3d_Object2;
    }

    public void setMaterial(idx3d_Material idx3d_Material2) {
        this.material = idx3d_Material2;
    }

    public void addTriangle(idx3d_Triangle idx3d_Triangle2) {
        idx3d_Triangle2.parent = this;
        this.triangleData.addElement(idx3d_Triangle2);
        this.dirty = true;
    }
}

