/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Matrix;
import idx3d.idx3d_Object;
import idx3d.idx3d_Vector;
import idx3d.idx3d_Vertex;

public class idx3d_Triangle {
    public idx3d_Object parent;
    public boolean visible = true;
    public boolean outOfFrustrum;
    public idx3d_Vertex p1;
    public idx3d_Vertex p2;
    public idx3d_Vertex p3;
    public idx3d_Vector n;
    public idx3d_Vector n2;
    private int minx;
    private int maxx;
    private int miny;
    private int maxy;
    private idx3d_Vector triangleCenter = new idx3d_Vector();
    float dist;
    public int id;

    public idx3d_Triangle(idx3d_Vertex idx3d_Vertex2, idx3d_Vertex idx3d_Vertex3, idx3d_Vertex idx3d_Vertex4) {
        this.p1 = idx3d_Vertex2;
        this.p2 = idx3d_Vertex3;
        this.p3 = idx3d_Vertex4;
    }

    public idx3d_Vector getCenter() {
        float f = (this.p1.pos.x + this.p2.pos.x + this.p3.pos.x) / 3.0f;
        float f2 = (this.p1.pos.y + this.p2.pos.y + this.p3.pos.y) / 3.0f;
        float f3 = (this.p1.pos.z + this.p2.pos.z + this.p3.pos.z) / 3.0f;
        return new idx3d_Vector(f, f2, f3);
    }

    public void project(idx3d_Matrix idx3d_Matrix2) {
        this.n2 = this.n.transform(idx3d_Matrix2);
        this.dist = this.getDist();
    }

    public float getDist() {
        return this.p1.z + this.p2.z + this.p3.z;
    }

    public idx3d_Vector getWeightedNormal() {
        return idx3d_Vector.vectorProduct(this.p1.pos, this.p2.pos, this.p3.pos);
    }

    public idx3d_Triangle getClone() {
        return new idx3d_Triangle(this.p1, this.p2, this.p3);
    }

    public boolean degenerated() {
        return this.p1.equals(this.p2) || this.p2.equals(this.p3) || this.p3.equals(this.p1);
    }

    public void regenerateNormal() {
        this.n = idx3d_Vector.getNormal(this.p1.pos, this.p2.pos, this.p3.pos);
    }

    public void clipFrustrum(int n, int n2) {
        if (this.parent.material == null) {
            this.visible = false;
            return;
        }
        boolean bl = this.outOfFrustrum = (this.p1.clipcode & this.p2.clipcode & this.p3.clipcode) != 0;
        if (this.outOfFrustrum) {
            this.visible = false;
            return;
        }
        if ((double)this.n2.z > 0.5) {
            this.visible = true;
            return;
        }
        this.triangleCenter.x = this.p1.pos2.x + this.p2.pos2.x + this.p3.pos2.x;
        this.triangleCenter.y = this.p1.pos2.y + this.p2.pos2.y + this.p3.pos2.y;
        this.triangleCenter.z = this.p1.pos2.z + this.p2.pos2.z + this.p3.pos2.z;
        this.visible = idx3d_Vector.angle(this.triangleCenter, this.n2) > 0.0f;
    }

    public idx3d_Vertex getMedium() {
        float f = (this.p1.pos.x + this.p2.pos.x + this.p3.pos.x) / 3.0f;
        float f2 = (this.p1.pos.y + this.p2.pos.y + this.p3.pos.y) / 3.0f;
        float f3 = (this.p1.pos.z + this.p2.pos.z + this.p3.pos.z) / 3.0f;
        float f4 = (this.p1.u + this.p2.u + this.p3.u) / 3.0f;
        float f5 = (this.p1.v + this.p2.v + this.p3.v) / 3.0f;
        return new idx3d_Vertex(f, f2, f3, f4, f5);
    }
}

