/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_Light;
import idx3d.idx3d_Scene;
import idx3d.idx3d_Vector;

public final class idx3d_Lightmap {
    int[] diffuse = new int[65536];
    int[] specular = new int[65536];
    private float[] sphere = new float[65536];
    private idx3d_Light[] light;
    private int lights;
    private int ambient;
    private int temp;
    private int overflow;
    private int color;
    private int pos;
    private int r;
    private int g;
    private int b;

    public void rebuildLightmap() {
        System.out.println(">> Rebuilding Light Map  ...  [" + this.lights + " light sources]");
        int n = -128;
        do {
            float f = (float)n / 128.0f;
            int n2 = -128;
            do {
                this.pos = n2 + 128 + (n + 128 << 8);
                float f2 = (float)n2 / 128.0f;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = idx3d_Color.getRed(this.ambient);
                int n7 = idx3d_Color.getGreen(this.ambient);
                int n8 = idx3d_Color.getBlue(this.ambient);
                int n9 = 0;
                while (n9 < this.lights) {
                    idx3d_Vector idx3d_Vector2 = this.light[n9].v;
                    int n10 = this.light[n9].diffuse;
                    int n11 = this.light[n9].specular;
                    float f3 = (float)this.light[n9].highlightSheen / 255.0f;
                    float f4 = (float)this.light[n9].highlightSpread / 4096.0f;
                    f4 = f4 < 0.01f ? 0.01f : f4;
                    int n12 = (int)(255.0f * idx3d_Vector.angle(this.light[n9].v, new idx3d_Vector(f2, f, this.sphere[this.pos])));
                    n12 = n12 > 0 ? n12 : 0;
                    n6 += idx3d_Color.getRed(n10) * n12 >> 8;
                    n7 += idx3d_Color.getGreen(n10) * n12 >> 8;
                    n8 += idx3d_Color.getBlue(n10) * n12 >> 8;
                    float f5 = f3 * (float)Math.pow((float)n12 / 255.0f, 1.0f / f4);
                    n5 += (int)((float)idx3d_Color.getRed(n11) * f5);
                    n4 += (int)((float)idx3d_Color.getGreen(n11) * f5);
                    n3 += (int)((float)idx3d_Color.getBlue(n11) * f5);
                    ++n9;
                }
                this.diffuse[this.pos] = idx3d_Color.getCropColor(n6, n7, n8);
                this.specular[this.pos] = idx3d_Color.getCropColor(n5, n4, n3);
            } while (++n2 < 128);
        } while (++n < 128);
    }

    public idx3d_Lightmap(idx3d_Scene idx3d_Scene2) {
        idx3d_Scene2.rebuild();
        this.light = idx3d_Scene2.light;
        this.lights = idx3d_Scene2.lights;
        this.ambient = idx3d_Scene2.environment.ambient;
        this.buildSphereMap();
        this.rebuildLightmap();
    }

    private void buildSphereMap() {
        int n = -128;
        do {
            float f = (float)n / 128.0f;
            int n2 = -128;
            do {
                int n3 = n2 + 128 + (n + 128 << 8);
                float f2 = (float)n2 / 128.0f;
                float f3 = (float)(1.0 - Math.sqrt(f2 * f2 + f * f));
                float f4 = this.sphere[n3] = f3 > 0.0f ? f3 : 0.0f;
            } while (++n2 < 128);
        } while (++n < 128);
    }
}

