/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Camera;
import idx3d.idx3d_Lightmap;
import idx3d.idx3d_Math;
import idx3d.idx3d_Matrix;
import idx3d.idx3d_Object;
import idx3d.idx3d_Rasterizer;
import idx3d.idx3d_Scene;
import idx3d.idx3d_Screen;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vertex;
import java.util.Enumeration;
import java.util.Vector;

public class idx3d_RenderPipeline {
    public idx3d_Screen screen;
    idx3d_Scene scene;
    public idx3d_Lightmap lightmap;
    private boolean resizingRequested;
    private boolean antialiasChangeRequested;
    private int requestedWidth;
    private int requestedHeight;
    private boolean requestedAntialias;
    boolean useIdBuffer;
    idx3d_Rasterizer rasterizer;
    Vector opaqueQueue = new Vector();
    Vector transparentQueue = new Vector();
    final int zFar = 0xFFFFFFF;
    public int[] zBuffer;
    public int[] idBuffer;

    public void buildLightMap() {
        if (this.lightmap == null) {
            this.lightmap = new idx3d_Lightmap(this.scene);
        } else {
            this.lightmap.rebuildLightmap();
        }
        this.rasterizer.loadLightmap(this.lightmap);
    }

    private idx3d_Triangle[] getOpaqueQueue() {
        if (this.opaqueQueue.size() == 0) {
            return null;
        }
        Enumeration enumeration = this.opaqueQueue.elements();
        idx3d_Triangle[] idx3d_TriangleArray = new idx3d_Triangle[this.opaqueQueue.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            idx3d_TriangleArray[n++] = (idx3d_Triangle)enumeration.nextElement();
        }
        return this.sortTriangles(idx3d_TriangleArray, 0, idx3d_TriangleArray.length - 1);
    }

    private void performResizing() {
        this.resizingRequested = false;
        this.screen.resize(this.requestedWidth, this.requestedHeight);
        this.zBuffer = new int[this.screen.w * this.screen.h];
        if (this.useIdBuffer) {
            this.idBuffer = new int[this.screen.w * this.screen.h];
        }
    }

    private void enqueueTriangle(idx3d_Triangle idx3d_Triangle2) {
        if (idx3d_Triangle2.parent.material == null) {
            return;
        }
        if (!idx3d_Triangle2.visible) {
            return;
        }
        if (idx3d_Triangle2.parent.material.transparency == 255 && idx3d_Triangle2.parent.material.reflectivity == 0) {
            return;
        }
        if (idx3d_Triangle2.parent.material.transparency > 0) {
            this.transparentQueue.addElement(idx3d_Triangle2);
            return;
        }
        this.opaqueQueue.addElement(idx3d_Triangle2);
    }

    public void useIdBuffer(boolean bl) {
        this.useIdBuffer = bl;
        if (bl) {
            this.idBuffer = new int[this.screen.w * this.screen.h];
            return;
        }
        this.idBuffer = null;
    }

    public float getFPS() {
        return (float)((int)(this.screen.FPS * 100.0f)) / 100.0f;
    }

    public void resize(int n, int n2) {
        this.resizingRequested = true;
        this.requestedWidth = n;
        this.requestedHeight = n2;
    }

    private void performAntialiasChange() {
        this.antialiasChangeRequested = false;
        this.screen.setAntialias(this.requestedAntialias);
        this.zBuffer = new int[this.screen.w * this.screen.h];
        if (this.useIdBuffer) {
            this.idBuffer = new int[this.screen.w * this.screen.h];
        }
    }

    public idx3d_RenderPipeline(idx3d_Scene idx3d_Scene2, int n, int n2) {
        this.scene = idx3d_Scene2;
        this.screen = new idx3d_Screen(n, n2);
        this.zBuffer = new int[this.screen.w * this.screen.h];
        this.rasterizer = new idx3d_Rasterizer(this);
    }

    public final void render(idx3d_Camera idx3d_Camera2) {
        int n;
        if (this.resizingRequested) {
            this.performResizing();
        }
        if (this.antialiasChangeRequested) {
            this.performAntialiasChange();
        }
        this.rasterizer.rebuildReferences(this);
        idx3d_Math.clearBuffer(this.zBuffer, 0xFFFFFFF);
        if (this.useIdBuffer) {
            idx3d_Math.clearBuffer(this.idBuffer, -1);
        }
        if (this.scene.environment.background != null) {
            this.screen.drawBackground(this.scene.environment.background, 0, 0, this.screen.w, this.screen.h);
        } else {
            this.screen.clear(this.scene.environment.bgcolor);
        }
        idx3d_Camera2.setScreensize(this.screen.w, this.screen.h);
        this.scene.prepareForRendering();
        this.emptyQueues();
        idx3d_Matrix idx3d_Matrix2 = idx3d_Matrix.multiply(idx3d_Camera2.getMatrix(), this.scene.matrix);
        idx3d_Matrix idx3d_Matrix3 = idx3d_Matrix.multiply(idx3d_Camera2.getNormalMatrix(), this.scene.normalmatrix);
        int n2 = this.screen.w;
        int n3 = this.screen.h;
        int n4 = this.scene.objects - 1;
        while (n4 >= 0) {
            idx3d_Object idx3d_Object2 = this.scene.object[n4];
            if (idx3d_Object2.visible) {
                idx3d_Matrix idx3d_Matrix4 = idx3d_Object2.matrix.getClone();
                idx3d_Matrix idx3d_Matrix5 = idx3d_Object2.normalmatrix.getClone();
                idx3d_Matrix4.transform(idx3d_Matrix2);
                idx3d_Matrix5.transform(idx3d_Matrix3);
                n = idx3d_Object2.vertices - 1;
                while (n >= 0) {
                    idx3d_Vertex idx3d_Vertex2 = idx3d_Object2.vertex[n];
                    idx3d_Vertex2.project(idx3d_Matrix4, idx3d_Matrix5, idx3d_Camera2);
                    idx3d_Vertex2.clipFrustrum(n2, n3);
                    --n;
                }
                n = idx3d_Object2.triangles - 1;
                while (n >= 0) {
                    idx3d_Triangle idx3d_Triangle2 = idx3d_Object2.triangle[n];
                    idx3d_Triangle2.project(idx3d_Matrix5);
                    idx3d_Triangle2.clipFrustrum(n2, n3);
                    this.enqueueTriangle(idx3d_Triangle2);
                    --n;
                }
            }
            --n4;
        }
        idx3d_Triangle[] idx3d_TriangleArray = this.getOpaqueQueue();
        if (idx3d_TriangleArray != null) {
            n = idx3d_TriangleArray.length - 1;
            while (n >= 0) {
                this.rasterizer.loadMaterial(idx3d_TriangleArray[n].parent.material);
                this.rasterizer.render(idx3d_TriangleArray[n]);
                --n;
            }
        }
        if ((idx3d_TriangleArray = this.getTransparentQueue()) != null) {
            n = 0;
            while (n < idx3d_TriangleArray.length) {
                this.rasterizer.loadMaterial(idx3d_TriangleArray[n].parent.material);
                this.rasterizer.render(idx3d_TriangleArray[n]);
                ++n;
            }
        }
        this.screen.render();
    }

    public void setAntialias(boolean bl) {
        this.antialiasChangeRequested = true;
        this.requestedAntialias = bl;
    }

    private void emptyQueues() {
        this.opaqueQueue.removeAllElements();
        this.transparentQueue.removeAllElements();
    }

    private idx3d_Triangle[] sortTriangles(idx3d_Triangle[] idx3d_TriangleArray, int n, int n2) {
        float f = (idx3d_TriangleArray[n].dist + idx3d_TriangleArray[n2].dist) / 2.0f;
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (idx3d_TriangleArray[n3].dist > f) {
                ++n3;
                continue;
            }
            while (idx3d_TriangleArray[n4].dist < f) {
                --n4;
            }
            if (n3 <= n4) {
                idx3d_Triangle idx3d_Triangle2 = idx3d_TriangleArray[n3];
                idx3d_TriangleArray[n3] = idx3d_TriangleArray[n4];
                idx3d_TriangleArray[n4] = idx3d_Triangle2;
                ++n3;
                --n4;
            }
            if (n4 < n3) break;
        }
        if (n < n4) {
            this.sortTriangles(idx3d_TriangleArray, n, n4);
        }
        if (n2 > n3) {
            this.sortTriangles(idx3d_TriangleArray, n3, n2);
        }
        return idx3d_TriangleArray;
    }

    private idx3d_Triangle[] getTransparentQueue() {
        if (this.transparentQueue.size() == 0) {
            return null;
        }
        Enumeration enumeration = this.transparentQueue.elements();
        idx3d_Triangle[] idx3d_TriangleArray = new idx3d_Triangle[this.transparentQueue.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            idx3d_TriangleArray[n++] = (idx3d_Triangle)enumeration.nextElement();
        }
        return this.sortTriangles(idx3d_TriangleArray, 0, idx3d_TriangleArray.length - 1);
    }
}

